(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[   1770249,      30200]
NotebookOptionsPosition[   1766333,      30075]
NotebookOutlinePosition[   1766697,      30091]
CellTagsIndexPosition[   1766654,      30088]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"d", "=", " ", 
    RowBox[{"First", "@", 
     RowBox[{"Import", "[", 
      RowBox[{
      "\"\<E:\\\\Presentations\\\\BAO\\\\Amas 21cm\\\\test1.fits\>\"", ",", 
       "\"\<RawData\>\""}], "]"}]}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.537765593083966*^9, 3.537765713036219*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", " ", "=", " ", 
   RowBox[{"Drop", "[", 
    RowBox[{
     RowBox[{"d", "[", 
      RowBox[{"[", "1", "]"}], "]"}], ",", 
     RowBox[{"{", "1", "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.537765779513504*^9, 3.5377658571042047`*^9}, {
  3.537765903638303*^9, 3.5377659396181955`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", " ", "=", " ", 
   RowBox[{"Drop", "[", 
    RowBox[{"data", ",", 
     RowBox[{"-", "1"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.5377659544514813`*^9, 3.537765967229127*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"dataLog", " ", "=", " ", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"i", "/", "8192"}], ")"}], "*", "250"}], "+", "1250"}], 
        ",", " ", 
        RowBox[{"data", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", 
        RowBox[{"Length", "[", "data", "]"}]}], "}"}]}], "]"}]}], 
   ";"}]}]], "Input",
 CellChangeTimes->{{3.538116427112395*^9, 3.5381164642169385`*^9}}],

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"dataLog", ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1380", ",", "1425"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.99", ",", "1.01"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Red"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", " ", 
   RowBox[{"FrameTicks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{"i", ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1250", ",", "1500", ",", "5"}], "}"}]}], "]"}], 
      ",", "Automatic"}], "}"}]}], ",", " ", 
   RowBox[{"GridLines", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i", ",", "Dashed"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1250", ",", "1500", ",", "5"}], "}"}]}], "]"}], 
      ",", "Automatic"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.538116474219487*^9, 3.5381164783391013`*^9}, {
  3.538222390123519*^9, 3.538222457806034*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[1, 0, 0], LineBox[CompressedData["
1:eJwtzk8oBFEcwPE3e9lyUqbUHjQif4oTKS7zLlIu5IJStLVnN+Ggp+Sy2IOD
UmrLaS/rxIXDM6XVOiqnLYuUA63SXCwy+76/w/T6zG++v3nd2dW5XEopFSRP
61RqNpvPH+rBpUIUD3yGyQtTStw6h3uc7S1WX53O6g3btQ5nnd5zrmfa6Ptw
0U/TT2Lz8tNwfQ7rpqLfwcEjc3OK1ZBHH8m+qvTP2N4w194+35/90ge43i59
iIOxP/plbLbl/1vYeszNCV7ZYG6vpO+Svib7F6Rvyve73/SZA+4zEzvbcVw8
/qBfxMHdq7Nex/a6Rn8knrinv5B9lSr9g3g6oo9l//wlvV/gfqlz+hFxf7kR
Vt6j3tHE5amnTT/xP0obo8E=
     "]], LineBox[CompressedData["
1:eJxVmnm4T1UXx7exRKaMkY6pUCGlomITkVAZM3bIFK8hoWTaZEwprtnFQWb3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     "]], 
    LineBox[{{1273.1728270168992`, 1.01}, {1273.193359375, 
     0.9992595314979553}, {1273.223876953125, 0.9992914795875549}, {
     1273.25439453125, 0.9993749856948853}, {1273.284912109375, 
     0.999974250793457}, {1273.3154296875, 1.0010634660720825`}, {
     1273.3227157329138`, 1.01}}], 
    LineBox[{{1273.3702166132098`, 1.01}, {1273.37646484375, 
     1.0026640892028809`}, {1273.406982421875, 1.001212477684021}, {1273.4375,
      1.0024982690811157`}, {1273.468017578125, 1.0057624578475952`}, {
     1273.4776385332136`, 1.01}}], 
    LineBox[{{1273.7958418235573`, 1.01}, {1273.8037109375, 
     1.006516933441162}, {1273.834228515625, 1.0033804178237915`}, {
     1273.86474609375, 1.0021169185638428`}, {1273.895263671875, 
     1.0052651166915894`}, {1273.900222597912, 1.01}}], 
    LineBox[{{1273.9483074852733`, 1.01}, {1273.956298828125, 
     1.001342535018921}, {1273.98681640625, 1.0004234313964844`}, {
     1274.017333984375, 0.9999265074729919}, {1274.0478515625, 
     0.9998924732208252}, {1274.078369140625, 1.0000298023223877`}, {
     1274.0984482070326`, 1.01}}], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQBWIQ/XX2jueVLyY7aMb0H/qq8cEeKHSgD8gH0g23/7wH
8RnWQfnF/8B8h7MQ/oFLEPmGN1D+vG9g/gHul2D+g/gvEP3aEP6BfGmw+Q5e
UH4zRH1DJoTvkPwZor8Dqr8cIs+wAsJviPwKsf84hM8QB+E3PIOaF80PcT/r
KzBf4ch3iH5VCP/BTwjfwQUq//8HRH8yhN+w7S/E/iao+ilMYPMYFkH4Dvbc
EPcfhPLPMoL5DQ8g/AN8/yH6/0P4CzQg5jHIv4ao74KGnx2Er7CLAaI/FsJn
uMMKcX8NlJ/AAbF/DlS9AjvE/t0QfkISUH7WzJmVV14j4g8Axwqmjg==
     "]], 
    LineBox[{{1274.9710548673886`, 1.01}, {1274.993896484375, 
     1.004347324371338}, {1274.9977396870886`, 1.01}}], 
    LineBox[{{1275.052619892109, 1.01}, {1275.054931640625, 
     1.006784439086914}, {1275.08544921875, 1.002548336982727}, {
     1275.115966796875, 1.0023151636123657`}, {1275.146484375, 
     1.0017551183700562`}, {1275.177001953125, 1.0012990236282349`}, {
     1275.20751953125, 1.0007526874542236`}, {1275.238037109375, 
     1.001592755317688}, {1275.2685546875, 0.999911904335022}, {
     1275.299072265625, 0.9993959665298462}, {1275.32958984375, 
     0.9993677139282227}, {1275.360107421875, 0.9994069933891296}, {
     1275.390625, 0.999464213848114}, {1275.421142578125, 
     1.001863718032837}, {1275.45166015625, 1.008330225944519}, {
     1275.4552517923175`, 1.01}}], LineBox[CompressedData["
1:eJxVmne8z+X7x2/z2HsL72PvnRluo5CRqJDRu4FSKSv6Gt1EGWXPrLdVGkRE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     "]], LineBox[CompressedData["
1:eJxFlVtIVEEAhiddoRKktUiCslMGaUXuy9ZDoqNpXqrNInwog4N2N1SierAe
xqBa2m7UGt2WjmAKagjVQyHkdBWUHiIoLKQDkSVb5DXXyrXt/D/0IMvnP9/8
M2fm7C6pqNm2J04IcTj29+9z62BT98HcoMwov/h0PH0oJ/YvfSjGsU/pSXZY
nCMnJTgs28BWdpzDqgesqsB6EGxPRH84/qw8h0WCgJ8OtuSUk6tCsL427bDe
CzaC9E+DVQf9O8xLweo5/Waw/sR88QysP3491lNAfylYBOjnMk+mb4Kt+Hj4
iuN9mE/eBhvLweox2Gyn3w+W3/9g/VNgbbF/YT724+X+14F12m/sfwfYrAKL
OrBsxXh5nXkUuXoItsaQ63fMc9k/ATYu059fAA4hV16w6Wf/drCsZ/8RchLO
Q17h+Gdc/z2wuor59Gvm85CLYbAdZv+cDcg/sD8TbIfY7wOrEfZXk3vonwfr
MNaj2sHWF96fXrDhxvMWYfadQi5nFyJ/Sz8DrKp5fkXM2+jvB4tKnv8ZsPbw
/jeD5W7e/xf0I2DxmeMX4D5JVxH6Uumnkedifp0HtrvYXwE2POyv5/gB3l8L
LI6xv4t+I/s/klvZHyX3s39RMeb3088C65X0y8GC+5XHwWYi/Rv027n+R2AZ
4vvXB1ajvP8R+n1cf0oJ+l7y+a8ht/zC+ZeRp37i/I6CjXTkKgi2iiZw/vc5
vmwc/hvmtWA5AlaXMJ9yb6Q/Bt8DVmH6pcwb6Ncw96JPXQCLXvp3ycYk/Fdg
O4rx8hvnu0U/cROeVx3G6xVgszUCvwRsZHL/B5ivRp/yMx9lfwtYB4bhd4NF
HlgO0H8wCj9hM/JVI/CXkYu5/3ywXIv1yEqwEZ2J8zvJvJPn10g/wPN7AtY+
vM/Spv+V31/T9GvwPupUH8Zn8v5nk8/y/d8FVk38/jgBNnfSv0l28/ejE2zX
8v6953wNvL+THJ/qGspx7cuaTtny//fwL8xbGfY=
     "]], 
    LineBox[{{1299.7751335444832`, 1.01}, {1299.8046875, 1.003188967704773}, {
     1299.835205078125, 1.0058720111846924`}, {1299.86572265625, 
     1.00865638256073}, {1299.890857187814, 1.01}}], LineBox[CompressedData["
1:eJxVmXmcz+UWxx+7GWsylPVLhMIlSVR8C1MZbvZtxM9YZmwzYy0M89iTkKxl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     "]], 
    LineBox[{{1312.5395000252606`, 1.01}, {1312.56103515625, 
     1.0039576292037964`}, {1312.591552734375, 1.0049444437026978`}, {
     1312.6220703125, 1.007581353187561}, {1312.652587890625, 
     1.0084964036941528`}, {1312.68310546875, 1.008704662322998}, {
     1312.6899844142197`, 1.01}}], LineBox[CompressedData["
1:eJxVmXd4l9UVxy9RZIQRlkAi+FJAQSigFXEwLkZkFSzTBii8WBFZMixUBOSK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     "]], LineBox[CompressedData["
1:eJxF1UlIlVEYxvGjOdBgktXCXHSN5qgWdYlE9DQvqkW1KCHqq9SwIrFFNlAd
UAIjmoiIEv2IgrJNQbNppwEaKJKgFg1wK6KJUtLboE23+3+ghVx+vud5z3m/
4d78lZULy1KNMWsSf/8+o6nXowXnDtoxS/feiI/uKE78y8xNOPERZqUnbdfg
2LrUpF0djmzF/qTq2b3I38FBDrZvsWlRPuM89RXU/Qh5hvKz5LI08qXYlFJ3
Naq3UffHsHuEzQ0crs8g/xJHpitvLiRtS3X+oXJ1Cvli7DJ+tyfzy7DvZ8hv
0/p51H09DmZSN1flKmyfqd9m+rtuuVD7517kvCO1/1RsV2O7BPtO7V+NTbny
h+Q92FzAke3YPlb/yZq/S+6v6zfwEuuHa/9JOLb+D/MvxKH7mbSrUr0P9vtU
b8XmDHazNP9DHDTRz33GZgd1n3WZfi90/cbjyEfl5+HglK7fWmyi2O9Svlrz
N6m+X/PfxW6D8u/UP1P5zCvkveYfhV2O5p+Ng2uav0y+rftfq/VRbI6rX8V3
8jdx2PCD/Cu5+Bv5lGbu75Bu8vk4iGJrceQIdsuxq9X1345N+i/yDc16X5Vv
Ub/j2v85Dguo+x5ss3vI513lPGNZbwtwOI7zuhIcKeokvwmbii/kDyu/6jP5
i/KCDvJPcFDPeh9Xv2/t5Ae3MN8A6nYytoXs5xbh2IM4+Q3YrP1K/oDyHziv
Pat8EetdG/b5XeTbcdjI/TLZrfTbSD87Qa7S/vOxnaj8OtVbNP9u1f9o/tOq
b8PuHg4rP5F/j90nro/pfY31I7Adjf1JnX8ODgbp+SnHNq7ndyeO3df7c0L9
Dur5vaX6Yj2/r3GYp/enl+c8WzLJD8O+pA/vzzT5aR7vT4AjaVnkHY690/d/
Iw6n6PunFduavuRfaL+juR3FXaZu2hv///foL9j8FI0=
     "]], 
    LineBox[{{1328.303240466067, 1.01}, {1328.30810546875, 
     1.0084760189056396`}, {1328.338623046875, 1.0043609142303467`}, {
     1328.369140625, 1.0034294128417969`}, {1328.399658203125, 
     1.0037785768508911`}, {1328.43017578125, 1.0053290128707886`}, {
     1328.4577072136879`, 1.01}}], LineBox[CompressedData["
1:eJw9mnmcj9Uexw9jG4OxS6JHyZ6UJbIdKokSZY30UBRuZEkp1akUyhLJkktP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     "]], LineBox[CompressedData["
1:eJxVmHt0yGUYx9/NtUWJihn2GzMmmZCw2K92GCWXUejmJ8YpHNSJleItOd0N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     "]], LineBox[CompressedData["
1:eJxV2HmUj1Ucx/FrTUNEljLUYzmWDqayHMpyx74rk2LM5DFFWpiiVYtLljqF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     "]], LineBox[CompressedData["
1:eJxVl3mUSFUcxy8zJMtkT3TyxsnWyEEx0eIeWxqyZSYkPQZjNGMYM4yp9JQk
S2OJLC3PFqmmsiXL8YyTfShapOhFcTIylmOdQcz30+n0x5w5n/nd7/3+7r2/
+7tvogel9RpS2hhTeOvn9u/U3lHxZQfMsY375+RdbHS27a0/BXff4tu/T5cu
YRMrtitMCdsEcVhD7GWKTcHNwhL9O4zfo7hZI/ZDxe1BOO5GCXvn8St7Xfoq
L5Swc0px01zsr1fc9hAHKWIvTewmoX9bbINi6XPF4Rmtx+bDO0sp/9PMl1tZ
66/gKj5e+ZoYuKPysXFic478k4mPLZL/ZHHQCf0KsdsL/Q6xH6m4d4L5PtJ+
BWUGSj9B6zH1xe5srcd2gJOuSZ/I+Mb4vyb2BipuFovtSMXtVnG4XuyF6BOv
SH+TeDT+dQeJffyfEDur0D8v9vqw/y8zfhH698RmEf4bYdbjHWZ8N+1PcJV4
Lud3T6L8duP/iNi67P+zcJriwRhxuBD9XOJn8F+bSL2R//dity/6C8Q3sH/V
Buu8ToltC3GwEf+exA9R/yPFthz1P0NspnJ/Phe7+dyffYyvxvn/LfbyqZ9K
QxSfq3q1TcTBYOqnC/Ge6IeLnUnop8D51N/H6OeT/06xmx4p/Ul4CvfvjqFa
37fcvwZil/V6HcXBK6x/MNyD9U+Ej+C/RGxasv48sbeb/H8XhwXoSyUp//Xs
nwP34/62Fdsc9APEwVb048Uh/ci+z/hh+G9i/NOaL/hF7D+KvkhsykRJX3uY
8m2Bf2ux2039JegjtuXpn1lwdc7vXbHpq7i3TuxPx/8HcdgsQvqLzP8k/at6
stY/Gv1DYtsU/15idw7+6YxfwPpnMn4++X8BL0W/X2x6K24K0R9DHzVc+XVH
/yC8jPy7ioNr7F+K2LtB/58Kx6JfKfY5r2CX2K2K/19i+zr7V+5F5XOG+mso
9qdQf53EQR71O1TsRuD/hjicyfuxlHhr7v82uCr357jYfEr9l06RXzb9K1ps
qtB/rdhG0X9ccTCL/vUq48/h/4HYzSL/zej3az5zhPg19MX/+uFfJ1Xr2UX+
bVL/1w9NP3EQiX4c49ujnyd2i8n/K7F/FP+f0B+j/10Se7V5f2qM4P6hfxiO
wb+32F+N/2ixe4L+O0tsOvB+fEl8Oe/Hd2JvHfqzYieP/bsrTfGJvB9NxeFe
9N3Etoj+kyp29qGfxvho9v8TsVuP+t2DfjL6U/hVo/7uHCm9Q/02EnvN0XcW
+zupvyTipdBPErujWP8y5muA/hviydT/H2KTSv+KGKXzieL+1ROHA9C3I56J
fqDYb8j988SmmP37UOzMQL9F7EWgPyq27dBfx68L/vem836hf0zsxNC/nhMH
nck/W2yf4f2ZLw5/pH99nc57g/8hxm/D/zJ+Y/CvOVrxBPSt4Hb0r3ixQz/1
MsTecPSzxeYC/Wc18SbkfwB9PP7nxH5L9JUzpF+JvpnY+RX/7mJ7kvMfkcF5
o58Ob0L/mdithP9euA/5F8Dp6MtnUs+s/wGxv5b9e0rsJbD/w8Sui/5N9H05
v+XiYB75bxcbw/fDn8RTqP/IMZq/Dv3zfnFwmPvTXhwWcv8GwY2p/wliJ47+
swiuyfdbIHYnXZb+N7GpT/+5gd8Wfc+a+8aKPbF9XOwcoP/0F3uXLkn/Ehx7
VfqFcEX8N8BF6H+GV/H9fAW+zvdjrSzxrovSx4rtAvJPgMuLg0xxeFxs5ogD
h/zXMN+MC9IfhJPxPy92snj/qo7TflXQfLa5OKiLfw+xPcj7kSb22rD+HLHZ
zPuXS7w79ZfP/PGc32mxP5nzr5gtblVG9RMj9grZvzji67j/yeJwDd8/b4lt
f+p3hdgU1JL/DnHQtaz0Jxi/uNzZtku2r5p2Nfu//2//AcX0ilE=
     "]], 
    LineBox[{{1374.766735367843, 1.01}, {1374.786376953125, 
     1.0005607604980469`}, {1374.81689453125, 1.0038741827011108`}, {
     1374.847412109375, 1.0091307163238525`}, {1374.8779296875, 
     1.0071457624435425`}, {1374.908447265625, 1.0047621726989746`}, {
     1374.9204954967722`, 1.01}}], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQbXy30fpWzVQHzZj+Q181PtgDhQ6A+EBaIRTCZ/gF
4S8QZwPzHSRrwXyHAEYwv8ECyi+E8A+EQ/lZ39+D9ZdD+A9UIfIO06Dy27+C
5Ru2QvgMnV/A/ANXIPyGU1D9X6D6v70D8x2E6yDucfgA0W8E4T/wgtofCOEn
tED1F0L4Cut+QvRPgKpvgsg3rIfwHVo+Q+w/B+U/+gjR/w7KfwK1n7ce4r7H
EH6DDoR/4CxE/QFvCF8hGuI+hmyo/BOIfx26IPyEPIh/G1ZC1T+EuO/ACQj/
Qf4viP4XEL5DGjsk/NgbIPJMkPhoUIPwFU7zf7BvNLx716kBEZ8AuaCeoQ==

     "]], LineBox[CompressedData["
1:eJxF1E1IVUEYxvFRSzTr2peLiuBIoLkQk5CQICehL6gW1aLiSrfAWvQh5EKD
sLHS0huFURTSx1lUhLhIITOIOlhhFKES5MbkQBFUC28LyzKt6/0/0EIuP2ee
d945M+fkH6jZUZ1ujKlK/s38li0fqjaNV21R9FLf+MpERfJfNi3p5G/wrSBl
52E7OD/loELjxbkpm33Yf4Rtg8abM8nfVL40m/wTHG6ZQ35ELjfkJ7ELpsZS
+aWnqX8xj3w5jvnY7MG2cS75emy+z2P9axrviJDvUb52Afn3Gk8sIj+O3cAs
8ovPsJ+3v1P9BKuxOfw3ZbMTe3Vp5I9j/yH7cW2aX8f84IHqbZ0mP4jDemzH
5JD5LnIW36d+UCz3aP1t2E2ks/4RHMtjvotr/kat34FtO/2Z1zjo5XnbL9i8
+8X6WU24W/svxP6xSdbfhGPd6v8gdlGdXxMOinBwB3tO+3+heiX0Zz9im8m4
S2+mfqn6z8cuh3pmPQ7b1X8M2xblT2GvS/3fUr272DxV/hW2H+STP8n/0fwN
E+SXnaN+PzZrcRjhedi92GvA7oQ8iYPr8rjOrxf7UT2/YdWPq/8f2FVq/3nn
WW8V52vKsO3k/bS7sKlawvnXyn053J/Lci/vh+nGgc98O4RjBbPJJ+SE+s9t
od8CnV8JdrXa/3Ycdqn/o9iO6vwvKJ+h+9eJvds6/zfyFb0/X5Uf0P3PbqX/
UPki+bme32YcOr0/h1p13lq/Gbu/uj/3NB7X/XmJg8+6v59UL0L9ICNOvlDr
r5D71X8lDoez6H8/jo3wPQwc9tZh42P7mO+hfYbNGr5HblT1ahaSn5Jnvs+7
ozfapuP/v9//AAOG1t8=
     "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQnew/TY6nd6qDZkz/oa8aH+yBQgziQD6QOjBREsx3
MIPwG9J4wPyGUAj/wT5mMP9ACYSf4MsI0T8FKv/z33uw/s1Q89J+g/kNlyB8
hp0/wPwDHyF8hV0QeQbBPoh+v58Q/QYQvsMTiPoGfwj/QAhUfx5UXvMbRH8f
VP+1rxD9a6H8BxB+wxkIXyEFwj/wGqr/wieIfu5+iPkpXyD6tSD8BykfIPo9
ofL9EP6BDAifYfpHiP4OCN/hzmeI/uVQ+QlQ/x+D8BuqmSDh9xTCV/DghoQf
6wSI/muikPBXgfJruD7Yi2yTk9edgIgvAAfLlDo=
     "]], LineBox[CompressedData["
1:eJxV1ntMl1Ucx/EjEZpTl4lGrNWjzZJhMJthsymnpGwazpl2cZoPGLoulqVh
2u2wskbOiQneuD0iUC3KNLXbrGPpKpurhuHK0sfKSg1lmlYCGv4+79b6g7EX
3/M933N/GFj4yKSiJGPMW10/53/n9p06+LuyCpsxbdnHp4a05Xb9yR/octfv
qLVvwuacbCZ2HD9ve8XyhOPgz4TdKDlc20350+SgtbvynyI+3CRsK3GJ7N6X
fZHa+2/pf8q5RP/mb+JNf6l+2stypcbjRshxQ2fC/k7i7YqbYjk8wfgr8B61
d5tx9QWq3yybE9Q/KdtG2V6yQv3Tnxsmhxmaj58o2z6ymSsHi1TPLpPjlDPK
f5P2L8h+N/37dtVvpf9NZ5Xfqzxhl8/4M+WgWHE/Tg4XyuYB2Sxi/UvleJ/m
416V/UnW71Pi2eT/io8y/pQK1bOKu8Gyn6/+fJ4cdyRr/vcRH3Sh6j8nm/ok
7X+d7H5R3G+Xw52cn4PEC3W+rFmp+js4P1fKZov686NlF2o/zb203yXbp/F0
6lfJ4Xj2/wPijM/so/+t5J+R43XkX7ZK7ZPJv0GO5pN/t+wKGP8COSyT3Uqc
y/3ZQn8TZPON7BeQ/wftS1TP9Vut9pupf50ctzP/SbLJY/0fxWnaH1eGr5H9
BvrrT/6Xsu2k/jHZD2T8vdeo3gb2f6gcVjL+22W7V/3bB+VoNuv3kuyayH8N
T+b+fY6TOL+/0f/bnL/ua+VDnN+r5SCH+3erbApVzxbhVOo/T/u7OD/r5fgA
4/9EdunU/1G2pzl/3SpVv4r7H+BUjafrwZMzuT8z5Ggb9/cZ2W9k/6qJp5G/
TXZzeL++l+OZvD/tshnG/U+v0vjKub8jZV9L/XvwSPbvCTmay/hX/Rtn/d6h
v/eYf4sc1DH/U+TH7F9qtTyd+sOrub+8X3fIZj/v32NyMEPvnV+O83j/Nsq2
P/P/inzeG3eceAv736dG9Ut5/7PkYB7182s475yfh2Sbw/1bUsP3gPm/LvvF
nP9dspvJ+h2W4z2sX49a1XuY8ztE9kdY/7Fy2Mz+zZKNYf6L5fh3xt9AvJj8
HcQHqL37SXa3sP5JkeZzLfUHydF29u8m2Qxl/0LZt3B+npWDbM5/LS4l/0P6
O8j8fyB/FuvXQf0s1u/ydRpfFt/PG+WggPM/VTajqL8QL2X/15Cfyf6/S/wV
5r8XH1Xcn8Y53J8Bdbwf5F8vB+yHmyz7gPrz5PAY53eFHPF9sJtky/vsvqb9
FObfJsdLmP/F61W/lvOTLZuerP8EXMP458jhaOa/lPzxsm2S/eOcny+I53N+
jsjRGM5Pz3r1P4LzkyEHY5j/bcRLGf/s+v/tt3lRjray/41ynMH3ZyfxPL4f
P8vhZ3y/kxs0vvIeyr9KDsYp7m6W/ereyi+Qo2byS2T7hmwj4p0pyv+I/tMv
Uv5++h/bS/lnZXO4X1vu/U8e2n1p43//7/4DmWBfQA==
     "]], LineBox[CompressedData["
1:eJxVmXmcj9Uexw8ZQheV7Yo8tjuESSg3U+ZESJTtVtzIc201yOiKylJHlihL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     "]], LineBox[CompressedData["
1:eJxF131M1VUcx/HjRbQYPsynXJldyaXXygQdllb+pstKTA2lGlq7WkG0ikTU
LKtTqan5mNNirfw5cyZE2LKcZd2TaeUyjNKEnrwiivgAiPJQioX3/dn6w7GX
3/M53/M7nN8D/Wbkpj8eMMbsbvt3+WdOZGbKg9G1Xmjayl2NA+tHtf2Xvey2
n/7UATG7OdgmdY/ZrMPe3Ykxe59i07cT+QPy5K7kz+FoYRz57kfIJ7UjnyKn
GvL3Y/fhv3Wx/LOqZ2CzCvu3xpMvwSbxQqxuS5VfTz93BocH/02+UyX1zJaY
vZtw9Cps07A/nfHuSWwW088sxd70f8hvwXY5tt8rH9+Z/tWafxjrMx2Psp5L
zeRvwOZO9sPehe1C6u4xjZ97jvwCHEw5T34jdvMa6L9LLsDuCI4W1ZNvV0W9
z0XyQRx+lPntKOxVnyX/iMZnYvMSNuvU/13lK7DdiYOpreR/V71I+39BfrWR
/NXHmH+n8rdhM4b1uIdUn6T8c9heT917S/UcnZ/PcLRK6z+I/RVaf6PG1yrf
4zjz3aLrHypb9U/HplL98+Qs7d9q7P7Q+duqehrnwe3H3hLGmzq5p/Kdq1lv
QOu/GbutAc7PeOzP0fl5SuNXYe8NHJ6i/oU46F+i/17NNxmbGo2Po593xQmu
dxP97ADsXav+Y3E0TfdvFjZ7qXsLsQtTt+/Lv+n++0a+riP5o8pXtCcfqMHZ
1G0/7EWoOw8HE9Q/rPoQ5V/G0Qncn/Y91Rs6kP+yRvup/J/qt0brv4jtngTy
15xkvhD3oxuBzUj2y2Ti8ALt3zyNn83zyb6t+kHlt2Obic0hzZeh518T9g9p
/3ueoj5L+zcMh4t53popco7WP0vjd+j58Sb2W1if+1j1bupfdkr3M/N79dim
qH+X0+x3q/KDsT9Q+Qk4nKL1P42jG3V+l2G7QddfpPki2r8flC/V+k9i06T1
X3mG8Yk6fwPlUvW/B/v3qX82NrnKL8I2wn65TapfUH6P/KJ+f1UaX658XC3r
66/rT8IuovxouVD56djX/WGt6r8qv14eq3wER+dr/X/hYJ76t2LzlfJ96qgv
Vv527Jbp/TcV+/ncD/Z5HF6l/SvApoPyO+SHtf/lcj73i22WQ13I96qn3wjG
m1QczFY+A9svtP581bfp978Gm6Hq/4nm6638zxpfrfxZ7A3S+rueJR/P9Zkh
2CvQ+Z0oZ2n/n8H+YeWX46hsiuVa5fdhN1fn/5Q8SetPaMA6z2YQtgGt/17s
79H6n1Bd5829Lg/X+d8s79D5+RYHX+N9YI/hcCrPc9f+HA7xPjH95Tye594Y
bDtgO0P1QuZzr+DgZr5vzAaNL2si7+TxvI/tYewvwu6S6ul6//Q9z3wl+n65
Q16h/DRsAsq/gL10+pl3sP813wfe5/JEfX9VYFusfAuOruZ7xvRuZL4Q9oZj
O7qO/APY363vn9mq91B+LQ721v23TZ6v9+cv2CXr/d+g/FF9P3Vrov8+9U/G
0RPqPwm7ENfjcnFwpr5fV6q+pZb8Rzhczvz2R+wnM587rXylvl8Sm6kPYLx3
I3YHenH+xuHgT1p/Dva2K78E2xJ9v32gelf9/r7DplbfL8dVz297P47cP66s
sfn/vxf+A5iL+u0=
     "]], 
    LineBox[{{1406.0196897423778`, 1.01}, {1406.036376953125, 
     1.0003489255905151`}, {1406.06689453125, 0.9999750852584839}, {
     1406.097412109375, 1.001247525215149}, {1406.1279296875, 
     1.0051863193511963`}, {1406.1371189780855`, 1.01}}], 
    LineBox[{{1406.2495538702801`, 1.01}, {1406.25, 1.0092357397079468`}, {
     1406.280517578125, 1.00289785861969}, {1406.31103515625, 
     1.0032927989959717`}, {1406.341552734375, 1.000491976737976}, {
     1406.3720703125, 1.0037258863449097`}, {1406.374894601397, 1.01}}], 
    LineBox[CompressedData["
1:eJw1mWd8V0UWhidBEmqoSgtwkRJ6EaWsQAZQBKR3ReDCBlGEpSpSlFGqsEoH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     "]], LineBox[CompressedData["
1:eJxV1n1sT1ccx/GztoT6w8NixrC7ka6WoFG0VWsPvyXDQgRBpZKrjYZESDDR
1uKQeFgyWzadzGZzhfFHN8tsQj0eQgSRWSyTeYgrLaIW9bB6aqvq9/4k0j+k
eTnf7znf873fe9t3ShZNmZtijPmq7d/LnycyyjM+G7bJDir+8nhj5r3Ctv8y
P7b55c/r3ZK2h3H8R1rS7opcb5L2TTgqbWlI5r+VTf5lbEfh6BZ2RdjVNyXt
l2Nbh823OF6P7T7FT39G/j/ylafkN+LgPDY9h3N+zWPyh+NoVSP5U+Wt/5O/
GNsENl/jMPs++b/Jldidx8HCR+Q3aL8z7G+6jkjaD6YeOwSHecS7iTgu0f0X
yDnq3+fY7u9C/6tx0LGV/DPa/xj98LeVX6X7dx7JecU6PxMH2er/R3JP5Zdh
l6X+r9X6rifk/4TjZ/TTnVB8X/W/Vi5i3aTmUN8m5b8r924mfwwOy7mPD7Ue
6/4O2+Oan63yRubNHcFBBev+qlzGfqYFux3E2765rH+s++fLu3X+LBxlEW8q
sP/1NfI3y9XPyd+PzUXN/0Xs6lg3j3Pb9du+kcf+83T+CBwPVf40HHZX/UsV
n63zN2q9fwr336P1TOz/wsESbO5jvwLbbqOo77TmZ6hcrvMn4XCL7r8Q+wXE
2w1aj3X/n7Hdrvk5i+O72NzRei226fnUt5N5cYOwmab8cdhnaP7m5as/6t86
HN5U/3YqfrKe30kcnVP9N5TfS/1LG816Wgf6NwDHKaz7sfJp5Zdgk675WYV9
meYvwmG1+ndU6y16ftew3a36n2v/maq/3wf0Y4vmdzSO9H6bYnm8+l+JXa3O
/075raq/BpsSPf9/FV+VSv1PsD2k+elVgDdofkYWqD7izXTstmt+PlF8uvKr
cDhQ+b9jk0U95gIO8tT/B4oPVX/3QvZ7Xf3LwkGs/k8ubPe9s4sUf1L5X2DX
QL3+FxzX6P7nsG9W/f/JmzuS38Viy+8z/z6O6rCZgM0a5c/X+p/cx62Xx6n/
u7Rfhe5/Csc7dP+bOLil96/DGPrRiffJD8Q+T9+PD3FwgO+lLVX8D7r/amwn
qH/bsHtP/TuGoxzNb4zjIj2/VuVXqv7+Y7lvquovwNEl5c/GYZPOX4H9Sp3/
PXZTVP9BbN/W/F/S/un6fjzV+jLd/80E/lTPLxebKv3+n5FQ/7Bbpnj9veC/
weEcvT97E+2+B/ZvHJfq/X8o9+lxr7C+eWb5o8Srv39eAMjmpuM=
     "]], LineBox[CompressedData["
1:eJxF1E1szEEYx/FpK02jGy4lUsHupVuJJhIkKqETsS3tVqNEKLEb1QuiFQdx
EJOIg4i0HFQINqEHFVoXIiEm68KlWgklHFbj7bLbHqi+Uev//YlDs/n0mWfm
eZ6Z3cj+9ua2QmPMnvzf38+q0YFQbNMlu3xvZ/pH5VhN/l92W975z+RMaWDX
gf1gUWDfKd8pCGz6cKbXkD+g/CvYZbEZmRkN8kOxwG4nNiuwnZ0ObBtweHQq
sDuo+PpJ8s/iVPwn+be1vo/19jk2rybI/4oz7Tq/uJb4kVnyK7Bd+Yv8GE5d
Vf0HcLIA+9PY1f0m/6b2y2Kbxn4H57mP2i+m+k0d592lXxPG/pPqr8GmQ/3v
w5l34+SflEvU/zXsntKvfSx7znPv5XvE/ZTOr9D55ZvZb63qr8ZmGrtdikc0
v+OKJ5TfLS/T/B7Ircp/LVcT99+xn6v7L9uC+5W/CqfK2N81K/7v/o7iTEj5
F7AZxrYfJxdqfi+1X6Pmn5NnsZlXzzyK9P6qZKP64zhsdP+H5HpszmF3Xu+/
V/Ec78u9qNd8lf9NHlJ+SQP9taj+KE4N6/xaHG7Bvk3xrOZ/Brse1X9L8Yj6
f4aTh3X/I/Ii5m0K4+xfqfwITrXq/VtsegqpP4FtYg71n8LJL8X0fx27Jdg9
0fqlrPcfsL+h348Z5Tvd/+JG1n9W/+uwi+j97MapctV/Qu5S/mUc7lb9D7Vf
F/35N9hE9X7GtX6Dvj8LthIf4vvmVuPwW81vu+Jp5R/DSd2PvShPqv772G7U
/Q1qvzW6/zHsJ1T//Cb6fZSfT2nORaua/v8+/wHnCbvu
     "]], 
    LineBox[{{1427.9746527221014`, 1.01}, {1427.978515625, 
     1.009023666381836}, {1428.009033203125, 1.0010426044464111`}, {
     1428.03955078125, 1.0004169940948486`}, {1428.070068359375, 
     1.0017606019973755`}, {1428.1005859375, 1.0054136514663696`}, {
     1428.1025962574008`, 1.01}}], 
    LineBox[{{1428.2175719796307`, 1.01}, {1428.22265625, 
     1.0039410591125488`}, {1428.253173828125, 1.0007789134979248`}, {
     1428.28369140625, 1.0007649660110474`}, {1428.314208984375, 
     0.9993067383766174}, {1428.3447265625, 0.9990817308425903}, {
     1428.375244140625, 0.9988210201263428}, {1428.40576171875, 
     0.9985424876213074}, {1428.436279296875, 0.9988991022109985}, {
     1428.466796875, 0.9989610314369202}, {1428.497314453125, 
     0.9996947646141052}, {1428.52783203125, 1.0061722993850708`}, {
     1428.5288365720291`, 1.01}}], LineBox[CompressedData["
1:eJxFln1o1VUYx8+m23zdi4qZ1fzJmDiWRYWa1NoJS9MSbeb0zul+m7uUEirV
Isr0FIJDKS3DSlb8WpAvSFpUSJqchHaLdGFZmEn+rGzEJr6x5nxb1/v5Qn+M
y2fP833eznPOvWMbVlQls40xLem/G59vFlSfT1RtsWW1Gw92jz9Xmf6XWZjm
9Ic7OirD9kU4HtI/w+5dODp27ewN9nvl3webY3DYdznDtgcOCi5l2I2ci77l
X/QTYVOEv5kH+0HY7XOwbepFvxl2f0r/KRx0daP/EY53Sn9e+abCrvAJ/AuH
ZPrxd8K+swf9bDjc2Id+OWy7rqB/Tf67rpJ/l/y3GeZ3SP7F2cyvU/nmXkc/
aB71lxPPl8HxLNjMgKNc5mmfgsMSzW8d7EuU/yPpe7CbNtim6MeeVrz10vev
Jn+KefoSOErCZqp4uvQNcNjG+bhX4OB72EeKd1z1ezjWPtiTsFmbxf5cF/fC
/rb59LNV86uATbbmXyt7heb3Ehz+pf63wlGR9F/C9qL0v8p/E+wuKX5LHvlv
WkD990k/GQ7ugG01HL0MuybxDti/BZvpnLf5DI6buC/2J3E7dndB8Ver/6IE
+gRs7oLjXO3PHDj8QPNbAQd/KP/rCe2n6v9Y+nrVf1j+RzS/Ltitk35wDfEL
mY8ph6O9mt9M2OVwnm5pjc5T82+GbYL4ZrvinZA+Jf9W6f+Wfx7+Pmeh8qv+
UthPkv4h2J0cQP9LZB+RS/2vwibZD30rHDyo+X8t/7KB6GPxNObr++TfRj9m
TC28D7YPwPGTqn+R7Pna/1Wwv6z71wKbT7gPdh/s9mv+x+HwG/XfC9s5ev9u
XkS8LOnvFU9Q/vlweEHvx/NwfEjntwV2lTr/z6UvZV7uqOzDRtL/RdiMyWF+
wxfjv0393w3bDcr/OBz9ovNfKf/3Vf8mOBgv/W7YnCa+a4fj37X/Z2DXof0Z
Wkd/+ar/djhIaf8frdM+6fyWyb9T+7MejkrxtzukPyD9t9Jf0/53SF+j+eWF
+M+QfhzsN0v/MGzLh6NvhMP7B5N/LRyt4X2xH8LmKnZ3UPZW6U8p/mS9H1n1
zKNY+QPYVih/pexrNL/FcPyV+l9dr/ur9+M9OBwn/X7xs+r/N/l3qP8rsB+r
+Y9uoP567pebAkfmFvQLGnSfi8n/guwn8tG/DfuVBei/EK8K0P8sfWoY+m7Z
31H/I5ZwHlP0ft8DR9PUfxUcH1H9z8D+EfbJvgHbSun3KN5M2P8Au3b9fjkr
+yz1n99IvoHST2jU+6ffP4/B8VDlf1r+1fr+2wCHp3T/d8K2TvP/DnbNev//
kb6cedsBSfhwep+WNd96bnTy/99r/wH91uQ3
     "]], LineBox[CompressedData["
1:eJxVlntollUcx8/eLaN0KZbLWNnjSJkmomYqWnmyjKbiJbYiXfSkLDWdr5et
VxfVscBozFyGl0r0UefmhW50n0THoBZmSWoXB+UTs8gcucJppJvN9/t5if0x
xme/8zm/3/mdy7OBc5MPlCWMMfu6fi7/dtf1nPZL2UY7pHTdZ+2FbRO7/mRa
uvhyqCQ/zTbxuLjuijS7geIglZVmb+GtRn4oNj0vnUn7z4qjEWK3VRyWiP0n
Yv9BZ5rNT8w3RfPZi+J4k+Iuf754suJ+vDiYQ/7ZYrcGf5XYNovdZrhD8/kP
8XupHvODOKqm/nPkS2q9rt8Czd9K/aPFcX6H/GKxKbogfwXjH76o+teLfRb5
3xGHhxU33zKfE9s2cfCM5ne9Fyp+SuyHw5eof7rYvk395cTHs/4asZlG//YR
D+nfV/Ae/D/EUR3+VU+o/nr8QnFcg3+/OEioPjsfPkH9a/CPUv8usVlN/z4n
Xs3+nWT+A+TPXqR6sshfANex/kniuJ36H4MPcX6c2FXgb8PfhP+p2Jwm/8/w
UPJ34NMPf+Ni7d99Ca3/DrHJIf8csW0lf5U4fg3/VbiD/B+L3W3k/5H5cvso
/3nG346fVy4u5/6MEftZ+CXEC6m/QhxNxH+FeJ7Ot3m3vPv5O8L4Wvy/xOH3
nP8+S7S+SdQ/Quxfwp9BvD/3fwnxWs7/WriA+t+A2/APicNH8U+L3VjF/dVJ
9ec5zt9QcXgT6y+CDf4CsV3O+XtB7CrJ3wC3sH9fiD39dr+SbwLrz1mqfvHe
mVvE0Xf494j9LvZ/rjhsJf9qseU8mu2M367x1sOd5D8hNqPZv07yZeMPWKb6
eY/tnWKTef9KxfEZ/KcYvxT/dbEvwW8U2374x4ln3o9/xEFm/f2XK1879Y8V
B6fwHyQ+jP2vFMeH8TeIwzzyv4c/k/4dhU+S/2+xP0v9fVcoPkP30Y4Uh6ls
5Z8pjjLvV1Jsh3D+18HcB/sm/mLq/1ocX4/fyvip+L0qFG9k/28VRzXUP0Vs
1uIvhDPv14tiO4bvx25x8BHvZxNcTP9+w3+Z89ujUv5O3t9BcCP5763kfuHP
I76f/j0vdj1Y/w5x7Fn/AbGZzvc/FkcH8c2T4qT6bW8W21E58u+Cm7U+/4g4
nMD372mxKaD+LcxXr/Fuv9gfw2+GL+D/y3wB/b8h1e29dOPgXPr/kNjMZv9S
qW73wW6E5+G/Lw6O4B8TRwNY/1m4lP5du1L19MUfJfZ3489ayfvM/i8TB/w/
ZGuJN7H/b4lNEfv3jdha8v/J+Ab6l7tKzPfSDRMHTbxfU8XhNax/EeOP079q
xg/C3yP27Lf/UmxbyP873Bv/yirxXvzBYjMOf7I43oZfJg4aus5Por54uKv6
///T/wAi1jLE
     "]], LineBox[CompressedData["
1:eJxF0k8og3Ecx/HfpDg5OchpaoXDJGpxsZ+DxmElKyXKk+KgyZ+TNtt+B1pI
0oqT2sFpFzs5OTwtJydKXCRxUmpLNmyYZ3t/y+Hp1+v5Pp/v9/etp2NueWK+
QSnldZ7a6VtsWjqNHOrumf1csavgd17ZOcfOaQ031q2esMl/52vWrmjdSmHj
xjqGbT82SaxmxaNV8nFx6of8MX7MVsifY2vol/y9zMvI/ApOV+ln2jeo38j8
QWymy+SnpB7+Ir+OdfmT/BG2Cx/kz7BbF8nfigdK5IuSH8OmNcb9t/ne7sc6
Tj8VwmaPeXoNqx3q5kBckv2z2AphdSX9R7DOS78o+5mWOPUItr1YJ9lXBbF5
l/lhqQdk/11seeT+GWxvsp+6lP5B6voFq5U38s0J3Cf5Tmw89FcB7PbJ/AXx
KvuYLWxNyv4nOJ2S/S+k3uuq/4/6WebdtRX81z3jD6+J///3DwQh7rU=
     "]], LineBox[CompressedData["
1:eJxFmHe4z1Ucx489iowrKvS1spNkPFnHCCFkZCR+ZJSRRFbiXHvP69ruFyUk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     "]], LineBox[CompressedData["
1:eJxF000opVEcx/HTeK2ZDTXY0KM0YUUxJjWcydQ0jaEhsaCeyOI2C1IjZRYn
WVBiMWaS2TwMbimaGhasDkUpKy+lWehqysIY97rycqXM9Xz/sng6fZ7/+Z1z
nnPOk9vaUdf+SClVEX/u2j9dybsfvW+6oHlk9Tw/Uhl/pXrjjje2NNW3Hsdq
I9m3WcL6ANs97A6mkL/CzhvqOnPCtzeUQP65eA/bBmxXEsl/ws5gEvlR8RJ1
8wubKLZbku9hPBXFoQNFPm2S9S9eh/18EXbLL33bWuy8v/CtOrDJv/Kth7Hu
j5Gfk3oGtpviWfqrY+wFzsk//sF6yhjfFGIzh+1bqQfOyAfE/SfkB8QlYfJB
7J38I7+OVS51dYjdNayTppiv/pR8Hg71RMhXYe8dddUm9ft8H3Zm6W8mxF8k
byX/Kko+JB5jPH0rfs16Tc40+7n4l/xLccMx+RYcmpTz+4zNC+6j+Y7d7SPy
y9J/CKvfUq/GOoadXeYzWTP0f8L32TLs1Mj8jdjLxrobKyPr/4pNLedjFyTf
Lvu/Iw6zP/oMu1r2Pz3I/C1y/sXYbboh/wF7idxv3Sn1SBrfP4JtXRb3f17G
63sWqdzPiz39GXz4n/8DlEBInw==
     "]], LineBox[CompressedData["
1:eJxVmHt4z1Ucx8/M3CZKCbn0JQlP5Fn0lHk4qqUYT0mXFfoiaqFSIhWd6CIp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     "]], LineBox[CompressedData["
1:eJxV0j1IA0EQhuE1xiaIWsUqEJGAB4KVpWTBIlgpERF/iiMgWGlj71qIlSgK
2qayMViIVqIsKQJCCk3SmyYiKOREROJP9Nx3QCyO5bmd72Z2uYHcanYpopRK
hc/vWrzoX+i9OdDe4k7xdShIh69MPHS42kKnsx3F6lI5qxmcP4446zVxsoP8
Pjbr1NtTXM98NV2+It+bp14/S/1L2+2bvltnnf1wtiPia8lPYn8Y6xVsd7/J
b0v9PbYFnEzI/GWc35T+j7h+JfPHKtjD1sO6Jf0nZL/BfHoZJ8vsmy1sSi36
H0n+gXpVwn5T5m9IvuedfLTKfCdv5AfFs1iNY334ST6HVTc2G+LpGPPnsZ+K
cn4rDrgPfVf9dz7TxvZM7i9R4zzFLvJjWO3Fg/T51FNmrvb3//wAKErJeg==

     "]], LineBox[CompressedData["
1:eJxVl3uQj2UUxx/rfr9EKUa/NXLJbW2GmG29s6LcIhNtsuYNkcKKXdE2eTWU
cl9yKeq1MYTQkCaiB7k0otxy591ld9u1d7eVW2u/H9P0x85vPnvO95znOec8
z/P7hQ+N7/9mmDHmesnfg89ebQ9sHHJ8kdNi8Nzd15sXdCn5l5dUwiWfbnid
UrZfiO20sFI228R+wr38B+ycFgfhd0rZKxaHUu+Xsn3shDimmvQdxf675UvZ
GSh2MxTPS8SeVyz9QrE351Ypmy3ioNVN5T8mtvP/kb4I/xStx9b+S1xXbNqJ
Q6PETj+x0431x+PfhPxz8D9H/g1im3tX+kPYl6DPEbtd0Vc9WcpmPfqWYn8Z
+XuK7SrWP0rsBLelnwEni80asTuN/PvFwS7V28sQe/WM+lf+lNZ3pazq/5TY
jSqj+j8vDsLE3jCxfxv9R2JvIf1PEdvFyufsIt4S+XsB+g7o7xM/Uv7mydPi
WOYnWuyuof9x2Beg/0DsxYjNMrid1uNsF4dqs/4zYltFdntL7KTJbh4/o370
riT9s2J3XTnpX8W+T/52othpzPoXif297P8Hsa3K/o8TL0f9sVfhAP0jZ8XJ
6CPF3jH69zLciP2PE9ud7H8ePEvsbBT7W8l/WGx6sv5ccegO/a9+Tv7F6FuJ
bQr6XuLQWfK/jX849ftMHLRB/y08A/0B+D30mWK3GfuveF7r68/8NhX70Zyf
bmKnHPM/HE7X+TDT4JnovxHbE/L3dmNP4PynioM56MtcUH6H+ofEfmfmr4vY
JnF/DRG7m5j/D8VeLPO3XBx0Z/8/Y/8V/VniH+H+uQ03IP8TF7WePuy/kzgU
Qf1ixQ71MZPEwVLt11mM/rDuG2+r2HK/2BNwBv27LnbHNdX66wayj1A9vWfE
bkPy9xc78dxf48WhTtR/vtiPoP6bxN4q5v8P9HVUX5MvDlpz/mukyr88+28t
9i+g7y12y7L/0WLHoJ+J/0z6txb/7eh/EwedyJ+F/zvoK6VpPxPQNxN7Pehf
9zTWy/kbAW/SeXKmi20W989Ksd+e+2eP2J3C/Fwi/mzu37BLipeseF642E2p
IL0jDi1F74ptIvM3Bf+rzN9XYod+2x1wX9Z/XuwncX7voE9VPK/BZcVvh76z
2FtP/kHwMNY/WRzKIv8SsT+O/f8oduty/5xEvxv9DfwnUr966bwHzF97sUe/
zCviYDzv54R06k//kuE8+ve92DnA/BxB34LzV4D/w/w1M5TPRd9G7HIezUti
U535GSN2Yjk/s7Afld2uEweDyH8QezT5s4nfmfu/cqbqUZb6N8/kPaN+L4q9
SOo3UuwmUP+P0S9Gv0oc8D6bvcQbSf8vZ/7vPvfK/i19FP1rLA7FoY+BezJ/
b4jNSOrniYO11O9rsX14fn4hfnPWf4F4k5i/u9ivkb9hluJF6X02UWKzi/yv
i51a6N8Xu3Hol+K/Tt83zU/Yp6I/hX0s+pvE20H9Hs1W/m3Uv4PYcB6dAWIv
VfG9BLFfKH+7AHsE+s1iew/9UfxHk78wm/dN+7W1rihfPucvQmxvVJa+L/Y/
0Y8VB6vJPxs7+cx32DdT/9+JV4f754o4BNsqOeJE+ve02O/L+eshDvbqffDe
EpvCa+r/J9hrFWr+V2OPypN+n9gNQ58udibnSF8uV/mj5W+awGnZ0ncV+8Mz
pR8qDmIypJ+KfZ38zQqxbXpFeov/ykvSX8zlfhPbe/hPuSx9ozz5D1A+5zl4
ueJ7g8Whg/nSJ8Fj2P+XYhN/XfptYr8S99dpsZvP/VcMN2R+6ufLv21F9a+j
2LxWVf0bCM+tKX2iOHRV82I+h/dVkX7LQ3/0x8RBRf1es0Xky2ggfZ0C2Rc1
lL6dODRW36e9fmKvDe9XPPZBYjNX7Mdpvp0NYreI79+HxCZb+7M5+Mdy/qsV
0i/0LcVeDuevJzxdbEeJTX3yf4p+J/VbI/b3yO7tR/8C688Q23mql6lQpPmM
rFHQZUXKyT6Ni/77/fwvNej9BQ==
     "]], LineBox[CompressedData["
1:eJw1zj8ohGEcwPGH8+/KSbFYzisLZVLKIPcuMrgSixL1ItlcpiulnjKZnOUm
XagbLGfQLW7wMFjklAwyvVI3uos7yuXP6/n+DG9Pn+f3fp/n6VtOzK42KqX6
g+9vDXnZw6XXtDu4sHtZG6jEgi2zEjhY3bVOa7WNvUSTtXuEndsWa32Bdamd
3sf+RIRevTHf66Dvxf43/+tx7OyE6RexW8JqC3t3rfT72GTl/oJ4HpvH/3kz
/af0B230PVW8Lv0odn+kn8Mmz30qKQ5Ln5Y+zvt0XvqU9PfiqPRVrMd4j9tV
Yz6C9TD24yH6GZl/NNBvYH3+VbZ9CquzurU+waZYsTZFOS/6bK1esFd/oI+8
c37mmn4Im2SBfgo7N6fl2HH4atoLnJt82uzOlWO/PYW7AA==
     "]], LineBox[CompressedData["
1:eJwt0CFIA1EYwPF30wlOcahnsXgDg2bTFLyHIBaLChOZ4BAGtoFBVHBeUItB
BzIxCCf2MRYEwXAsGU1Lhs1g3QxDvRXP9//C8fjde//vuJfaLaznY0qpVPT8
r3ur10cL32VdWWkd25W2G70KliNHq05WjVUeB5/PxvoM+8VXY+8Rq0yDvi7n
b1r0H9g5VR3TWz/GzULc2HOwN20ZBy7OhX3Gakf21wboizjoT9Dfy7xwhP4F
Oyej9O8yz8K6h/3sGP3kL31inD6NnZr0W1ifc14fyn5a+lvsTdj0T3J+nnmq
gf07+X5Xzl8k6e2Q/cVh+jmsH4boN7BX43/1Ps5dDtKXsMpyn0FV9jNyf28y
/ytG38bNqWheaWnzIN4r69ntq3p3puP+AUWdqow=
     "]], LineBox[CompressedData["
1:eJw11ntol1Ucx/Gz39z2m/vNMdt0OFo/nZdpiPmHSUzz6AIvkEWkSBN7Gsy8
dGNKkAg7eCPRnEaZWI4ndZXm/MMbGaEHMQsviFPUQuuRFWFibm5zLjfn/L0/
/jHGa9/z+Z7zPM85hw2tev+16pgx5pO+n8e/yw83jyx+sNWOnl93oqOsZUrf
n/zYPvf9DtYMStm8jH0YT9m+g11j/5TdBnkx9nuxOVNI/jSOyqjbmzisoJ+L
d1Mfi/0o7EqyyU+Xrym/ENsd1N1abKo1/27s2+hnTuLguvLN6jdA64/10K9b
+aHYeWym4jAtQT5QfXIu+Vp5ax75ehxlFpA/hpPfF5G/rvqdYvLd8oBnyBc/
ZPysEvLl2GUPIf8GDsdh95HqB/hefhsO6geS/wFHdazXXsF2j97/PdULM8kX
9vL+ymLkJ2D3FbavY1tuyC/D4aWeO6n8p3J+d8rmADZ1/6dsL+DoVmfKrkX9
L3eRzzNfpObPuUd+HA6XM97OxtGCNvLvYrsd+40aX9RBfp/67btL/ozqZdTd
v8p3Yp+dhqvvkx+Noyta/wzsA57Xva16I+/Dr8OuAptvcND0gPzPcpbyf+Hk
i73Mnx6j3+U08qXYTKCfnYbDSr6Hewu70/2Y3+GgXfOH6pegnz2u/NyHzP8H
9pP0/nvkUp7XPJ1O/1F8TzsJh0+xXleJ7U59/xXyDOpmOzb1mv8ojuZhd1Vu
Tmf9nerfwX40g/thx/PZ57EfkUV+jupTtX+XY1dM3XyGzQjq9iC27fRzTThY
rXwrTt7U/s/PYL4h2v/P4TCX9bpXVP81g/x7OEhQN5s0/ojuz0Zs5zDencXm
vL7fLRzVYJOTyXpmav4x2NTo+8/Ebove3yLVm/T8H6uep/3zrepL9P5Pqf67
9u/fOMrV+c3I4vl+4jzY4Ti5E7sKbAzn1VepvpvzalbhaL/O39caf4rxzqu+
Wfk/cXhb568X2426v0vi9H+T/eomx/U92K9+vtxC3azEvkbn90tsTyj/Y1z3
ifK/afz0dvJdGn+ulXxRNvWY7o+JOGj4j/xc1fdyH5kPVd+l9/c5dgW6/w7h
ZBV1fxHbF7T+No1vVX5gf8bXsl43Hocluj9eVf0lnZ8PZK/zU6fxDdo/+1Uv
0P45p3q59u9tbJZp/yVyWF+X7v9nc9Rf+2cWjm7o/lmCgz06/+txuFT579RP
95P/RU7T+ftH+W355DMTzFc5rGVK87DaG4/95P+XRx/Zhuo=
     "]], LineBox[CompressedData["
1:eJxF0bEvA2EYx/FHYywdTGLwMtUksZBIeNNImGvQQS6NXMVEJBKDSC76BzAx
MByD1dSkIZHjHzBZWM5sULQUOXV9v09iuLz53O9+7+V93pGVjWIlIyImfbpr
00smC9kjO7a8f9vKN2bTV9Fc6u4ntayz+Di8zjjbKi7Pi3Nwpvl08uL6N+pT
cnnC0dqXy630OdvntnMwjI35oD+jefLpLB6OF1/p72q++k7/BIdb2r9S977R
f9S+z//sN5bjFv3Bfs5z3qA/hWWJXErYVn/ob2tewMGh5h3OF9Vw7DEPudf9
68zDNnFY6dAfyDGfnV/6E7jcJpciNqPkdhPLgs7/QPN1HF3gcLyH+d/h+DL1
kG/2HnL/9/0HB5iY5Q==
     "]], LineBox[CompressedData["
1:eJxV1n9sTlccx/Hz1I9aabVa/aXqMkGXhUlaWf3IzpYZWQ1ZTYIl7taUJbM8
UpO0mthBG2xDFk2kMnFNUEMwS/AHu2FLNlsyJtnEhjtjKwmqVoquPHven0T8
0TSvfs/ne7/n3nNvOvTd+JvVKcaYhsTP/7/X1o79IiVzky15e8OJjlFtLyX+
5NITTvwOBvZKOnxebkpN2kyTv++TtH0f2x2sdx9jU9Wb/G4cXWW9+UHrx2aS
b8UulkE+NStpv7Ef+RHyZeVfw66V/rYahznM5xqwF9P823FQhM1Jre/uSf4y
tn9q/tgA+i/qQd7D0YvYWNVTlZ+P/fgz5JfjYB8Ot8jv6f4d03qr+f/AYTH9
3EOt35ZCvjAbe9TNeOzFmdfOwWGc9a42W/dP93+T6v2YxxxWvQnbX9V/sfbf
gd0q5g1zcsj/rf2XYr9L16/Errf2X6P1Xhr5z7C5oud3UF6p83MaB519yd9S
//3sN8wYSL/XY+RHY+9n9mvfUP1z7X8R9qcb8p9g06D596g+49GtZP4Udvf/
S9pdU790rhf2yaX+O+vNKHmn8lOwvwa7BTgs0/lpxFEp85kd2NbQ336r+mzN
/5f6X9L8KXnMP7yb6w/Dbhf97cvYO89652N7tCu5PvwoT+f9Ifmt6ldA3R7H
fvkD5r+gfMk98l04aNT1i/Lpl99BfgK2xZ3k5+br/Or6ddhbiU2z1n/JPPaI
fFz7/w2ber2/d3Gk82xyC6iXa/9lchF2s+S5Oj9LsOvS89+o+mTOt/1KrtL9
O4O9s8q3Yf9fvX+ZhcxTp/d/DPY26PszHQcVev8/0PrVnG+zDvt1Ov97cdiO
3Y+qV+n9uY7N7HTyaYNYvxzbEuw15JKfKk/KJr8Q+4f43prVyp9WfqfqLf3J
f4ejcuWvqF9ZDvmeRdzPCn2/n8XRYuZ1r+Bgu+Z/B4dNen4rlG/R9yeQS5X/
Rv2quV/hRWxn6vvdLcd0/wcPfup9cxOxX6nzNw8Hy3T+6rW+Ted3M45aqbuj
2Bt0h/w59Ttwm3wnNhvbyOcVU1+B3TjsCu+Tf0v1NL0/S7EZST/bhL28m+QP
af1zN8j/Ijts2nE08jr5rCHs79g/5F/A3qu8z+EM1Zs1f1yuaie/Hoer6Of2
4ehD6uFP2H6aeH5fN2eknh3y5P+Fx6ecMvI=
     "]], LineBox[CompressedData["
1:eJxVlntollUcx89mTte2Ni9BQ5zP1Ndtvuo20iI1dlTKvP3RFEtNfdBWtKRS
NBUsD5qpeS1KhYm+RpKodKHLwDIOU7yjgtmgop5tpJnpRm46Z1629/OV6I8x
Pvud7/ldz+9Z/pzXyytSjTHvt/90/H5m5JxT/YKttuiFTTUthU1l7X9yA9u5
43daepL9ODice7exg80rcLS/Ncl2jeyjbybZfSr9zrYk+yNwYkSX5H3mguyl
Jsm2c77ssOsv3gb7MbBfDpu5cHRI+hWwy+iEfpd4cmf0HjY10kfi2B3ivyt/
f90i/ry+Sbap2P2TsJ8Bm5lwUNcV/8tk/z0F/1Wwuwb7A7JPScX/z/fvI157
E44qFf8j/eDfOO8fh01uGvrnYDedets3xXHq7T4SP3ad+L+Gfes/xP8jHORJ
fw1OfPcA/rv3x18L/fKlcCKbfptnxZPU/zdgd1n+N8E2UP6fyR6q/qelX51J
/ld0/pzqlxnDXqD847Dbr/pNkP0w/bWVsB+r+VkLhx9SL78HjtbK/zHZz94m
/ouyz4Rd2gDujzMPPgaHNf+S/1Nw8Ifq9yIc7WQe3EpxD+7zH8Pmb+pjamTP
0fzWDfh//KaA+1fw3nwf2KyhPqYMdrulnwXbEs67t+CoQf63i4+oft9Lf1T5
/yKeSj1dm/xfyqN+uYX4X0W+5gk4PHMD/fOw39CM/8WwOwj7LeIfND/fSn+b
eOx52XvKfzMcfK7336OI86+pf4+K68jXlovTVb/5cKI3/fKbYT8yA/0XsF1A
P+wZODip/XVV53NhnzWQ/Bcr/8Fio/wnwj6m/fEqnNig/r0n+zLsZq/0Tvvn
OOxy1L8/4aBe+XeJox+l/hfA0RT2s30adkuVf4U4Jv07Op8t/SdwmKn5OQSb
WcTj6uPav6pfyiDqNYz+mHzYHeM+a2FTkoP/2XDYyj7zb8OJ8/p+7NB9jdIf
1PnNej+/6nwW+8jfgoMZir/XYPRV0g+H3Ubtj2myL9T+WQJHofq/Tedj7Adb
LfvL6t9Psufr+9UiDvX+Hx5CPLNVv6Fwog27myz7esW/AA63KP4PYDde+/9L
2NxQ/GfF2zU/jdJnaf6zi+GF8j8EDpbr+zGpWHrlPw+21fK/Xna9L7sP9lt5
j+6E+KsH0V+Sfp/2R3oJ+mrFXwjbrpq/sbDL1f55CU7Uav7fhcNy6mV3674T
mr/DsO/zEP4bdN9FzV+nUu77phv++8KuSPtjFGxqNX+huErfTyde1LupzK1c
t2p16X///9wD7pCBag==
     "]], LineBox[CompressedData["
1:eJwtzz1IQlEYh/FTZB+a0BBNhbXlFFlOEfdsbg3hFAW3oNWWGnI6tEdBRLQ1
NURINbkYl+hjaLEhgkiyMRJuQSJlX6fzvINcfv553ssdWliaXmxVSiXs7/+5
n3uYPBrd0cnZjbP68Ktn/zKn1vbpr0WdgwpW5Q5n9Y31Zruz7k85mwN2M4HV
e4R+BuuLLvo89r+4r3dx1YvRF3HQGae/kz3RTd+QPY513xjvW+WeSePBJu8L
sjj44L5axqbURr+F/ccW+hPpa7+h62+kn/txVm+yG75P94zjbNPtZgTvRT7p
p2TP1OlzuDqP9Tr2n2v0h7KX7+mv5d4AVi9y7/yKPppmj13SJ8WV49BrbN+u
pKwLmad8byH0/gCHmpS5
     "]], 
    LineBox[{{1486.1494269013199`, 0.99}, {1486.175537109375, 
     0.9987683892250061}, {1486.201923079508, 1.01}}], 
    LineBox[{{1487.4288137838123`, 1.01}, {1487.457275390625, 
     1.0077260732650757`}, {1487.48779296875, 1.003340244293213}, {
     1487.518310546875, 0.9965677857398987}, {1487.548828125, 
     0.9915966987609863}, {1487.5672020212448`, 0.99}}], 
    LineBox[{{1487.8387316566557`, 0.99}, {1487.85400390625, 
     0.9909914135932922}, {1487.8597626149601`, 1.01}}], 
    LineBox[{{1488.0403305778166`, 0.99}, {1488.067626953125, 
     1.0074825286865234`}, {1488.09814453125, 0.993202269077301}, {
     1488.128662109375, 0.9938223958015442}, {1488.1591796875, 
     0.9922780394554138}, {1488.1747864555196`, 0.99}}], 
    LineBox[{{1489.145729241655, 0.99}, {1489.166259765625, 
     1.000839114189148}, {1489.1844683029055`, 1.01}}], 
    LineBox[{{1491.0998057587703`, 1.01}, {1491.119384765625, 
     1.003697395324707}, {1491.1461736666763`, 0.99}}], 
    LineBox[{{1491.5001369489753`, 0.99}, {1491.51611328125, 
     0.991913914680481}, {1491.546630859375, 0.9976035952568054}, {
     1491.5771484375, 1.0034695863723755`}, {1491.607666015625, 
     1.006201148033142}, {1491.63818359375, 1.008083701133728}, {
     1491.668701171875, 1.0096217393875122`}, {1491.6706786820203`, 1.01}}], 
    LineBox[{{1492.0956057053352`, 1.01}, {1492.095947265625, 
     1.0099146366119385`}, {1492.12646484375, 1.0086872577667236`}, {
     1492.1303670965567`, 1.01}}], LineBox[CompressedData["
1:eJxFk0FIVFEUQB+WmpnSCFoR4hioDW10EQrO1FtEC1to4+RsbPhMRLooN+nG
IZ4DYauGaKgIoU8EthIXGpEgTxdGUBAkgcLgF2FoITgGQbVo/P1zwcXncf69
57737v2/NT0Wv12hlIr6z//1QTmbKAw815Hh3Oqv86XL/iu95bO/2khHwOaf
cFNLwLb5esA6djpgFYONasUfht3SOfxJyX9Yh/8SVm9C+B9g7/MR/A3hqRr8
38LpY/in4vhVVfjdcLhQiT8k8Xcn8Mdh+0n2z0u+Q1wtCN+pxf8GO6/E/wm7
ubP4oUHu+4R81SU8cxJ/AHYbOZ8ZE87D9jHs7XM/NQfbkQr8L7CzRj/MrnBK
/NoE+70gX12AvdRx/D7YfqcfZlTivQr/ERy+fxT/Lexeo77+KPkJ6pmicI7z
2Mob1N+mvmqDw3fFvwJ71fX4t4S7GvGzsJ5vwH8Nq2Xy9YrEO5mX8WBT5Ly2
LPsZmX/LENxdjX8JtlHp/01Yb/C92QzsZmR+M7DTTn29JPX6Zf6b4mvq2z+w
Vy7vBf6ZJOfPyPfXAztPZf+kxC9K/ydg76rM75nEd+iPXoTtPfpj1mH93s//
Ozv99Ufy8H89AOU1CwQ=
     "]], 
    LineBox[{{1493.9992232051302`, 1.01}, {1494.0185546875, 
     1.0013148784637451`}, {1494.049072265625, 0.9995580911636353}, {
     1494.07958984375, 1.0033962726593018`}, {1494.110107421875, 
     1.000445008277893}, {1494.140625, 0.9981762766838074}, {
     1494.171142578125, 0.9975718259811401}, {1494.20166015625, 
     1.003594994544983}, {1494.232177734375, 0.9989145994186401}, {
     1494.2626953125, 1.0036568641662598`}, {1494.2879282859506`, 1.01}}], 
    LineBox[CompressedData["
1:eJwt1Xtol1Ucx/Hj5mVTNqdphA585mJugSKlRV7YwdsSJVG66lzPbG5TZsZS
vNf5w1s5C9sfU0F7xC2olUwWSaB4cEwsJVEQDSsfcSiWNdN+zsvm/Pl7f/4Y
47Xv+ZzvOed5nrO8JSsXLE0zxmxL/jz9/fn5K8Uvvttgi0q/OJEovF2c/JOb
k3Tytxk8NGW/HLsxjzuf2nyGw813Urbf4GDZvym7UzhKPEjZ39D42qzUfGbA
wpTj+udStgXYJXrIz8RB713yFRpf+Yj+m7EtvE//g/IU5U9g04X9Vc3X+JB8
n0Wspx3bALvsPuy/WK7rJV8mf8d+zMc4WqP8Phy8jd1RzV+VwfldxnEP6zGP
VM9jP3ZEKev1zO9exfE46v4d1etZn1mL3SX1b9D4A93kf1R9jaH/BexvYpPA
4a/YDlvM+Ik8X/cSNhu0/wU4qtPzr1V9tfK7cNjal/Nrkc9q/Wc1fpfOr1P1
A9p/dhnzn9T6x+J4Xj/WP1f1Nq2/Boct6fTfgX0Ddfet8o/1/v6MzUqd303s
7mj9Ge8x32Tlx2A7k/34WTjYrnyl3ITtFo3frXwj9vOp+zbVqweRv6Z++Wnk
00L8P/t1eaG+J87bW9Wb9f6E2A5R/0+wP8h5uP3YjFf+GI76sh/zh+o71L8b
xyXKjyynf7me/yT5B2wWYneK+e06OUP7343tW3r/jyifqfxFbH7hedt78m96
/sOX4Bp9vxOwK9H+38BRIbYf4bhJ/b+U9yp/GNtO5c9pvjLt/7bGT1N+8PuM
n6PzG4ejPTq/11X/mv3YFTjOUb4OB+l8n75Z47P0/p/GrkX311+q79f+Myuo
x6zPF+LoiO6v17ApYj5bhYONun+2ql6QSb4J2za9v+3ytf7sv0P9QuzSl9Lv
wQDyo7Hv1fs7TfVj3Oe2HMfzsXOqtzLefyV3DCR/HAf7OE/7Jw4rtP4e9cvX
/Z9biRsT7H8KjjbxvdhF2GWOov96bLuH0H+PxufzPpqf5FzdP5fkUq2/Cwfb
dH7PVnGe53LIv4yj57Pp/yb2WbdY/yoczuhi/fUaf1T//1pxHLAeex4HzR3k
/1P+gr6/nGryRc+QHy8//If1z5MPXyf/ATav6PvbicO7v3N+32Pfc4P8GRx8
qvvnb82Xe5z+A5cxvp3x5gVsCy6Sn41NLeNdNY4/TParuTx1+pakD5VcXT/s
UGfxE03hhNg=
     "]], 
    LineBox[{{1498.3854253469376`, 0.99}, {1498.4130859375, 
     0.9947382807731628}, {1498.437423572113, 0.99}}], 
    LineBox[{{1498.4502155450905`, 0.99}, {1498.47412109375, 
     0.994350016117096}, {1498.4992844453707`, 0.99}}], 
    LineBox[{{1498.517218041394, 0.99}, {1498.53515625, 0.9913198947906494}, {
     1498.5525076797073`, 0.99}}], 
    LineBox[{{1498.5709234389196`, 0.99}, {1498.59619140625, 
     0.9948206543922424}, {1498.6232277520983`, 0.99}}], 
    LineBox[CompressedData["
1:eJxTTMoPSmViYGAQB2IQzeguZNSbNd1hnfvDKpF17+2BQgwLgXwg9eDBNjDf
4QCEf8B+PZjfcB/CT5DbBOYf+AfhK5jvguiXywbzHdq3QvTbQvgNa85A9MdA
5X/tgeivhvAfzIPYxzAbwmd4fAWifxdUP9chiP6bEL5CzmGI/h9Q9SXvIPol
ciDuu3EJot8cwj/Acx+iPwzCV0hn/ADWXwrhO8z8BtE/Fap+3luI/i0Q/oKD
wmD1DZeh+pcpQPR/gsobcYL5DEK5EPesFfhgvzbkeLcYkK8Z03/oq8YHewAL
sXa5
     "]], LineBox[{{1487.908624354165, 1.01}, {1487.9145228765392`, 0.99}}], 
    LineBox[{{1487.9500084759425`, 0.99}, {1487.9667811456634`, 1.01}}], 
    LineBox[{{1487.9864975182272`, 1.01}, {1488.005310085169, 0.99}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{1380., 0.99},
  Frame->True,
  FrameTicks->{{{1250, 
      FormBox["1250", TraditionalForm]}, {1255, 
      FormBox["1255", TraditionalForm]}, {1260, 
      FormBox["1260", TraditionalForm]}, {1265, 
      FormBox["1265", TraditionalForm]}, {1270, 
      FormBox["1270", TraditionalForm]}, {1275, 
      FormBox["1275", TraditionalForm]}, {1280, 
      FormBox["1280", TraditionalForm]}, {1285, 
      FormBox["1285", TraditionalForm]}, {1290, 
      FormBox["1290", TraditionalForm]}, {1295, 
      FormBox["1295", TraditionalForm]}, {1300, 
      FormBox["1300", TraditionalForm]}, {1305, 
      FormBox["1305", TraditionalForm]}, {1310, 
      FormBox["1310", TraditionalForm]}, {1315, 
      FormBox["1315", TraditionalForm]}, {1320, 
      FormBox["1320", TraditionalForm]}, {1325, 
      FormBox["1325", TraditionalForm]}, {1330, 
      FormBox["1330", TraditionalForm]}, {1335, 
      FormBox["1335", TraditionalForm]}, {1340, 
      FormBox["1340", TraditionalForm]}, {1345, 
      FormBox["1345", TraditionalForm]}, {1350, 
      FormBox["1350", TraditionalForm]}, {1355, 
      FormBox["1355", TraditionalForm]}, {1360, 
      FormBox["1360", TraditionalForm]}, {1365, 
      FormBox["1365", TraditionalForm]}, {1370, 
      FormBox["1370", TraditionalForm]}, {1375, 
      FormBox["1375", TraditionalForm]}, {1380, 
      FormBox["1380", TraditionalForm]}, {1385, 
      FormBox["1385", TraditionalForm]}, {1390, 
      FormBox["1390", TraditionalForm]}, {1395, 
      FormBox["1395", TraditionalForm]}, {1400, 
      FormBox["1400", TraditionalForm]}, {1405, 
      FormBox["1405", TraditionalForm]}, {1410, 
      FormBox["1410", TraditionalForm]}, {1415, 
      FormBox["1415", TraditionalForm]}, {1420, 
      FormBox["1420", TraditionalForm]}, {1425, 
      FormBox["1425", TraditionalForm]}, {1430, 
      FormBox["1430", TraditionalForm]}, {1435, 
      FormBox["1435", TraditionalForm]}, {1440, 
      FormBox["1440", TraditionalForm]}, {1445, 
      FormBox["1445", TraditionalForm]}, {1450, 
      FormBox["1450", TraditionalForm]}, {1455, 
      FormBox["1455", TraditionalForm]}, {1460, 
      FormBox["1460", TraditionalForm]}, {1465, 
      FormBox["1465", TraditionalForm]}, {1470, 
      FormBox["1470", TraditionalForm]}, {1475, 
      FormBox["1475", TraditionalForm]}, {1480, 
      FormBox["1480", TraditionalForm]}, {1485, 
      FormBox["1485", TraditionalForm]}, {1490, 
      FormBox["1490", TraditionalForm]}, {1495, 
      FormBox["1495", TraditionalForm]}, {1500, 
      FormBox["1500", TraditionalForm]}}, Automatic},
  GridLines->{{{1250, 
      Dashing[{Small, Small}]}, {1255, 
      Dashing[{Small, Small}]}, {1260, 
      Dashing[{Small, Small}]}, {1265, 
      Dashing[{Small, Small}]}, {1270, 
      Dashing[{Small, Small}]}, {1275, 
      Dashing[{Small, Small}]}, {1280, 
      Dashing[{Small, Small}]}, {1285, 
      Dashing[{Small, Small}]}, {1290, 
      Dashing[{Small, Small}]}, {1295, 
      Dashing[{Small, Small}]}, {1300, 
      Dashing[{Small, Small}]}, {1305, 
      Dashing[{Small, Small}]}, {1310, 
      Dashing[{Small, Small}]}, {1315, 
      Dashing[{Small, Small}]}, {1320, 
      Dashing[{Small, Small}]}, {1325, 
      Dashing[{Small, Small}]}, {1330, 
      Dashing[{Small, Small}]}, {1335, 
      Dashing[{Small, Small}]}, {1340, 
      Dashing[{Small, Small}]}, {1345, 
      Dashing[{Small, Small}]}, {1350, 
      Dashing[{Small, Small}]}, {1355, 
      Dashing[{Small, Small}]}, {1360, 
      Dashing[{Small, Small}]}, {1365, 
      Dashing[{Small, Small}]}, {1370, 
      Dashing[{Small, Small}]}, {1375, 
      Dashing[{Small, Small}]}, {1380, 
      Dashing[{Small, Small}]}, {1385, 
      Dashing[{Small, Small}]}, {1390, 
      Dashing[{Small, Small}]}, {1395, 
      Dashing[{Small, Small}]}, {1400, 
      Dashing[{Small, Small}]}, {1405, 
      Dashing[{Small, Small}]}, {1410, 
      Dashing[{Small, Small}]}, {1415, 
      Dashing[{Small, Small}]}, {1420, 
      Dashing[{Small, Small}]}, {1425, 
      Dashing[{Small, Small}]}, {1430, 
      Dashing[{Small, Small}]}, {1435, 
      Dashing[{Small, Small}]}, {1440, 
      Dashing[{Small, Small}]}, {1445, 
      Dashing[{Small, Small}]}, {1450, 
      Dashing[{Small, Small}]}, {1455, 
      Dashing[{Small, Small}]}, {1460, 
      Dashing[{Small, Small}]}, {1465, 
      Dashing[{Small, Small}]}, {1470, 
      Dashing[{Small, Small}]}, {1475, 
      Dashing[{Small, Small}]}, {1480, 
      Dashing[{Small, Small}]}, {1485, 
      Dashing[{Small, Small}]}, {1490, 
      Dashing[{Small, Small}]}, {1495, 
      Dashing[{Small, Small}]}, {1500, 
      Dashing[{Small, Small}]}}, Automatic},
  ImageSize->{774., Automatic},
  PlotRange->{{1380, 1425}, {0.99, 1.01}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Input",
 CellChangeTimes->{{3.538222566651021*^9, 3.538222608352092*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"dataFreq", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"i", "/", "8192"}], ")"}], "*", "250"}], "+", "1250"}], 
        ",", 
        RowBox[{"10", "*", 
         RowBox[{"Log10", "[", 
          RowBox[{"data", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "]"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", 
        RowBox[{"Length", "[", "data", "]"}]}], "}"}]}], "]"}]}], 
   ";"}]}]], "Input",
 CellChangeTimes->{{3.5377658861675634`*^9, 3.537765891503668*^9}, {
  3.537781582727993*^9, 3.537781652871865*^9}, {3.537782476929163*^9, 
  3.537782486117622*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"dataFreq", ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1400", ",", "1450"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.02"}], ",", "0.1"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Red"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", " ", 
   RowBox[{"FrameTicks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{"i", ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1250", ",", "1500", ",", "5"}], "}"}]}], "]"}], 
      ",", "Automatic"}], "}"}]}], ",", " ", 
   RowBox[{"GridLines", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i", ",", "Dashed"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1250", ",", "1500", ",", "5"}], "}"}]}], "]"}], 
      ",", "Automatic"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.537765717468706*^9, 3.537765749159317*^9}, {
   3.537765861238284*^9, 3.537765862174302*^9}, {3.537765977948535*^9, 
   3.537766085237585*^9}, 3.537781524118075*^9, {3.5377816604379134`*^9, 
   3.537781661030717*^9}, {3.5377821562001796`*^9, 3.5377821567305827`*^9}, {
   3.537782198570051*^9, 3.5377822592444696`*^9}, {3.537782424558598*^9, 
   3.5377824440303373`*^9}, {3.5377824921704607`*^9, 3.537782495898885*^9}, {
   3.5377834972522216`*^9, 3.5377835255664034`*^9}, {3.5377842313494086`*^9, 
   3.5377842317862115`*^9}, {3.5377843313404903`*^9, 
   3.5377844180174603`*^9}, {3.537784598681048*^9, 3.5377846633764706`*^9}, {
   3.537784739604581*^9, 3.537784756887099*^9}, {3.5377848087218256`*^9, 
   3.5377848164598227`*^9}, {3.5377849038983583`*^9, 
   3.5377849286736526`*^9}, {3.5382156104196777`*^9, 
   3.5382156402633295`*^9}, {3.5382179958471794`*^9, 3.538217996767581*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[1, 0, 0], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQB2IQvSVy3rcvXZMdZs0EgZ32QCEH3u7JDi7mpiaCJVtB
/AYdIF9CIUr95f/NIP4BbyD/otbkpbG31oP4DNlAfu6ZhI03WNaC9XcB+VPP
7f4saLcMrH8lkH8kNezwG+bFYP0ngPwH+bsqnN/OBOt/AeTLv5rRqSw6Fayf
vWeyw5w/nF8zXrWC9asB+TM5H7SF7qwD63cF8mdNSuJbwB69H6Q/Fciv/PXk
vxJPIFh/C5Af8qz662JdsHzDYiDfgEfv6smoELD+Q0D+9XlqqkfvQ/Q/AvJ3
LhBP33siDqyfsXeyQ8bnhn+l8iFg/QpAPk/JP+WtzUFg/fZA/l8/sbM/hPzB
+uOBfIfMvFDmyY5g/XVAfv0cx03NAYFg/XOB/MaVVgkHKxzA+vcA+QYr/cv/
RQaA9d8B8sV0Cp6ky1uA9f8G8md9nS9ofjIdrF+qDxheO9YtNLYuB/EPWAL5
GWEPqh7/awbrjwTyo4SCJ+6r7wHxHSqA/D6BDINSncn7TQ/vlGoA8qtF1rk/
rJqyHwCyLMMB
     "]], LineBox[CompressedData["
1:eJxV2mk8Vd8aB/CdJMq/UpE0CZVISppk2EmlaBKNMpaSoSSFxCkiosFBpVFJ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     "]], 
    LineBox[{{1273.3587639188047`, 0.1}, {1273.37646484375, 
     0.011554607972777443`}, {1273.406982421875, 0.005262533967827491}, {
     1273.4375, 0.010836314376872153`}, {1273.468017578125, 
     0.024954206526542982`}, {1273.49853515625, 0.08261077379289972}, {
     1273.4991360078186`, 0.1}}], 
    LineBox[{{1273.586475248207, 0.1}, {1273.590087890625, 
     0.05913995496191347}, {1273.5950808430925`, 0.1}}], 
    LineBox[{{1273.6760150859166`, 0.1}, {1273.681640625, 
     0.06674756940075731}, {1273.6837829981787`, 0.1}}], 
    LineBox[{{1273.7726191708507`, 0.1}, {1273.773193359375, 
     0.08610720927238186}, {1273.8037109375, 0.0282108577032064}, {
     1273.834228515625, 0.014656209950438691`}, {1273.86474609375, 
     0.009183943105405691}, {1273.895263671875, 0.0228061253483956}, {
     1273.9142472047736`, 0.1}}], LineBox[CompressedData["
1:eJxTTMoPSmViYGBQBWIQfdtxdfK+55MdZs0EgZ32QCGHy0B+v52r6rq75SB+
wycg/0bUiX/58nEg/gHBF5MdVudcs+B5bbIfyGcwBPJTE+//EZ9tB+I7BAD5
UtHT/B5+UwDrzwfypx9MmfLlwAaw/j4gn/0BS6+ybzRY/zogn+Vez+n+F15g
/WeBfMGMvGLtmWD5hjdAfpDlfD+bxBIQ/wD3y8kOW9kDz2g6V4L1awP5Ypwm
hs0b5oLd7wXkf5CcffndbLD6hkwgf+Vc/aDujGqw/g4gX+e/2LH9W8HyDCuA
/L/GRyTjVcrB9h8H8qU+t/lPkwLzG54B+WkL1mvdWTIB7H7WV5MdvH89aat7
XAjWrwrki0S4Ja/MA/MdXID8nnMXfq7PzQPrTwby/+fLp/ncCwbb3wTkf5S8
uaIqKw1kHsMiIH92WOuZJckdYPcfBPJTOGzW/PCKB4ffA5B9XsvO6sU7gPX/
B/I96lw2/FsXAbZf/vVkh8NzTX64x3qC7bcD8iXtD2kLOXmC9ccC+SfyxeQP
51aC3V8D5Ds/MLN8pNUEtn8OkG+y4RKr4es6sP27gfwjjU0n2A3A8g23gPyE
a4/VdviuAuv/CeQfnOH/dabXZHvh1Fxp9jeI9AMA3eD3rg==
     "]], LineBox[CompressedData["
1:eJxV2nk8VVvcP/CtNKGJVCQlkVBSqFRskpRKZlIaEIokKUk6lbkRp1AplZAG
mpPUTlGhQiMNVyjJ0IQi5fn4rt/v9Xqe+8e9r/c9PmftYe21vmvto7LKz8aj
B8dxufhX939zVrp912qM5w8ndf+TY4z/xU+DL4weNvj14GPdFjnC057VpQw6
FdFtYRP8LHBDjG9sWLe5Q/B6UZ5Gqu52yl+FE5N2BRYP20z557BNzZZt+ffX
UP4nXNWnJnabVQjl5ZrieXvltpvj5Kbf6c5Phqu1R3oP3e7RbZE1HGkZ+v2A
aHW3hfXwzy9nHyQq0ufcAXjVCy9t9cFulM+C27WtdqbtF1H7T+CR01WcjDac
pPabYKM2n6bfd29Q+/2b4/kpt7U9J1xeTcevDVuGrR//2WIltW8Jv9oif03p
hje1vwaWmufuXdTTlvIxsOIu908F+6yo/TPwwt0jBpkELaH8Q9ipsUfIHQMb
ytfBCZv9FUvOLKXj7/MVf3/RzXas5yrKq8MaAccPxwQ7Un4OrHn3WMxho2WU
d4eloq0WndoXQPkwOL16zLhYbgPlT8HZDudnxphupnw+/OPwusULL6yn/Ae4
zq5g7JVzdD6cxLd4PsPuZM/LMivp/EfDdsPbh10fzc7fGPYzC9xwU4vaE1xh
3bkPRm3K8aR8KCxXE3C5MXwFtZ8MO200Ljn/YDHlb8Fh3r5SHz7a0/V/AyeP
da00ambX7w98wKGnk2+LNbWv+D2etwq/al56eirdv+nwTj8rbxVjOh7BCXb3
ff9x8ZS11H4QXPgmLUn3ozG1nwD7uYXbH/pJxye6Bg8YoPLCqT/1D+EFvHRs
vr+X7DrKt8KGQSeUm5vZ9R/yI57fU+gw+Yj+GspPgX3K96wRzTKjvA1ctDeG
n9NK94fbAPc4NSwuNUuajj8Wloo6FDPgpwMdfza8mDsbOuTqMjr/p/D5C/0l
Mp3oenNfYYeu61eUE/0pP+Annr/IgOaWWlfKT4DHXVAcd55fQfkFsJn6E/OA
EnPK+8AroqNtxywyo/xu2NezT0+/I+Z0/JnwyuOR4akedpR/BNcpzNCRWq5L
+Xp4pmlpSg+5GZTv2xLPLyvI+W0hb0rtj4NPLJXtutZF/Vswh9MePTx6/+Jk
yq+G9cu/y2yVp/vLh8NmrXbDlM5Se6JUuJdYu0KvdDa1fw8enTHw2docuh5c
Ddy3qNx63SrW/3q0xvOrA37f/WxA5ytSgefHTfrr8ZWdPw+3zQ66o6XgSfkV
8BEHkw6VEkfKb4dD9E48l0ql/iA6BjsZWyz7fn0uHX8ezBn07Tf8qS3dv3ew
T8LQ7YcKZCjfCa8f/all4aDF1P6INvTvauMjY5JXUfuGcE1E362ddYuo/SVw
2cD0rb4FVpTfAgdOyfO/tZBdv0TYom/D4DhDJcpfh9sn6j+2qFlA+VdwxJEe
Eprr6Hng22CxZOqm2LvOlJf/Fc8/H/c2VUubro+gBweOeO+3oM2d8nbwkqKd
KxM0ecoHwGMic8aWnmLjRxycW+/3yr3ch87/Iry4/FH+GztrOv8yWP7PKrWc
Unfq/9/giJ5TM6YdpvFQNPB3PD/03fr/fMvo+4SJcK7G0tD3dfS8cIvgvVol
AQlm9P28L2x3SPq+qImur2hP9+dnlcLM76hS/iz8YMk559+cGx1/MXwsMDm6
WNOEjv8LfP1qTa7UspnUfr/2eN7FI6htWfN6On8NeEzyi3kmph6Ut4DdXTWn
tnnS/eE94WzvOw5JpXMoHwFnzv2qP6tTn/Kn4XXat4fpNVN7XAHcGT9i8lJr
et74WlhbvWd1UqIL5Xt2oD8uGa7uka1D+TFw8FjVkLsrplPeFA5Z+NZv1FI6
H34lfCxpnqOCElkkgh0dXQ8o+3tR/jgcu6tmxM+31J+5O/Bf6a4nI91ofuTf
w3dHtDleyl9H+b/wfP9laaVBbP5U+hPP16scsTKcyq7fTHjXy3er2jq8Ke8C
73uTmPVxEfUXUTC8+/nT2p27aHwRkuCH2cVnEuey/pMDB+XscOuV33W7O/8a
1rVY815fzZjyv+AvFxo+SVyi8UUY2hnPb9kwb+FA27mUN4CrJsyYvGUze/7s
4ZXOVV+2H2fj10bYZ/0WDWmB2hPi4d6Vn7UGWbHn/3L3598qPde60PXhy+GG
NLP5Ri+WUP47PM1xytXENU6UH/QX51vy8lxzDzZ+ToJVbpgGT2plz58V3Jk/
ZPB9NeoPonVweYFF3Jtc6s/CXvj2NPewAF/W/nlYqjrH5X4WHR9fArt7T5fR
VlGm/tsAF+q9fjr+Opt/pP4hL6yTV8myp/6vCd9P/KCg14c9P/Pg1UmuMlnX
nSjvBftNHRKY+4OeFyESzl9YtzXpqRfl02Gj5Gzv+ss0v/OF8NHwEtHGcKp3
RB9hrw0xEUNd/Skv2RXP3xpcYzJ0Apv/x8Ktimnf+To2/8+GHay0Rh58Sp+L
VsHvK1Zv2t/O5v8d8KN1GbLGrhspfwJecfHBwKBzNJ/yAswtSt7g6e9H+f/g
O2dKl49RZfXXP/iIaIOVksJGun7KnJjfdqWrc0opHR8/Cy45ePS5w/5gyi+F
OyV6TrWSCqL8Vnhp8r7vn/7f8R+B579eniLqoOPhb8Jhu6TfR4bS/CyqgH0D
C9sbZNjx/4bPd63wvm9I7XHDJcR8jKFRdX0ofT8/Ffb2OjShPoPlHeCilRX1
H3zZ+BcIe/Cpta7KrP45CAeWaL+I1GHz1xXY5mivkmIxG/+ewX3UBz/0+0X1
rfADXhAXuSPOnepLTraHmP/iEit4m1M9zOvCPvNGVc/9E0P5xfB582yDKJc4
yvvBPd2D1a+4HKL8ftjvgcm7++FJlL8Aa/VY5/avkSx6DEcdt98dPfYg5Rvh
3s2lXyXLD1BepqeYN6lN+hqovZfyWnDE2bqJTwLpeETz4Rq5x28nGtPxCt7w
k8glG+qusfsXDfetaRg30YiNHxlwRa8rCsOU6HkSPYD/xkWaK/iz/v8JTt/8
b96466z/9pYU84dH5XoUjKfrzavBQ0PK1667yOpPM/j5XgOZmv5bKO8GZ3V0
pGfcZPd/FyyxxyAkM4P1v5Nw/Nal+bLtZNFd+PYp2ZTkFNb/qmC1U1vEDovo
eDiul5iXEYedfzWM1W+j4MnWlhH2EixvBCveKVib3UnHKyyDM+OqtK2fUP/m
tvX6P8fDH4WrfV+p6erR8yTKhUt+Ddrn/IP6p1AJS5zJ3v91eyDlO+D1eaM6
11WSeYXeYn4L1zYngWf9bxqcVqHZGmTLzt8RjnfUcQo5QeY2w54D1TJtR7L2
D8HH7o7s/HGU+qfoKvzixCEtw7tUjwrP4QmjN97VGEnmWuAhsaucxl6g9QQv
10fMP4g9VOt3m+Y30WR4oLulq/YXnvLWsNy2jiuS+ez++cNh4c8mHX1B8zV/
AH6zSOHO7h8snwX/y/gVKy/Nxt8n8Cf/IY+NB9DzwTXDP6TDTi2soM/5/n3F
fPF0ydHDU6ieEWnDl5QDhIh8qkcFS1g6+1V6XKIB5dfC8XqqISOc6HM+Bl58
9cZE7iNbP5yBPypP+zqiegrlH8Ltc7/dlf2sScf/Gb48+6v6Q8d51H6ffmLe
XcNq8oI1rP5Whze8MF/sOYbVT3Pg2w86xvwbx8Z/D/jwpXZnlWiqt/gw2PHT
UoUHGez4T8GlxZ+CVdLsqP18eK5neLWDDtV3XDWsMdKhb/Flqnd5CSkxv0w+
cbnWRlY/joa9dMQeT47SfCYYw6OGKYWbiqm+4JbDznnTWy+8ZONPKOw/2KBi
rJsN5ZPh/zW/CrfgsBvP3ONOsPn/LSwZqr507ASqJ/g/8KoyLivDYwPlFaXF
/J3JPg3lfdn8Nx0Ojty6a3AezbecM1w2a0ofnzJW/wTBqSHtGm292PknwC2v
dszmG9n1uwa/iTv2JzeQzod7CV8yGrHp3zI6H74VPl5Xl5NkPp/yQ2TEvHXp
DD/XyKWUnwJPPmZvMqAvq79s4crtZvJr50yh/AY4IXF4AVdH90cUCzuI9pvo
P6PvF7LhSy/uhex5TusJrhSuLQpdUKTF7t9X+NzRrD/7ytj4PaC/mDeX/hWQ
XUDrBWECvP/38FS7KTTecQvhI+J1anMTWf3lA+f2L1x27wLVl6Ld3Z/3t1+j
V0n3U8iE/1x1izssSf2RK4LvPs1RSPCi+pKvh1c5Ln8u/4Pd/74DMB+UXY//
2kXrJWEcLKdacFy2ntaT3Fx4ReV03XdvaX3Cr4YVM12Wf7/Wi/LhcHCwZYCn
8Wzqf6nwfOdeQz6WLKD8fVhXM1l//hstytfAr88aF284oEH5HgMx3s1VTKhv
G0Ttq8DR2f0vVN+g68WZwC/eJS1eEcX67wp4r3vOs/YkVr9uh5U0l01o87Kg
/DHY7ru6dOIbqg+523CG+fg5T00XUv4dvMarp6Z8Bst3wnrF835MlKb5SRgx
CPWA9uv5ag/ofLkZcM7AiPbSARZ0/EtgmVsLliT9YfsPW+BaL8lfPqdpf0FI
hFsWZtnOfatD+Rvw4s2XOjPj6fnkX8HfS/QLCqVZ/dQGn9NL2a3j4kp5+cEY
n64daYvKYet3fVgi9WfH5uNk3g6WTVnyI3Z1c3c9LAqANxea3JQqcKZ8HCxt
scRs1wW2frwENx01ad66lrVfBs/5PWhgw8RF1P43ONy9mssdTestYaCsmC9U
nvG0aj9bP+nAPm6SBy/msv2TRXBMT+eV07az8/eFK/OnTDtvw+q/PfCHfpLm
V93o77lzsOGAudsi2mg+44thIePZjIQnVO+IvsCSz46JNF1Y/dRPDvWLe86t
nW9Z/TMevu+9P90gmfZLeAu4y7fzoTNP9a3IE26S7VE0TInGYyECrlqzO/Pd
6Il0/9PgJHOL8WEHhtP9L4DDGkK3WSqbUL4WVrp6usvYgPqn0HMI+ne07J7L
YxuMuvOqcNqylx52vdn1N4WX9ttcZ7Sd6mnRSnjmpWSDYn+azwXRkO75ZOW9
fU20v8alwEF6ZSeDd9L14u/A7TeXnfp7hV2/97BBpMa09Gy2f/YXtn89KKvd
i76fGymP+d7wSu2FEbSfyM+Ej676flX30EjKu8BDL52THpipTv03GLa562E+
ag7Np9xh2CrhdNGk0ax+z5Hvng+9Iu8m0Pgkeg1Xjhth+e0GfZ/wC357RT7S
duAMyg8biuc/bX9G2S26vrwBvMZi+6Gpv9n8bw/3eXTlxeNGF8pvhPMbo+2G
7WP9Vwzf/vRo9Ic8dv0uw997Hdt2MS2A2i+Hr78fJxtRSvWo8B32EUQLXnYE
0f0bPAz1wbuZpqG/xlB+EqzZw1/uQTkdn8gKXjQ8e+jsKdSfhXWwYW2+ZXBI
F92/fd2fi6d9unKM+jd/Hnbd/mxEi8I8ypfAz9e8OHRpMHt+G+DVbqFFEQE0
nnHSwzG+3ZFxeLZrGuU14b4qW8PDatnzOw++NDwmTtuG1e9e8LHT1h++96b+
zEXBifsMO8oj2P1Phyvbb9RWl9J+n6gQ/pO35ZZVOPVv4SM8zi0huUlM6zOu
l4KYN/VtsNy9urn7fPixsI3hCwXPfWz/bDbcoD3e5m8T/b2wCs473kvXp4KN
/zvhhCeNftWCFvX/E3DYWFef8FFs/hNgnVfDUv/9pv0e4T9Yb5SLc+8cNn92
wTuNnwV4mdF8wSsrot7qNTtTZzEbP2fBVz4KZt9Dp1F+Kdx2uW56V4ok5UPg
WxKKHolKbP47AlvoZ23+uoXtH92EubI/srmD2f2vgB9Ia1bcd2f1Tzvc837U
3IhKH8oPH4H5+0lEimQ4rQ9EU+G6ElHaEN9gyjvAw6qUpy84soXym2D/fgYb
fMdTf+MPwpVWjeKHKtsofwU2C40Mvf2W5Z/BBs+b+sX0o/UU9xMeHr3JNb2c
3gfwsko435qjaiMnsv17XTiuj4r/YEtqT1jc/XnCjHW269j6az0crOarsrKB
vp/fDwcESc5rbaX+LboASy9PUJ0/juUfw41DjxytP8LePzR1f/+Q2nqZ+q2U
lxmJ+6N0/qObG1s/acE9XW9tffxiJ+Xnwz/qGipPv4uk/Bq47O4BLrF3NOWj
4SUWa1ta9cmiDDjJtaL4zi+y8ADuXJZx7bD1bsrXwdnRsecqgul9C99bGeut
nD4ex9NjKa8G2/67OOnd2lOUN4M3rupSOCEZRXl3uCPK69+O/vT3/C44M6PX
1UsP6X2N6CS86dxJW1ejPZS/C+/capZn/o7Wo9wHWMpVbDF+GvUPnhuF6zfj
bOq3ONb+KDhffnDTln20XhWM4MlV6tqrSsWUd4U7PGYYFV5PoPw2+N/9jKgF
LmTRUbhdUdGk8jhbv+bC8V6LWmUGHKb8G/jtSNWDwc30/XwHLGqXrHsjPkJ5
hdGo14KOOg/cQBamwTpyTokV/+Ip7wRval3db6M3nQ+/Gd5t5LIqpYgsOgQ7
f51eHnyC1svCVdj01EPVy0PoenAv4KXiHY9HttD95Fvg7MtFx9QH76C8nArm
06xa2/1q9LkwGZ5pc/76oQx2/23gbyfr9rhr7aK8P3xO7L7Ccqwv5Q/A7ZvL
muwPBFI+C75ZOXPMyFRWfz+FdeZ0qrS/YfvfzfDEsmXHzO3Y/nn/MVg/KF4+
0eJC9Z6gDRdnhXdO9bOk8WcBvMikIGhOCNUn/Fr45n3+TPYMqi9EMbDpLslH
uztoPSuc6f77kgT+vg5bvz6CnWY5+evpb6L8Z3iXpcEi52Fs/6iPqphXd7xe
FV5I+zmCOlyT/kD2dQpbv5vDx3sX52bY03qU94Dvy305vlGCjd9h8D7r4SFH
FrD3R6fgJ6Ez1mkZ0vFw92CvrmWbe7qz/atquG237oiYO3Q8IomxOP76tG3Z
k9n5j4ZPv1fy/ruc7f/wcO9cDT3vg2z/aDncPHSCRpUxW7+Hws7xjc36haz+
SYZvyOdfud3I1v958Grpvb5FO9j+xVv4lvIt/mYQqz/+wAWz+TO1i9n7P0U1
1D/1oSmabjS/cIawU9yQSq8DVF/yzvCv1hV9Zxmx9VsQ7NDx0l9djr1/SYAr
7cvdixNpf5K7Dmce2Lmt4rUK5V/COapVCoMM2fqrFX674FDL7eds/3WIOtaj
Pr/8FLma7vqU04PTt77p2rGF6i3eFlYfUDEnaj6tL0QbYL2GPmav19P6SoiF
66tniF670fdxF2FFwTlOy4L2t/lSuGF1e2Pf9+z9y1f44El7/zKBHf+AcVgf
9IpVl9Rn88dEWKaw5uAzrbWUXwhnjP0zbu9I2m8W+cCTD5cu7dVF84mwG45p
GpY1UJbtP52FBR0rl79KND7zRfCPficUD6qx+ace/q2TUKZYS8+X0FdDzAdK
2T1tsNxPeQ3403EFqYxiej/Az4Xn131XkCtn9c9qeMCHfR9KbtJ6WAiHP1jG
Zp5TpOeROw0fTN6mEbOGPufvw+6J2Xc2PWfvr2vgVUOvSKxNIQs9xov5k06F
0tE5NL9xY+BDARfsP1mw4zeBvw/21HtWzY5/BdwYH7IuVonmI2E7PFwzeKvD
UzZ/Hoe3PE0dO2M4fc7fhgddXqDrMdyP8u9g1dNKd56sovWo0Ak/2PJYc68F
u/5KmmL+fbvpflcXU7r/M+C0u5Mn/RCoHhUtgd+Ea0tVBbP9uy1w860TeVFj
2PohCS7Pa1ipd5/VrzfgH653dEaJ2fP7Cu5550NTmRlbf7TBke+D63tbsOd3
qBbq59ojpzsd2f6XPtxrTNTmfHeyyA5Od1qteraJjR8B8Od8VVnvHWz/Kx6e
tbjlsG4Yfc5fgv2KRr+fczKE8mVw+/yN7Q9Mwyn/DY6RU5aPrydzg7Qxfx90
mFqxJZryOvCSr0e3GX3bTflFcMLqxqKTu8mCLyzfuv5J4CkytxdW2+uwPtmc
zJ/rto5l/UQ/li+GZ43qq1gosZfyX+APLqNvZlhFUV5qgpifapR3u3FPJOXH
w3ZPXvWMHc32Py3gZvNmzyyFMMp7wovzcqLLTHdSPhKetPXVplcFOyifBtcp
OOhLhdB4JSqAFazWTl4vQ9dTqIUXWPuE6pf5Ul5yItZn6R8TV/xdTnlVuF9K
bc38Oaz+NYUPjw+c+2gHG79Wwmf/2aY7raT1NrcDXrewrM/PTE3qfynwy64z
Ux6MYM//HTjPKaVtw2s2f72HHYZp/bvSQvMj9w++9LdaYp8jqx9G6oj5AzMO
+07qwebfmfDjUy6/iruoXhBc4GSJcIdTc9j8vxW+obSket12Vv8choM3DzG5
vfEE5XPgjWdP7lP/zX6/8RrOk7c3+G9MKuV/w3YnYwa//0P1ET9skpi/uneT
x4BrZJEBvHGFxc/4SFY/2cMFLTcWF/Ukc4GwYrO08r2H1B4vhmfF6/eaJptC
+cswXxb7+c2AZMqXw1JtRQnmmrQ/z/2AXWxfVH3wovqGH6yL41HVfDwmi+oN
0SS4aGnoAmE3q7+s4B85lzeF76DxjPOD+18e99Hsv1DK74PvtyR/tHRk9e95
+FSuX3aPUjZ+lMD/630f1wibFnmnt0aw+l96Mubbz0lZ536z/R9N+N/N+dPq
nrL9i3mwzYhy0bQMer45b7hLO8lwxUu2/xwFP/hyzqGPPj2fonT4XI7tJyc3
EeULYTVzQW7l1FDKf4IbFg90VI5n/bfXFIzHB4f0/BpL/V00Fg6sLnC8IE2f
C7Nhi55xUz5PZv3fDe7lk6ueMILld8KCqLn99qrtlD8BJ+Z9rhgRw/bPBVgl
556/gfpWylfBdu8drPavZfVLF9yaNK/x1GxWvyjrYb6L2DkwwIutH2fBFZH2
Md8+svphGdxxsPn1t5ns/VUInDm5dUffkez5PQI/+71pyLYulr8Ju+razI5a
zPYPKuGSnVlNitXs/V87nPItP79sEPv90nB9MW+90fmb63yqL4SpcPOnn5sH
9mPX3xHmcrzLT2mw+m0TfHXgyBUL/6PfF4gOwhqx8rvep7Hx+wqc9dNpZm2x
LuWfwzI67rE6XwZT/ifsb/3wgKUqvZ8VyRqIeU8nu+fbftP+rqALp5q/Va+0
pPc7nDVcUtbY7NrFfj+wHg5M/1z/7bke5ffD79sOfZ63nP1+5wJss2yBv9tT
tv//BN7bFXJmcDz7/UITzEl81lm0nO1/yEwV82M0qtKXRw6lvBasfHS6uvse
qo84S/h0Rd/t8nns/cEa+Lzfv44Pu8dRPhpOn2W9K3HOz+56R8iATfPXrq5p
Y/vHD+HMEal+KnqqlK+DR5nIv30sQetxUe9pOP6Mw1mVN2i/UlCDr73bIbSq
svf3c+Cgchvd//bRfj7vDjcXBkQ9LqD9DNEuuEhl9pPYtH50/U9O614vWOvt
z2Lvn/K7P1eNljtoy+q/D935odv2j/tB+4Eibjrmu4ylX9t3UX8QRsFL0pqU
BR/2+wtjWHPKX7UgP7Z/4QpfkZk0w0qe7V9tg+NHr3x3dSV7f3wUNhUrrvQP
Yv33Flw1ZP3f8nRWv76B0/a8PtxozObvDnirTGgkt4u9/1IwxPpo66vCRYvY
+5/p8Mw+F/sYZtJ8wzvBeZ5VdfaxbP7YDA9tmKC6yYTmF+EQbDe7ZWLuF7Z/
cg2eIsu5f3Nh/f8F/MNsQl3bAbb+aIHD9t41uaHBzl9uBj4Pemh3/Rz7/d4U
uHyaq8nYF7TfyNvAo6fv2J0Sy/af/OHlAybV1b+m/RDhANz4xr8zW4N+j8Rl
w7MHnI9ONmS/33kK1z6YU9bUxurnZjhJJu2mVAvL95+J69dy9Z/RHrb/NQGu
OhO251YOWz8vgPf3qJtvJrD1+1p4jmbfexUBbPyNgfdExBpIVbH6MRM+Nctm
5ulGtv/xCHZS259cdYXqUdFn+PMceSXbi5so32cWno85Mxc2ebD9i3HwWxXH
Yg1fqhd5c1j8w/NojQfb//GAJaOHvT5WwN7/hMHbs8MypaXGUz4VXi3nek7V
g+4Hfw82LTArPFs6n65fNWwWIe9T+diBrr+EEcavilzTMmv2+0MV+HpF1Jel
Y1j9x8O+OSft7x6g+y1aDndaWu/b1oPt34XCFoUx5/dfYPuvx2Dx5Q9dj3eT
+Tx4+OFIj/ap1J7oLayv3zEoWpU+F/7ANkc4X8u+1B43whj15EkPzVSJ8ZQ3
hP87nH8iXpf2V0XOcEvWFxmjY2z8CYL/1++zuETYJf/qrFeL1Ch/HY463Wl6
L4u9/3sJ736nf8H0C/v9WSs8b4V1lNojut+cPC/m342dlZ57gMYjXg8eZCNk
hjxi988Wlgvo7Sblz/Z/NsB6prfOO6vQ+ywuDo56a3Rf5jN7f3cRPrBzQ22l
JPv9Tin8c5Hq+wnzaD9A+Mr/n/dr3EATjLeGvcb//EL7gfxEeL1USsiLml3G
w3ZOKNSH///vc/8HZo4l0g==
     "]], LineBox[CompressedData["
1:eJxF1Xs0lHkYwPFxrWFzQqvWSWfCEWk12QhdvMaMWxlj2HGJYiYyiomM0JZx
mbTRZfWmZlpFqXY3KlJR7c4UxUqpdk+aHJdSHLfFbG12xe4zz/vHOmeO8xnn
6/m9nndeS4USfoI+jUbLgpfue9l195cJPiShVOi+Gr3hLfVOMPPRp6Ps+uM6
00rAJRNfDosmpToTl8Eu5zW2TftEOsvawH9V6L8KNUjAfghsyqj46vtRH5Wu
p7NI4njoRNP7mx826HpHcHcid2tmT4Tu5zJ/8MSSqtoG4xU6qxPBs+Xmovra
AOwPgANm536afuqP8y+AMx50BKWp3HB+M/is4vbiOZV+OL8fXFDKzmbuDcPz
G/iShL6Fhx3x0RV7W/BA+J+aud0s7H3ADLPEIa/9C7CPA3vmcQZbnZOxl4Ht
XZysiR8F2J8Fn6LX0xjG4dj/Aj55PkaVsg3Pp+4GD9od6R+si8bzz4CviVUC
xVMO9ovZJCHwu+XA8I7E618L5j9kz+fZJOD1R4PvWCwdNh8QYZ8D3vLWlH4n
IFxnQgHWXi0t4G+Px74B/LNFY07x/VDsO8Gj/ZHmbuw47D+COW6JtQLrr7G3
4pCEResJht2OWOzdwB48taVZEs5Th4MfLqqbNCii5meAXYcMnYf7edgfBxeP
XWuXpIZhXweeLunJr6/C36d+BhZY+7lot0RhPwl+72j84JgZH/v5fiSR02h7
2pO7GfuV4HWFmrJKE2o+F3xhld+xESVeHy0V7PihTXKQifOIw+BDE/RlHBUL
+2rw4o7b8rl7TLB/BP6u8JLt7yctcH8j4OeGFTWHq5jYm/iTRPAcw32f3NnY
O4G9stbojc6sx/0FgI2dHSv1PHGftCQwzyvNZuLzSNxfEdhp4mVJiBF1/18E
u0iuBgubt2H/AHxmczt3qkWM/TtwUr7U6tkI3k+EYQBJXJ1cJu5LFGJvB37l
fmV0Yy0fexY4x3E2q4MehL0QrLfZzCHlHN5vRB74UKmrMt8/BPsK8Fig5sye
LdTnTwW279Mf5nclYt+r88myXl6nBPtZcPw1+RXG2yTsbQJJIn2mRfF4murX
gfu4ekWDGjwfLQbM/oyubp9FE3vBS2mv33Wq47FXgg1r0lMfmsZi3wj2Ha/x
zKbHYK8BJ2WrCr+V87CfAjNLu5wVucHYLwwiiUneXlXFFF6v2h287GhWygqP
7bh/AbhcmXP/Zulu3J8UzMzNXPBcKMb9kWC5+M077Xg67v86OOLU6JOo5Xuw
/w38rMCIv1Cbib0W7BC0Uusuy8DefCNJ3DVI7myQZmPPBP+wOilsfECKPQ/c
apXXXFVJ9RJwXGp1u/wLPI/sCNj19Ie1HtFZ2NeAvdrGmtp6UrB/DL5ZK3Z5
JErDfhSsHN5xL9oTzysz3UQSSwJzCblgJ/bLwTsNOHTLHgn2QeDyIY3VUBie
hxCDozZVM55cwfPKDoJn0kcOTOlT8y+BA2WSNKvkXOxbwNyWFwUsIxn2A2Ce
3otCm4Yc7I2CSSI8anY4b95+7O3B/4SkxnkHUH8/NrhqcI0va2gX9iKwtvF6
pjyvAPeXD84QdR90EAfi/irBltn3ymxuUPu7B74YFk+XCrdh3wdOX1XvRGul
nl//gn96Hftmu+tGnL+ESxK/ShfG9Iw44f2zARxjdqM4OZp6fsWCt0b7JM9z
pp5f34D9rNkdd4s3YX8aLNTv7GhqxecV7Q44XGpfPX5uA95/r8AdkaUWlun4
+ZD9DXY9NVbb1peG518UQhK9nV0NrPKLON8DbMb9w5sMLcE+Aty8W2WjoCux
zwR/XH+ZiFh+HvsT4NXTJmLOfaq/AR739t0VWV3vXVkn87gV8v//2/8AgrPC
Vg==
     "]], LineBox[CompressedData["
1:eJxV3XlcTV37P/CjMhRCg6mQSoVEpkrJbkAlSmhQFCUlERkq0dZASSGnNEtK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     "]], LineBox[CompressedData["
1:eJxV23k8Vdv7B/BdpFAqDW6iZCqlEirJsDOTBokoU+YpyTwkOxkrSpxQUYlI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     "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGBQAGIQLd//g3FLzVSHWTNBYKc9UKhhN5Bvsnn2Cx6OrSD+
gVtAfmrfg+WHTy4F8Rl+Afl5Ej8dQwuqQHwHydqpDup8V3iCL4SB9VsA+TIT
H9Sk8UaC9YcD+Zs0l0ndXla0H6S/HMg3nCA3I+tDMFj/NCB/0bx0sc6IMpB8
w1Yg31Nwo+uelxUg/oErQL7/z43yi68WgvV/AfJ3rX2r8q25CcR3EK6b6rBR
sfKBhWwjWL8RkC/5NFz0dxHYPQcCgXz/Z/fVBPMg9hcC+Y//nNvMW5oN1j8B
yH8jtexOcCFYvmE9kD9jZeeUYwrVYPvPAfk5ZsUxb9fWgfW/A/LbWi/ss5wB
sZ+3fqrDh6C5S7hmgvkNOkD+hqSlP1tugdUf8Aby17aHSKUygN3HkA3ke3H5
Oc35WgrW3wXk75nadnehciVY/0og//aORwqp07PA+k8A+RYXlnr/18oA638B
5L9yuXtyJm8DOPzYG6Y6rP5yYWKkGDg+GtSA/E1fJ6QHy04E+98VyHeb9+T2
n/rl9lYHNjdGNSDiGwCEWNG5
     "]], LineBox[CompressedData["
1:eJxF1HtMU1ccwPELjIeilGSgGzKoQTRoBIERQHBccGDlFVYKilEBtZAiD6FT
mCt4FXlZkIdc+kBEDQ/H6kC3MWA8yqRmoGOIDIR1ZE5YgBHadSIDitnv/vhj
JIR8aL85v3PPyd1+Ko3LNyQI4gT8Mn/zpS1VsxRNymXMT7sf/Is0uEyTtmMC
i0zTesYUG2ykdnvd6lnBWOkH3tcWbWwjLGNMxIJtDLL3+pqVY58D/j5sOcqd
K8K+BjycPN4drM3FvhN8Ma3QxzMiH3s12GB2MHU2yQX7VbC9Ju5EUkFkD9Pb
XKHJib9sLVhHJdh7g4tZFqr9Z9FEDLizWmE/aivGPgts+rI9/rnXdVxfAnYt
Sde09Jdi3woW9b+bsWUG90OMgq9x7GuTpTT2i2CJVZLK7eWn2Fvl0qR1m4q1
4UYCM4/SHSz6cj5u2etDxkQkmMuTxCYLY7DPAK9UqauV9Rzsy8H8oLRXxlI3
7FvAzXtkJhNFYdgPgacWujr3iIMZkxqw8d8Jc/JpS9y/xVWavHR6QB/9/DjO
vxfcc3/6StS4A/Zh4JvykmLvJwJcPxlcczfcWf2Mi+uLwb9PLSa6sL1x/Sbw
Yqmg6+nCx7j/AXA7v2qhZwCfNzkLHurYaNQ/koTrm+XBeakn2XfME7HfBQ5y
+qVMN3Ya1z8E/vfN23/s6oKwTwDfvK2/eHA+Gvs8sOTACser/ij2dWAP19pe
9824X6IPHPnaMWsTxxf7V2CvkTz2WadPsDfMp8nRe9VDB8zxc+V28FetehlL
EYO9P9jaY7g8YpCHfRx40/5obWPqYewvgZ9O2FWmstbnvwV2aR77IicATXSD
uduGKa97eL7kb2CFPOjbkzkZ2OvB7MzBx9cHzmG/rQDu56ruXGlcGvY+YOcV
qtEki4/9MXCs7rGHtBKfD/UZuH2IX5N+Ph57KXg14ztrfs1SN9O3gY9nm3e8
cyEU+zFwhektYiZkff434IbcP5vc29bPz7qQJi97TpYKm3l4fh5gz5/OiPst
8T6TPLAgMKJPJ6zG8xeCXdce/diXU4T3pwL8Yjbsj8yuEuwfgh2nkg9v7sLv
k8/AKw2ycrNjF7DXgkuO/Byyq259flYRTQaIdzY5Wkbg/l3AGY6VJY9+wP2S
4eCHh96fHlTgfaBSwN/MdWu1V7nYF4O1ml/V2SLNR0yvAAtC+8LbQnZj/wTs
sCZ/YGKD95OaY/ojfTZfp8Ti/Buu0WSR+dsX7fxwnN8J3B17Z19gbiD2HHDv
0gd1M6Qrrp8INmxcZm8R4v1Q5oP9U1zWWGfwfhENYBFXe0rPi8JeBfYN3VG2
1QfnpabAI54V74kmcb9KIzFNUvdn9HHpjri+AzgreDxhp8IO+wBwkEwuq3PG
9x0VD56XjJ08r8rG+Snwg8zaJc7Wz7G/DdYJVifS/Qvw+feAU3t5Er+hSuwn
wRZyM+7G5RvYr4E1eR0HC+H9PMhV5VgV///+/g+0dEtL
     "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQBWIQbf9W8v7XnqkOs2aCwE57oNCB70C+pnJpfu3xTSA+
g3jvVId3Dz2+3F0zG8R3MAPyK3/v+vzmUReI3xAK5Cs9/2ha4FQA1l8C5B9+
V9iQOi8MrH8KkG8SyLvnzknH/SD9m4F8h7V/rmv9SgbxGy4B+bvXJHY2zMsH
8Q98BPKPyVmff9CfBOIzCPZNdYjbtceGRzgXrN8AyN9RvM6w8VEeWL8/kD+5
0viS8soCsP48IL8rhO3FuoRSsP4+IN/6+tGHx4TLwPrXgtRb7GXl/AeWbzgD
5Pf/nMLqylsO1v8ayF8m6cHjuKIGrJ+7f6rDnw8XPvdbVIL1awH5b97qvT35
tQGs3xPIl7ho5ax2HMw/kAHkv9p7dMLcwHqw/g4g3yNOnzUtsQqsfzmQH2r0
kfONG8T/x4B8xbmev0z7UsHh9xTIP7iv5dadsg5w+LFOmOpwzviRWdbS6eDw
VwHy45xFtwbvbbOP2XGF03YCIv4AFMzB4w==
     "]], 
    LineBox[{{1380.105169865871, 0.1}, {1380.126953125, 
     0.05416629834628286}, {1380.157470703125, 0.0956529691230949}, {
     1380.1598053524494`, 0.1}}], LineBox[CompressedData["
1:eJxV1nk4VfkfwPETUeliSgtZKoZsxZSIiuOOfVR2WYasPdm3SCXXKG6UbCe5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     "]], LineBox[CompressedData["
1:eJxV2Wk8VtvbB/CtQtFBA6mTKSWVIiJCtgwpZMiQKRIiRcZk3Co0l7gb1ElR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     "]], LineBox[CompressedData["
1:eJw11wk8VGsfwPGZQl2JFpVbbpcSXiFZ3uglj0q2FlIRg7GmwbVPdkcpSxdF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     "]], 
    LineBox[{{1406.2416415435023`, 0.1}, {1406.25, 0.039926216345908636`}, {
     1406.280517578125, 0.012567040107600652`}, {1406.31103515625, 
     0.014276951652294164`}, {1406.341552734375, 0.002136102412004178}, {
     1406.3720703125, 0.01615124858952756}, {1406.381085070453, 0.1}}], 
    LineBox[CompressedData["
1:eJw12Xk4VdsfBvBNidCggaKkVETJ0GzadE0NpkiiQoRQpjIkHUSlksTRoOGW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     "]], LineBox[CompressedData["
1:eJxV1ns4VGkcwPGDtFIbshO6eNrQakTr2jAuR5TSsu6xxLgMRjTIYIVOrHRT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     "]], LineBox[CompressedData["
1:eJxF1HtQVFUcwPEbBClDKChJaIhEQAzawsIUr+7hsWjyZlEghEUQcdmIlYeW
j2HDiEFgSEavgS5poOLCCCgtWIu7QIU2ChvxCGQCecQjYpbXNiBKv/3dP2KG
YT7LfGfPOfd37q7E9IhkPYqiEuBX9zc1Vh7I8WdIeZnu5z4NH1EuYBHNn+6y
b9KZhIMXEnln3n1RoLNEDHbo5HPXS8Q6q0rAtYp2kZ9BHPZ14LWA3JQIzl7s
O8F/ytvjbRf9sf8HbLj+pLF6a6xS1xvzGNLCPVnWrxboTDmBbd3n389LOqwz
CQT3LEfWrb9yVGdJKthoYqXxliAN+wLwsuXNeTKZgf1tsHep5spOixTsH4J/
kabb9jqnYz8Jvtow7Bi1FI+9YQBDEiTjGQo1F3s7cPfC36stn0RjzwMrb4pk
X1vxcP1HwIlLacqh0f4Pdf058BfRDaVmE8HYV4Jz7Lszi2/7Yt8GHi+WVxiP
4P4kz8CrbT1txJNdP7WXIY1nztR0dyRibw0+aJQkN38P90tocHWpqUeW4zHs
48Eucfvq741kYn8WfNealuafQlNScAodcYLOxf0SBThTv7yT844I+6dgmXi9
w/Yx/l+1Cm4edpnLMEvG3nIfQz7ljKVwxkKwdwfPvKHcGC73wT4arPWpGDR7
koD9SXAfz9jyj+1HsL8Mjtxg6HJNLwZ7OfhNr1djyWtB2PeCjaYUC3JrPF/V
EviHiXJBsTM+b2rrRwz5znlA6rM5Ensu+Hx+8IuNAlyfJALcZH3DK22ZfX7H
wR6zd2rCHdj+Ajjq5VihdxbOF6kH271+8LK2Toh9F9hz4cFbpy3Y858D57aq
Q/rMUrE32Q/zcT7bolCG30d2g1cOm4wXxoVjHwTm2ww8dRJcx+cvAmvonXNF
Vq44/4Vgxias9RnXD+dfBh4Vy67GHNPH/hE49svmlfnhPXh/pnTWfmy95XQQ
9hsCGfJTzWc20zU4L8QerIyq6pjd4Y99ANh58cBE1nU8T1UyWH9RSFvWs/vP
A0eEhlXmTOM8kSqwm8/olGkOu/928KNhu69+zRZjPwq2unZRxvHC50XpBTFE
ZeVqHmzE7n8XOJl/gvCNPHH+Cbj+0jb7TO1RXL8AfKdDWEWvZuD6c8AtIleZ
WnMW918Bnnl7jN9VcAr7FvDzb32H6JHj2A+Bhxuifx51PYT9GtggSkuXNB7A
798ezBCTfzNucDl+uH4P8PRDUcDkLDs/MWDqvrC70oFd/+dgD4PazQJ7tv8G
HF17SeOdy75/msBRmlJNLy8J+z6wIq7XvVOO80xpwW4z1f1hg3g+xDwE5m9t
6vHLRbxfElfwYM9zsds29v7wwb4D9bZNjoewzwQblw+O7JDi8yGlYKPxlrKi
bvb+NIDLr7TuDiR4v1Rq8Mzv+7//rc8J968Bh1z84K/GCpw3sikUzlf2o9Jw
Cd+vkj1gP2GeM7XlFp5fMFjxQGiqHr+LfRr4Qn4fU5V4D8+/CNycPT/hVNNM
b3JjuqSh/7/v/wOGu07s
     "]], 
    LineBox[{{1427.920294970018, 0.1}, {1427.947998046875, 
     0.07208570576586773}, {1427.978515625, 0.03901352617981921}, {
     1428.009033203125, 0.004525614775538402}, {1428.03955078125, 
     0.0018106048642525861`}, {1428.070068359375, 0.007639474257678696}, {
     1428.1005859375, 0.023447777652052807`}, {1428.1086200281527`, 0.1}}], 
    LineBox[{{1428.2062822885985`, 0.1}, {1428.22265625, 
     0.017082163412932654`}, {1428.253173828125, 0.0033814615781503285`}, {
     1428.28369140625, 0.003320935135044071}, {
     1428.314208984375, -0.003011841093095181}, {
     1428.3447265625, -0.0039898244264933635`}, {
     1428.375244140625, -0.005123265241138843}, {
     1428.40576171875, -0.006334513271679673}, {
     1428.436279296875, -0.0047837720544847235`}, {
     1428.466796875, -0.004514528771214342}, {
     1428.497314453125, -0.0013258227920682191`}, {1428.52783203125, 
     0.026723567287397724`}, {1428.5325401451503`, 0.1}}], 
    LineBox[CompressedData["
1:eJxF1ns81ucfx/GblNAcQpuikyJqU0pJDl9CP2o53463MxFzLJrafKkkRhLf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     "]], 
    LineBox[{{1433.371632873511, 0.1}, {1433.380126953125, 
     0.09134608322365512}, {1433.382911382231, 0.1}}], LineBox[CompressedData["
1:eJxV2nk4Vdv/B/BdGTKkUholohJuRaZS2eYplClThgZJxkwZ20gkkdQxRCTR
rIQk1ZbUJW4SqQwRmiPhppDv53zW73l+z71/fO/z+jrvs9baa+01nSu108di
z1SKoiTgf7j/dpYbMHuzh0NnZnD/uaMJ/xfVA27RDGfWncrmmp7qxqE38oXM
mR1xkGtGCmxhlebs6W/HNUuDr8Ynqe0L1MO8CzhvdOkF61z6ATd/CFymmbrR
dPlGrpmzYCow3sVRVo1r9h44VVk6fLGtPtdUB/i75tL+RAllLH8cXPMjNiPR
1xDzi/dy6Kmi6tL0TyUsfwNYQc1d4N5ddSzfHhz+vCSilNbGfAj4Q0qZ+J9s
U6x/OrjLW6lwfbIWln8bfL3RYKI2EetLtYKHTYssDdrXYP3/BevVS9XEjthi
XsydQyt3HlHmVeDFvDKYM/nJ/skSO8xbgbfKyh/xC9uNeX/was/EtpoyZ6z/
SfChLK3imK3bMH8TPGo//3dkmQPmn4MDpOO7s12cMP8dfOPoj9eL/7bG/Mx9
HLq0zXfO4FILzK8GX+j7MKLgnHKfmzcD+2QvHbl1YTnmvcB8/6q0dY2swfon
giO2dDs05+LzZa+Ad6WkfKBNNuDzewo+2fzJ45bLSsx/BleOq2aqbNfHvIAH
h87JqBDnP4dmZcFOKffj5SV0MG8IVubXN4udwOdB7wWLtSY8tYnA+jJHwMk3
9z6Q6yL1vwC+z3qLSRVh+6gasK9qZ5JdM+m/XrCShsoHQ3NjLH/afg7tzhN1
snBD+2Zufhm4LH+NyJEGWcxrg9vCr9ocHB/hPg/aFaxe/Pxpcasuls+A08U0
Ltef1cT654Arorx+9VkpYP4B+KFK8ZamHnMsvxN8uDtDsKF+BZY/Aea05491
WJD2i3ty6DtNbr6CVbuw/RvBKa2CJ4YW4viiHcDujgV6p8u0sfxQ8NqIlp5o
Hnxf2AxwvfuArWRgE/bfHbB2Z6r55LA8lv8KvLDI0fHk7hQs/yf44SY7NyHN
vzA/z4tDC+u+/mJibIL1VwXPEbh+y26tKuatwRtUZYWC1pL6B4Dp+IcvxnQV
MZ8KXs9pV/j0xQLrf8vrv+OvCXz6gs8z31zsX2YQ7HmGkm5Pn4f9N8ubQ/s/
exnQw67H8teCQ4V2xwl/3IF5c7DQJsH7OgGa2H5v8D+vOOq2X/F9Zo+DIwQ1
eRsVt2L+GljzUo9H5Cl7zNeDTY6eae2rV8H8F/DgzfVzl/i4YF7Qh0NHGjAj
rvlaWH85sKHiDeWc3qXYfiOwmLnvkX5b7A/GHXy/zXOJ0RobzMeB80RVHj2r
McbyC8HeItL/nB4UwfIfg0UcXvlf/QufN9MH3hV1+kBD5QbM8/hy6G/x5z5J
pZD5Qwacv8zpzvwp8zGvA7Zr3Hsh5JABlr8T3DbAuakuSMZ/FFg6Ln/M6ziO
R+ocmBn2N/31CD9Ps2A5esjhq+E2LP8teLlW4rKwDQrYf3/A3wfa2iPCB7jv
AyXhx6Gzdjss8I3G8UVvAvPuOz9udprMf47g0o736qf0t2I+DHwqSSu3O34z
ln8GfM2h8oW+vhrmK8DG0T22tqLzMf8aHFj48dP3ZjJ/jILNm95dX3WWtH/B
AQ4tsHWbf7IEjndaDbx1yaT4zTx8nxgbME+P2J73D82x/YHgzc6TKqqSizB/
GnxZ3biV32QBll8CPqjkV6JiborP7wV44oys9LQRMyz/BziU/7Ki5hlsDyXq
D+uByZ6hSeHdmFcEmyzcfc91gTeWvxUcN68ysiiLvL8+4HGlKaf55a0wnwyW
qnzoJdKN7wN9nfv5P8oj+h6bMN8Afs+MFA9+WYj5r2DZLl/NyBAbzAsHwPu/
RNfYpXoZtl8e/G109gweZSOsvzFY8fWdv2KW4fvE7gMv4gyGDo+S+eso+IxX
e9WXerJ+XARbuRbOXN1oifkn4NuSYg6lAvg82PfgPXOPaFAf8X2i+AI5dO/A
tOzEWCvMLwcXvYz/brIY11dGF1zFq+3s5o79w+4CB+zqiF+xzwjrHwMWbAw9
GPsMxxudBw5JWKOYqEDm3yqwzOpVi+hL2F62C/zL07xa45AJ5qkgDt10R8tv
aYsX5peCXyw0UORVO4D5zeDuRS2zjHl2Yvk7wJutVvTqO+H7TEWAt82Lmp/8
0RbrnwVujYtWzurFzzN3waxPhsBacZJ/Axa+d7/rkzLOF9RvsN0jRZNBu82Y
Xxj8n/mSUQfn+0m08UiJYP23g5cVf/qYH7Id6x8c/J/3geaAN/AJdZ2fooH5
UvClFy91H8ZswXwzWFbmvRhfriTmh8HTJ8y7NxTi99FzDsL71l0lrT00B/NK
YMlFN8LzXpH5dxu4vPqKW5rSJqy/H/iz2wz3nzuxv+gT4KgfFf02BqT/i8AT
7tL7pj4l/f8PWOHn0Xn7fPH7qH7w1ZzsEzt2kP6fEQLrV+AiufVGXdz5gVEA
q/QNGel2SWDeBFzw4dFcY1sy/+8Hh1b3v/Etnov5BPAJtZx7litlsP6XwFaG
R7enxmB/s3+DBTpF9M6+xPeR+gje7Fg9EmlD9n/8oRy6Ov2pTdYiA8yvAB8T
W+5p57Ya83rgi/3XRtcVk/3jHrBC4oqOmjIffH6HwfenOYTOlryE+fPgsHCP
7TrLbmL+IfhGv8f98wdxfFHvwDvf8w/a55D1Y0oY9EeX0k9tF1d8fpLgftHu
liUMrm+sJjjonaWt8Eo05Qxufnu3sfyDOuYjwYVmmfa7Rcj+KxssYv/OWLSc
jL9KsKfJs0s5MWaYb+eWp7SySHvMEfNjYKmszwnVIpe56zuzKBz6UzSuxywJ
93vsenBbn0fGsRh3zNuBnznJ/Qk45Yn5g+CZm/Zmd0V7Y/lp4KqkuP7IaD/M
l4EjZoj6HHMIxvxL8JPRBD5bOhDzI+DtAgpD4ovRzNwIDj2jtbdn7d0gzK8D
O0mLJbmGHcC8JdglPOTo0798MX8A/G/Q6T8vXfHvTAr4z4UKx7Jj+DzZG+Cr
z32FHc1wvqIawZkrl73jPUrmrwHww/GuwZDRvZgXiYTxlfLcUHEMzf4FHpMq
COSRwPZSpuBgEfuvnWewvbQn+EChe3jYY6wPcwzML/x+sDsN28te5n6fhojR
w4wAzNeBt7zTbrmwCf9OfwI3yU/LzQiJwPz0Q1DfJxZNWqEkvxL8YsjWeJoo
Pk/KAGy87M2mki+k/W7gJlOleLGGXZiPBcuufVttoYXtY/PBDeoDmfJq+Hfq
EdjbpuLsowJcT+ge7vdJTou37cnE8TuV4dCJkx9zPatLcPxKgdXFg/pvWeN6
RWmBIyuiK1WTyfrlAp5vq/rtch3Zvx4Cn3p4cpPtJ9wvsWfB1olff1GlW7D8
++CgC1v39f/C8wXdAbbPmxG1YXEolj8OXi372sj1I84P7OIomL+rFX4tCcfz
CaUBnhUhoLvmKu6PaHuwn0VQOk+nMpYfAk6pDSsw1iLrfzrYpTXkxe90Uv9y
8MCXmJY/FR5Y/1Zu3seLTlD2xPL/Bb9Mpi4bzQzEvFg0zBcX410OXCLvrwr4
a4CY2K4wX8xbgeOGnxw1TvLHvD/4Ubrf8Zyb+Hf2JNip513q9BYsjyoG25YK
SXU378X8c7D9xIRvcALOj8x3cGLOrcorPTsxPzMG3ve6dM45RzL/rQFbN3YE
dB93xLwZWE3Qbv15YexPxgsseKDAzHoBtodN5H4+JnRKobwf5q+C9Y99cVPo
wvrST8Fu1LwBWckAzH8Ga3LepKS3B2Ne4DDM922TXe1mIZhfBZYNqiqlPwdh
3hDMYftWZI6hmb1gyXqR5WPbyPM7Aj4567PtkRuk/AKw+cDXtae2u2K+Biw9
ev+u0hWcn5lebnmXX89ctJnM39NiOfS6E/mKWfXk/CANLv7wdivfdLL/1AZv
WzCQ9+QiOb+5gofDc8rWuq7C8cOAdT3fvazmkcF8LjhyvHblahb3C/QDcOiM
rx76rXhfwHSCo+02DXuYYn+xE+Bzs46O67q5Y/2XHIH9+LUFHU1yuF+jN4Iz
lfQsllx1wbwDeOWESKfkMI43NhS8vsx6e503Wb8zwbaGOyvm/STnxzvg758d
Df5djvM78wpsbXix/EQMmb9+gtdpuSd6aPpg/efHwfx9/XPd7+te2H5VcKhf
3841h8j8Zw22X8I5/DAZzQaAs7ou23abeGD+FLjIuyH39TY3zN8CX+ULX9Rd
hecRpgmc3nZ8NM9sOdZ/EBxT6lUSvBn359TseA6t41Q5tusA7i/oteArZnl1
v+XJ+mkOtvoQ9/fDVfaY9wb3Xk4SKRLTxXwSuG6iprV8CD9PXwMHjs7tM1GW
xvrXcz+/wvnEzHsaWP8vYLs5y4WCebG9lNBROL9vFLP5xEvmXzkwvfh+VLEP
ab8RWJ/nhNW7VSGYdwc/zvhWoFNM1q94cHvauzolGbL+FYIjXCuFbG7oYP4x
WNBawG7zpe2Y7wP31kVuqZPH8UHxJnDo1EjDkWUqqpiXATcZCCUWXsbxyuiA
5zwvOFJjhfszdie4MtTIsvmpNeajwYVTigzM3uJ5gj4HvtqxxvFSJhm/LNii
VC+b84Xsn94mcN/ndU/1MnC/SU1yy0+OXuFXhus7LXEM9utPa23SYnC+ZzaB
E+JMJwSc92DeERzxVtRPx3wf5sPB/+7+7W4eis+DPgP+cevuEoH1eB5nKsB6
jgu7ipMorP9r8IMrP507RLG/qV/gkzWmD6JC8T6BXpAI+52Eyvu1SjhfMWpg
ue9rw/fr499ZG/BouLzwtvT9mA8CW76e5h3isA/zp8HHk6Vk4zR2YL4EPNMy
1fRyBJn/XoA5H4+rFdc7YH4ILG4y6/vPL2T8iR7n0H3NZl3D+eswrwhWueet
fkyJnJ+3gj3OvQkqfoHPk/IFR1hK7l9VTuafZLBI4zOn0bJS3P9cB0v361bt
yFLCfAM4aVeIYOo/uB+kvoEFRyMSba6Q9gsncegjRft70ofJ+U0eLDQ/W8d9
C5l/jcGdDpq8fXVk/fEAy/Dp/Hhki+2jj4Jt83mrLAbJ/HMRHGfSKzFdiYyf
J+Cr57W6qmTJ+/cB/LR8RSSPDN5P0nzJHPrVpYr2t+K4P2eWg8UyH6iJL8P7
BlYX3JhqceNiE66n1G7wP78k+ItMcL9Ox4D5GhrSJ1fieGfywAWTkpIbzpDx
VwX2m3Ewq/gJPl+qG5w19dyruRQ5P1An4HzH+UDfGyLz31Lw0+BkhxFl0n+b
was2Pt31KRf7m3ICz0urPFrVS9ofAZ6x+NHIAnM83zFZ4KbrQ7br9Q0xfxd8
MKpPpSWTnD/awM9TnmdHWOph/X+DOfrrhUwM8D6HWZgC+/OSSD+lIPL+qoON
NeQVnJfj+0XZgjtqXNW2tOB6QgeDcyJVZGf/3/mNAza7ZptfJ0DuH0rBLiVV
hplfyf1PC9jCLEGKVcHzFj0MNmx1nnWtBvuLmXOSQ6veLxgcT3fCvBI4Ul99
QC6YvP8W4KIdJZnHluPzov3Amu/mpD7WwvHNnABr9ecN7jXG95EtAj9c5NBX
Loj3E9Qz8PhPm1h9PxXM94NlU8RiOgvI+WFGKuy/v9fYSrZj/7IK4OCO5bX7
nMj43wLu9b4cnNuH6wG9H6was3zmdlnc3zIJYGEnhUiNCZwf2Etg1z+6Dc4y
OJ9QteDFgcPqFV/Q9Eewzes2lbU6+HwY/lPw/V6NzbdX4PmKXQGeVWenFJ5H
7t/0wT/Gte+q2eF9Fr0H7DTY419xAD/PHAZXbInq/DyfnD/Og/trfU2GX2N7
qGrwXdNf1usswrH978A34hWjbh0m9Z9ymkNnnGrNnt2E7WMlwQO6v1tL68j8
T4NFJp8vlltG1g9n8NTJuEYDedxfM5FgDcdrRvU8eD/MZnP/rj+lnr8mCp//
PXB07sAotYK0vx1MiSaW9Hrg55kx8MjuyrTp08j93yIOh25t7SsUnk7G3wbw
qw7T0M4W7A/aDsyKJ/Nuyyb3VwfBlQ8reV5b4XzPpoHbPPREHEpxfFK3wUP5
CVMaO7G/6Zdg454HH/mmkf3/CLh4qmnBDUFc39m5aRw6/+rK1JEYMv8rp/33
/tsSrDExFlM/hTz/A+Cy8kemxQfJ/X8K+NvEoU2Pr5PxcxNc0vNk6KAeOb83
gg9pLhDOPY7vEzMADligbfghGveXrEg67IdEmoUtG8n902rw8XJRnvxyvO+g
TcEX9VfpPdMm93+e4GMdodmJrfg+sMfS/7M/o66AxSv4xAM/436Chq0x/a2h
ktUymoXlfwIf0nmu270Sz9fs9AwYfxlKog9Okt9vZMEn8qbUrKwj488ArLdb
aIvqUdwPMG5gq7Kq4c8jpP9juR6fZ+P3E+cT6gL45MUu11tONJb/CPytliMR
0ETuD3vAK94fv1MziftxdmomzA/Vok1LZ5L2LwOz12Znf/9N7q+0wC7nzGTO
WuH6wLiA28vMO4qf4f0Uewj850Fhg3AWzpdUDvheVOXZ7C6cX+j7YNOawdDb
BjgfMx3gw3JrIsvn4e9N7Dj4wLrYn36bcT9MiZ/h0BJvTrpmFuLvXbQG+HF1
bZeAFbn/tQevPtGcpeI8G9sfAg6KGLVYwiH3vxngs16vZaJW43pNl4Ov7k3V
Hb/hjOW3gp/r9LexN8n8/y/YqkcsKkWD/P4wLwv2eztLjm01xf00rQKeVJ/p
WNKL5xnGCmyb3sVTlozrKesPFvp+y62El+y/U8Efy598qJ2N+wm6GLx0al9/
2nX8fuY5+LR82bRj78j68R38RvD2z5M/cT2nZmXD+sBpvndGnvT/GnDY360W
yjvJ+2sGrrN8LRrtR34/8wKX7O/T65cl889xcOTt1eYjBeT+5io4Z36DD6OH
3888Bb99c2mOvi9Zfz+DF96sFSifgb9vUIJnOfRY79i3mW/lsP6rwC3Pgx8s
dSTrnyF4isFH/inx5PyxF6wY3M3nswXHAxUHXvBKK+F7Pp6v6AKwTpegiLK9
G+ZrwGpBV5b6/4O/B7K94PRey6jAZDwPUzw5MN4W/eL/TK3EvDTYhHJ9UeIl
i3lt8M2jotS4Bbn/dwV7Gkg2eezC/RQVBa6Mjt+bI4D1pXPBdqVyRd2lZP1/
ANas3qR26DaOB7YTLK4pfjj7yB4s/w/4V6Xqqlhtsv9bkgvnt5u7874uxvMh
sxHcnkiFCJ7A33NZB3BtxBcbUQe8j6DCwKqJU6dbPsP5mM4EV1e0rgnwi8D8
HbDEmlXG6W/Q7Cvw3XVjUpV2DOZHwVPTzraabw7D/Pxz8D4KWyTWN5L9myp4
oUbIHrlicn63BvsJqvkev4DnYyoQbKy1WnE7H9aPPnWOe7/fvkWaIefnW+Dx
jPfavCHk/NsEljQbOr1VBr+f+gFewN/8V1sBnnfp2XnQH7GHOWl/cL5m1oKz
hhp7v4r44/M3B7cMa5rcEMX7McqH6xmfU7YJ4HpFJ4HdtwuEiciT9e8amL+9
7ZbYdFzf2HrwWZnxgbgOcn78Cq6Xrs01n0Lun4TOc+hdEqFyPeQ+jpEDr9g6
ESCvhfdVrBH40fyy5mX2YZjfB35RKyU3ORmN+Xgw4zy3KIpGM4XgExYz7oad
j8H8Y3Ds+EVDKRv8O/UeLMUzg8f0fBTmefM5tHzxdBv/3kOYlwH7a51znt7F
YF4H/Dhxd8+pEfw7tQvclsL/qCqP5KPBkn7xqYGX8fPMOfCGoRiP0GqSZ8Hp
Yz9cD3bi/RrVBR6t1sifa4bfR0+C7SPf2YQ4Hsa8xAXYfxYkC0jOPIL5TeC6
FyJJYy6xmN8Bdp8p/cVjEf4+Q4eDPxXNv2HYguOROQO26v86OM4Th/kK7vfJ
HvC8uw1NvQFXfp/u9yMNTf/ifr+j9SHvr/j9zIICmO8WGqbweeLzYtXAvBoT
JZXupPztYLqV501sNpoOArv4nU5uX0zqfxpc5qNySnQDef4l4NayKv1pwuT5
N4O7pl8P3euMz4ceAr9qeP+Hj588P9FC6G97PV79ftL/iuBK8bDoRJbcv20D
ayv9dhf1w/eV9gVfMIpPUvdJxfYng83kmqWyrfA+kb0OXth76cysZ/maTwLm
1DUU/v9/z/E/v1Pj1w==
     "]], LineBox[CompressedData["
1:eJxV2Gk4VukfB/CjooyGktKibO2DsWYpOSQiTUKLnRASyV6hI5UUifJEJBUt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     "]], LineBox[CompressedData["
1:eJxV2Hc8lf0bB/BjREVWQ8NKknHyoBRxHre9t6woHCE8tJQoHSRURtKhZCSj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     "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQB2IQfWXyvC0xn6Y5zJoJAjvtgUIHkoH8jguRljrHJoL4
DM1A/pGj2wVMHIpBfIdFQH5bVMsSpp5aEL/hIJDvZ+y1luVHN1j/AyD/nLp6
XdmxHrB+hs/THPb83JyhPKUfrF8eyBfxSv9+XAcs32AH5Ef+SziyZl0LWH8s
kP/D/qhKVkUrWH8tkB9lfGr1l+8NYP1zgPz+lfxz5t6oAevfDeQrdvGYZE6u
Buu/BeQHf7r7vKapAqz/F5Bv+tv6Z+K2JrB+yS/THLawOms0vQCrb7AA8t+2
tm9eGVMH1h8O5P8zuWH9aifYPoZyIF+8ZMXv7/mNYP3TgPxtzGdq+bXB7m3Y
CuR/SxVtT6kGu+fAFSB/lSs3u8BjsHkMX4D8nam+d/7vLAPrF/46zUHmcdS8
3llgfoMRkH/aLtKxc3kOWH8gkP/rnIy4glAiWH8hkD9PznqC1ITg/SD9E4B8
3zfGt7MnJIH4DeuBfL2oO1vnNTWA+AfOAfn/T/9J18rs378sS2b/SyC/WmSd
+8OqKfsBKTDRuw==
     "]], LineBox[CompressedData["
1:eJwl1gk4VekfwPETZa9ByDATlRhJhUYqcUKUYZS5lBmNLNlH1kR3OBSyG273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     "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGBQAGIQPasiStqWZ7rDrJkgsNMeKHTABcg/IOp2Rqm3G8Rn
SAHyI7ZyKz68kg7iOzQD+cdW7EqpjDcG8RsWAfl35D7wvuCM2A/SfxDID8hS
3/zvnStY/0Mgf6LJYaupi3JA8g4MvNMd7JrFnwgfyQPxG+SB/PcvZ09uLSkF
67cD8jdXnksNTi8E8RnigHzlau2GRY/rwfprgfxNZmH8rEnVYP1zgPwA4cru
C3tKwPp3A/nnglsnqyfXgfXfBvK/WdnPE28rAOv/BZIX7GD9OrUMrF+Sb7qD
i8z+a53rGsD6LYD8NB/N5ec0y8H6I4D8xJu/lILrksH6y4H8mrvFk+/MTAHr
nwbkv/by7CwXyQLr3wrkF/CfObTgehhY/1UgP+V31Dl3Vk9w+H0B8j+Y6vzc
/dkErF+Yf7rDpz9Ou80jvcD6jYD8LYelTu/o+7APpD8IyOfXCRKxMw8A218I
5M/orJz0rAsS/hOA/IRpZR/vPrYFx996ID/ar8lk38wQcPifB/KDbJdxPueO
s9/B9q71FT8ivgHyoL60
     "]], LineBox[CompressedData["
1:eJxV1nk0lWkcwPF3mqmMKGtoIUy2aZJC0fYybWQtFLJmvdbs4nJxLYOksbxI
idKJGUJmLg3dK43GJKWsKbJMllIiS1Tmd3/vH3PGOY7z8dzvex+P53nOlXf2
O+a6jCAINnzzf95/y5SZWkORebn8r9r98CuWsAhFhvYu6DmJhvDN2wLeLa4d
JBvA4pswAiudLXHIFY7jm/QCR8+rNJmzwrBPBqsJm+mrcyKwLwFrPG2xWjDC
1xPN4GrXBmZTygXsR8FZ8x+jkk6lYb9SlCK9vBe1721OwV4JHPRmcczlIN0f
Al87b0muXGBi7wqOahvQf1kbhT0b7Nt+iR1cE4z9VbBL8j+Kd9Tx7yEawVcX
hHVVynGcHASrJXXcTGSHY/+VGEVa/uaZQtz2wX4T+Lv1ngMfPnphT4I5fjrl
Kcwz2DuAvYd2RA2FsLGPAn9qn0jgfkbzLoF1xW1KuGL0+tWDK03KKgXlcX3I
5+BYYnS71yA+j7UIliltclDuccN+nThFMu7qcM6N4zihCz7puFMrIysUe2uw
rK0cS1vFFfswcFVzl9Beo0jsKbCc85dsrUJ6/Thgo9dxQkL3cX5kJzgxc0OF
RD4+jzUDVt2voUsY43x5EhIUWduRURz4zh97TfCgpvpZ1QVcL/I4uO6AyGBp
Bj6fFQB211RrVZiLx/4CeFLQx3D8CP3+lWDums/d54NisX8MLnM/Ni048xP2
78DicTV3uiyDsF8tSZFpu/JPPfK3wn4rODw7NEzGxQN7Y/BAGcO8sxzXi+UN
vsukGD0HtbBPAfdXyhdOxfti/wt4eOjRq875nVx+/zfYN4vzYFuOOd+sMbCV
zoipn/Ex7AXWUuSzuLSUvMfi/HFCBVz0iHioe1QF+8Ng2RNxkuZ7tmHvBm5d
6rjc0Yf7hRcPnol8PiGrehrfvxisfSFK+p6sNc7/Hthx+cXFQ2YuOP8h8FTC
1GVbCxPsl0lR5Md9jJFpJTN8fwXwWyuruRW3/bDXA7dYVKZezzXG3hFs2PP7
YW7IKf7redFgyRubT1e6OmFfAJ5NbK0umnbE+d8B/1HPWPFMyhPn/wJcGnKy
X0kzEPtPUvzzbtd9tcwA+w3SFCl9xrNLpTIU+93g5Ppbn3LkzmBvA961de6Z
wAE77MP54/5PtRos7bHPBffKFT/ubXfGvgYcw0zoKmhzx/l3gbnSIRoSzbgf
ebNgialdIh4muJ+JtTIUyUs/ki+4iOtLaoE1MzvsTy4xsLcAt8stvA0bCsA+
EMyRWDvSZkyfnwzw14XDMatTorGvAmsrVNi96tPFvg1cM/2t4ZtJev9Ngm88
qbBVjsH7ghBZR5E/zFvubPAJxF4drJz9fcl2NzwvLBOwYpZhnJ8qff59wG5F
s32jBO5v4hz45nuOcr8Tvf9/BaulH/zQ70Gfnwdggx1u4wGJCdiPg+PVVE3t
xlKxF1xPkQe2m6qk653DXhUsedxQb6tTDvZHwBOeZmJ9nZnYu4OTbrsMM6V/
xj4RnCNG7ROYpvvr4JjJuqL6uXTs/wRXR76fsXlK98PgzL1ls52DWdh/s4Ei
H5aFtqneoO9vRbD94n1mxTWcL0sfvGVurOeiWCL2TuAw7pOskTT6/xfDd2zB
j8VT9P1zBSyRtS97XJ7uueCqgZ5NBpwk7PvA6tbmqSVrcD8QX8BGf403+TjT
9+/Gjf87b6w9YAHBdO+l1w64/2zBsYU++hPZ9P6LAPvoehyK7w3G/ZcHTlUV
5b7utsH9WwtuiZIZcV8eiX03+Lr2y1HGumjs58ERrsU6lxpZ2EvJwn28ydWi
uRPN0gavishrqpr1wd4SbF3XWJC5HO8XIhjMnrt864oC3WeCK7NPrGKExmF/
C5zuKaUnGM7G/gm4219ROmg9mpgCRxZU55RzE7EXlaNIi5Rg5Q7HZOy3gcsD
GzrlxzywNwUP1X1uHDlKz9+PP26ldpidycQ+DeyosdK+1BafxyoDs53nFJZ8
cZzXAjZodQoWYkTuz/9SIPtC7r/PC/8CydEAvw==
     "]], LineBox[CompressedData["
1:eJxV1nk01ekfB/BLtCjHHVOJEIZsFZJZrF+EIUnX7RbGLntFWbLVjQhRWcaV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     "]], 
    LineBox[{{1486.1655576232931`, -0.02}, {
     1486.175537109375, -0.0053521141720192025`}, {1486.2060546875, 
     0.05076941138748102}, {1486.2271028448104`, 0.1}}], 
    LineBox[{{1487.167871902219, 0.1}, {1487.1826171875, 
     0.08276620813825011}, {1487.213134765625, 0.06298497371016645}, {
     1487.24365234375, 0.06192451325349221}, {1487.274169921875, 
     0.046515593409389995`}, {1487.3046875, 0.047651000947383546`}, {
     1487.335205078125, 0.04907483411749871}, {1487.36572265625, 
     0.044067593534115754`}, {1487.396240234375, 0.05963838626706588}, {
     1487.4267578125, 0.04391999313921424}, {1487.457275390625, 
     0.03342495366584339}, {1487.48779296875, 0.014482322842177315`}, {
     1487.518310546875, -0.014931555971520061`}, {
     1487.5254326860725`, -0.02}}], 
    LineBox[{{1487.9546572379963`, -0.02}, {1487.97607421875, 
     0.09060284004051966}, {1488.0001437456565`, -0.02}}], 
    LineBox[{{1488.0488410221972`, -0.02}, {1488.067626953125, 
     0.03237523536893652}, {1488.0934077857682`, -0.02}}], 
    LineBox[{{1489.1560229738366`, -0.02}, {1489.166259765625, 
     0.0036426985139813624`}, {1489.19677734375, 0.06976110861663425}, {
     1489.2106710063283`, 0.1}}], 
    LineBox[{{1491.0552613799837`, 0.1}, {1491.058349609375, 
     0.09489526684637083}, {1491.0888671875, 0.05832834962837802}, {
     1491.119384765625, 0.016027971222251646`}, {
     1491.1355423809723`, -0.02}}], LineBox[CompressedData["
1:eJxF13k8Vfkfx/GbJBSVpSZDy0hoE9VkJI5qTDsuUbpS9gwSkbhytEi2bLky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     "]], 
    LineBox[{{1498.2504491208697`, -0.02}, {
     1498.260498046875, -0.012863130269106786`}, {1498.285114428226, -0.02}}],
     LineBox[{{1498.3498654916, -0.02}, {
     1498.35205078125, -0.01889248955152239}, {1498.3533070913832`, -0.02}}], 
    LineBox[{{1498.9786906814602`, -0.02}, {
     1498.992919921875, -0.00931235845512397}, {1499.0151191765613`, -0.02}}],
     LineBox[{{1499.0422365723243`, -0.02}, {
     1499.053955078125, -0.017503594623652224`}, {1499.08447265625, 
     0.0014871530880440791`}, {1499.114990234375, -0.004986946467600862}, {
     1499.1455078125, -0.009754943573632695}, {1499.176025390625, 
     0.020897086958704028`}, {1499.20654296875, 0.03448006818217829}, {
     1499.237060546875, 0.009741346476499706}, {1499.267578125, 
     0.01764525712546802}, {1499.282122785037, 0.1}}], 
    LineBox[{{1499.319195824721, 0.1}, {1499.32861328125, 
     0.059633790338057956`}, {1499.3354095990107`, 0.1}}], 
    LineBox[{{1499.3822778222873`, 0.1}, {1499.3896484375, 
     0.0551366417796901}, {1499.420166015625, 0.0646241462803774}, {
     1499.4338179047672`, 0.1}}], 
    LineBox[{{1487.8554048924516`, -0.02}, {1487.864115198148, 0.1}}], 
    LineBox[{{1487.904360045965, 0.1}, {1487.9128280216714`, -0.02}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{1400., 0},
  Frame->True,
  FrameTicks->{{{1250, 
      FormBox["1250", TraditionalForm]}, {1255, 
      FormBox["1255", TraditionalForm]}, {1260, 
      FormBox["1260", TraditionalForm]}, {1265, 
      FormBox["1265", TraditionalForm]}, {1270, 
      FormBox["1270", TraditionalForm]}, {1275, 
      FormBox["1275", TraditionalForm]}, {1280, 
      FormBox["1280", TraditionalForm]}, {1285, 
      FormBox["1285", TraditionalForm]}, {1290, 
      FormBox["1290", TraditionalForm]}, {1295, 
      FormBox["1295", TraditionalForm]}, {1300, 
      FormBox["1300", TraditionalForm]}, {1305, 
      FormBox["1305", TraditionalForm]}, {1310, 
      FormBox["1310", TraditionalForm]}, {1315, 
      FormBox["1315", TraditionalForm]}, {1320, 
      FormBox["1320", TraditionalForm]}, {1325, 
      FormBox["1325", TraditionalForm]}, {1330, 
      FormBox["1330", TraditionalForm]}, {1335, 
      FormBox["1335", TraditionalForm]}, {1340, 
      FormBox["1340", TraditionalForm]}, {1345, 
      FormBox["1345", TraditionalForm]}, {1350, 
      FormBox["1350", TraditionalForm]}, {1355, 
      FormBox["1355", TraditionalForm]}, {1360, 
      FormBox["1360", TraditionalForm]}, {1365, 
      FormBox["1365", TraditionalForm]}, {1370, 
      FormBox["1370", TraditionalForm]}, {1375, 
      FormBox["1375", TraditionalForm]}, {1380, 
      FormBox["1380", TraditionalForm]}, {1385, 
      FormBox["1385", TraditionalForm]}, {1390, 
      FormBox["1390", TraditionalForm]}, {1395, 
      FormBox["1395", TraditionalForm]}, {1400, 
      FormBox["1400", TraditionalForm]}, {1405, 
      FormBox["1405", TraditionalForm]}, {1410, 
      FormBox["1410", TraditionalForm]}, {1415, 
      FormBox["1415", TraditionalForm]}, {1420, 
      FormBox["1420", TraditionalForm]}, {1425, 
      FormBox["1425", TraditionalForm]}, {1430, 
      FormBox["1430", TraditionalForm]}, {1435, 
      FormBox["1435", TraditionalForm]}, {1440, 
      FormBox["1440", TraditionalForm]}, {1445, 
      FormBox["1445", TraditionalForm]}, {1450, 
      FormBox["1450", TraditionalForm]}, {1455, 
      FormBox["1455", TraditionalForm]}, {1460, 
      FormBox["1460", TraditionalForm]}, {1465, 
      FormBox["1465", TraditionalForm]}, {1470, 
      FormBox["1470", TraditionalForm]}, {1475, 
      FormBox["1475", TraditionalForm]}, {1480, 
      FormBox["1480", TraditionalForm]}, {1485, 
      FormBox["1485", TraditionalForm]}, {1490, 
      FormBox["1490", TraditionalForm]}, {1495, 
      FormBox["1495", TraditionalForm]}, {1500, 
      FormBox["1500", TraditionalForm]}}, Automatic},
  GridLines->{{{1250, 
      Dashing[{Small, Small}]}, {1255, 
      Dashing[{Small, Small}]}, {1260, 
      Dashing[{Small, Small}]}, {1265, 
      Dashing[{Small, Small}]}, {1270, 
      Dashing[{Small, Small}]}, {1275, 
      Dashing[{Small, Small}]}, {1280, 
      Dashing[{Small, Small}]}, {1285, 
      Dashing[{Small, Small}]}, {1290, 
      Dashing[{Small, Small}]}, {1295, 
      Dashing[{Small, Small}]}, {1300, 
      Dashing[{Small, Small}]}, {1305, 
      Dashing[{Small, Small}]}, {1310, 
      Dashing[{Small, Small}]}, {1315, 
      Dashing[{Small, Small}]}, {1320, 
      Dashing[{Small, Small}]}, {1325, 
      Dashing[{Small, Small}]}, {1330, 
      Dashing[{Small, Small}]}, {1335, 
      Dashing[{Small, Small}]}, {1340, 
      Dashing[{Small, Small}]}, {1345, 
      Dashing[{Small, Small}]}, {1350, 
      Dashing[{Small, Small}]}, {1355, 
      Dashing[{Small, Small}]}, {1360, 
      Dashing[{Small, Small}]}, {1365, 
      Dashing[{Small, Small}]}, {1370, 
      Dashing[{Small, Small}]}, {1375, 
      Dashing[{Small, Small}]}, {1380, 
      Dashing[{Small, Small}]}, {1385, 
      Dashing[{Small, Small}]}, {1390, 
      Dashing[{Small, Small}]}, {1395, 
      Dashing[{Small, Small}]}, {1400, 
      Dashing[{Small, Small}]}, {1405, 
      Dashing[{Small, Small}]}, {1410, 
      Dashing[{Small, Small}]}, {1415, 
      Dashing[{Small, Small}]}, {1420, 
      Dashing[{Small, Small}]}, {1425, 
      Dashing[{Small, Small}]}, {1430, 
      Dashing[{Small, Small}]}, {1435, 
      Dashing[{Small, Small}]}, {1440, 
      Dashing[{Small, Small}]}, {1445, 
      Dashing[{Small, Small}]}, {1450, 
      Dashing[{Small, Small}]}, {1455, 
      Dashing[{Small, Small}]}, {1460, 
      Dashing[{Small, Small}]}, {1465, 
      Dashing[{Small, Small}]}, {1470, 
      Dashing[{Small, Small}]}, {1475, 
      Dashing[{Small, Small}]}, {1480, 
      Dashing[{Small, Small}]}, {1485, 
      Dashing[{Small, Small}]}, {1490, 
      Dashing[{Small, Small}]}, {1495, 
      Dashing[{Small, Small}]}, {1500, 
      Dashing[{Small, Small}]}}, Automatic},
  ImageSize->{1268., Automatic},
  PlotRange->{{1400, 1450}, {-0.02, 0.1}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.537765736413872*^9, 3.5377657502109375`*^9}, 
   3.537765862798314*^9, {3.5377659727872343`*^9, 3.537766015011927*^9}, {
   3.5377660630790353`*^9, 3.537766088404405*^9}, 3.537781525444092*^9, 
   3.5377816616859217`*^9, 3.537782158118992*^9, {3.5377821997088585`*^9, 
   3.537782260274076*^9}, {3.5377824329990597`*^9, 3.5377824446543417`*^9}, 
   3.537782496398088*^9, {3.537783510917909*^9, 3.5377835262528076`*^9}, {
   3.537784232597417*^9, 3.5377842597312093`*^9}, {3.537784395833311*^9, 
   3.5377844188286657`*^9}, {3.537784607869507*^9, 3.537784627667034*^9}, 
   3.537784757464302*^9, 3.5377848168966446`*^9, {3.5377849093850408`*^9, 
   3.537784929313691*^9}, 3.5381144883931923`*^9, 3.538214782526059*^9, {
   3.5382156169880886`*^9, 3.538215640809331*^9}, 3.5382179972355824`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Apply", "[", 
       RowBox[{"Composition", ",", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"MedianFilter", "[", 
            RowBox[{"#", ",", "n"}], "]"}], "&"}], ",", 
          RowBox[{"{", "1", "}"}]}], "]"}]}], "]"}], "[", "data", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "5"}], "}"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "Blue", ",", "Red", ",", "Green", ",", "Pink", ",", "Orange", ",", 
      "Black"}], "}"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"4000", ",", "4500"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.99", ",", "1.01"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGAQBWIQ3fPttcKh6FeOTlunKYHorvZD2SDap+trCYh2+bCl
BkQ33H0EpiNLUttA9IH6bTNB9IMHvclHgfStH//SQLRP47lGEK36/heY3vR4
aweIdtkp2wmi41Yd/5MV88qxNv0vmG7YzhGaDaSbWiTDQPSB+h3RIFot0zAG
RNeleqeA6BefTHNA9IXZDwpA9JlPzwtB9IKbLuUgOuuucSWIjq5cqlcEpEO3
lxmD6CkhGb/mAOn64M2/QbTA4n18c4E0h+5xQRD9z+yQJ4g+pjzLF0TPKA4M
AdFu4RLRIDrwaHsGiO5eqpsFogOy/UpA9O34LDD9QffLRBB9ZXPOHBANAJm9
tF4=
  "]],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[0, 0, 1], LineBox[CompressedData["
1:eJxTTMoPSmViYGBQAGIQfXVxga0Xp62DZkz/oa8aH+wZwMDOAUg06CrD+PYg
PsNncRjfAcQ/UCYM5TeA+Q+kuGDyjiD+AhF2mDyY7/CbASbvBDb/8Z/3UHkn
NHlnEF/hPlwezGfQYYTJu4D56//C5MH8BwJweVewfrN/MHkwv6ERbr4bmjyY
n1AJl3cHy8vB5cH8BxFweQ80eTA/oe0XlM/gCXaf/1eYPJi/YNZbmLwXWP/p
pzB5MP/AwTsweW8w3+oyTB7MZzh+CibvA+Z7HYLJg/kLwnfD5H3B7mXaCpOH
8NXXvbcv1GfeMafR12Gd+8MqESAfAAUbc9s=
     "]], LineBox[CompressedData["
1:eJxd2n2Q1VUZB/AjiK4v6aUcWUcnjy/lao3dcGoWKzmZjJuCc8u3VYF+oOKq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     "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGDQBGIQLf1w2cv3sR0OmjH9h75qfLBnAIGEDgcg2bBRCsrP
APMX3OCF8gvQ+BVg/oMJolB+Axq/A8w/UM8K5U8A8xn2MEL5MyDqU/+/h/AX
oPFXgPkO8gxQ9RvQ+Dsg7i3+B1V/AMK//QfKPwGx/xKMfwHCn/cNyr+Bxn8A
4TfD+C/Q+B8g7iuH8X9A7Iv8CuUzdIL9Fwfjc6DxBcB8hSPfoXwJMP/BTxhf
AY2vAVH//weUbwDmN2z7C+VbQNRPYYKGhwMa3wPMdzgLC+8AMP8AHyx8IyDy
XbDwS0DjZ0Ds3wUL7wKIf+7A4rMCIq/ADot/iHwCByz+wfyEJBh/AsT95wQ/
2Is//Xv/z9ROePoDADXVslk=
     "]], LineBox[CompressedData["
1:eJxdm39QXNUVx18UDVUSQdFsFTMbRUMbNBuDhlHGPA1tSKV2J9J2rRi3BpWO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     "]], LineBox[CompressedData["
1:eJxd2XFolGUcB/DXudzSqSNuOXLqaQsmrFg1YdbQC5cMnbBy5LBRh8w8YujE
KQtOO+rEGQMHLpm61RWzRq61YOkVMw4dtWDCsBFLZ50wZdh0y506a1r5fN/v
E/v6j3z4Pc/v+T3P+zzv854u3bLj1a1JjuO0zHCch3+HLjS89lzHUd/yikNn
b+eMr3Ye/uk86nsY+mWp6y74icWuo8axjnmuu419J2e5jhk74WTXPcbePY7r
XvRPuj8G9yHu/ct1v7H/3buuB9B+3x3Xg8bxjbddD6G+BXRcPIz6ttEj4lHk
j064HhcnUM9u1jMpnkI9pTdcO8emO9nYG6NTjSPzbrpOE6cbO94x1x5xJvI9
zvZZYq9xzMP6s41D39I5yDdE5xr71yVc50k8H/k6brkuEBca+y7TPngt+xfB
i7jexei/mC5B3D6PUsSXTrouQ33n6HLMN4X7pQLxmVOu/YhXP3BdifX98h/X
AcT/pKvgmzPc/VmN8Q8mua5B/gUzXdeKg6j/EtuHxGG0L2D7OsS383zUY7/8
QDeIG9H+Gs9XE57PxRTXzah3z2zXEfS/Ocd1K9pvSnPdhnquzXXdjnjWfJ5/
rNcdukscxX5KobtR3xjHi2H87aynB/VNst5ejPcU59OHfJs43354G9drQDyI
55XB9R3CfL7n84uj3p30MOI76BH0H+b7aBT17afHxQmMf5meRL7f6CmJO8fN
+OfpZGPvYjoV3sf3X5qxfw33b7pxyE97xJnGsat0lthr7Myns9H/1t88/4h/
QufCu+g8iecj/0rmK0C9n9GFxr6LtE/iRcj3NvMVG8czeH5LsF7V93j+0b6a
79cy+D2+H8rFFVjPrWzvx3wH+b6oxHhB5g9IvAr901hfNeJHWH+NuBbjr2f7
oDiE9fqAzzcsrsN6rWP7enGDuBHr+RLXqwnrtYj1N0s8gnrO0K1oP8Z8bZjP
btbTjvl/RXeKu+Aavk+jmE8r35/dGG8J93dM4j2Yj2Pvf3EfXEb3o38DPSAe
xHwSrG9IHEe951nvMOpbzv4j2A9Rvg9GMf4VelziCfTvsOdfPIX+S9jeaZ7u
ZHGqsbOQTjOO/cR86cbeGO1B+/V0pnHka84vC/HDtFecjfy5dI441zh0g87D
+Bf4/PKN/XcZLxAXin3IP0EXoZ7NzFeM8V7heSpBfAVdKi4Tl2M979EVqPeE
vf/FlVivy9z/AXEV8n/I/VMtrhHXYvwddBDjPcv5hhB/gfMNi+vE9ci/hm4Q
N6J9C92E9XPoZuP4Cjoi8VbEr7O+Ntjun3aJd2J9NnG/dSHfaToKz+b+7Ub7
DXQMzz+V93OPuNd9/mzfJ+4XD2B/XacHEV9JDyG+3t7/4mHxCOa71p5/1Oez
51+cQPtr9KR4Cvlb7PlvMfUdt+e/ZXo81djZa8+/ON3Yd9+ef+P/3w+Z4iyx
F/m+o7ON4wE6B+09dK5xZAudJ85H+zhdIC4U+zD+DboI+YKcX7GxN40uEZei
/1X2LxOXY30f0BViP/Kd5P6vxHrOtN//yLeH+70K9a2lq2F739WIa8VBOMue
f3EY9RxmfXWo5whdL/EGrGepPf/iJrR/3Z5/jPc0+0ck3or5ljDehvhextsl
3onxXrTnXxwVdyPfLXv/i3vwfJr4fHvFfRj/U3v+xQPYv8/Y84/8PzL/EGzv
y7jEh1Fvjb3/Mf5d+/0v8XGc11Z7/lFPhj3/Ep/C+s/i+835aLqT4efpVOP4
Vnv+jb3b7PkXe8SZxr4U5ssyjh205x/xLLbPxvhv2fNvHLK/h3MRP0HnifPF
BcbO+/b+x3hR+/2P+Bf2+19cbOxfxfuzBPnXM1+puAzeTJeLKzC+Pc9+cSXW
+1eOHxBXof1Ce/9jvfPs/S+uFQeRbwMdEofxfO7b73+M18fnUy9uwHot4/Nt
xHrZ+68J42fy93Az+r9BRxA/R7eif5S/r9vE7dgPRXSnuAvzaaaj4m7M7549
/6jHa8+/uFfch/E67fc/nm+hPf/iQbQ/a8+/OI789vwNi0fEo+g/x97/4oR4
En7Zfv+jvgc8H87H051s7Avb3//iNGP/Kvv9L/YYh+zvo0y4zd7/Yi/yH7P3
vzjHOP67vf8x3h/2/hfnG3tt/wLMz94XhWKfsfOIvf/FxeIS9N9lzz/Ge9Oe
f4mXG8e+4XmqEPsxvwH7/S8OYH772b5KXC2uQb3Z9v4XB9H+hD3/8EaOFxbX
YT5X7e9/5DvN3+sNEm+EO+kmcTOe7zv894CIuBX5z/DfP9pQzwTdLvFO7KdD
dBfWd4L5ohLvRr4DXI+YuAf5Rzm/XtS/k/37EP+Z+fslPoD4J4wPYn8EmG9I
HBcPo95TzDciHsX8Ttn7H/0b+X5LIH6JnoTHH+X5R/vHMnj/R4yDi1wniZON
Iz6P61niVHjuEtez0f/8Mr4vjEOfPzm++sqBwcCu/8z/v/kXQCRmaA==
     "]], LineBox[CompressedData["
1:eJxd2XFM1dcVB/DXN0atIiJjFlHpq6WEIWGEoGOE0Scio8iYUmTiCHslyJBS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     "]], LineBox[CompressedData["
1:eJxdmn9Ul9Udx7+iQ0RSI2JmRMgcMXKMY8SYoRLHcYwcY84YOeaQKcfUSDnm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     "]], LineBox[CompressedData["
1:eJxdm39Q1/Udx78hmUMiRWMmZuR5pmbqmDHnzDgzdcSYETr1zDhyZg6VmSNy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     "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQnbhw3qHfbBscNGP6D33V+GDPAALsGxyApEIojM8B
5i8QZ4PyOcF8h0JGKJ8Lwg+A8bnB/AeqMD4PRD7r+3sInxfC3/4VyudD4/OD
+QydX6B8AYj9Dh+gfEE0vhCYn9ACM18Y4v51P6F8ETR5UYj7mmB8MYj9LZ+h
fHEI/9FHKF8Cwn/yDsqXRONLQeyLhrlHGsw/cBamXwZifx7MP7IQ+Scw/8pB
9D+EuVce4r78X1C+AoTPBAt/RYj9aexQvhJE/2n+D/baGwwSXygh4hMAm098
ag==
     "]], LineBox[CompressedData["
1:eJxd1LtPU2EYBvAj1CaSiIphp0ulILTgBasCR6CgeKkWBS8FS7UqcimIQrmI
VUYTWZy66CAJMQwtCRE2AgmM8gcQ0snFARxIVIJAz/M+MXmbtM0v33fe23fO
cYSjgUiWYRit+9/Mv3/5i+1PYdJ0BScWtwo3q43Mx5U0938XfjrFRZbN1aPi
Ysufvx0Rn8T+EroE+8sOiUuV3coey2mvIS5TLke+D/niU8qnLRu/DovPKJ9F
vq+54grLof5j4nPKXsvx7zbxecTr3N2ALyhfRD2zrLdSuQr7B7m/Gv3F/olN
5UtwmvtrlGvhqQMSvw7159M+5Xr0n2A9Dbi+nvEu4/zmdsRXUO/MX3Gj8lX0
17MtvoZ5BXn9deUbyn7LBXH2e1P5FuK7WV8A9du53oT6E4x3W/mOcjPip1h/
i/JdzGuSvgf7fovvKz9APSt0EPlyOY9WxB+j2+Bt+iH6C7KfEOK9p9uVw5hf
DefxCPk8PN/H2D/N5zOi/ATnN8fn4anyM+UO9Os8KH6Oep2spxPrm+ynS613
I/8659+DelNcj2Ien9hPL67P5v3Zh/WP9AvUl6b7lV8ifpzxXmF9ifkGML9d
1jMo503HcP//oIeUh+V8GW8E8VaYbxQ+wXpeI/6aXTym/EY5jnnN54jfIl80
T/wO/VQcF49jPfN+Xp12zNrH/7+/9wATsXyV
     "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQHXjv6d1l3RscNGP6D33V+GDPAAI9GxyA5IGJklB+
L5jfkMYD5feB+Q/2MUP5/WB+gi8jlD8BIv/z33sIfyLEvLTfUP4kNP5kiHq/
n1D+FDT+VDDf4ckPKH8aRH8IjD8dIq/5DcqfAdH/4CuUPxPCvwbjzwLzFVJg
/NkQ81K+QPlzIOZd+ATlz4XI93+A8ueh8eeD+QzTP0L5CyD673yG8hdC5CfA
/LsIEp7VTNDwWgxxjwc3lL8Ejb8UYt410Q/284+/n266FBFfAE77h6E=
     "]], LineBox[CompressedData["
1:eJxd1llQjlEYB/CvTYtEKpKtslTaZClb+qgUKUnJBaNl6Moyo8lwlRszRjNc
dCVMjGGG0pcWayRb9qVkCX22aE8ptEi9//NvxtNMNb95znmWc973K7eUHXFb
THU6nWHwe+h3ZJppVsFZg95r46GKLs/2EN3Q1zmDfvBnbou9cp5mXWxfG5wv
fF5z0hETtb5A2ADv0ykXCl8QLtJsTBhQ+Ys1l+ewXolwKdxLXxS+JHwZ9ar7
la9gng7Wuyp8TbP+NF0mfB22Y/83hMs1u+5lvZuI7+9RrhC+hX7Le5Vva86M
5v47yJfxV/mu8D3Mt4euxHnWst/7wg9gf65/iPqdrPdIxB+jnp5+gvXpzPcU
6/vM1fzPhJ9jvbuF8gvMV09XCVfDKXyeXgrX4L5KTJVfIZ5kpvxa+A3OJ4p+
i3lOcX+tiL8T8fewOeMfMN8Jxuvw/qTTRuQ7zH4/op9k+hPyxdCfhb/gvHbT
X9X7wvr1WF9Mf0M/vfR3nI8zz78B9qAbRbwJ+Zy4vxnPZz/rt6AfN7pVuA39
5dDtOI80nscP4Q6cRx6fn07hn3A83YX8RXz+uoV/of9Avn+/MZ8j6/1BPJHu
EfFenF8d++/D/N3M1496R+m/wgOwN98fXeH/NtGcW0abCpvBzrS55sxt/Pyy
EB6hWRfA+S2FrTTrs2lr5N/Jfm2ERwrbanY9SY8StsN6I+9nNPpLYb0xiG+i
7bF/Mz/fxsJhtIOIO6J/J87rBNfwfMYJjxd2xnl4sP4E5N9Fu+B+jnGeidgf
yPufhHlS6cnCUzQbq7l/KvJv53m4ai5vZD9uqFfFedyFpyFfMz1deAbmyWC+
mejXl/U80F847Yn1PuzPS3iWsDf6P0D7wP6c1xfzbKX9hP3Rjx/3z0Y/fuwn
APWCef5zkD+Z88zFem/OOw/rz/B5mC/igYg30UHCC+BA5l+IesP3sQj9u7Kf
xbiPVnoJ5hn+PA5GPIFeKuIhIq7H/R3keSxDPzb0cvg4+w3FfFGcN0w4HI6m
V+D9CuX+COFI5A/ivCsxfyi9Stx3FPaX0quFozGPF/8+xCAexr8fazB/paVy
rPBa9J9tpRyH/VWMrxOOx/nm0wnC65HPxVo5EfNE2CpvwPwNDu0hWcbM1KpB
8//df8WixpE=
     "]], LineBox[CompressedData["
1:eJxdmXlclmUWhj8QNKHQCpVQE7cBEtHEdCYbZTJtczJ1amyUJBQVQamo3BVz
twyX1FzDpQzXkFwzxaUUp0WzCTXNJXVcERVcEav3eu/3j+Mf+rt+5zzn3Pd5
nu99v+ezblJ652R/n8930M/n+/PfLkktlt3qlhsf3T1re2lUcRvfn3+658b/
8fcxv0iXExzObxfq8qsOZy4MdrmHw/EdKrmcSHxsoMuvGU6CEwJc7umwL9bf
5V7ET5ZfgpPRU+OOy70N93E4+7jy+xpOoV7Dmy73M5xK/uTbLqcZ7u9wYmCZ
ywMMp1Ovi8/V/7rhN5ifv/hNwxnUqyd+y/DbDkcEid+h/uvSNxA+e8PlQYYH
M9/AWy4Pwd9T4qHUr6Z6w+ifJH/D2d/+4hGsH6v5jiQ/VvoyDY8y/C792vm5
PBq9KeIxhseiP0Trx1FvrfqPh3/WeZhA/b3iiYYnUa+Z+D3D73O+SsWTXf/q
9wH7N1Kchd4dd12egp490jsV9snPNOrniKezPlzn/0N4uXiG4ZnMP1I8C3+B
4o+oH6P6s/EXKZ5j4nPRN13r5xmej/8l8rPA8Mfu80H1stEzX+sXGl7E+m7i
xfh5SbzExD9Bf7r4U8NLmU+R+n+Gv4niHOJNpXcZ6/21X8vJD9R+rjC8Ej2t
xavMfq/GfwfV/xzOEefC58RrTDwP/9HS+wX9ponXGl7H/tSX//XoCRBvMLwR
Xie9m+jfSH6+NLwZPTd0/r+Cm4i3kH9Iz4OthvOZ30712wYHy+92/IwT7zC8
0/DXnJ9d4m/YvzT522V4N/npmlcB+rz934OfKOn7L/o2yP+3zKuK/HxH/Qw9
L78nP1b8g4nvZX9qqf4+9CSKfzS8H311pO8n6leW/v8RLxT/bLjQPY/iA6wf
ID5o4odM/Bf0FMn/YfLz9D44wry+1vvyV8NH8Zuu/GPwKc3vOPmnxScM/8Z+
t5D/k8Qfk75Thk8b/r/7fNP+nzF8lnmlis/BW8Tn4cf1feSC4Yv0GyF9RbCf
Pg+XmNdW+S/GT5r4suErrI/QvK8y/1KdhxLio9WvFC4SX8PfcPm/TryX/Nww
fJP9uK78W/QbLb5t4mWw9zy6A0+Q3nL81hXfZV6dtZ++NY6+zvLr53D8GH0f
8TdcweHMQuUHOJzYRvUCqddb/is6HDFFXMnE76F+S3Flw0GGgx3O763530u8
mfg+6q/RfoeQ/6L0VSH+pPRXxU+JPh/3G34AztHz4kE4SvVDDVdz+NhccXX6
b9L8axDfJw4j3l77/5DhcOabIv81DddivjPEteGL4ocN12F9huYVgf4wcV3m
eUH66qHHe1/UJ54gfw2YZ4nm2dDE/0K/o+ofiZ6KOq9R9B8qv9HwYvEjcCvd
VxrBVYNcjnE4e4PuN41NPBY9oXo+NEHv5QouN0XfYPV7FL8vS38zw3HoX6d5
NKd+hvw/Rv0QcQvDLdE3S/P9K/XWi/9GvLH243H0RWp+rQw/wXnarPy/M49+
4taG25A/Xhxv+B/U9/b7SdYX6vy3NfwU+pfr89IOvqZ4e8NPM4+J8vsM85sq
fpb8ePl7Dk4WP2+4A7xa/E/09xK/YOId6ed9v3vRcCfyr4s7sx8tNZ8unIdU
nYd/4Wea5vWSib9M/BX5+7fhrvA68Sv0H6P+/2Hey3Q+u6EnT9zdxBPoP1Of
r1fdz7u4h4knEu8rfs1wEvlx0tOT+An57YWewzrfycRDFe9t4n1MvC/6h2le
KfiP0Lz7GU7lvGaJ06hXXXr7Gx7A+gPSn06/MO/+Dx9W/zfw+4T4TdYXS28G
PF38FuvPiN828XeIP6PzP9DwIPxsEQ+Ge2heQwwPdd9n0jcMThYP5zz11HxG
wCnikZz3QeJMw6PYrxfE76I3Tjya/H7qN4b83dI3Fr035Wec4fFwDeVPgH3e
/d/EJ1F/oHf/J+7pfZ/4JPFkd7329wPOwypxFvPw7u9TDE9lfa53/4dbaf10
5rFfn9cPmUeMeAb5G6V3Jv17ys8s8p/TPD7ivBTo+Tnb8Bzyc7R+Ln7rqP48
4u+J56OvTHoWoKeD5vMxfr3v79msLxcvNLzI8GL8LBUvQe9Q1f+E+l+o/6fu
50H6l6K/q/gz9MaIczjP4ZrPMhNfTv+24hX4S5T/laz3fn9aRb+G2s/Vhj+n
nndfz6XfUn0/WGPiecxjgXf/p573e8pa/Nf07v+s7yM969HXSbyBflnSv5F4
kfxtMvwl9cKUv5n13n3wK/iq6m9BT6L0bGX9anE+8ZY6/9vwt1K8nXrtNY8d
xJ8W72T+DSrq/m/4G/p597ddnIcs9d8Nr5feAsN73Oejd/+HwxX/1vB36IsQ
f4/+eeIfmOcl9d/L+vPysw+9d6X3R8P7qd9R/BP1Crz7P/02e/d/w4XMO07r
Dxg+SP0g7ech2Ps99Bf6dRQfNnyEel3k51fDR/GzU/M4Zvg4+c9K7wn2Y474
N/otkt6Thk+ht6v4NOvHePd/OFr9zsDNtb9n6d9J/s8ZPo/eAq2/YPgi++m9
H4sMX3KfL6pXTP/W0ncZ/bs0ryuGr7Kf5covMVxKPe9+cw39tb37v+Ebhm/y
POmofrfQu1L+buNnkfyUEW8uvmO4nPzmWn/XsC/P6T9K8/dzODtb8/F3OD9W
9SoYDnD42BDVCzRckfzZ+j5UyeHMaPE98CS97yqzPlkcRLyWONjwvejfft3l
+wyH0D+j1OUqDiemXnW5quH7Wb+kxOUHHI733kcPGg5FT7VrLldD/zb1q27i
NdATp3gY9dJU7yH6H1F+uOGa1CuUvloORyRIf20Tf5j9fF716xiOYP1izasu
8VWqV89wfep3VP0G6G8rfQ2ZZ4h3/zccyXzmaf+iDEejZ7jOxyPUb6Xz2Ij8
yTpfMcyzkp43jcmfqc9PLPkL9D5qQv0V+j2hKfO9ot8LHjXcjPzq9YvblAUc
mhb8B+v/X38He7WHnQ==
     "]], LineBox[CompressedData["
1:eJxd12lQ1VUYx/Ebps04NjolM71wSXuhtxepTGFKCi5hZaLhUuEGbmgulN4g
SwsVTSsVc0VLsTLzuqDhhtt1gRIzlxYFcws10kxwYVHIkvs9P5t5mBHmM885
53nOc87/3r/NhiTFDg/xeDz59/7V/K1fsSbtn2eyo7wD5u4va1ka6an5Cc+O
uvc7s38L57ZBpzZ/1PnZoD1NHnZuZ9zeOCLo8/5azs8FHdX8AecOONzj3DHo
vev+LcGRxlGM7yt3Ir5C63cmf70qF+8SdPxTt527Mj6u0vl542j2n6Dx3ciX
cMf5BfoxW37R+CX2+7Tydzd+2bgH9d2tcI5hvelyz6AfD7vl3IvxKTedX6H+
jBvOsXii3NvE+zB/qOb3Ne7HfouvO79q/Br9XaR6Xmd+oRyH16p//Y0H4Kll
zgOpb5fmDzIeTL4uqi+eeC+tl0C/nlB8CP29qHqHGg9jfCuNH45T5RHGieQv
Ur6R5D+t8xtl/IbxaPoXWu08Bs+Sx1JfiO7/OOMknK713uR+Jstvmfh48ve+
6zyB+5Mp++h/La3/NvU0DnFOZv+r5BT2ny+/Q77uet4mki9efhefkt9jfuGD
zpOIN33IebKJv089AfkD3FpONZ5CPTG1nacaTyPfRtWTZjyd/PO1vxnM9+rz
6UP6laZ+zWR8hDzLxD+if3Ga/7HxJ8azOc+Tyj+H9SeovrnG6eQbpfHziOdo
vU/xI/J84wXkD9P8hcaLqKelxi82XmKcQT1h8lLuW0D9WMb6KxX/jHrK5c8Z
X0/5l5v4CuJH5EziSfJK4y9wlfyl8VfUUyCvIj5Z9X7N/Qgovhr7Ff/GxNfg
E4r7cbTia43XsZ/x8nrjDcZZeKa8kf77dP83GX/LeaSrn9nsb6C82XgL9tVx
3mq8jfyJGr+d/bSXc+jnTtW3g/Gb5Z3Gu3CxvJv1HtN6e3i+n5QDOEP3f6/x
PjxC3s/ze07zDxjnGueRP0X+Dt+/r98bH6TfeXI++79/vw6Z+A/Ec3Q/DuO2
8o/0Y5q+D45wfuH6PD9qfIz5dfR5ftz4J8b7td7PrL9a7ze/MP54ufOv1DtD
38cnjE8yP0vvIwXGhXiOxp8y/o3ziVW+06zfU/WcMT5Lfes1/xznNU/vL+dZ
zyv/blzE/IbyBdbPlS9S3yT185LxH5x3G33/F7P+Yc3/k/UvlDpfNvErzPdq
P38ZX+V8CjT/b+prU+J8zcRLiLeQS6m3SO8z1/Ex1XvD+KbxLerP0vtVGfU3
UL/Lef6v6X22grivrruvlca3OZ+xuu93jKvI30jfx9XM7xhaGpl7tTC0R/X/
///4DwUlQ/8=
     "]], LineBox[CompressedData["
1:eJxd2Xdc1lUbx/EbFHDizByokBmSM7XUHhUcucJtaLkJNQlzhA0xxXBibo1E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     "]], LineBox[CompressedData["
1:eJxd1klI1FEcB/C/45JNm0vmUpmWmVbmpNU0bU6ZlbbZpLZZjWNKh6hDEJSH
7BB0iyA6BQkdugmCBkKHEjoURN0stRqbSUtLx9JRZ0bNed/3FfoJMnx477e8
3/vPkum65qgzGYbxYPY//NqSEiyo7Gyz51bf7xjL8RUZ4b+PbfbwS2+c9idl
d2uUdhc8YGh3Y3/31DDcI/xZ+Ity40BQ+6uy3Uu7kf8e3Yv9VQHtb3DPpLZH
OeMD7UW99nHt78pNd8a0++Ano9r9qF9M/1B2Noxo/xQeQPxb5htE/at+7V/Y
b6N/K7/MY39DOJ+L5xuGrZyPD/liZrRHhP8g3yvO4y/iHzL/qPAY4pO434/5
WVh/XKxPwM8mtCeFA8gf4HyD6OcR10PCU3BqSHsadvO8M8LG8/8doWzvoE3K
GfWcR6RwlHA03EzHCM9TbrLweY4Vnq9sdNJm5UbvtI5fILwQ8ZfZ7yLhxcrO
eNZfouzOZ/447C+M0I7H/nSTdgLWc+hEnOc6vVQ4Cf3dZP5lwsnCKZj/FfaX
ivpuni8N/Q7xeVmO+/HQK4RXYn4VdLrwKtTL5vOYoefBeWWifh+9GvvL2d8a
zOMd+89CfDLnt1Y4GzbR6+A3jM9B/no6V3i98AZ4iv1sxPmb2W8e7uMxvUk4
H/3Pvb8tcCm9GffjYb0CxM+w/0LM08X73oL6L+itwtuErcj/lN4ubMP8s+gd
iDfTO9GPjf3sQj8Wejfinex/j3AR8iXSdvg1vVd4H+6rnfWLMf8QvV+4BLbz
++sA5uulD4r1Q+j/LuNLsf89z1OG/bfow8JHhI9iPv28z2NYt/H9dBzziKXL
xfoJnL+M53cIn0R/VrpCuBL7G9hPlfApnDeSPo1+gow/g3xd9Fn0d5s+h+fF
wX6rkc9Mnxe+gPo36IvCTj0vfh7UYH3u94FLrNei3xrO95L4PKjD81IbrV0P
pyX4ilr8JYOVs+bvn39/51Y3
     "]], LineBox[CompressedData["
1:eJxd1MkvnGEcB/B3EBHEsXGh5mK5uTThoCYukh6l6YEmRCOxlFFbqaWjG2qZ
UUtrrFVD7bV0UNvwF4iLXiQiehQORMc2xvt9viS/SWYmnzzP89ued8aYaU7J
8tE0Lc37vv1uTdsK6cl2mmKeWzdPo48TtdtXjtPk/cy4DFLO1e3a8lXOg8cN
yi91741pyvk4b6cLdGv7l0ewWbflGV2o2+S5UH6lO+LoXLkI6wlu5WLhEsTf
/q9civPTPF+G+szM9xrnY6+Uy3G+wKNcgfoNrP+NcCX2H16r/VXoJ5muxnye
Ml8N8k2yv7dYP2B9FuFaxC+k36H+gDPl98IfkH+d/X8U/gS7OK861BPJeuoR
L471Nwh/ho3sp1G4CfU+5Dyb4Xi6RdgqbEP/gYzXCt/d1xfkC6bbxHq7WO/A
fT3g/Dp1D3jY/1fhb5iHL+fRBWvs347nSeP9d8NP6B7hXjU/uk+4X3gA9eww
33fES6UHhX9g/yHrHcL9OmgH1o3sf1h4BPGiuf8n5hXK+xjF/hesbwz35fBR
Hsd80v2UJ5A/zF95UngK+8O5fxr318//j19Y/8f+ZlCPhfXMIp6RnhOeR702
+rewE/VH8flYQD4b+1/EPB7z97Ik/Af+Sy8j3ibjraDeu/tZFV6D3fQ68ifR
LsR/xHlvoL8l73x2Xfvuk437/+cb9s6TbQ==
     "]], 
    LineBox[{{5831.873420397817, 1.01}, {5832., 1.009023666381836}, {5833., 
     1.0010426044464111`}, {5834., 1.0010426044464111`}, {5835., 
     1.0017606019973755`}, {5836., 1.0054136514663696`}, {5836.065874162513, 
     1.01}}], LineBox[CompressedData["
1:eJxd1klQzmEcB/B/b5uUtyQqoT0lka1Qed9EG1kKiWghO0W6mEkdHAyHDl0w
HXKyjItLzHBoHOqAiEpCWixRlNK+vOr/fb4Ov2aq+czz/H/b8/zr9c3NT80z
aJp2d/p75rdXXUVG46sqc0hm2bPB4D6TNvP1uso8/bM0wEW5Xnd1uLXyG90+
fvRbOHWsF27Qbb40otyIeOlDyk3C77B/nG5GvOJh5fe620omlVuwnuip8n8Q
/oj4DR7Kn/C8k41yK9YtjPdZd2Uz3aY728J+2hHfmf10CHfi+QrW/wX9FI0q
f0W+Tq5/E/6O+u7TXYgXR/8Q6z9xHt2cTzfqLbMo9yB/z7jyL+x/MKH8W7gX
z9/R1Hz6hP+g37Qptb8f9aQw/oDwX+FB5PNnviGsD3N+w8Ij6P8aPSo8Budx
vuPCE8KT6KeG5zmFfp7TFpxHC+vVHun1/L8fVrq1K1ZqHgZha93VtzgvG6wb
eB62WI/h/OyE7XWbB7h/lrCD8GzdpVHM5yjsJDxHd2UxbYTv0c6oN8Gg7IL+
6+i5wq66fS6z/3nCbrqzb9PzhRegnx7md8fzHbQH8uXQnsILEc+F8/BCP4/p
RWJ9MeZhy/NcIuyNejJ4Hj7CvrA97Sfsj/OMYL4AlZ/1BmLdzU45SHgp+o/l
36dg4RDhZXg+nucRivUavl/LhcPgJ/QK2Mj7v1I4HPfhId+HVZjXU/a7WngN
6rHi/rXC6zCPfjoC62GcfyTO9wXntx7xTZzfBuwP5Lw2CkehXm9b5Wicz3XG
j8H9aGL/m4RN6D+YNgvHor5W3t/NwnHoz8h6twhvRbxa7o8XTkA9gXSicJJw
MvqdZPxtwtsRP4n7UzCvcnoH6ot2VN4pvEt4N+JP0KnCaYgfyfu4B/OPYb69
wvuE03HeJfR+5A+iM4QPwIXs9yDy+9KZwodQbw4/rxzGPDUv5SzhbDxf4Kyc
I5yL+mtdlY8IH8X+G6w3D/Hj6WO4P/W878eFTyCeiT4pfEr4NM47mT6DfA70
WeFzwvnq/xnflwLMt53v93nhC8ifxfkW4vyusr+LiB/KeRfBL+37TDVdBe43
p83Pm/8A+/6qbQ==
     "]], LineBox[CompressedData["
1:eJxd1mtMjXEcB/Cnq0sXiU6RcgpbeWXDZnrRYfPCZmymF8amMW/MlhfMCyS3
kOjklmsXSpRLbp2Uy5FL5HKoRKGiXCIKHbduTv/v831sv7Zqn/3+z+///f+f
//OcE7E4Ye5Sd03TCl2//f+LTdaA1jU2S/TCtHJnVEes1v+z1mZx/U2KC9W9
Ds710p2obF7tpns9nKnpTlLOntDXDm8Q3ii8STk+jt6sbC/u1b1FuWkG+ycL
b8X8C+htyJtMbxdOwXhfzrdDOBX5UuiduL6N3iWchjyhPbqtqM/v1p0uvBvr
ddB7hPcK70O+RPbfj/la6QxlSxHzHEC9jz4IT+X6Dylrs+jDwkcwPp4+iv3I
pTOFszA+lc5G3kbmy8H9rKaPCR8XzoVT2C9P+ATmd6PzMb+T6z2p56NPiXoB
6hl0Ie7PSvY7jf0YT5/Rzz99VviccBGu92T/88IXkKeHvojrJ/L6S8KXMX4y
XSxsEy6Bo+grWG8sXSpcJnwVttLXcB5rmfe68A2cv+m0HQ6hb+L+Wfk8lwvf
giPp28J34A4+D3cx/yL2r4DDmPee8H1Y4/hK7O8q9n8g/BBu5vhHwo9xP2No
h/AT7L8P/RT589i/SrgazqFrsH/GeXyG/pPoWuHnwi+Q13gf16FeT9cLv8T4
FfQr5ImjX8PG+6EB+YLoRjzvxnqbhN9gPifX9xb742C9WbhF+B3un4nzvUf/
FvoD8nXSH1Gf4667VfgT8kfz8+szbKLbhL9g/uXs/1W4HXmD6Q64lPm/CX/H
fhjvpx/CnchbwvehU/gnPI/7+Uv4N/ql03+wnlL6r/480V2olzF/N/La6R6c
D2/uRy/eD5Ws92G+2axrJaqe4KHbTdhdOT6Gz7OHsKewl7K9pku3t/AAuIvj
B+J6M/dzkHKTH/MOho33pY/y//PvK+wn7A8voYcom6voAKw3nB6KfNPoQOQL
pIchTxTzDkc/4/tPkLI2kzYJBwuHoJ/x+TgC/SrYf6Soh8J1rI/C+HGshwmH
Yz3G/R8tbFa2FNARyDeFjsR8WfQY4bGYL991Xpb55xU0uMzvp/8AoCLSpQ==

     "]], LineBox[CompressedData["
1:eJxd2Hd8zWcUx/Frq5ZaRVs0UST2jMRMzCBGxCa20NgxY8XeW6jRQdFWU9So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     "]], LineBox[CompressedData["
1:eJxdmmeYjVcXhkfvbfQahCjRgyAyJgTRQxAE0UX06NFGSwSfMnofvcwQ0bvR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     "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGBQBmIQvbVqn4jUr90OmjH9h75qfLBnAIHfux2ApEO6AJT/
B8xXOM8G5f9F4/8D8xue8UD5/8H8B668UD7DHlQ+I4T/D6aeCcx3eMYJ5TOD
+QqdMD4LmJ9wiR3KZwXzDyyF2c8G4UfB+OxofA6I/jwYnxNi338YnwuNzw3R
vxVmHw+Ez8kB5fOi8fkg+uVg6vkh/Akw8wTA/AYbVihfECJvCuMLQcLDhxnK
F4bIf2eE8kUg+vf/fQ/hi4L5DLt+Q/liEPec+wDli0PMk3sM5UtA/P/7BpQv
CTF/3mkoXwqiv3w3lC8NCf+zm9/bi/teLVgB5K9zf1glsu69PQBZwYnR
     "]], LineBox[CompressedData["
1:eJxdmHtcjmcYx9+XlENJCilLDqkcyqHwluolFCE55FBIyXIqi83G0JAd2GKa
Oc9p5jAxZlsWa20zO5htLBszcprDEIokGc/v+r1/XP1Rn+/nuu7fdbiv+36e
pxbJGUNSa5hMplizyfTs77CAWSd2tSyw5kWVzHbLux1hevbTqsD69LfVea9w
a4MLr+QL+xi8cd5R4TYGm+KLhX3hn1si7Gew93xTKdjf4KzWZuG2BidV1hRu
p7g9/OPshTtA366ucIDB5yvrCwdivdlFuCPizyV3Qv4JDYU7K+6C+rPJQVhv
IQcre1dwiKtwN8Xdob+a8S2oZ7GzcAjs4Y7CoVi/qZ5wD/jvY71hqG9JHeFw
9D+hlnAE7PHsn1VxT/SrOfV6wb6osXCk4t6Iv5v+fcCTyH2VPUrZoxHPj9wP
9UbWFu6vOAbrvVjfAPRjPXkg6k2l3iBlj1X2wdCrT45DfWfJQ2AvJA+FXhV5
GPIzc3+Gwz/MSTgevJL7OQL12rsJj8T87HIXHgX7bU/h0bD39xJOUJyI+IEe
wmMQrw55rMwH92sc6tvA+UxCvBzmOx717WC/k2FvxPOVAr11NYQn4Lz5kVOx
PpTneSLyO/lYzvvzYJcq4TTsR06l8CToFz8Unoz4Nx4IT8H6meSpiF/vvvA0
xF9zTzhdcYbi6dBzLxd+AexHzoT/A/IMcGqF8Ezkd4r5v4h8kljvS6gnkv2Y
pfhl7IcD/V9RPBv7Hf5EeA76Fcz1ryJ+Me/LuXJfcT/mKZ4Pf0f6ZyFeGfVe
g398tcRbgHpasb6FihehHl/uZzb6s5n5L4aeK/N/HfZo8hvIZyTzeRP1bSC/
BftF3k9LoJdlJ7wUXM75fBvck/wO8vN0EM5R9mWI50Nervhd5FvGeCuwH9fY
z1zF70HfifmuVPw++neU9/Eq6A8nr1a8BvkcZ/y16EcmeR3smYy/XvEG1L+c
8T9QvBH+k9nvTbCf5jxsVrwF8Z2431tRTwHPw4fox2byNvBWntePEM/E87od
fIS8A/rLyDuVfRf6eZP6H0N/HO+L3dJvzmceuJT2Pcq+V9k/QfyxtO/DfhTR
vh/1RpUJf6r4APyP3RH+DPadvG8+V/wF+uvG/uSjnmTWd1Dxl/C/Qy5APAvz
OwT/+cz/MOrz4nn7CvZCzk+h4q/BbpyPIsXfKP4W+zOD8/Yd8nnIeTmCfpaQ
v1d8VPEPWG+7n35U/BPYzHg/4/5axfenY8gvoaXwL4qPgw/wef0r+nOYer9B
L4r5/K74BPxDeb+dxH6msf9/IL8b3J9i8GPu7ynE9+Y8/wn7RM7DX4pPKz4j
zz+u/xv9X8vn01nF/4BHkM8pPg/u9Ui4RPEFxRflfLD+S8gnlfN1WfEVxf+i
X3P4fLmK/lbQfg3xotnv6+hXOvkG9AI5D/8hn4Pkm7A34v15C5zL+/+24lLF
dxA/hff/XcX3EO8y34/KcB7N/L4oV3wf9WVz3h6AL3B9BfrhxvgPsf4q41Ui
v2as5xH6YSZXKftj6FXzPFdDbyrP6xPFpkMGO9DfbHBSBt+XayiuafDGNOZr
B7uV+dYyuNCLevaKHbDem1xbcR2DvTNYT13oZ1O/HvQcmY+jYifUs5D51Yf+
dOo5Q6+K3ECxC9bbU6+hYleDTZe4f26KG4EXkBtDfw/ra4L6jvO+cUf+tvfp
poo9FHtCbxDPQzNwLM/Pc4q9kP8ZcnPF3uBt5BaKWxp8PojxWylurdjHYGsm
z2Mb6J1jvr6K/dAP2/uFv+K20Mvn+0Y79LcpuT36U837qQPqt/D5F6A4EHr+
vI87gr14X3dS3Bn5LGC8LoqDFAdjve150hX5zuF8dVPcHWzhebQoDkG/qsih
sI/mPPVQ9jDkc4L2cMURiq3oj+39tifsOTw/vXB+Yjj/kYp7o/93Oe99FPeF
fort+x/5x/N7Mxr+88j9ED+M/x/przgGevsbCA8Ab+f39UDFgzCfFq6PVTwY
/YuhXhzq22L7/of/dNv3P/y3s/5hioeDg+gfr3gE5mMw938k2Mz+j0I/grmf
o5HPbM5XAuobSk5U9jFYX8rn+1j0z5PvD+Owfi/fT5OwHytKhccrTkb+Hny/
SVE8Af6+1EtFvCa3hCciXtZNfv+D25LT0F/f6/z+VzwZ9a2m/hRwyl1+/yv7
NGVPh95Mcgb6vfTp86TocnHHkKfsn5hTVO5XGvE/SXcX1g==
     "]], LineBox[CompressedData["
1:eJxd1llQjlEYB/CvfU+UpUi5aGi64YKbLoqbhhk3TeMCEcY044IRSYkSIUtl
qwhlyVIp2UK+pNKKImu0WpLiQ/su7//8XTzNyPzmOec5z3nOOe80a+0m//XG
Op0ud/zfv/8ftmc5V27W+3quTCjumfPLR/fvJ0TvO/472txKeYvmoHVjBngr
vGhAOVR4G+anDSqHwfN0Kt92zenedLhwhOaiKHoH4il0pObmEnon8tuYKO8S
jtKsK+b4aNhjVNW3W7OvMR0jvAf1rKD3wk1GKl8s1uui9wnvx/gAY+UDKh/r
ixM+iP1toA/BjZx/GPm92N8j8HL2Px5e0KucIJyo2X0mxx9FfwtMVf5jwsfh
pf1q/Anhk8jfwXqS4CD2Oxn9dGc/UuA6+hTyzeb+TgunIl82fUb4LMaXmimf
Q7/iuH6acDrua+2Iqvc84oH0BcSLh5UvIr/XkPIlEc/AfEfOvyx8Rfgq7MB6
rgln4j740VnYbwadLXwd/ZzL95kjnIv8n7j+DbiM/ctDvmXs303hW3gvsbwv
t7H/mj7lOxiv71a+K5wPF/K+3MP8Ea5/X/gB7mcu91eA+Eb6IWxF6+EW7rdQ
xB/h/Fx5XkXoTwjv62OsV839FWO/YXQJzsOZLhXxJ4h78H6UwZF0OcZH8/tR
IVyJ/jiw/irU08r6q5FvId/LU+FnmB/O8c+Fa2APuhb9saVfoJ5VrOelcB3m
V3C9V+jffN6P18jXz+/VG+G3GG/g/HfC73E+dvze1At/wPhUjv+IeuLpBuFG
4Sa1f3PlZuEWvIdgnler8CeMD+L9+Yz6BukvOK/V7OdX7D+J67dh/hL24xv6
28d4u/B3zLdjvg7hTngr/QPzz3D+T/QrnzaI+C8R/437lMz39wfxLLoL8/NZ
f7eI98CWrKcX+3Xm96YP9fqzX/3CA8hfxfs2iPltvF9DqM/NXnlYxEdgT3pU
eAz5U3neukLNoa7KRsLGmoNirJVNEK+1UDbVHJ1Jm2n2TWR+cxG3QPwJ/56y
RP5h5rfS3Oxjo2wNu9kq2wjbai6yo+1QXzjz2QtP0Ow+xPUdUJ+e72si6vn/
98wkjO/k98hR2AnrB/K8JiMewPcyRXO6Gb+vU1H/mh7laRjvRztj/fZOZReM
r61Xno58rvQMzC8tV3ZF3KZMeSbckGfwcfGeGrx43Dl+LRFOOQafv9lw0wo=

     "]], 
    LineBox[{{7738.144420702451, 0.99}, {7739., 0.9987683892250061}, {
     7739.864615469324, 1.01}}], 
    LineBox[{{7780.067370067961, 1.01}, {7781., 1.0077260732650757`}, {7782., 
     1.003340244293213}, {7783., 0.9965677857398987}, {7784., 
     0.9915966987609863}, {7784.602075832154, 0.99}}], 
    LineBox[{{7793.499558925294, 0.99}, {7794., 0.9909914135932922}, {7795., 
     0.9909914135932922}, {7795.361614018306, 0.99}}], 
    LineBox[{{7800.298498942366, 0.99}, {7801., 0.993202269077301}, {7802., 
     0.9938223958015442}, {7803., 0.993202269077301}, {7804., 
     0.9922780394554138}, {7804.511402574464, 0.99}}], 
    LineBox[{{7836.327255790552, 0.99}, {7837., 1.000839114189148}, {
     7837.596657349607, 1.01}}], 
    LineBox[{{7900.358435103388, 1.01}, {7901., 1.003697395324707}, {
     7901.877818709653, 0.99}}], 
    LineBox[{{7913.47648754402, 0.99}, {7914., 0.991913914680481}, {7915., 
     0.9976035952568054}, {7916., 1.0034695863723755`}, {7917., 
     1.006201148033142}, {7918., 1.008083701133728}, {7919., 
     1.0096217393875122`}, {7919.1030020125945`, 1.01}}], 
    LineBox[{{7932.988807752423, 1.01}, {7933., 1.0099146366119385`}, {7934., 
     1.0099146366119385`}, {7934.012576707589, 1.01}}], 
    LineBox[CompressedData["
1:eJxd1mlwjmcUBuBPQlaRxF6URMiCWttSWz6xpGqNttYgiTVVQkSjEUQr1lhL
7SKEtloR+1KERGIbzBjL+CdTtH86wcggkmp897n/3GYw15znOec8y/u+X3BC
0ogpbg6H42b13/f/+4492/+Zo8AZEbuusDz8WaTj/Z8aBc7qfy9GhJnd4IYt
zO7imi5nOILNtcQeLjtyA82eLjsz/cxeLj9a4m32hhO8zD5iX+Tz8DDXFvvB
J2ub64j9XQ6KowPEgS7HZdN1xfWwvp0B5vrwBl9zA5f3bGI/DcWNxI2Rv8Td
/IG4ibgpPIHzm+E87tcyfyhujvWl1DS3EAehn0HMFyxuiXylzBciboV8Mzm+
Nc7Ls445FOedX9ccJg7H+Vzg+AjEO/J+tEH+DOZvK24n/gju6mluj/Wk83w6
iDuKO6G+k/M7i7ug33Su/2PxJ+JPsR8D3Mxdxd2wn7O4H5+Ju4t7wAnM31Pc
S9wb67tTwxwpduI++T8vg/uIo5Cv6StzX8w/w/Pqh/tfQffH+v3Z7wBxNMaH
/Wf5Pke9pS/MA8VfoF75G/MgxJN5PwaLhyB/eZWNH4r9nvrWPAznGf7aPFzi
MYj35PwR4i9Rr7jC/JX4a9TPemceKR6F9aRy/Gjc11H0GImPRX9VrD9OHIv6
wex/vHgCxrenJ4rj4JxKc7w4Af2nOmx/JyH/LXqyeArOewHXOxXryeJ5T5P4
dHge5yeKv0H+2+x3BpxDfyueiXol7H8WXMR8SRifz/fpbInPkXgy+kni8zJX
nIL9ecH588Tf4XxXcHwqvJ+eL/Hv8bzF0GniBegvhO+PdPgln/eFEl+E/Inc
/8XiDNzvQOZfIv4B9fdxP37E+lcz/1Lcl2jGMyW+DPWO87yXw/H0ComvxP55
cf9WiVdjvDfHZ6HeQ573GvFazI/m87JOvF68AevZTm/EfpTRP4k3YXwU+9ss
/lm8BfMPsP+tiAcwvk3i27Fed74PdiDux/fhTvEueDfXv1ucjft+ivn2IH86
nSPei/lFvA/74L/4vc3F/sXR+yV+APXe8Pv5C+7TO35vf8X6Y/j+/k18EPOP
cfzv8GMf8x/odxd/zxzC/Z/M/vNQL7fcfFicj3wL+fwcQf+V/L16VHwM40P4
e/S4+AT6Wc7fsycRj+V6TsGt+L08LT6D/vvxe3tW/Cf2J4j1zonPY/w93p8L
4gLxRdSv+Nd8SVwIH3lqLsL+Vf1tviwuFpfAxfQV7GfoA/NV8TXxdTzPyQXm
G+j/yd2yyLZpB73+qXZedGla/byyyP8BVaIrtw==
     "]], 
    LineBox[{{8140.101128682629, 0.99}, {8141., 0.994350016117096}, {
     8141.824552705909, 0.99}}], 
    LineBox[{{8142.4122007804, 0.99}, {8143., 0.9913198947906494}, {
     8143.5877992196, 0.99}}], 
    LineBox[{{8144.4122007804, 0.99}, {8145., 0.9913198947906494}, {
     8145.68014497205, 0.99}}], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQAGIQ3Sumejj20n6Hde4Pq0TWvbdnAIHL+x2A5IMH26D8
K2D+Afv1UP5VMD9BbhOUfw2Nfx3Md2jfCuXfAPMVzHdB+Tch8r/2QPm30Pi3
0fh3wPwGrkNQ/l2IeTmHofx7aPz7EPfcuATlP4C4n+c+lP8Qjf8IYt/Mb1D+
YzT+EzT+UzB/wUHhDxD+MzT+czCfYa0AlP8Cwa/3+D99NpCvGdN/6KvGB3sA
mmh3tw==
     "]]}, 
   {RGBColor[1, 0, 0], LineBox[CompressedData["
1:eJxTTMoPSmViYGBQAGIQfXVxga0Xp62DZkz/oa8aH+wZwMDOAUg06CrD+PYg
PsNncRjfAcQ/UCYM5TeA+Q+kuGDyjiD+AhF2mDyY7/CbASbvhMpvAPMbHv95
D5V3RpMH8xnW/4XJu4DtE2CEyYP5Cmb/YPKuYPMa4fpd0eTdQPyESri8G5q8
O9j8CLg8mK8gB5f3QOU3gPkJbb9g8p5g9/p/hcmD+QtmvYXJe4H1n34Kkwfz
Dxy8A5P3BvOtLsPkwXyG46dg8j5gvtchmDyYvyB8N0zeF+x+pq0weQhffd17
+0J95h1zGn0d1rk/rBIB8gFidnRC
     "]], LineBox[CompressedData["
1:eJxd2nuMnFUZBvBTSmHLdaqELqHRg6AuaHCswSzeekQaNlzMICCFbvG0QLuA
pWNpYUuRHi6FrRgdIOKGgDmK4oKhGaOJK1b5AmiLAo6CZFMofMViF4F0VC5b
KK30efd9yTz9Y5tfzv32fuebmaMWLfvaxfs453713p+9/6+79eErXqieHdaf
svXqw9bvmOP2/gtnh/f+lmc0J53g/KENky4kfcbGSbtz4Nef0vKw+/cWLQ+H
R7Zpedgv3q7lvw5vUQc4bX1Fy8PujB1aHg73/0/Ln4v8s9/S8nD48h4tL+lz
92lPlof9WdMm7eah/t/uN+kAhzn7TzqRC9hfqnbnoX43XcvDZe0ALU8uyO58
lH9CHcgJzlMP1PJwvF3t5iP/tIO0PDmRC9idYuX7MZ67rH043Gbtw+XR1n84
T7H+L0B9/7Txw2l1l5aH46ds/mC/SufbXYDyr+6r5cmJXJDdN6g8XO629Yfj
He/q/oHTC7t0/0TkP+KdSXtyIEdyImc4fXKntgcXV05MuiS7hZiPQd2/Hg5n
2H4mRzgdpeUTOcPFqre1fbjcpfNRkt2iTns4nK3nJZAjOcF+xtRJZ9idqy7E
1+p6l9LeuJ2fC+FXNN2LX9T9E8iRnMgZdqXuxwL2Cw7W9uHcc4i2fxHm7/lD
tX1ygIsfVLR92P9anciZ8hdwWKbtlVL/A9o/dzH64238cJxu8Qj2++n+jeRE
znDaslvXX9JLp+1Le+st/i3utCcH8YO2/uREznDYaOtPLsW/s/O/BOM92ca/
pDN/oPRITrC/0vYfuYDz0xofSkp3A6hvl/bfw2mDzleAw2qbf3KCy//o+cnk
QrzZ5l/Kf2eKtn8J2rtP7WF3jZ0/ciQnuHhey2c4zrX1l/oXvK7nn+wu7bSH
iylvaPyB3U51hP1ujUeJnOHcVheUXsJxpcYndxnS11v8Fd+g8xfg+KQ6UnqC
03Kd30wu4PC8zT+lu2/Cn7b1h+PjNv+SPlX3S4SL2bb/yBnOQ+pC0ldY/CO7
pZ325AC7zbp/Ixxm6XonyX+yjZ9ckEs4zbL4fznm8zjbf7BbZuOH00m2/8iJ
nMkFXL6rz9uS7JZ12sN+ue7fIOnR1h92z+p4EhxPtP1PLsglnKba+at3ugLn
6Vq/p/Qq7L+oDrB7S9enRo7kutT3I7vfwPFJna+G5D/axkNukgupb4m6Jek7
bLzkNtl9C+1fa+Mne7jYqfNRFb9p8VHy362uwWGhxUu4/JPeh+rkJD5G179B
znC+UONDk1xIe8dpPGmRS3Ib9vva+V/e6QrZw+G/uh+r5ECuwW6plo9SX1Xn
s05O5AYcX7LzTG7C6V67z5Jb5BIuFmv/2nDerHZXoP2P6fmqkL24pa6Sg3ix
7t8aXJxu8RKON6nr4g/a/ofTOeoGOZObcB6y57v4EBu/tP+yxRu4vEfvx22y
W4H8+2j5Chxvs3hE6VVyoPw1cpT8P9H8dbj8qb0/kBtS/mJ7npKb5AL2n9H9
0SKX5DYcPmD7fyXSX9P+VsieXIXzbtv/lF6j9Ai7XZpeXynzp+mJ0hvkDIdb
1E1yQW5J/edo/aX0b5Htf7K7Ev6jukL2cHGMxT9yINfgdIidf3KdnODSyjfI
Gc4bLP7D7vcW/8ktKf+ExX84rtPz2Sa7qzpdgfMui//iZ+z5Rw7kGjnCxWKL
f+QkvtDin5R/Rec/k5uS/3pbf3ILTnfZ+pPbMt7j9Ty6wb32a+z8i09Qe3KV
HMg1chQvtf1PTnB5lvavAYe5tv7kJrmQ8jdqPG6RSzgfp26T3Srkt/mowPl2
jY+eXCUH2P9dn+c1uHhaHaX+DRrf6nA8096fJP+RNn44RBs/pTelvYU2fnKL
XIqnWfwju6v32h1o55/syVU4zrD4B5czbP+TI5zsPlCX8ofb/of9D23/S/lX
bfzimfq8a5ILyt8SD9j4yW2yW435ft3uP3Cy9wsPl/12/slBvMLGL77Vxk/p
ddidZfEPjsss/lF6JjfF768/uUUuZXx/sfHD/ii7/17TmV4he3JV/AuL/7A7
Vc9TjRzhYrutPznBcY2tP5zvsPs/uUkuxL+08Uv9D1j8k/SGxT+y+3Zn/gpc
Btv/cDjI7n9w/Lnd/+C008ZPjpL/bXVd6jvBxg/nY238Uv54Gz+5SfkL6e95
Nn7xmI1f8l9g939p/zdv6viv7XSF7GF3uMazKjnA/lSLf3C+TtuLUt92dV3y
99vnF1LfP2z8cCpt/OIb9fncJBfkltR3vu1/6c8ptv+lP5da/F/T6QrsPmz3
f3JV8n/U9j+5Ro5wcYftf3KC0x/s/ZecJf8zNn44X2Xxj9yS/l6u+UtJn2X3
HzhW7P6TUP91Ot9dcJ5p78NwtPPcDaeP2/kg95CrUv/P1L2w22jPD0lfovX3
weFmO0/Sn3U6X/Mk/99sfskD5DrsF6kHZTyP2f6T/l6gz+MhaX+d3ccl/0nq
YUnfpvs5k0cof1PGu1o9Ku19xd5fyZsof0vSp6nHyCV5XNq353N7cn3VE+JZ
9vy7rtNd5AqcD9b+dcPur/Z+BId+dQ+cbtL7TpXcK/U9o/MVKL1P6n/Q7pOw
P037P0/8or1fiZfqeg7A5S22/lLfW7b+4n3t/iG+SM/DELkh43tK8w+Ts7T/
XfWItD/b4jV5VMb7qD2/4fgJ9SZyS9rbpuMbk/49a/db8jjlb0v7z6knpP6P
2Ppfj/702vrDxXxbf3I3HOzzL0/uIVel/Eptv5ccyH2wu9PiqaTb543zyJE8
IOOZaesPx+/pfhqE/d32/kEeIjfIw1L/cns/l/E+ph6R9g61z+vg/K56lFyI
D7TzT25J+4epx6T+z9nzXdrfpR6X+XjAPu+U+rapJ6S+Uy3+37DX7gl1F7lC
7iZ7uBhR94hfsvuy+Bp1L5y22vNT6jtR3Qf7z9r6k+fBcX+7X8F5uo5/QNqz
76fqlD5ITtL+l9RD0j/7fqUh7Vfs/JMzeQQu77f3NTiMqEelvXss/kt/9uj+
2STtr7D4Tx4jl9LeZt1P4+S2eL62NyHzc5fdf27snN8ucgVOX7DzD4dg70dw
Yfe1HnKV3Cvl3/9+idwH53tt/eG4ytaf0iN5AC6fs/Mv9W+z+E9OlH9Ixm/v
Ow1Jf0Q9LOO5z97PKH2Eyjdl/uz7mlFyQd4k4/2xxX/p7+nqMWn/UTv/0v4W
Xd9xcps8IfVvt/eftZi/jbofuuDSPi+twKHf1l/Srb+e0nvIVcrfSw5wMdXW
n1yT/l1i6w+nPXb+yQPkutR3rq0/OcFxyNaf3JD89nnMMDmTR6S/U2z9yaPk
gryJ3JL5OsLWX9pba89/me+tFv+l/EN2/5P5GLT7H9ndhPyXqbvIFbhYoPGk
G05r9P7myT1wXGjvi7DvV/fCzhwovY9ck/rO1PbnweUS+35B2rf5H5D6X7Pz
L/WdpvFnkJzEX9Xf4wyRG+Rhqf9f9nsL8gi5KfO3Vn9PMirpw+qCvInckvWo
qMfE09QleZzyt8kTcLjbfj92MxzVXeQKuRt2a9UeLq2+HnKV3Avnh+z3LXCy
zzP6yDU4vmPnX+rLFv+lfzs1vg1I+XH7vAEurtDPawfJScbzuH7eMURuSP3d
uh+HyZk8Ij5S3SSPwn6H/T5OPFv7u0nyb7Xvc8lj0r8/2/mX8vN1fsdlvuz7
9rbM9+f194oTMj8v2+8XhzrdBcc7Z7bn7HnjoXvXHjAUju3//sNv9LTn/B9b
NBEd
     "]], LineBox[CompressedData["
1:eJxd239wpPMdB/DnKkhPnA3BDnFdBGkv3CJI2wwPMr0g1e25tmukZ4fQGKGr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     "]], LineBox[CompressedData["
1:eJxd2X9M1GUcB/CviEqIyRokJepptHCjRg0bFdNrkWOBGyZLVsxuDpM1puck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     "]], LineBox[CompressedData["
1:eJxd3HFUllWeB/A3dImUlBgiU4d5M2IYch0OQyyHJUIiliGXJYYYdD0OssQa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     "]], LineBox[CompressedData["
1:eJxd239U1eUdB/AbMnJIZGhkSHTlmKmROTNyzpBjpI4YEVOHzuweZswcKoc8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     "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQnbhw3qHfbBscNGP6D33V+GDPAALsGxyApEIojM8B
5i8QZ4PyOcF8h0JGKJ8Lwg+A8bnB/AeqMD4PRD7r+3sInxeNzwfhb/8K5fOD
+QydX6B8ATS+IJif0ALTL4TGF0bji6DxRSHua4LxxSD2t3yG8sUh/EcfoXwJ
MP/AWRhfEhI+0R+gfCk0vjSaehmI/Xkw98tC5J/A/CsH0f/wJ5QvD3Ff/i8o
XwHCZ4KFvyLEfWnsUL4SRP9p/g/22hsMEl8oIeITANCYe7A=
     "]], LineBox[CompressedData["
1:eJxd1DtMk1EUB/APhQblIcG4y1IoiFJQERVa3g9RoLx8FKwgCqIU5FEQgQKJ
CwMLE4sMuhgGOiCwkZKAG2wshDCxMAgDiUp49fuff0xOk7b55dx77rnnft9N
aPK6Wi4YhtFw/g39V6x+C/+bNOe0uSeDh0n7DiP0sc05z3+X96ziZNPOjThx
iumZhSviGxifSqea3im9LL6J+fZL4lsY/8UiTlNxu5qfjvhotDjDtHEQI76N
+I9Y8R3lu8qZyveUs0z718PF901f94WJH2D/84b4Ierxnf6Gs5VzlB3KTuVc
7P8nnQfv0PmmPddYT4FyIfYzzfqKlIuRr4j5SnAei8fiUuyv40hcpvxIuRzz
bZz/GP1z00/QP/+JuAL1WOhKFa9Sdqnx1co12M8016vF+lF0HeK//onrkT9A
P0X/vtPPkH/tj/i58gtlN/LHsh8NyD9MN8JH9Ev0z836Pcg3Qb9C/Xk8nybl
ZqyXxvN+jecnGCVugRf5frxB/lm+v29VvFXNb0M/rBHid6jXyvrald8j/zb7
/UHFO1BvgPaiH1+5n06Mv8jnswvxKfqjcrdyD/L7ma8X+1nhen3o3ynr8+F5
3aX7lQfU+E9yvsw3iPga1/sMJ7KeIdSXw/ttGP3cokeQbzNS7Ef/lnjfjSLu
jRePYT+ZV8XjiIfu543ZhHnL+P/7+wxArHhE
     "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQHXjv6d1l3RscNGP6D33V+GDPAAI9GxyA5IGJklB+
L5jfkMYD5feB+Q/2MUP5/WB+gi8jlD8BIv/z33sIfyKYr7DrN5Q/CWJ+Gow/
GaLe7yeUPwXMd3jyA8qfisafBtEfAuNPh8hrfoPyZ0DMe/AVyp8J4V+D8WdB
3JMC48+GmJfyBcqfAzHvwicofy6YzzD9I5Q/D40/H42/AKL/zmcofyFEfgLM
v4sg4VnNBA2vxRD1NVxQ/hKI+zy4ofylEPlroh/s33wv7l+6FBFfACk0hpg=

     "]], LineBox[CompressedData["
1:eJxd1llQjWEcBvBTSsquItmOLJVSIiHSoRKRSOGCoZpuMYMMV7lsmOHClZ3B
BcWJZCd79qVk59i1J8pSSX3P9zTjaaaa37zv+9/e851zhqavTM50tlgs9rbf
9v8JGZnvkg7bbYFLtlxpCKiLtrT/HLHb2v7ure5tOtfw8u1OpvPER+Fwi+lj
8EbaLvvzZf24nD9h2JHaWgsXwAdbTJ80XNTUbLoQ5+vpU7J+Ws6fwf5S+qxh
2yHmOyc+b9hST18QX5T9lwxbNzB+kfgy6itqMn1FfFV8zXB2Is9fR7ysv6Zv
oJ/19E1xsfiW+DbmE0rfEd8V30N+G30f9a5h/w8wnwPO5n0+xPlmF9OPsN/P
1fRjcYmcL4VP0k/EZeKn4mfod3Yn08/FL8Qv0V9H/lewC9dfy/ob9LePfovn
Zw3tQPytfP2/w32m0e/FHzCPdfRH8Sfz+WE9n1FPAf0F9TTRXzEPH86/XFwh
rkQ8b56vwuu7hfmrkX8HXSOuFdeJv4nr0b8zn//vcC5fTz/gFLpB3Cjnf6L+
CPoX+vPiffwW/xE3YX5vWV8z+m9kvBbUv5P+i/y+dCvu/wKfV0v+/3YyvDyI
dhZ3wn4f2kXsKu5suGgP7WbYEsbns4th2zbaHfsjWa8H4q2iuxq27qe7yXp3
Od8D6w7eR0/D2enM1wvrS+neiL+M7299xJ5iL9Tvzfdzb8TLoftivYz990P/
/sznI+6P+KtpX8x/F/sZgHgRvP+B4kGGHaXcP1g8BPFXcB5WzKuC9Q3F/irW
7ycehnpK6OGyPgL9ZDHeSNQ3mvn8Mf84OkAciPPBrHcU6s2hg8TBcCj7Hy0O
kf2hqCeEHoP8IcwfhvxRnP9YnE9jP+OwP4j9hovHiyPEExC/kp4IRzD+JOTr
uI9I3I+V9UzG/GvoKehnLvuNEk/F/lQ6WtZtuL9NnMc01ONBT4d3s94Y1LOW
jkV/iXwe4sQz8DzEcH+8nJ+J+BPY7yz0H0MnyP3NRrxCeg7O57CfRPQTyM+H
udgfy8+PJMRLcDM9D/MppudjfwmdLF6A+eXRKbKeKl6Iefi6m16E/PHdTC9G
/eWeddGbHdkZJW3m991/2lfDGA==
     "]], LineBox[CompressedData["
1:eJxd2XmYjvUex/FnhiGjUNmyZJDGZElUzjk6zCFtx0k4dXSQCWPNUtNmH9ll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     "]], LineBox[CompressedData["
1:eJxd12lQjlEYBuBP+MeMYZrxA2P5QX6IhhAqQshaslPZQ7JnCdmFNkt2spNd
thSFQmTfylayZEkiJTSo7z43M3cz9c0155zned7nnPf93uoND/QcZWOxWNLK
fss/69n7JJa2iHO1GxJxqahRgYul/McxzrXsb8zghsYtrQ6pX8O4ldUWr2rG
reE6VY2drHZ1r2Lcxurs2IrGbTFev4JxO9jRYuwsdrE6+dCfz7CruD3me9Md
UE+VX8ZuVvs2+WHcUdxJ3BnX70e7I77fT+Mu6EcY3RXX15z5usm4h4x3F/dA
/t/fjXti/RK6l9V1Hb4Z98b8oELjPujHxq/GnmIvcV+xN64v94txP8Qfwfj9
xQPQ32jWMxDjmfQgeGGR8WDxEPFQ8TDUl8h4PmJf5HdjPX7oVwN6uHgEbE+P
FI+CQ+jRyJdPj0G+HJ6HsbAH99cf859xP8ehn7alxuPFE+BQOkA8UeYH4rxE
Mv4k8WTxFNTj9dt4Ks5PDD0N/a7I+2s68tW2MZ6Bfuyhg3C9afRM5PPg/TwL
+Xzp2fATeg7WZ1YyDhbPFc9DPUn0fHGIeAHclF4oXoR6e1Y2Xoz6jrG+Jci/
hte3FPPt+Hxahn4tZr+Wi0PFKxDPm+tXop+D6FWY/5AOw/PmMfOHiyPEkVjv
T0chXzzjrRavEa+Fq9PrEL8RHY34DvR6Gd8g3ijeJOs34/p30FuQv5jeKt4m
3o7ze4uOEe8Q78T6QHoX8mfQu8V7cB6S6L1wLPdzn4zvhx9x/ADcmeOx4oOo
bwp9SMYPy/gRnL9g+ijGl9PH0N9I7v9x8QlxnPik+BT6NZQ+jXxj6DPis6jf
iY5HPxNY3zlxgjgR8XLp84hXk/Eu4P5tTCfBo3m/Josvii+JL6OfWYyXgvP6
z6nIH0RfQb029FXMT2W918Rp4uviG4gXz/OSDrekb6Ifi/i8vyW+Lb6D/Yul
74rvie9j/b4S4wfIf7fY+KH4kfgx1ofz+zlDnIl+e3L+E/FT8TPxc/EL5D/M
+FnYvyi+r2SLX2K9HZ0jfoX9SKFfY7+b8fv9jfitOBfx0rn+nfi9+IP4I/Yj
o8A4T/xJnI96G9KfZbwA/c/h+9oX8Vf4DusvRD+P8v3pm7gI9VZjv4vxPMjn
+8139DuA57lE/AP5avH79af4l7gU+ZxtC1xS8jJte5T+///jLyhhRNc=
     "]], LineBox[CompressedData["
1:eJxd2Xucz1Uex/HfDGZym9xS7jNJQ66hjF3MuOTW5JqhxnUiEblEFyNG5BqD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     "]], LineBox[CompressedData["
1:eJxd13lQVlUYx/ErqBVaqaUhGkKZYGWSZvha5ptWLm1GSkWWCEmbgWVZmiVq
li0mpVmZBYpkSWKWWJQlMtMfNtPkf5pLvQJKkYAVqAhIcL/nx4wPMwzzmeee
8yznLhqblpU0M8zzvGNtv+1/t0Y2DZu6tzg4eNqKsob442O89p99xcH2P4d7
OP/mO7Sts/N+XO05H/CdV9VShw+y/oB8iHi6/Lvv7Oom5z98ByvlEPsvkw9z
ffJp53J8sNG5wnfMHrmS/CUnnY+Qf1GD81GcW+9cRf5x8p/GfxlXs/5n7fe3
79TACedj1JMp1/guHaL6aukvTf3V4UTN57jxP8b/st8uzeM/43ry95YbjE8Y
nzQ+xXz7q95G4htPOZ8m32q5ybjZrG8h3rfZ+QzzLFM/rcRDsrf9bHcyDvMd
k9HqHG7c2bgLLpK7+s5L0P17jomfa+LnGUf4zq48467vRn2FcncTP9/4At+p
PZXvQt+hodq/B/mGd3LuyfXRYc69iMfLFxlfbNyb9Wu1fx/qmSdfgnernkj6
mSX3ZX1I9UdRb63ul36+gxVyf5wvX2ri0cYDyDdIz0OMm4fOO5b8R+XLuH6y
6rucfn9RPwNZH6b5XWE8yDgO79b6ePIVyoPJlyFf6duLkK8i3qJ6rqa/ItU7
xPga46HU31XrE/BE+VrOp0L5hnG/tqr+4dSTpvO+jv2XyyPwDvl640T2z5dH
mvUB5jFQHkU8Qr6BegKq50bqSZBHEw+p/pvYL1UeYxxk/5/km836sZxXifKP
Y/7N8i30UxfufCvxoL5ftxmPN55A/Uu130TO41f1M4n8G+TbWT9fvoPrJ8h3
Un+VzvMurg/oebrbeLLxPfQTp/6T2D9Rvpd5TZKnGE+ln3DVk2x8n/H9nEeT
1j9Avv1yCvUtlB+kviTVO834IeOH3fMjTzdOdfPS+2CGcZpxOvXO0HwfMe+D
mZxXehfnDBzVy/lR48eMH2f/5m7OT9D/Ht1fT7r3v+Y3i/WblP8p1q+RM+m3
XN/DLOaTLM/m/FrV39P0W6f35TN4izyH60fre/us8XPm+rnUl6V8z3N9gt5H
L1BfpuY5z3g+rtF5vWi8gH7Gyy8xnynK9zL5Nqu/hcQrVV82+82WFxkvZv+d
+vfGEuNXcJG81MRfxaWaz2vU0/H9WcZ8YlXv68ZvUM8AzetN47eMlxu/jQPy
CuMc5tFxPu+Qv7v8romvNPFVxu9x//XR/FYbv2/8AfMI1zw+xJ7Ocw33k6f7
+SPjteQfKX9MvON99ImJ5xKv1f2Vx/O7V/nWEU+R19N/ivrL5/oa1buB8y2Q
C4w/Zb94eaPxZ8wjUufxOfunq95NnFeBvg+FzGe6vh9fGG82LsLR8hb6ydX7
40viR9TvVurJVj1fGX9NfTnyNvqNlYuJR8nbqT9O8/uGfDnq/1vmsU/PS4nx
d8bfs1+Z9tvBfmNV/w/U23F+PxrvxI1yKfuP0Lx30U9J23wOlZY31rdZ/1/9
H0Vn3q4=
     "]], 
    LineBox[{{5831.873420397817, 1.01}, {5832., 1.009023666381836}, {5833., 
     1.0017606019973755`}, {5834., 1.0017606019973755`}, {5835., 
     1.0017606019973755`}, {5836., 1.0054136514663696`}, {5836.13143169481, 
     1.01}}], LineBox[CompressedData["
1:eJxd1llQzVEcB/B/t7pJe6IILSolJVuhuDdLKbKU7RItXNmLeDGTemN4yIwX
jId4sYwXLzFjmMZDPVijkoQWFEUp7Zv6f8/Xw6+Zaj7zO+f8lnNuU0B2bqrV
oGnanfHvid++r25Yql+XmsPSi5/1hHaatImvN6Xm8Z9FQe7KlbrLomyV3+r2
D6TfwamDHXCVbvPZfuVqeKhXuUb4vXAtzivoU/6gu6FwRLkO9VX5qPwfheuF
P2G/s53yZ8THeN4X3SW1dIPuzDH206hb86CbUJ8b+2sW/orzm9nPN+HvqOce
3SLcKvxD+Cfuo43zacP82oeU2xG/P6z8S/g3+iseU+5A/Wmjyp3Cf4S7MC8j
59WN+lKY/69wj3Av3Md59eG8i3S/iA8ID4r1Q7B1QHkY866gR9BvOe9vFP08
p8ewvo71aQ/1fP/fh43usuuaej8GYVthO92agfO1FzYKO+jOvExP0m3uph11
l3jw/Mm6/SNpJ91FsbQz1hfQLsKu8F3aDfUkGpTdhT2EPTEfIz0F9d+0UfZC
fefoqdhvoaehv3bm98b6JtoH/ZynpyNfFj0D9T/ifHyR352eKTwL+Sx8v7OF
/VDfLd63P+IOjAeI9YG472ieP0c4SOVnvcE438q/lyHoN55/j+Ziv5dROVTE
w8T+eVifwPmHYz45rH8+9pfz8x4BP6Yjcd4DvvcFwlHCC4UXCS9GPRHMvwT9
dzG+VDharI9B/S84v2W4fxPntxz5/OyVVwjHCsfhvi7x/JV4LzXsfxXy36ZN
Im4Wjkc9Lbz/1ejHlfWtwXwr+L7XCq/D+jauT8D5wYwnYv1Ter2IJ6G/Ee5P
FvEN2J9EbxROQb9X6E3YX+igvBn1xTkpb0G+YXqriKeK/Wk4P4bvcRvmVch8
23EfK+kdwjuFdyFfCG3B+3jC/ncjnk/vEU4X3ot+svj52Yf6612VM1B/npty
JuKar3IW6qvwVM4W6/cLH4Cvsn4rzkugD6KfSr73HJxvog/h/pLpwyJ+RPio
8DHkc6SPC58QzsW8Gvm+84RPol4Xrj+FfBmcbz7u+wL7O43zwznvM/DL8fdS
3prnfW3c/H/zH9yHrZs=
     "]], LineBox[CompressedData["
1:eJxd2ndYl1UbB3DElQPLCeUISAUcpeIgFzgQFRVFceQiDXsxDSkHiiJOFHEg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     "]], LineBox[CompressedData["
1:eJxd2ntcz9cfB/CvQqmI5E6LzcgIDRtaGqO5j5n9mCwMM8Tc7+W2YabcL3PJ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     "]], LineBox[CompressedData["
1:eJxd2Xt8z9UfB/DvdxizzYa5s1ZZW5RLUa3FRpeREsXIwlgT6odmvzTCmqZE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     "]], 
    LineBox[{{7738.144420702451, 0.99}, {7739., 0.9987683892250061}, {
     7739.864615469324, 1.01}}], 
    LineBox[{{7780.067370067961, 1.01}, {7781., 1.0077260732650757`}, {7782., 
     1.003340244293213}, {7783., 0.9965677857398987}, {7784., 
     0.9915966987609863}, {7784.602075832154, 0.99}}], 
    LineBox[{{7795.499558925294, 0.99}, {7796., 0.9909914135932922}, {
     7796.421156631387, 0.99}}], 
    LineBox[{{7799.298498942366, 0.99}, {7800., 0.993202269077301}, {7801., 
     0.993202269077301}, {7802., 0.993202269077301}, {7803., 
     0.993202269077301}, {7804., 0.9922780394554138}, {7804.511402574464, 
     0.99}}], LineBox[{{7836.327255790552, 0.99}, {7837., 
     1.000839114189148}, {7837.596657349607, 1.01}}], 
    LineBox[{{7900.358435103388, 1.01}, {7901., 1.003697395324707}, {
     7901.877818709653, 0.99}}], 
    LineBox[{{7913.47648754402, 0.99}, {7914., 0.991913914680481}, {7915., 
     0.9976035952568054}, {7916., 1.0034695863723755`}, {7917., 
     1.006201148033142}, {7918., 1.008083701133728}, {7919., 
     1.0096217393875122`}, {7919.1030020125945`, 1.01}}], 
    LineBox[CompressedData["
1:eJxd1lVQVVEUBuArKIiN3YKogN3Y95qo2B2oiK0INgYqdnd3t2KLCSqCOWOM
8eKDjvXkoM4wjhgI91//y88MMN+sHWvtvc/Zxz8yptcoD4fD8Sz7N+d/yNvU
+3/+JbmCw9fdzQj65nTk/GQlubL/unbTjuQc3w4ONOcSe7gd7/A3e4pzo33J
SuY8brtaljZ7ue047Gv2RnxJQXNet98t8DH7wJF5zfnQ38vLnF/iBcQF3faL
KGAuJC7sdsQ+uojYV9oXlXgxcXGsx4b85hLI5zvrKen2/s3MvxRcgi6N8YbS
ZeA0T3NZcTms9+s85vLiCsh/Wm5zRYlXEvtJe3/E3zNeGfmGMb8AtJ9IVxFX
Rf3ehczVsH9JdKA4SByM81GX56M6xg/xNteA4zlfTXEtaV9bXAf1xHG/6orr
YX4X29dHfnFcjwbYj02cr6HEG6H+Dh7mxhIPkf5NMN9Vtm+K9Y8uam4mbg5H
crwW4pbiVqjvRS6zE/MN/5MOuyTeGv3L/bR4G3FbtL/G/WqH859Jtxd3EIfC
gf9svI4YL+OXuZO4szgM/TP+mruIu4q7YT9G/zZ3F/cQ9xT3wn6lZpp7Y/1a
cPw+2N+fdF9p30/cH/XE0gPEA8WD0N+f+QwWhyPf2vQQ8VBpP0ziEfABnofh
WL9Yh+1XpHiEeKR4FNZjTpaNN1o8RjxWPA71r+b5GI/8nzLfCeIo8UT0T2M9
0XAK84sRT0L/c3y/TkY+MXwepoinot4f7D9N4tPFM/D+WU7HimeKZ4lnw0fo
Ocg3gO+LOPFc8TycV1/2ny+Ox/jjuN4LJL4Q9azieItwXkK5XoslvkS8FONf
4v4uEy8XrxCvhH3oVeLVmC+Kz98a7E8ovRb7HUSvk/h66b8B9e2kN2I90ulN
iLfh/m9GPIzrt0XiW8Xb4CL0dvQ/ynp2iHeiXk++D3aJd4v3oN5Eeq94n3i/
+ID4IPJJ4Xk4hPWL4P11GPEP9BHxUYz3i/fpMdwnWbxvj4tPiE+i/0X6FPwx
n/k06t/D75czOP8jmX+C+Kz4HMaby/vyPBzA78kL4otwOL9PLmH+Zfzeuyy+
Iu0TxVel/TXEbzJ+HefFj/PfQP7teB/fhF/xvNyS9kkST8b4mV/NtyV+R+J3
sR9/v5hTxPfEqXAqnSa+j/NR7Y35gfih+BHy+/TS/BjP65Rk8xOsX+LzdGeU
M7r852wnhL6fXTwh3fkfwoA+kw==
     "]], 
    LineBox[{{8141.270493823094, 0.99}, {8142., 0.9913198947906494}, {
     8142.5877992196, 0.99}}], 
    LineBox[{{8143.4122007804, 0.99}, {8144., 0.9913198947906494}, {
     8144.68014497205, 0.99}}], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQBGIQ3Sumejj24n6Hde4Pq0TWvbdnAIFL+x2A5IMH26D8
y2D+Afv1UP4VMD9BbhOUfxWNfw3Md2jfCuVfR+PfAPMVzHdB+TfR+Lcg6n/t
gfJvg/kNXIeg/Dto/LsQ/TmHofx7EPfcuATl30fjP4D4h+c+lP8QzGcoeQfl
P4LIz3sL5T+GuGfmNyj/CcS+dMYPEP5TMH+BESeU/wxi3loBKP85RP6gMJT/
AqJ/mcIH+7y997ZHAPmaMf2Hvmp8sAcASMR5+w==
     "]]}, 
   {RGBColor[0, 1, 0], LineBox[CompressedData["
1:eJxTTMoPSmViYGBQAGIQfXVxga0Xp62DZkz/oa8aH+wZwMDOAUg06CrD+PYg
PsNncRjfAcQ/UCYM5TeA+Q+kuGDyjiD+AhF2mDyYf+AoI0zeCWyeDozfAOY/
EIDLO4P4Dr8ZYPJgfkMjjM/gAuIrmP17D5UH8xMq4fKuaPJg/oMIuLwbmjwa
n8EdzJeDy6PxGTzA/mGEy4P5CW2/YPKeYP/5f4XJg/kLZr2FyXuBzTv9FCYP
5h84eAcm7w3mW12GyYP5DMdPweR9wHyvQzB5MH9B+G6YvC/Yv0xbYfIQvvq6
9/aF+sw75jT6Oqxzf1glAuQDAFhococ=
     "]], LineBox[CompressedData["
1:eJxd2muMnFUZB/BT2soiF6eGpEsgegQ0SzU6lmAWvPTIJW24JIPcKm3xUKTd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     "]], LineBox[CompressedData["
1:eJxd239s3GUdB/DvoLADCrRY5ELKvEmB6oq7scIqNnBKdR0pWMfUIg1+AwWK
1NFJB00oeGDB21a2Y3Sj0w5OKHKBZhRpoJKGnK6QxnSx0QKHNnjGOk7WZTdX
3A26ITzve3+Svvlj5JXneT7Pr+/zfb7f575desvda287yfO8H57seZ//f8+b
1emZlljkK83b/vhRZe5q7/P/WmORz/6Nvnx+we3Omfi5BXc6J9JnFhx1Tr0Y
KDgmjsM/P6XgPmdvdFHBCefIl7yCk6jvtk8PwUNozxJ6RJyC7zlR8Dj89/mC
J1H/X+g0/NT/Cs7Av6Cz4pw4L/Y2LXTAOTR2tOAScdA5c4wOIf3TfMGVztFX
jxccFtc4RzazvxFxPdpzFsenEfFf5/g2If8+jr+P9vSexPl39qY5X+3iTsQL
Leb8I923+Xf2b7H5d07cfxrnX5wQJ8VD4hFxCvWF2Z5xtO/RUwuehNey/Wn0
/9yTC86Is+KcOA/v5nh5m51Xc7wDzv4pvN5KxEFnbznnKySuFIfFNajvA14P
EedQA12P/HOsrxH1v0I3iX1xK+I/Q7c7R/d+UnCnOCqOoT3nfVxwXNwnToiT
aP9mesg5cRbbM4L2XUanUH+prX/xpORPS3pGnBXnxHm0ZzHjeVtc/AH2PyAu
EQfFIXGls3eVrX9xjXPqbVv/cDHXdz3ireX6bhQ3iX1xq7hd3OmcqKKjaF+S
9ceQvoOOo/wjdJ84IU6Kh8QjqG87nRKPo/4w2zeJ8bmCTsM30xlxVpwT58Ve
z0IHxCXwLNsXdA59SIeQ/i+60jnzKB0W18BTdETK10v8Rqm/SdJ9Kd8q8dul
/k6Uv4+OSv6YpMedI4t4vfY5+6t5PSfESfGQeATtHaZTEn8cfo3340nnaCvb
kxZn4AfprDiH/nTTedSfoL3HnHfa/D+2ML1EHJT8IXGlOCyucc68QUecQ4fp
emd/JfenRufoFXQT4l1J++JW58Qk3S7uFEfRnu/TMXFc6u9zjpyw5z+0dy+d
FA85e0P0iDiF+FvocdR/h61/SU+LMxIvK/XnxHmU/8jW/1Y3fi/b/ItLti6s
L7h1YftCSD9g6x8e5/UbdvYesvu/c+IS2/9RXy/3o3rkn+V+0ujsP0s3If+t
tI/2THK/bUX5a+l25F/O59NOcVQcE8fFfejfIjqB+vbxeTgpHhKPiFPicYxP
P+NPov5SOi35M+KsOCfl8xLf2+b6c5gOOEc+oUucMx3HuP/Dqzi+IeSvsfXv
nNrF9RJ29m7m822Ns7+VjiD9Rj4P16P8hmKuf7TvkbO5/sW+uFXcLu4UR1H/
Rr4PxtC/9WxP3Dn0ANvbh/a9WcT1j/5n2d8k/G/b/1F+ntfriHPiuxy/FPI/
w/EdF0+K0+KMOCvOifNiL77QReKAc2obXezs7bHrQ1wGP23vi87+Ab5flotD
4gpxJepfyXhV4rBz9DS2rxp+l65Bf47TtSh/Psc/4hy6jq5zzvzO7keI9xrv
Vw0of6q9n8IPc77XiZvEzWjPDfb8Im4Rt4rbxO3iDnGnuEscRfvs/bpbHBP3
wEu53uPiXoznCroP83kt3Y/x/abtn5J/QJwUD0r5IfhGehj9i9l+i/mz549R
pL9l+694DPGmbT8WT4gnxVMSL436B+hpjMcTtn+LZ8RZrKdH6VlxTjwn5fMY
v1/R89Ie7/HPnRqhi8QBcfHjC+OVOHv30GXiIMof4/VT7uzn7f3BOXM9XYHy
37HnCfh0ugrld9nzhbha8teIa8URcZ1z4mx7H3GOXEo3oL6N9n6C9r9i6x/l
37X1L24W++IWidcq9bUh/2b2tx3+Dd8fOpyju+nOQjrvX12Ib+8jUXE3XEfH
xD2SPy7xe8V9kr9fnBAPiJOIF6AHcf1dyfvzEPJfRA/Dedtvkf91ehTjE7f9
VzwmHhdPiCelPVO43h9je9O4fi7ifEyLM+IZcVY8K86hPTeyvjl4P9uTR/t2
0POwjY+3faGLxAFx8faF8UqcU8/RZeKgc6SE12u5OCSuEFeKqxD/HDtfFFeL
a5wTNSxfK444eyvpOvgaO4+W9AZxo3iduEncLPad/X+yvhaM71a6VdrThv7l
Od/tSL+O492B8kftvFPcJY6Ku8UxcQ/au9TWP8Zzma1/+BU7L0F7f8r+9jtH
T7bzM8RfSQ9gvn9k52niQZRP2fM1/DY9jPoO2Xkb4v/M9n/kv8/2f+fMJtv/
UZ+9/46jv1/n8/0E4q/lefok4v+E7wNTKP86nUZ9+3l+P436vsjz/Yx4RpzF
eIbpWcx3NZ0Tz4nzaO+T9Dzas572nliYXiQOiIvFJc6Z7Xw/KoP38PeToLN/
O9+nyuFFZ3D/d45upiuQnqArxVWIf4wOi6udE7v4/ljj7C3m+12tOIL6R/k+
WId4q0q4/4sbxI3idWjvnaXc/51Dq77A/R8+Svtoz1QZ93/Eq+Lvla3iNnG7
uEPcKfV1OUc2nsPnf6Q3sb3dSD/B/sQwnk0cnx7M/xGObxw+g+Pfi/qzp/P5
H+MxSPfD7/D6SKD/7/P6GUD5o1w/SbTnJq63QczXO1yPQ/BZ9DDau8ye/9G+
u3g/GkV/b6ZTqL+U968xxNvH+904yl/D980J8aR4CuWvoNPiaXEG9S+hZyQ9
i/RN9Kw4V7je6TmMVz+dF8+LvV5X3uP7e5Gzv9rOg5y95+li5+jH9v4vLnOO
VPH5KIj4azie5ci/yX4/Qn33c/+qQPk3bP9H+U9s/xeHxdXwanv+R7yd9vwv
6RFxnbheyjeIG8XrnDP2vtqE/u6hm5Hfzrt959BSXt8tGI/DdKtz6mmuhzZx
u7hD3In6BugucVTcjfLTdEzcg/HZwP0sLum94j7J3w8/QCfEA+KkeFDiDWG8
/8z6huFejt8Ixv9e3h9GUf4l2/+Rfpj3gzGMxxO8HscRbzs9gflaY99nIP0Y
r+cpxNvH6z+N/GdyfUwj/w5b/6jvUp53zWD+L7HvOZB+zRzXPzxxhOsf4/1r
eg7r9a//5fqHN8xy/SP/uwe4/nc4P57l+ndOfLif619cLC4Rl4mD4nL42f9w
/TtHf/Ah17+z9/BBrn+077JDXP8o/xwddo7c9BHXP8o3cvxqEP9Ojn+tc+hC
ngdGkH+pnf85+3HOZz38Pc53A9rTx+ulEfFW2Pp3zvzN1j/qD/B6bUZ9q7n/
+Sh/MffTFsR/ivtvK/Lfyv27DfHrglz/GI/l5Vz/iFcf4vpH+nkXcv2Lo+Ju
cUzcI46jvhnW1wu/egHXP9r7Hr/H6sd4XnUe1z/mb4z9G4Bv4/NGEuPxVT6v
DSL+CY7fEPLH+PwwjPgX0CNo72sc/1GM5wneD1Io32nP/0j/mv0ej3iL+Xww
gf6M2/s/4r/P620K+W/nek2j/UGux2lcDwdyXP/iGXFWPCvOYTy2Heb6F+dR
/0O8P8yjv1ezfd5O159mrp8i5+geOuAc+jLvV8XO3l77Psw5VWL7v3Nksf1e
5OzfQJcj3r10CPUd5HhWOCcutu9JUH4FXYX2rqXDqP8QXY3y59vvjcjfZe//
aP8/7P0f5Rts/0f7H7D9H+17wfZ/caN4nbgJ7dlv53/oT6nt/5LegvZstfM/
cZu4HfHs9/0O9LfDzv8Rv9nO/8VRcTfi2/0shvjL7PwfvtC+jxD3wlmObx/G
44Sd/2F85+z8D/XttPM/lH+Y99sk8pfSg4hnv6cNofxBehges/M/XG/Fdv6H
8cnY+Z94TDwunhBPiqdQ31LWlxZPoz+NdAblH6Rn4N/TWVyvd7D/s+ifnb/k
MH9ddv6H8tX2vVfBnI95xDvTvv940rXnYjv/dw6t4f0xgPQGuhjpT/J5q0Rc
hvyn834bdI5eSZeLQ+IKKV/pnBpm/CqpL4z87/F5r9o58w22t8bZt++ZalHe
7u8R5O/geNU5e759j4j8K+z3P7TnsH2fKF4nboIP0s1iX9wi5Vvh43Qb+rvB
zv/Qv1LObwf68yzdifF9me5CPPveLArb91Xdzgm7P8Xgq+gexP+W/f6H+q+3
3/+Q/yn7/U/cL06gfT/m/A2Ikxj/jfb+Lx6S/MPiEfEofJft/4X+0WPicfEE
yr/E8ZpEexrpKXFaPI3x+7Z9vyWeEWel/Cyuzy32fRfm77f0HOZj0L73kvR5
sdfnbN93FfUtjB8QFztnzrHvw5wjL/B6LBMHnaOX0+XiEPLb9V/hHNpNVzr7
36SrxGHJXy2uEdeifJl9fwTb9/Z14nop3yDpjRJvHbyXbhI3o/9/on2M5wG6
BfW9Y+f/mJ8Ddv6PeI/Y73/OiQ9s/aN8qe3/qG+97f9If9HWP+b3Vq7HbnFM
3COOi3tR3xL7Xg7tD9P9mO8WOoHy9n4+IE6i/DJ6EOkWb0g8LB4Rj4pTEn8M
43uGrX+M16D9/o/277bf/9HfI7b+Uf49W/+I/5atf/h5Pi9kEL+SnsF81tv5
H/If5/vFLOqL2993iOfgA3x+z4vnxd6uhS7atTBeAL7cnv/FJeIycVBc7hxa
bt//iCvgI3w/qRRXicPianGNuNbZW8P+Rpwjq/j+Uof0LZyPeufU9Xwea0C8
rH2fiP4N2P6P/Jtt/Tv79v19s9gXt8A32fpH++629Y/4y+353znTbs//SN9h
37si3hI7/0P+s+3vnxD/TJ4ndCO947P3+5GrE39Y/8td9vdV/wc9bxRt
     "]], LineBox[CompressedData["
1:eJxd2X9IlHccB/Ans3J2bRK63LK6yoGBG27YckzWQRKSBrakZJN2NFsypK7l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     "]], LineBox[CompressedData["
1:eJxd3X9YXVedLvBTmhsjIk0pIk0jHjOYQcrEDEOR4VKKNKYRGYxIkWYyuacM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     "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQnbhw3qHfbBscNGP6D33V+GDPAALsGxyApEIojM8B
5i8QZ4PyOcF8h0JGKJ8Lwg+A8bnB/AeqMD4PmN9w6vt7CJ8Xjc8H5ie0wPj8
aHwBiHlNML4gGl8IYv/2r1C+MJjP0PkFyheByLd8hvJFIfxHH6F8MTS+OJp6
CTS+JBpfCo0vjcaXgfgnD+YeWTD/wBOYe+Ug4f3wJ5QvD/Ff/i8oXwHCZ4KF
vyLE/DR2KF8Jov80/wd77Q0GiS+UEPEJAFL6fOo=
     "]], LineBox[CompressedData["
1:eJxd1L9PU1EUB/AnamMUlMDqYJfaImj5WQFtaxUUUdTyU3jVWii//FG0QhWw
tnQkkd1F/wCHhqRWN6ODbHRzcejugA5dIKD0fc+Jyfclfc0n975zz7nnvmeP
xILRCsMwQvu/8n88fzL+xpn1u8y1ryXnb59RvlxZ//79yy+HuM6yv1AtPmP5
ff6EuB7zG9QN5LPkc4iXrhS7yY3kJnKzZeNPlbiF3EpuI3vI5yl+u+XU5iFx
h+VTiQPiTtSfM8QXLBeLf7fgi2Qv/FHtI/tp/iVygHyZnr9C7iJ3k6/C3epr
lsPre+Ie9OvTrvg6uZd8g3yT3If9NNW3sP5b9W3sv03Xv0MO0vx+8gB5EOsd
Uw9hfGNbPEweId8lj5LHyCZ8fEccwnlJqu/BO+r7OD+m1hdGvavqB8g/oP2J
4PmSehzrufU8TqB/jsPiKHmSPEWeJs+QZ5HvQT3vD5HPO83nEfkx+Qk5hvfv
m9Y7h3pSOv6U/IwcJz8nz1P8BXKC/IL8krxI8ZfQn+/qZfi07s8r1Ou1iZPY
z5/q14j344g4hf5/PipOYzxWI15BPp5acQbj5e9z4YM9Z8v8/37/A4FhjoA=

     "]], LineBox[CompressedData["
1:eJxd3HfcjmUfx/EbIZKRZERWxS17Z962oqxoWDcZUUaIFCJ7z+yMjGyy91ZW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     "]], LineBox[CompressedData["
1:eJxd13dUjlEcB/BXdvaIzMrMzpaZ7J0QElJky6asjMgsexOyylbIfPUf5zj8
l+2VrOwRkqSe7/PtHN/O6XQ+597n/r73d5/7Vi4Bwd7j7CwWy/uc79yfZx0z
mw1JTvCo5xeZlO76uZMl9+t+gkfuj+elTT8wbIsvYPohnGYx/chw9OusT/Bj
PP+IfoLxQPqp4bC0TNPPDHuk0jasH0E/x3yf36ZT4McZpl8Ydr5Hp6J+4k/T
LzE+7YfpV8hzO930a/Eb8VtxmvidYX93rv9e6n0wbG3EfB+xvy30J/FnzL/J
/X4Rf8X+3difb+LvMj8deRzoH1LvJ/L70b/EGeLfsl6m+I/kyUKeSn9M/8X8
UL4P2Tj/JNpy4X/nM2y10XaGnYOyTec37B9CF5DxgvApupC4sMwvIi4q8+1R
rwxdTMaLG7Y14f0oIS4pLmXYkkyXlvEyhsNC6LKov4cuJy4vdhBXkPUqwreY
3xH9nkJXwvO2v6YrY7wOz7eKuKq4mri62EnsbO6f5+2C+q/oGpjvxXw10T97
7qcWxoPo2ng+jq4jrit2FdeT9epLvQYYz2KehuJG4sbiJmI3cVOczwvWa4b3
LTuf6ebIE2BnuoW4pbiVuLW4jdgd/ahFt8X9tKfbIY8787TH8250B3FHcSex
h7izrO+J9yOR9buIu4q7ibuLe4h7on443ctw9F3W7435MXQfnFco3Rfze9L9
0L+9PL/+6F9vegDmt6a9xAPF3uJBst5gqTdE7CMeivxL6GHi4WJf1H9Ij5Bx
P+SZy8+LkXh/velR4tFif/EYWS8A+cfwfgQizx3WH4v5i3h+45DvXn7TQeLx
4gniieJJ4slwHM97Ct6PWOaZiry76Gl4v1L4+zAY+/WhpyN/Nj8PZ4hnimeJ
Z4vniOciXzDrzcO4Gz9f54tDxKHiBeKF4kXoz2DWW4zxk8yzBOOp/PshDP2Z
Ti9Ff6z8+2OZeLl4hTwfLl4pXoU8eb9/IjA+ml6Nfrkw/xrxWsx34n7XideL
N2C/ef2PFEeJN4o3oX5xejPG7ekt4q0yf5t4u6y/A3mT6Z3oj4X3bxc+jz/y
/u0W7xHvFe8T7xdH4z4ns94BjPvSB3GfHNnPQ8jvy7wx4sPiI/L8UfEx8XHk
CeT9jcV6+3nf48QnxCfFp8SnxWew3+2sdxb9f8n9n0OeKOY7j7xhdDzugwud
gPmV6Qs43yT246L4kjhRfFl8RXwV+/nFeteQ35P5ryNv3nnegDNoK/bfkvu/
if0k5vTniTUl43uO+f/qP6qk6q0=
     "]], LineBox[CompressedData["
1:eJxd1llQjWEcBvDTiRLaLGXXLlpkK0nOsUWRJWtEhWQvSzdmLHfMuGDGTe66
NZPbmGFMY0ZmVMi+RBSKopR2ddT3vM/Nc2bOnPnN+37ff3u/M1/wvoKMPLvN
Zrs19B3+TS09W1z3uMw5O+vqg87INodt+FNZ5hz+6QozrrJcEh1gXG35Ypif
8RPLQfGexk/Fz8Q1lsvj3I2fYz2EfgFn9LXCL8WvxK/Fb8Rvxe8sf74wYPwe
9b2lP4hrxR/Fn8R14s+Wc1yM/wX99afrLTuLeo0bkK9vj/FX9Luhy/ib+Lu4
UdyEfjd3G/8Q/5T4zXBLv3EL9pf+M/4l/i1uRf0erL9N1v+I2+FQukP8F/NK
Zz6dqC+K7oIfMf9uxM+je8S94j5xv9zvn3gA86zg/AYxr0rahf3vmZ/ttpW/
i/1wE9stlycPGrtbttldxiMs51yjR1p2dtAelkv8beb58RSPEnuJR1sOiqXH
WL6YRI/F/nO0N3yT9kG+mW7GvrjfedpP7C8eJx4vniCeKPEC0I8W5hOI/fX0
JNRziZ6M/ufSU1DPHfZzqnga+u9HT8f9azivGeKZsj9IHIx5x9Mh4lDsr6XD
zPXMNxz7U+zGEeJZ4kjxbPEccRT6k8/zGS2OEcei/go+r3Phu3SceB7qaefz
MV+8QLwQ+cUw3iLM8x77HY/9D+kE8WKcjyu8PlG8RJwkXop6qziPZMR3cB7L
4EbGc4id4uXiFcjXh/dbCTfTq3Aew3neV4tTxGvEa8WpmEcqnYb+XqfXideL
03H9fXoD1hN4fjaKN4k3izPEW8zzR2+V9W3o3wXG3455JdM70L8Ieqc4U7xL
rt8t98+SfPbg/yeX7yt7sV7rY5wtzhHniveJ94sPoP5i5pOH9RT6IM5nDc9n
vvgQ5pVGH0a9DvoI1hPpo7jemz6GeF70cfEJ2V8gLhSfRLx0nu9TyCebPo3+
X2Z9ZxAviv0ugquH3icrmgoDbwyZ76//AXPF0I4=
     "]], LineBox[CompressedData["
1:eJxd2nmcjuUex/HHUrJVdiUaIlsLWbNkCCPZGREyic4hhVLGNsa+jm2otKBI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     "]], LineBox[CompressedData["
1:eJxd2ntcz9cfB/CviqIQcjeLzfU3NJMNTd+x1tzHzJax1Qwz98n9lss2181t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     "]], LineBox[CompressedData["
1:eJxd2Xd4T1cYB/BfbCISxBZNVWrW1ooUqdHYe5WGEDFblKBRI42tJVUxo4jR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     "]], 
    LineBox[{{7738.144420702451, 0.99}, {7739., 0.9987683892250061}, {
     7739.864615469324, 1.01}}], 
    LineBox[{{7780.067370067961, 1.01}, {7781., 1.0077260732650757`}, {7782., 
     1.003340244293213}, {7783., 0.9965677857398987}, {7784., 
     0.9915966987609863}, {7784.602075832154, 0.99}}], 
    LineBox[{{7797.499558925294, 0.99}, {7798., 0.9909914135932922}, {7799., 
     0.9922780394554138}, {7800., 0.9922780394554138}, {7800.625722986248, 
     0.99}}], LineBox[{{7836.327255790552, 0.99}, {7837., 
     1.000839114189148}, {7837.596657349607, 1.01}}], 
    LineBox[{{7900.358435103388, 1.01}, {7901., 1.003697395324707}, {
     7901.877818709653, 0.99}}], 
    LineBox[{{7913.47648754402, 0.99}, {7914., 0.991913914680481}, {7915., 
     0.9976035952568054}, {7916., 1.0034695863723755`}, {7917., 
     1.006201148033142}, {7918., 1.008083701133728}, {7919., 
     1.0096217393875122`}, {7919.189076391372, 1.01}}], 
    LineBox[CompressedData["
1:eJxd13dUzmEUB/BXViUjkU2Jhi0jI3opMzPZIRkZEckOmdl7j+zsTWUVJXtm
7yjjDyOcOEWo93vvP9/Oqfd8zn2e+zzP/d3f7/dmHxDsM8TMYDB8yvnN/fQs
Va9z5t84o4vfsoQM53QPQ+7Pvzhjzl/jZrUhPtcXXJzEeUw2rnEQm5m8Lb2y
OK/J4QZ7cT7Mt60kzo/5zUqLC5hs2GUtLoj43MJic8SjrcQWZEuT7fzVheDA
QmIrcmFyEex3hboo5StGtiYXJ9tQvhK0XkmTU75ZiG1Rv9UFxKXIpU32768u
g3hJdVnU91F+cTlyeXIF7Cc0n7gixSvBb9R2ZHus763rVyY7IP8odRWc19dS
XJXsSHbCfLeCYmeyC/qjjvZHNXJ17CdM612DXBPjjZqvFuWvDYfr/uug/qvU
dcmuqI+7uh7F65MboH/DtJ4NKe5G8UbIH6BuTPEmFG+K88Waid3JzWh8c4p7
kI00vgW5JeqbnEfsSfbC/eD09yvcCvGMTHFrirdBPUL0eraleDtyezgjW+yN
fhr6W9yB3JHcidyZ3AX1cNf8Xck+NL4b9p+UJfYldyf3oHw9EbfXfL1ofG+K
98H6tdR9Ke5H7kfj+8Pb/4gHwNm6H3/yQNS7gdY/ANdzsXoQ+nPqP/FgeLxB
rucQig8lB5KHUf7h5BHkkTQ/iNYfhf5dpx6N+YnqYPIY8lic/7s6BPmDtd/H
4fkxXx1K8fHkCeSJNH8SeTJ5CnkqOYw8Defvqp5OnoF+cdD7Pxz7W6SeSfFZ
6F9rnT8b653U+s9Bvcy1XnNp/DyKR9D8+eQF8ED1QthCvQj5rmo/LCYvQT9v
1H5eSl5GXk5eQV6J83xVr4K9db3VcJTubw15LXkdzV9P3kDjN1J8Exyp9/Nm
9G+MPj+2kCPJW8nbKN92OFGv3w7UN0X7YSfsr++zXRifqt6N/Jn6vo1Cfznq
96E95L00fh95P/kA+SCcpt8vDpEPww7m4iPwNH2/HSUfIx+n+SfQjxG6/5Pk
U+RozPfT910MxWMp/2n0n536DI0/S/FzuF8far+cJ8fBXr/E8eQLNP4i9pP1
WZyA50f2B3Ei+RKcpE7C/GPvxZeR/8cL8RXsf4z6KvrH8bH4Gsa/eyC+jvPH
3BPfQP+ExItvkm+Rb6Nf02LFd7B+SrT4LvbvcUR8D+tXPC5OJt/HfiNOiR+Q
H1L+R3Ck+jHFn5Cf4rxuZ8TPkD/rnPg5zmOZIH6B8UGJ4peIH7wpfoX9P0kW
v0Z9UrW+KTi/1WvxGzhSr/9bjA/9Ik7Ffjb8FKdh/UB9XrzD9XfVfn2P+YeK
iT8gftFG/BHzo+zSPVwb3bUNyrH+v/ofu2y7wQ==
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{4000., 0.99},
  ImageSize->{1011., Automatic},
  PlotRange->{{4000, 4500}, {0.99, 1.01}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.5382176906406565`*^9, {3.538217809956859*^9, 3.53821781639647*^9}, 
   3.5382178926970034`*^9, 3.538218009060403*^9, {3.53821812889421*^9, 
   3.538218156869057*^9}, {3.538218189520714*^9, 3.5382182125513535`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.538218242543005*^9, 3.5382182429330053`*^9}, {
   3.538218275334263*^9, 3.5382183057995157`*^9}, 3.5382222106490116`*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[0, 0, 1], LineBox[CompressedData["
1:eJxTTMoPSmViYGBQAGIQfXVxga0Xp62DZkz/oa8aH+wZwMDOAUg06CrD+PYg
PsNncRjfAcQ/UCYM5TeA+Q+kuGDyjiD+AhF2mDyY7/CbASbvhMpvQOMzOKPJ
g/kNjXB5FxA/oRIuD+Y/iIDLu4L4Cmb/3kPl0fgMbmjyaHwGdzR5CF8OLu+B
ym8A8xPafsHkPcHh5f8VJg/mL5j1FibvBdZ/+ilMHsw/cPAOTN4bzLe6DJMH
8xmOn4LJ+4D5Xodg8mD+gvDdMHlfcHgwbYXJQ/jq697bF+oz75jT6Ouwzv1h
lQiQDwCLcnMp
     "]], LineBox[CompressedData["
1:eJxd2n+MXFUVB/ALpbD8EKdK6BqIXgRlQYNjiWZBpVek6QqtGeVXgba+FigL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     "]], LineBox[CompressedData["
1:eJxd23FQXMUdB/CnoqFKIlE0V0V7UVTaoDkVK6OMeSrTYKWWibTFivFGUemI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     "]], LineBox[CompressedData["
1:eJxd2X9o1GUcB/Cvc+nSqSO2HHnqV1swYcWKCauGXrRktAkrR44adcjMI4ZO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     "]], LineBox[CompressedData["
1:eJxd2X9MVtcZB/C3jFFrEZExi6iMWmoYGkYIOkYYfUVkFB1TikwcYZQgo5Qy
Syx1KPSdOkuNY0oodYwxZIwyQhkzxjilhBmmhDLimGGEWPbWMkKpY4gUGaO4
9nzv9y779g+bT86v53nOufdw4cmcH6Ye8HA4HPcfcTg+//83f3o8/p2QBudX
M3927ZPQ6Wccn/+3scH52b/dN75iOdTYvTbAcpix0/GE5c3icOOG0DWWI8SR
4ihj13urLW81Dp77kuVotP/dz3KMOFYcZ5y9Z5Vlpzge8Qb5W04QJxo7nFw/
SZws3oV6/ZHjU8S7Ub+MFZZT0f4Xb8tpmO/9xy2nI54HX7C8D/FvcljeD6c/
/Becif5JS5azMJ/Pfyxni3OwfvGnlnPFeZgvY9FyPsaXcXyBuFBchPF99EFx
Mfp/vGD5kLgE5yOQ/Q8jvk10Kc7HesZ7FPvvy3qUi13iY1jvGH0C8w2yvifR
3v6I5Qq0f8j9OIV8hr9o+TRc96jlSuz31WWWzyD+15dbrhJXYz8/esxyDfI/
yvHnEM92uhb5NHtZrkP/bk/L9Zj/PONtwPh3mV+juAmuoZuR7/foFsTnT7ci
v7+xfm0Yv4NuRzwf8Dx2IN6f0BdQr208XxfFl8SXMd8O7vcVxNNCd4q7xN3i
a4jnNcbbA8/T18W94j7kP073iwfEN7H+Y6zfINqz6VviIfEw9nMvPSK+LR7F
est5ft1wKH0H+/UePQa3elgeF0+IJxHfTvou1v+A802hfZieRv166Rns58/p
WfEczl8ZPY/z8Afmt4D+r9CL8BjP15LYcf7/7QGnc7wnnE97GXf/g15mHGzX
czna99De8EXaR+xr7Iqj/cT+6D/G9VYbu39PB4gD0b+AXicOQv9vMN9g8Qbk
8306BPHEcPxG4+wXGF8o+q/hfoeJN4vDjR1HOD4C871IR4qjxFvF0eIYY+cP
6FhxHPJpZz5O+Aifx3hxgjhRnARXcb5k1Ns+j7vEKeLdcAWdiv2IoNMQfxCd
Lt6H8eft+1+cKc7CflQz/mzsRwf3OwfzJ9n3PzzO+zVPnC8uQD28OV8h8tlJ
F6G/fV8cRPvv6GLxIXEJxo/Sh5GPL/e3VHwU/cPZv1zsEh+DM+37X3wS9XzI
fCrEp9C/mvU7La4Un0H9v8zxVeJqcQ3yi+b4c7CL9a8V12H8Tvavh0uZT4O4
EfENsH8T2l+im8Ut4lZxG86Dg/G3izvgZK5/Aes/x/24iHyS+f64JL5s7Td9
Be/rexzfifn/yvW6xN3ia+IezFdDX0e7D/PrxfoDrHcf8n+F7oe30QMYH0Tf
FA+Kb+H8u7neEOJZY9//4hGcx7dYz9viUbwvPdjfLb4jHkM8b9LjiCeQz9cE
5l/Lny8nMf4Uv7fuiqcQ77x9/2P8AcY3I55F/VK5/pzct/OI7w3u/4J4Ef3v
sf8S5g+hHY2m/WPO72Hsfta+/+G3GY+XcXcuz8MytD9FLxd7Gzuu8udVH7Gv
2E/sj/mKuP+rjV37OX8A+k/a9z/iy2B+64wbfFiPIHEw5jvL8RswXywdYpxd
x3g2ov8ov8dCxWHizYjnBh1uHPwEHWHsPP9vy5FYv4COEm9F/046GvmcZXwx
6O/gfsUinm8xnzh4wb7/xfEY/ySdYOz2oxNhX9Y/CeM/5P4kI1/7fbsL7W8y
vhTM/zy9G/2z6FRxmjgd9uD7YZ94v3H2NsaXiXq9znpkGQffZz7ZiOcjnocc
cS7Gr6TzsF4az1c+2iPoAtRnPdcrFBeh/2/s+19cLD6EfKrt+198WFwKr7Tv
f8T7bcZfbux6QLsQXxffX8eQ/yp+v58Qn8T4l9i/Ak6xv//hBa5/GuvfYnyV
4jPGwVvYvwrjbVcjn1/RNeJzGP91ulZch/V66Hrk+xTzb0B+TzP+RoxvY35N
4mZxC+avoVsxXzHdhvY4rteO8R2MpwP5dLIeFzC+yb7/xZeMnfbPg5fFV8Sd
4i7M5+T63cb/+/68hva9jLcH8XmwPtfhtXQvXMJ8+8T9xg2fcr4BY7f9fXoT
8Z3l8zoIp9j3P+KJpIfEw+IR2MX3623xKOIJ4PvEjfZf0neMg/fy/TWGeN9h
fOOo1+N8nidg+3tmUnwXLmT/KbiM808j3xWMfwbxDfD9Pgu/8YnlOfG8cfY9
egHz/+mB5UX03875lsSOX5v1r9IeYk/j4AnWzwvtrYx3mbFj0b7/jbMTmb83
nEH7iH2t+ez7H77D9f2N3e553v/iAOOGZMYXKF4nDsL4P7P+weINxq4hOgT5
HWd+GxGf/T0Ziv7r+fyEYb4p+/vfuLuMz0M45vPn+zQC3kxHIt4f8/edUZjv
uRDLW8XR6L+C42OwX0e4fqw4DuNX8vl1iuOxP350ArydToSfp5MQfy6djPYD
zHcXfJNOQb0G6d3iVMQbz/nSUO9cxp8Ov8p670N9ve3vf3GmOAvxJNj3P/wy
nYN4fsT5c8V5WN/+fUq+uEBciPrkMf4i5FdOH0R7JV2M/Yxi/ofEJRhv//x+
GPtXxPdLKfq7+DwdFZfDXbQL+bfav/9HvjtYjxOI7zX79/9Y7326AvHY3w+n
0N++v09j/t/SlRj/KvM9I67C+sX2/S+uwXqP2vc/2v0Yfy3Wu8HntQ7tW+h6
cQPqUc/3TaO4SdyM8xTI90kL1ttCtyK+WroN651gvdvFHci/kP0vYL0Y+qL4
kvgy4gljfFfQvonv/07EE3ef3//Ynxdm+P2P8Xum+f0v7hFfR/yrOL5X3Ifz
H8v1+q33K++nAaz/4hy//8WDGB/H/rfEQ+hfwv7D4hH0/9os73+0v8x4RuF3
Ga8b/R9O8f5Hexk9Jh6Hn2Y9JpD/P+lJ1KuF8d7F+fDnfkyhHv18XqbFM/B3
eT5nxXPY37V8Xuaxfin/vraA9TP497NF7L8n/766JHY0mfkn+H7xEHsaO4/z
769exq5frJl+5u3v9I00fmb+ffy/fGOoAQ==
     "]], LineBox[CompressedData["
1:eJxd2n9Ul9UdB/Cv6AiB0IgYGbGvjBEjxzhEjBHqNw6HQ+QYY8aIcRwy4pga
KYc4yBj7HmJEzog4jJgZY0Sk5BgxY87IETVjzByZMeaIvhmZGSNwRmQOV8/7
ed9zeveHnde5937u53Pv8+P7PA+rC+/PvsfL4XAMf/7PF/8P/WyhoMev0/XN
/EeHPo6aXe/44j//Ttfn/w7+Kdx2ADxxje2Vlp2VK2wHioMse964znawOMSy
exe9Cu0p/rZDLReML7cdhv5FPradltuX0+HiCORz/1dsRyLew0tsR1l2XEtH
i9egf6eX7RjE91tqOxb51tNxaG+h47Fe31tmO0GciPw+Y/8kjD9OJyN+KPNZ
h3xeuPIR7IL/sWg7RZyK+AkOe3wa6vsu60kXZyC/FM63wbLrIc6Xifje/7Od
Jc5GvNsZbyP8d9abI86195P15iHeBOfPF2+Coxi/QFyI9WtmvUWYb4b5F6M9
md6C9fngsu2t4u3o/xDXswReyvE7EP9VzleK9XuHLkP7E8y/HPFvYb4VaI/n
elRivW/0tV0lrka9D7K/G/N9netXg3i3Mn4txq+g6zB/GvOpR7y7mO9utF/N
+veIGxD/eboR8dO4/03YzyyuTzPa/8X4Lcj3Oc7fCo/QezHeh/nuE7fhfFhN
t4s7xJ0YH8H4XfAE89uP+me5v92o9wes7yDyf+cz2z3iXnEf6vkJxx/C8XKQ
7kd+mZz/MPJ5ij6C9luZ7wDit9BHxYPiIYw/yvV+RXxMPAyH0yPY358yn+OI
33vJ9gnxKPI/x/pOon4/Hg+nxGPwCsYfx3y3cP7TiH8765lA++P0JNrfoj2I
F8v9PoN86ukp8VnU683x57A/j3P+8+g/zHynMd+3Wd+MeFZ8AcfTY/RFeICe
Fy9gvht4/F1C+6P0ZdTX5m3ntyh2PG3l38/6vOAx1rfMckEu7S32sTwYT/ta
9pjrgb9lVzQdIF5p2ZnK/QxEfC+uX5Blx0bWGywOsey+m/FWIZ9g5hOK+Zaw
vjDEP0w70X8tr3/hqH+BjsD4q3i9jBRHod4c9o+GP2T8Neg/xfxikG8v64tF
eyEdJ44XJ4gTUU8dnYT16aeTMZ8vj4d16G/uXy7E28z8UrAeQ3Qqxq/jeqaJ
07FeHeyfId4gzsR+38X5s5Dv67z+ZSO/V3l92Ij86ukcca44T5yP+f3oTeIC
7FcT8ylEfeb4LRIXi7dgvjKu71bkfz29Hev5e+5HCfrfz3p3YP4wuhTxqxZs
l6E9kC7HepV9bLtCXCmuwvwvzNuuRvs/P7HtxnxFn9quEddiv27letUh/1rm
W4/2Vnq3fX6Y+7+4QdyI8XdzfBP2Z4bzNyOfSebfgv6b6VbEW07vFe+z94Nu
g2fodsRzcL4OzD/HfDqx/pu5f12In8b93W+vF4+HbvFBcQ/i/YzuFfchnzAe
j4eQr5vz9WM//ejDGP8I8z2C/H5MD4iPIp8krv8gxh/ifEOoP9Pc/zGf+X11
DC7h9W1YPILxq3k9PI7519AnxKMYn0GfFJ9CvBbGH8Px28p8xsWnsV4N5v4v
nsT6LrA+j/gM+pt4U3Ceuf8jn23M7xzq+RbvB+dh8/t6GvFf5PPjjHgW6z/M
/hfs84vxL6L9Sc4/j/1LpheQ3xTzvYT2K9zPy5jvLzxeFtG/kHZ0fdlelt3m
9+wyy+3ztLflwWe4Xj5iX/hdc/+H58z937LzU3P/Fwdadr1NB4mDke8BOkS8
yrJnKc/XUHEY/C6PfyfiO+lwcYQ4EvVEM14U5n+Ijsb6vcF81ohjxLHiOMuO
D+h45LuT+5sgTkR+b7J/EvLr4/4nY/+eMvd/tJv7kwvzzbG+FHGqOA37Vc7x
6YjXTmegPdo8/8PmfUAm8j1DZ8Hv83jOFm9EvX+lczDfbXSuOA/1htH5WN/r
6U3YL/M8WID+u5hPIfqvp4vExeItGO9ivK2odxu9XVwCv0nvEJeKy+CjdLm4
Avbh9aJSXIV6DzPfarEb691F14hrxXWov9g8/yNek3n+R/uNPB72iBuwXi/T
jWgP4/gmxLuDbha3YLwf3Srea1+vePzvQ/4v0W1oX0+34/h6n/l0oL85PzrF
XTjevHk+7Bd3iw+Ke+CH6V5xn/gQ1meI15d+5PMxfRjr8zzzOyIeEB/F+BX0
IHwX4w2JXxEfQz4RHD8sHsF88+x/XHwC15N2ehTtJfRJtG8yz//iMfR/gB5H
fk/Qp5HPJXpCPIn9nqA94jOI38V6ptA+Qp8Vn8P55svx58XTON489Ix4VnwB
84fQF3E8DJvnf9Rzr3n+F18SX8b6vM54i2LHM9Z8e2gvy+4Fjl8m9hb7WPb0
cLyv2N+yq4/9AzDfd+iV4kDLjjvN8z/ae7jewZbbz9IhiD/A6+Eq+BG+7w8V
h2H8EtopDkf/fH4/iBBHov8Mr69R4mjxGtSTwee3GKzPWx/ZjkX8uRnbceJ4
y87r52wnWB6M4XolIl431yNJnIz9ep/x1iFey3ne/8UpmL/+P7z/Y/xzfJ5M
Q/tp/n5NF2eg/tf4fLkB+fyc8TLhjg9tZ4mzsV4Xme9G1NvF+XOQz8N8fsvF
+AM8XvLE+cgv8mre/8UFqD/IvP8XF8HP8fd5sXgL8u027//F2+HldIl4B9Zr
ms/XpeIycTnW44d0hbgS8f0Zv0pcDTfQbnEN6mvi8VOL8+813l/rsH7zdD3y
S+Dvgd3Yn7fpPWhfzvOhQdyI/t/nejeJm7Gf99At4lbYQ+8V7xO3ob5Pzft/
cQecyPw6xV2o/w56P+rZRXdjvi76oLhH3GuvJ+fvw3wvc/0Oifux33fSh8VH
sH7m9/cA9vdp7tdR9Dfftwaxvw/QQ+gfaZ7/Ud9S8/5fPCweQT0p9HHxCfEo
xt9Mn0Q+y+lTqP8XfH8xJh6Hg+nTiH+Q58ME1vtaelLsgcd5vTojnoIv8Pp9
Fuu7lu+LzonPwynMZxrrPU7PYH3/aN7/o32buf+LL6Keq+h5jP+3uf+j/9OM
f0l8GesZxP6LaDe/pxz7v2wvy56v0csstwfQ3mIfsa9l5+94/fBH+7M8HgPQ
/hLvFyvFgZZdHp4fQeJgcYhldzbjrxKHWi7IocPETsS7wuMtHPX/ho5A/9vp
SHEU8i/m80S0eA3imfdLMeJY2HxPjRPHI14arw8J4kTs30fsn4T8zPfuZPE6
rM8S2iVOEafC5nqSJk7H/Ob7aAZsvmdvEGeKsyw7zPurbNSfap7/sT+nzfO/
OFech3j55vkf63WP+f6P+RPpAox/gfkUov9O8/4fx+8vzfd/8Rb0H6S3ireL
S7B+Pub7v7hUXAb/mS5HvovMrwLxzfe3Sqzfr+gqcTXqf5Lj3YiXzvO3Rlwr
rhPXY/4Eerd4D46/T3i9bRA3Yj3HzPt/7N8k3Yz6n+X1q8U+/+lWuIrXm72I
d4N5/kf95v7UJm4Xd2C8uX51Yr2eNe//kc8E89sv7kb/avP8j/weMc//4l5x
H+o/Yp7/xf2Y7wPz/A/XmO//sLm/DmD8rLn/o94Pzfd/8RD2x/R/Bfv5B3P/
R/9XzfM/4pv3xyOY/zbz/C8+gfXJYv9RrHcdfRLzlbKeU4j/Dc4/Jh5H/Arz
/V88Af+NnsR6LzXf/2HzfvCMeArrYd4XnkW8EcY7Jz6P/N6jp8Uz4lnUG8R8
LogvYr0c9Lx4Aet3zLz/Rz7m+8Bl8SLGl/L5xXHAqneU9rLsuYn342WWHRm0
t9gH49dyvC/aRzmfv2XnLjpAvBL9f0QHioPEwZbd19EhiDdp7v+WBx80939x
GPyYuf8j/5OMF265Pc58/xdHwubvJaKQ3710NPI5Yt7/o32Ox38M1vcJns+x
qGcbrx9xiO9HxyPfDfz9mWC54BP+Pk1E/CY+DyehvY3Py8nidYi/lnYhnyg6
RZyK8Vf+y+d/cbo4A/WM0RvQHs33HZlYn518vs/C+ndM8/lfvFGcA1fRueI8
cT7mu4bzbUI+HroA/b96wXYh6nfSRajnXtZTjPF7uT5b0P9FeivibeZ+bUf/
Qd7vSsQ7xKXY70bz/I/4yeb7v7jCPn/5/FGJ/d3F8VU4Ph7n9bUa8e/j9dUN
38TjtQbrNUPXYvx95u//0P8Zng/1WJ9ynv+7MT6Q14c9yOe3dAPGT9CNqP+9
q2w3oZ5FuhnzH+Pf47ag/tUBs+t/vfPAzXOfm39v/H/inw6s
     "]], LineBox[CompressedData["
1:eJxd239Ul9UdB/BvyMghkSExAyPycEzNiDFjzhl+j5o6YsxIHXqIvoccmUNl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     "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQnbhw3qHfbBscNGP6D33V+GDPAALsGxyApEIojM8B
5i8QZ4PyOcF8h0JGKJ8Lwg+A8bnB/AeqMD4PRD7r+3sInxfC3/4VyudD4/OD
+QydX6B8AYj9Dh+gfEE0vhCYn9ACM18YjS+CxheFuK8JxheD2N/yGcoXh/Af
fYTyJSD8J++gfEk0vhQkvKJh7pEG8w+chemXgdifB/OPLET+Ccy/chD9D39C
+fIQ9+X/gvIVIHwmWPgrQuxPY4fylSD6T/N/sNfeYJD4QgkRnwCv4Xx+
     "]], LineBox[CompressedData["
1:eJxd1LtPU2EYBvAj1iaacBHCLkttuQmiIF6ggqCIiuIdiiKIAkWqXAREocho
AosTiw66GAYwIeBmJIER/gCGTi4MykAiELn0PO8TkqdJ2/xy3r6375xmNEVq
WxIcx2nYe8e/axa+eDb8U8FAaPzXuv9vqRN/BaaCe58/V33mTNfB5RRzluvP
s8nmbMTn0DmIzz9szhWfEOe5jhU75nzxSdQbSzcXiE+5dtYSzafFhaj3Lclc
5Lqx+6j5jLjYdXTJYz6LfOGdP/A58Xn0M8N+L4hLEN/H+FLM179tDoovwjHG
l4nL0W/6Act/SVwhrsT8E+znMvJVMt8VnN/cf3MV+v2+ab4qrsZ8nVvma9hX
iL+/Lr4hrnF9LMp5b4pviWvRv5e+jf4nmO+O+K74HvJNs//74gfY11f6IVzx
z1wnrkc/i3QI9ZK4jwbkH6IfwVv0Y+wvxHkake8D/UTchP2V8byaUS+P5/sU
8ZN8PlvEz3B+c3wenotbxW2Y13fI3I5+fewnLO4QvxB3ot9pOoJ9fOI8LxF/
kPfnK1z/SHehvxjdLe5B/ijz9eL6POu9xv52eD/04X7/TfeLB8Rv7HyZbxD5
FlnvLXyc/bzD/la85iHxsDiK8/pxxDyCepFU83vMU5RmHsX1+P/z8mTGjHd0
//97F0n0exU=
     "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQHXjv6d1l3RscNGP6D33V+GDPAAI9GxyA5IGJklB+
L5jfkMYD5feB+Q/2MUP5/WB+gi8jlD8BIv/z33sIfyLEvLTfUP4kNP5kiHq/
n1D+FDT+VDDf4ckPKH8aRH8IjD8dIq/5DcqfAdH/4CuUPxPCvwbjzwLzFVJg
/NkQ81K+QPlzIOZd+ATlz4XI93+A8ueh8eeD+QzTP0L5CyD673yG8hdC5CfA
/LsIEp7VTNDwWgxxjwc3lL8Ejb8UYt410Q/284+/n266FBFfAE77h6E=
     "]], LineBox[CompressedData["
1:eJxd1llQTXEcB/DbraQkUpFstyyVNllutnSpFClJ4YHRMvRkmdFkeMqLGaMZ
HjwJE2M8ULppscaVLftykyV0bdGeKHRb1PmebzN+zVTzmfP//7b/Oede7/Qd
SVu0Go3GOPA7+D82U5tbdNZo8N94qLLTrz1CM/hzzmgY+Jvf4qq6QLEmsacN
LhQ+rzj1qI26vkjYCO/TqC4WviBcotiS0q/GL1VsymO+MuFy2EpfFL4kfBn5
qntVX0E/Hcx3VfiaYsMZukL4OuzC+m8ImxTr9jLfTVzf3626UvgW6jVZVd9W
nBPP/XcQL7tP9V3he+hvD12Feday3vvCD+AQrn8o/Ej4MfIZ6CeoN4vxnmJ9
j53a/zPh51jvY6/6Bfqrp83C1XA676eXwjU4rzKt6le4nmqr+rXwG8wnjn4r
XIv+7Oh38GnGfy/8Af2dpOvw/GTRFsQ/zHo/op40+hPiJdCfhb9gXrvpr+rz
wvrqsb6U/oZ6rPR3zMeT828QbhRuQjwP7m/G/dnL/C2ox5tuFW5DfXl0O+aR
yXn8EO7APAp4//wU/gUn052IX8L7r0v4N+rX8/n7g/7cme+vcLewFfOrY/09
6L+L8XqR7xjdJ9wPB/B51RT/bxvF+RW0VtgW9qTtFOds4/vLXniYYk0o+3cQ
Hq7YcIR2RPydrNdJeISws2LdKXqksAvWW3g+o1BfOvONxvVNtCv2b+b7bYyw
m7A76vdgvx5wDeczVnicsCfm4cv84xF/F+2F8znOfiZgv57nPxH9ZNCThCcr
tlRz/xTE38556BSbGlmPN/KZ2Y+P8FTEa6anCU9HP9mMNwP1BjGfL+qLpv2w
PpD1+QvPFA5A/QfoQDiE/Qahn610sHAI6gnm/lmoJ5j1hCJfOOc/G/HT2M8c
rA9gv3OF5wnrEa+JDhOeD+sZfwHyDZ3HQtSvYz2LcB6t9GL0M/Q+DhdeIhwh
bMD5HeQ8lqIeJ3oZfIL1RqK/ON7/UcLRcDy9HM9XJPfHCMcifhj7XYH+I+mV
4rzjsL+cXiUcj378+fmQgOtR/PxYjflVOahOFF6D9WY6SXitcDLmWUinCK/D
PLwcVa9HPzHOqjeg/wa39ohcS06GecD8vvsPebXFrA==
     "]], LineBox[CompressedData["
1:eJxd2Xt8j2UYx/HfZiNbjWpYQ+bUtswIUSlWopMSOihkjWGGVaucmcwxLIQc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     "]], LineBox[CompressedData["
1:eJxd12dUz1EYB/C/jBcOh8PpHC9wjBfkhdGhyCgie5WMiIpsQpEtZK+IyMxM
kaKMrIyMyF5llYxsGRXK/H/vl3O+nVP/8zn/+9znuc+9v1FNvwB3fxuLxZL2
5/fvZ4XCmNAfTRJd7AasOJNfN8/Z8vfHIdHlz9+o/nWMHa0OqVXZuKnVlurl
jZuJncTNrc6OLWncwmqXWiWMW8IOFuNWVp/a++sD7Cx2EbdGvCfdBvnLFRm7
Wu1T/5txW8R7fTVuJ3bD+n05vj3m9/1u3AH9WEZ3FHfCehszf2dxF3FX1Pez
0Lgb5ptHd7e6hv0X4x4YH/zZuCfqj/xk7C72EPdC/GDGe4p7Y725H437iPui
vxGspx/iM2kveA/71188AJ6Tb+yN+o4zfqB4kNgH+V1Zry/6VZv2Q3+fsd7B
4iEY34Dj/eEQeqh4GPLlsP7hqOch92+EeKR4FPpnW2w8Gl5Ej0F9Njz/Y8UB
cBjnGyceL56A/B4/jQNxfqLoIPS/JOefiHqq2RhPwvp30sFYfxo9Gfk683qe
gnw+9FT4Pj0N8ZmljKeLZ4hnop4UehbckA4Rz0Y93UobzxHPRT0JrCdUPA/5
w7m++Yi34/1pAfoVyn4tFC8SL0b/vBi/RLxUvAz3m3vMvxz1BLK+FeIw5BvB
8SvxfTLnWwVXosPFq5HfnvFrxBGopy7HrxWvE0eK16M+e3oD5t9Kb0Q9BfQm
8WbxFpzfq3QUvg+gt4q3wUX0dvEO1JNB78R5SKF3iaNhN3q3OEYcK94j3ov1
TKDjxPvE8fBCOgH9DuL53y8+gP6HcT8TsX5vOkl8EA4qY3xIfBj5h3H8EazH
iU5GP4+xvqMYn0QfEx+Hc+kTmK8K5zuJ67senQJH8vyfEp+Gh9JncP1mMf6s
OFV8DvmD6fPwv/N6QXwR/T5Hp4kviS+jP8m8P6TDjvQV9GMunwdXsX8OvJ9f
E19HfBnez2+Ib2J8LOe7hfmj+X5zG+NvFBjfQb3z+Ty+K76H+Hi+j2SIM+Hl
HH9f/AD74858DzF/d9bzSPwY9cUxPgv7tZLvL9mYz45+Is4RP8X8qfQz1Ded
/XwufoH9bsTnfy7mS2f8S/Er8WvE23E9b8RvsT8ZecbvxO/FH8R5qDeH7zMf
4eus95P4s/gL+hvP96l81F+R/S7A9f+e77OF+D6orDmvX8XfsD9jeN6/i4uQ
vyqfx8WIb2Wb55z6NtO2a/H//z9+A0WuRxY=
     "]], LineBox[CompressedData["
1:eJxd2XdY11UUx/EfKODEmTlQITO0XLktFRy5wm1ouQk1CWfYUFMMJ5YrjUQz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     "]], LineBox[CompressedData["
1:eJxd1ltI02EYBvC/81Ctk1rmobJZZrMyl1a2TluZlXay5exkNWdKF1EXQVBe
ZBdBdxFEV0FCF90JQgZCFxV0URB1V6nVbEtrls5ynuY09z3fE/QKMn7se9/v
+d7vv2mO95Kr3mQYxp3p39hra0akyP2+zZlfc/tF2BpyGLGfD23O2Et3svZH
Zd/jBO0OOGhod2J9Z3QA7hL+JPxZuSkY0f6i7AzQPvS/RXdjffW49le4a0zb
r2x5RwewX/uI9jfl5hth7R74wZB2L/Yvpb8rexoHtX8IB1H/mv368L59WPsn
8lykfyk/K2C+fpzPy/MNwCWcTwj1SVPag8K/0e855/EH9XfZf0g4jPo0rh8W
HhEehR+Nao8Jj2P/e3REeEI4CmdOaE/CPp53Sth48r/jhE3KlgbOI144QTgR
bqGThGcoN9v4PM8UniVsVm4KTOr62cJzsP48884VnqfsSeH+85V9heyfjPXF
cdopWJ9t0k7F+1Z6Ac5zmV4onIZ8V9l/kXC6cAbmfYH5MrG/j+fLQt5+Pi+L
lZ1+eonwUmWjis4WXob98vh5sOh5cF452L+HXo71lcy3AvN4w/y5qE/n/FYK
58EmehX8ivVW9G+g84VXC6+Bo8yzFudvYd4C3Md9ep1wIfL/+3zb4HJ6Pe7H
z/2KUD/F/MWYp5f3vQH7P6U3Cm8SLkH/h/RmYTvmn0tvQb2Z3oo8dubZhjw2
ejvqPcy/Q9gh7ET/l/RO4V24r3buX4r5T9C7hctgJ/9+7RHeK7wP+W+yvhz3
8ZbnqcD6a/R+4QPCBzGfXt7nIbxv5+fpsHCl8BGcv4LndwkfRb4SukrYjfWN
zFMtfAznjaeP4z4irD+Bfh30SeS7Tp/C8+Ji3hr0M9Onhc9g/yv0WWGPnhe/
D2qFvcJ1yFvL+Z4T3wf1eF7qErUb4KzUkKN1uKzPPW3+//MXLj1WLA==
     "]], LineBox[CompressedData["
1:eJxd1MlPU1EUBvDHEGMCYUnYiHYDZeeGBBdKdyQsDXEBJBCJCchQJmUQsMo8
Sasyz0OZBxUoIENb/gJ2sCEhRJYEFhKoIKV93/1Kcpq0zS/vvnu/c85rDa/N
L98Ea5qW5nv7v21pexED2Q5TXHrH7oXxPFHzv3IcJt9n5k2Y8lvdrr0Q5Vx4
Lkg5T/fRrKacj/v76ALd2vHNGWzWbXlFF+o2ea+Vi3Q/OfunXIzrzz3KJcKl
wu9w/xLvf498Zp5XhvVP/yuXI1+BV7kC+YOYv1L4A9af3qr1Vagnia5Gf1J4
Xg3OW2B9H3H9D/NZhD9h/0L6M/I/vFSuFa7D+c4r5XrhBtjF/jQiTwzzNGG/
BOZvFm6BDaynVbgNeR+zn+3wM/qLcIewFfUH5mMT/orzwulvwt+FOzGvSPav
S/eIl/V3C/egHyHsRy+ssf4+PE8a598PJ9MDwoOqf/SQ8LDwCPLs87xR7JdK
jwmPY/0p805gvnbajusG1j8pPIX9jFw/jX5FcR4zWJ/FfLOYlz1YeQ79yQhV
nsf5jx4oLwgvYn001y9hvsP8//iB6yes7yfyWJjnF/Yz0MvCK8hrpVeFHcgf
y+djDedZWf86+vGCv5cN4d/wAb2J/Xa53xbyBuazLbwj7IQ9tAv7x7PfbtS3
4evPoevY89d9//98B9U2k3M=
     "]], 
    LineBox[{{5831.873420397817, 1.01}, {5832., 1.009023666381836}, {5833., 
     1.0010426044464111`}, {5834., 1.0010426044464111`}, {5835., 
     1.0017606019973755`}, {5836., 1.0054136514663696`}, {5836.065874162513, 
     1.01}}], LineBox[CompressedData["
1:eJxd1klQzmEcB/C3XUqFqIQWoiS7QuV9bS3IkiURFbJTxMVMdHAwHBxcMA6c
LOPighkOjUMdrCG7UJYoSmlfXvX/Pl+HbzPVfOZ5/r/tef7vvBFbCzMLXG02
29X+34H/oY8vZlc9ueWIyTlzvzW6yW4b+Hl6y9H/t3R8gHGl5bJpbsbPLIdH
0s/hzK5G+IVlx9EO4yrEy2ozfil+hf3d9GvEK2k3fmP50/Fe47dYTwsx+d+J
3yP+i2DjD3je1924GutOxvto+dJr+pPlPCf7+Yz4/uynRlwr/oL4teznq/ib
+Dvqu07XiX+If+I86jmfesyvodu4Aes3eox/iX+LG9HvFZuZT5P4D/pb02f2
N6OeDOZrEf8Vt4rb4HbOq13cgfM4RXeKu+CCTuNucY+4F/2U8zz70M8D2onz
eMv6bLetev7fDxfLthMuZh6uYjfLZRc4L3esuzrN8x5YT+b8PMVelh0t3D9I
7C0ebLk0kfl8xL7iIZYvldB+8DXaH/WmuhoHoP/H9FDxMMvhx9j/cHGg5bzL
9AjxSPTTwPxBeL6GDka+fDpEPAr13+E8QhE/gB4tHoN5ePA8x4rDUE82zyNc
HAF70ZHicTjPeOYbb/Kz3iisB3oaTxBPRP8L+PkULY4RT8LzKTyPWKyX832e
LI6D79JTYD/e/6niabgPN/k+TMe87rHfGeKZqMeF+2eJZ2MezXQ81uM4/wSc
70PObw7i2zm/udgfxXnNEyei3jAP4yScz2nGT8Z9ecn+54vt6D+adogXoL5q
3t+F4kXoz4/1LhYvQbwK7k8Rp6KeKDpNnC5ein57GX+ZeDnip3N/BuZ1ll6B
+pJ8jFeKV4lXI34PnSleg/gJvI9rMf9k5lsnXi/OEm9A/gl0tngjXMx+NyF/
BJ0j3ox68/l9ZQvmaQs1zhXn4fkif+N88VbUWzHMeJt4O/afY70FiJ9C78D9
qeR93ynehXh2erd4j3iveB/yedP7xQfEhZjnZ77PReKD4kPIl8v5FuN9Pcn+
DiN+LOd9BH7k1WQvrysKOt9vft/8BzC1q8g=
     "]], LineBox[CompressedData["
1:eJxd1llQjlEcBvC31dIi0ULKV5gpV2Zwo4tixoUZw4zRhWFGw7gxZnLBuECy
hURlXyuUKEu2SlmSJbKEEoWKskQUytam3ud9PjPPN9PX/OY953+es3TeghfE
zFrkaBhGTu9P3+8832SvppX5kWHzkkraQ1sjjL7PqvzI3u+4qADLq+EMF8ux
pm0rHCyvgVMNy3Gm08f1tMBrxevE68UbTEdH0RtN109l/XjxJow/l96MvPH0
FnEC2ruz/lZxIvIk0NvQv5neLk5CnoAuy8l4PqfTcop4B+ZXTu8U7xLvRr5Y
1t+D8ZrovaYjc5lnH5730PvhSZz/AdPGdPqg+BDaR9OHsR4ZdKo4De0T6XTk
rWO+I6aLK+ij4mPiDDiB9TLFxzG+A52F8ds53xPik+JscQ7mP5b1TmG/ltGn
rfNPnxGfFeeinjPrnxOfx/hd9AX0H8/+F8WX0H4inSfOFxeIL2O9IuhCcZH4
ivgqzmMV814TX8f5m0IXw/70DexfcrflEvFNOIS+Jb4tvoPx57N+KRzIvHfF
92CD7cuwvstZ7774AdzA9g/Fj7Cf4XS5+DHW341+gvyZrP9UXCGuRL0JzP9M
XCV+Ln6BvPb7uBrPa+ga8Uu0X0q/Qp4o+jVsvx9qsb8+dB3+3u3zrRe/Eb/F
+pTTDeJG8Tvsny/He496jfQH5GujP+L5TEfLTeJPyB/G99dn2JduFn/B+EtY
/6u4BXn96Fa4kPm/ib9j/TPoH+I25C3gfdgu/gnP5nn5Jf6Nein0H8ynkP6L
9WqlO/C8iPk7kbeY7sJ9UEZ347y4cn16MN4M2igw28c4WXYQO5qODuf7zUns
LHYxXVzZYdlV3A/uYPv+6G/jeg4wXe/B/ANh+/3oZvr/+XcXe4g9xYPghbQX
8kymB2P+QbQ38nnTQ5AnlHmHmrblcX98TBvTaF+xn9gf/UtZbxjqV9PDYfv7
M0A8Av3H0IHiIMzPfh5Gim2mI7PpYNRPo0PEo8SjMV5W73lZ7JmZXdtr/n/6
D6Of0h8=
     "]], LineBox[CompressedData["
1:eJxd2Gd8jWcYx/Fjq5ZaRVs0USNG7BEzQSIkZuwRO9QWM1bsvYUaHRRtVVGj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     "]], LineBox[CompressedData["
1:eJxd2nd8jtcbBvBXjISYsWdRfkTNFEXTSGmoXYqiorGrdsWqkSBaVT8j9k5s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     "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGBQBmIQvbVqn4jUr90OmjH9h75qfLBnAIHfux2ApEO6AJT/
B8xXOM8G5f9F4/8D8xue8UD5/8H8B668UD7DHlQ+I4T/D6aeCcx3eMYJ5TOD
+QqdMD4LmJ9wiR3KZwXzDyyF2c8G4UfB+OxofA6I/jwYnxNi338YnwuNzw3R
vxVmHw+Ez8kB5fOi8fkg+uVg6vkh/Akw8wTA/AYbVihfECJvCuMLQcLDhxnK
F4bIf2eE8kUg+vf/fQ/hi4L5DLt+Q/liEPec+wDli0PMk3sM5UtA/P/7BpQv
CTF/3mkoXwqiv3w3lC8NCf+zm9/bi/teLVgB5K9zf1glsu69PQBZwYnR
     "]], LineBox[CompressedData["
1:eJxd2Hd8jVcYB/B7jcRIxIitV8wkVoIESSS5BAlBzBgxIhGNUdHQailSRAdt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     "]], LineBox[CompressedData["
1:eJxd1llQjlEYB/CvfSeKFCUXDY0bbtx0Udw0Ltw0jQtEGNMdIyUlSoQsZS+K
smSplGyhvqR9QZE1Wi1J8UX7rt7/+bt4mpH5zTnPc57znPOeacGmbX5bjHU6
Xc7kv6n/Czoynau263081yUU9y3q9tZN/QTrfSZ/R5tbKe/QHLh5wgCHwCuG
lEOFdyI+dVg5DF6qU/l2aU7zosOFIzQXRdG7MZ5ER2puKaH3IL+NifJe4SjN
umLOj4Y9xlV9+zT7GNMxwvtRz1r6ANxspPLFYr0e+qDwIcz3N1Y+rPKxvjjh
I8JHsd8mxh9D/sXs73F4DfsfDy/rV04QPqHZ3Y3zT6K/+aYq/ynh0/CqQTX/
jPBZ5O9kPefgQPY7Ef10Zz+S4Hr6PPIt5P4uCCcjXxadInxR+BL6Fcf1U4XT
cF/rxlS9lzEeQF/BePGo8lXha8LpiHdg/HXhG8I3YXvWc0s4A+fvS2dif+l0
lvBt9HMJv89s4RzhO1ivnP3KRb7VZsp3he/he4nlfbmP/dcOKD/AfH2v8kPh
PLiQ9+UR4se4/mPhJ7ifOdxfPsa30gWwFa0XLoRbud+nuE+uPK8i9COY9/UZ
1qvh/oqx3zC6RLhUuAzn5TGiXA5H0hWYH833o1K4Cv2xZ73VqKeN+6lBvuX8
Xp4Lv0B8OOe/FK6FPeg69MeWfoV61rOe18L1iK/kem8QP8j36a3wO+H36LeB
8R+EP+J87PjeNAh/wvxkzv+MeuLpRuEm4Wa1f3PlFuFWfA9BPK824S+YH8j7
8xX1DdPfcF4b2M/v2P85rt+Ofg7QP4Q7hH8i3o75OoW74BD6F+JTGP9b2ID+
5dHdwn9wnxL5/f3FeCbdI9wr3Adbsp5+9MuZ790A6vVjvwaFh1BvNe/bMOLb
+f6MCI8Kj8Ge9LjwBPIn87x1hZpDXZWNhI01B8ZYK5tgvM5C2VRzdAZtJmwu
bKHZp4x/T1ki/yjzW2lu8bZRtobn2yrbCNtqLrKj7VBfOPNNE56u2X2E69uj
Pj2/rxmo5//fMzMxv4vvkYOwI9YP4HnNwrg/v5fZmtPM+L46of6NfcpzMN+X
dsb6HV3KLphf16A8F/lc6XmIL61QdsW4TbmyG9yYa/B28XIKWjnpbN/WCMds
g/c/UvLTXg==
     "]], 
    LineBox[{{7738.144420702451, 0.99}, {7739., 0.9987683892250061}, {
     7739.864615469324, 1.01}}], 
    LineBox[{{7780.067370067961, 1.01}, {7781., 1.0077260732650757`}, {7782., 
     1.003340244293213}, {7783., 0.9965677857398987}, {7784., 
     0.9915966987609863}, {7784.602075832154, 0.99}}], 
    LineBox[{{7793.499558925294, 0.99}, {7794., 0.9909914135932922}, {7795., 
     0.9909914135932922}, {7795.361614018306, 0.99}}], 
    LineBox[{{7800.298498942366, 0.99}, {7801., 0.993202269077301}, {7802., 
     0.993202269077301}, {7803., 0.993202269077301}, {7804., 
     0.9922780394554138}, {7804.511402574464, 0.99}}], 
    LineBox[{{7836.327255790552, 0.99}, {7837., 1.000839114189148}, {
     7837.596657349607, 1.01}}], 
    LineBox[{{7900.358435103388, 1.01}, {7901., 1.003697395324707}, {
     7901.877818709653, 0.99}}], 
    LineBox[{{7913.47648754402, 0.99}, {7914., 0.991913914680481}, {7915., 
     0.9976035952568054}, {7916., 1.0034695863723755`}, {7917., 
     1.006201148033142}, {7918., 1.008083701133728}, {7919., 
     1.0096217393875122`}, {7919.1030020125945`, 1.01}}], 
    LineBox[{{7932.988807752423, 1.01}, {7933., 1.0099146366119385`}, {7934., 
     1.0099146366119385`}, {7934.012576707589, 1.01}}], 
    LineBox[CompressedData["
1:eJxd1wlQllUUBuBfUHYE3NJMBTGRXEuNStM/3LUNtdxQCfcVI41KFCwJ973c
ciFx19xBcUFBUNNccLdFVEynmUZzhhpRJP3f844zLzPCPPPde+45595vMSQ2
rvsQN4fD8dfTf8/++vbN6nDfke0Mj56bU9zgflvHs59y2c6nvw+Hh5nd4Gp1
zO7i8i4nO0LMFcQeLjvSg8yeLjtT/M1eLhdO8TZ7w7FeZh+xL+J5eJj9xP5w
hp+5ojjA5eAYOlAc5HLMKrqSuLK4Cuqd72uu6vLqRcynmvgFcXXEy3c31xC/
KK6J/l+qYH5JXEtcG/WNL2+uIw5GPt2YT4i4LuLdYLxQcT3EG8PxL2O/PCua
62O/t1cyh4kbYH8OcXw4rjfj+XgF8ZMZv6G4kbgxHOFpboJ6Erk/TcXNxK9i
fSfnvyZujnwTWX8LcUvx6+hHRzdzhPgN9HMs+/Gm+C1xKziW8VuL3xa3QX0F
5cxtxU6cr4B/7sHviCMRr+Z/5naYv4/71R7nv4TugPoDmG9HcSeMD3ti8Tpj
vakPzF3EXbFe8UNzN1yP5/l4V/we4heX2vj30e+hj8wfiD8UR2G/W3N+d3EP
rJdXYu4p/gjrzyozfyzuhXoSOL63uI+4L/Ir5fr9xNFYP4T59xcPwPgm9EBx
DJz22PyJOBb5Jzisv4MQ/zQ9WDwE+z2R9Q4VDxMPhydw/gjxSMQ/w3xHwWn0
aPEY9C+f+Y+FcxkvTjwO68XxfvhUHC/+TDwe/XnAeBPEn+N5NI3jE8RfiL/E
/RZFfyWeiHpD+fxIFE8ST0b8EbzfksTJON9BjD9F/DXqncl434inilPE32K9
3dzvVPE08XT0z4v9myGeifHeHD8L613lfs8Wz8H8Trxf5orniefj/C+jF6Af
9+iF4kUYH8n8vhN/L14MB9JLEG8d61kqXoZ63fk8WI7r/nwe/iBeAa9k/SvF
q3D+MxlvNeIn0mniHzE/l+dhDfoVw/dtOq7foteK12G9h3x/rsd5LuP7dgP6
EcXn90bxJszfxfGb4SIf8xbku4LfM1tx/gcz/5+wXnqxeZt4O+JN4vtyB/J/
zO/VneJdGB/K79Hd4j3IJ5Xfsxm4Hs16MuF6fF/uFe9D/u35vs0S70d/grne
AfFBjL/I83NInC0+jPVL/jYfEeegX6V3zLnio+I8cT6cRx9DP+tfNh8XnxD/
jHxvXzCfRH8zz5lP4X6Pzzb/gvNZtNd8WnwG/SrMMJ9F/No7zefEBeLz4gvi
i+JL4suoL3WP+QrqicgyX8X1kgPma+Jfxb+hPp8c8++INzrX/If4OvK5UmAu
xP74XTffEN/Eekv/Nd8SF4lv4/wcqWzn8U/xHezX1kDz3edO6ly2ePnd5/8f
/R8xLK8j
     "]]}, 
   {RGBColor[1, 0, 0], LineBox[CompressedData["
1:eJxTTMoPSmViYGBQAGIQfXVxga0Xp62DZkz/oa8aH+wZwMDOAUg06CrD+PYg
PsNncRjfAcQ/UCYM5TeA+Q+kuGDyjiD+AhF2mDyY7/CbASbvhMpvQOMzOKPJ
g/kNjXB5FxA/oRIuD+Y/iIDLu4L4Cmb/3kPl0fgMbmjyaHwGdzR5CF8OLu+B
ym8A8xPafsHkPcHh5f8VJg/mL5j1FibvBdZ/+ilMHsw/cPAOTN4bzLe6DJMH
8xmOn4LJ+4D5Xodg8mD+gvDdMHlfcHgwbYXJQ/jq697bF+oz75jT6Ouwzv1h
lQiQDwCLcnMp
     "]], LineBox[CompressedData["
1:eJxd2muMXVUVB/BdSmF4eqsExkDMRlAHNHqtwQy+uiUQJjzMRagMdIq7RdoB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     "]], LineBox[CompressedData["
1:eJxd239wXFUZBuBbKDaWtGwwwE4NdQsBog10oYFGzcACGZtCxFiqpkMsOxAw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     "]], LineBox[CompressedData["
1:eJxd2X9o1GUcB/Cvc+qaU0dsuXLqaQsmrFixYtXQi5aMnDBz5KhhR8wcMfTE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     "]], LineBox[CompressedData["
1:eJxd3HFUXuV9B/BXzBATTJAixpjS1xgpxSzjUGQchviKyChmjDGkmOVQwpBF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     "]], LineBox[CompressedData["
1:eJxd23FUltUdB/A3ZMSIEaGRKbE3jpk6IkZGzBm+x5g6YkRMnTGz9zBi5lA5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     "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQnbhw3qHfbBscNGP6D33V+GDPAALsGxyApEIojM8B
5i8QZ4PyOcF8h0JGKJ8Lwg+A8bnB/AeqMD4PRD7r+3sInxeNzwfhb/8K5fOj
8QXQ+IJgfkILTL8QGl8YjS+CxheFuK8JxheDmN/yGcoXh/AffYTyJcD8A2dh
fEk0vhQaXxqNLwOxP+8LlC8LkX8C848cJLwf/oTy5SHuy/8F5StA+Eyw8FeE
uC+NHcpXgug/zf/BXnuDQeILJUR8AgAzsX60
     "]], LineBox[CompressedData["
1:eJxd1LtPk2EUBvAPhYZrJfgPwFKoWKSgFhHaT9QC3sB6QbAIchNQWy9AUbm0
Mjq4OHWRQRbCAANQN1IScYPNhYGdQR1MwEaRfs85MXmatM0vp+855z3v26+k
JxzoP2IYRufhO/3d8uVT5n7ZoukMvk/+KvvhM9Iv56J5+Lm26xCfsGxuFYrL
Lc+uHhOfxO9dapflneZccQXWu3PEp8iVZDetr0I8li+utmz8LBCfRnzeLj5D
Pkv2kGvI5yxHNzPFtZaLIxni89j/siGuQz+Rg+9wPdlL9pFN8gXsf0XdAO+o
L6LfuNa/RL5M9pMbkc+v+Zpwfok/4mbsL5QSXyFfJV/Deqeuv475BdU3UN/2
V9xCbiXfJAfIt8i3sZ+41ruD+nnqu4h//S1uw3kuqe9Z7p5TtyP/xp64g3yf
HER+u86jE/mn1A/glLoL8wtq/93I9079EP036Pn0kHtRr1LvYx/uTzJP3A8n
9P8xQH5EHqT1Q5iHI0s8jH4d2t9j8hPyU3II/S6pw5jHR93PM/z+qN7P54h/
UL8gvySPIH9U841iP+tabwzzO9D7ECGPk1+RX8v5ar43iG9ovQm4VPuZRH9e
m3gK89xWTyPft2xxFOf/WZ93McTDReK32I/nuHgG8fTzeWuhZNk28//5/Q9o
s3ZQ
     "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQHXjv6d1l3RscNGP6D33V+GDPAAI9GxyA5IGJklB+
L5jfkMYD5feB+Q/2MUP5/WB+gi8jlD8BIv/z33sIfyKYr7DrN5Q/CWJ+Gow/
GaLe7yeUPwXMd3jyA8qfisafBtEfAuNPh8hrfoPyZ0DMe/AVyp8J4V+D8WdB
3JMC48+GmJfyBcqfAzHvwicofy6YzzD9I5Q/D40/H42/AKL/zmcofyFEfgLM
v4sg4VnNBA2vxRD1NVxQ/hKI+zy4ofylEPlroh/s33wv7l+6FBFfACk0hpg=

     "]], LineBox[CompressedData["
1:eJxd1llQTXEcB/CjIiVLiGQrW6VNJES6VKJUtvDASE2vmJEMT3lsmOHBk90M
HghFssaVLftS9qWbPVtZynJL6nzPtxnfZqr5zDm/7f8//3NvQNbyOTkuhmEU
tf62/U/OzqlJ319kC160sbwhqD7OaPs5UGRr/bvrs7flQtOZWzpYPig+JD4M
rzMsF4mLxUfgKPqoaUdGSx1cAu9ttnzMtN3ZZLlUfFx8QuJPol4Vfcq0bR/r
nRafEZeJz4rPmfZfy/x28Xn0Z3daLhdfEF80nZ/K+EvIl/fX8mXMs4a+Iq4Q
XxVfw/pE0NfFN8Q3Ud9G30K/uZz/tmljj4u1n3cQ3+Rm+a74nrgS8ccYXyW+
L34gfih+hHlTXC0/Fj8RP8V8bvQzuH2e5+IX6H83XY3zk0s7kH8Tz0cN1ms1
/VL8Svxa/MY6P+zvLfopod+hHyf9Huvhy/WtFX8Qf0Q+H8Z/wvPdzPqfUX8r
/UVcJ64XfxV/w/PtwvP/HS7k8/RD3CBulPif6D+a/oX5enM/fov/iJ1Yv2r2
14T5G5mvGf1vo/+ivh/dgv0v43k1iv93B9OZIbSL2BX3+9Ju4o7iTqbtO2l3
00Ykz2dn07bNtAfuj2G/nsi3gu4i9hJ3lfhuuO7gfnQ3nZ/Fej1wfTHtbdp/
Cd9vPcW9xL3Rvw/f5z7IV0D3wfUHnL8v5g9kPV9xP+RfSfth/bdznv6mHVX0
APFA8SDxYORfxvXwx3p9YH8BuP8T+x8iHioeJh6OefKYbwTmD2O9QKx/Ih0k
DkZ8KPsdiX4L6BBxqDhMHC6OQD/h9CjUD2f9SNSP5fqPRvxSzjMG94dw3ijx
WHG0eBzyf6THw9HMPwH12vcjBvvjz34m4nn4Qk/CPGl8H8SKJ4vjxDbs33qu
xxT040lPhXew33j0s4pOwPMeTyeKp4mTJH468o/jvDMwfzydLPuXgnyl9EzE
F3CeVMwTzM+HNNyfwM+PdORLdrc8C+tZQc8Wz0F8JT1XPE+cIZ6P/ffzsLwA
9ZO8LC9E/7W96uM2OPKzK1vN77v/AM4zy2o=
     "]], LineBox[CompressedData["
1:eJxd2XdYj2scBvBfkShbdk6ZFcnmnJNDx+Z0zMPhWBnZhOyMjOxkk5ktO3tL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     "]], LineBox[CompressedData["
1:eJxd12lQjVEYB/ArfGOmGdOMDxh8sXwQZshaWUPWkj2VVLbsZJfsS4qIrIUs
2SJbiixZsodwbSX7lqRC3bF0/+fPzL+ZW/Ob9z3P85znnPP23nojJngFOVgs
lqy/n4q/9Zz90m0tUtwbDYu6UNKw0M1S8dMyxf3v7/ihDYxd7A6vX8O4ld0W
b0fj1nCd6sZt7Hb3qGbc1u68pMrG7XC9fiXj9nBLi7Gr2M3ucwd+f4HdxR1w
vw/dEfVUKzfuZLd/k5/GncVdxF0x/wDaA/EDyoy7oR+RdHdxD7GnuKe4F/L/
+m7cG9cX033srtu82Lgv7g/7ZtwP/YgrMvYSe4v7i33EAxA/kPEHigehv7Gs
ZzCuW+khcESJ8VDxMLGveDjqSWc8P7E/8ndiPQHolzM9QhwoHikOgsPpYOQr
oEOQL5/7YRTsyfUbjfufcr+NwX5xshmPFY8Th4rHiyfg/EQz/kTxJPFk1OP9
y3gK9k88PRX9rszzNQ35ajsYT0c/EukwzDeLnoF8njzPM5HPn54FP6ZnY7y1
ivEc8VzxPNSTQc8Xh4sXiCPgpvRC8SLUl8z6FiN/DOe3BPNrxOfTUvRrEfu1
TLxcvALxfDh+Jfo5hF6F+3PoSDxvHjL/anGUOBrjR9NrkC+V8daKY8TrML45
vR7xG9Kx4g3ijeI48SaJvxnzT6C3oJ5Seqt4m3g79u8tOl6cIN4h3inehfXP
oBPFu8V74K70XvE+cZJ4v/gA6plMHxQfwv6bQx/G9WV0MvobzfU/Ij4qThEf
Ex9H/BD6hPgk1sOXPoX5tKFTsb5prO+0OE2cjvhv6TOIV5PxzuK8NqYz4GCe
13Pi8+IL4ovoZy7jZWK//vMl5A+jL6NeB/oK7r/Eeq+Ks8TXxNcRL5XPhxuw
C30T/VjI5/0t8W3xHaxfEp0tviu+h/F7fhjfR/7sUuMc8QPxQ/TTi34ktoof
i5+In4qfiZ8j/0G+D+Ri/dbw/SRP/EKcL36J9cikX2G9m/H/+2vxG/Fb1HeD
49+J34s/iD9iPR4VGn8SfxYXiL+IC7Ge+V+Nv4qL4Dus/xv6eZjvT8XiEtTr
yH6X4rwX8P3mO/oZyv38Q/wT+WpVNS4Tl4ttyOfqVOiW+cnq1Mv2//vHHwvb
Rj0=
     "]], LineBox[CompressedData["
1:eJxd2WdUVUcUBeAHKFgR7F2wIfZeIgoqduyKKCqKHXvvir2gYkcRFbtiFxTs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     "]], LineBox[CompressedData["
1:eJxd12lQV1UYBvALqBVqbklIilAmuKCoIWKWf9FCbUNCVMRkUWwh0bRFrcQF
1wzayywoRA0UV1RcEpnxA800+c1d/wJKoYALqAhIcJ/zMOPjjMP85tz3vMu5
C/jGJ0fMdrUs63rz/5afuz3rh04+le/oF5NWVOt/Y7TV8u90vqPlx+XOxmds
O/e1MT4LV1jG52xnljdWw+cRf46+gPUE+qLtlIp640u2HWW0E/uvoS/j+qj7
xiXw+TrjUts+J+ky5C+4a3wF+ZfVGl+FM2qMy5F/LP2v+D9xBeL/4n7XbMeG
3DG+jnrm0pW2CwNYXxX6i2d/1XAw53NDfFN8C/sd5zxui2uQvztdK74jviu+
h/n2ZL11WN96z/i+uF7cIPGNqK9Hg/EDzLOI/TRh3Ulb+x+2i9jVtk9ik7Gb
uI24LZxHtxM/In5U/JjY3XZK2QPj9uIO4o7ix23HduF+nWw7B/N56mw7c5iL
cRdc7+1q3BXr/nQ38RPi7ojfxP09UM8i+km4mPV4Yt5JdA/EO1m/F+qt4v3y
lG1HKd1T3EvsLe6NfH35PPiYefC8fZH/Kv00rg9nfc+g37/ZTx/Eu3J+z4r7
iv3gYsb7I18u3Q/5Eun+ti13egDWG1nPQPSXx3oDxIPEg1F/O8YHwhPoITif
UuYbivuxifUPQz3xPO/nsP8GOgjxWfRwcbB4hMSHYB596JFYd6efRz0hrGcU
6gmkX8C6k/W/iPgT9GixQzxG4kNxXgXMPxbzb6DHoZ9qN+OXsO7g9+tlcZh4
POpP5X4TcB7/sJ+JyL+ZfgXxi+lXcf14+jXUX87zfB3Xh/B5ekMcLp6EfvzY
fwT2D6bfxLwm0pHiyejHjfVEiaeIp+K86xk/DfnO0tGobyk9HfVFsN4Y8Qzx
W+b5oWeKY828+D6IE8eLE1BvHOc7S94Hs3FeCW2NE2GvrsZzxG+L38H+De2N
30X/J3l/vQfncn5JiM9h/vcRv5Gei35L+D1Mxnyi6Hk4vyb2Nx/9VvN9+QG8
k14gXij+UPwR6ktmvo+RL5Dvo09QXyXPY5F4sXiJ+FP0E0Z/hvlEMt/nyLeD
/S3FehnrS8F+8+hl4uXY/xh/31ghXilOFa+CC/n7yWrU0/r9WYP5+LLeteJ1
qKc357Ve/IV4g/hLcZo4HfNoPZ+vxF+jng70N+Jvxd/h/vPg/L4X/yD+EfNw
4zx+gi2e50bcTxbv55/Fm5B/BP2L+FdxBuKr+Pxm4vk9xXy/YT2a/h3ziGZ/
Wbi+kvVuxvlm09niLeKt4m2YhyfP4w/sn8B6c3Be2fw+5GI+M/n92C7eIc6D
vemd6CeD749dWL/Cfncjfzrr2YP6Uui94n3ox5fOR7wXvR/1+3F+B5Avnf0f
xLxP83kpEB8SH8Z+RdzvCPYLZf1HUV/r+f0pPgbX0YXYP4jzPo5+Cprnc6Gw
pK6m2fx79X8eruV8
     "]], 
    LineBox[{{5831.873420397817, 1.01}, {5832., 1.009023666381836}, {5833., 
     1.0017606019973755`}, {5834., 1.0017606019973755`}, {5835., 
     1.0017606019973755`}, {5836., 1.0054136514663696`}, {5836.13143169481, 
     1.01}}], LineBox[CompressedData["
1:eJxd1klQzmEcB/C3ItJuK0JJUSh7IfRmKUWWskWoeGUv4mImdWPGgRkXjENu
GBeXmDFmGoccrKEkIYVQlNKixav+3+fr8G2mms/83+f5re877+ScvDSHq81m
uz7wO/g/6OnVjMpnpfbIzPMPOiJa422DP89L7QN/i8P8jCssl812M35hOSSU
fgmn9bTAryzbT3UbV8K9ncZV4tfiatxX2GX8xnJdUb9xDfJ7FWjivxXXit/h
vNcQ4/d47uR9HyyXVNN1lrOcrOejZZs/XY/8fFlfg/gT7m9gPZ/FX5DPTbpR
/FX8Tfwd82hif5rQv+Ze42Y8v9Vn/EP8E/mm/zVuEbeKf4nb0C939qsd+aUy
/m9xh7gT7mK/usTd4j/iHnEv8nH8Me5Dvx/S/ZhnOef3F/U8op14fQ3zs92x
7v+/Hy6Wy67YzP64it3EQyzbXJ3m/FCxu3iY5awL9HDL9nbaw3KJP+8fYTkk
mva0XBxHe+H1hbS32Ae+QfsinyRXYz+xv3gk+uNOj0L+11yMRyO/0/QYnM+g
x6K+ZsYPwOvr6UDUc4Yeh3jZ9Hjkf5f9CUJ8P3qCeCLiZXB/J4mDxSHiyeJQ
zDuG908Rh5n4zDcc9Tv4eTkV9Sbw82iaOEIcKeenI14i+z8D/cnlvs7E+XK+
36Pge3Q07rvNfZ8lni2eI54rnod62+j54gXIN4r5xYhjkf9j9m8h5h/P/i1C
vOChxovFceIlmNc53r8U+1LF+peJ48V2cQLyaeT8l6M+H+a3Am6iV+J8OPd9
lThRnCReLU4Wp4jXYL7J9FpxKvp9kV6H80XDjNcj/yWexhvEG8Vpcj4d98dy
HzehX0WMtxnzWEpvEW8Vb0O8qXQG9uM++7sdzwvoHeJM8U7sRzbfP7uQf62P
8W7kn+9rnCXOFueI94j3wpeYvwPxEul9qKeC+56LeaXQ+9GPePqA+KD4kPgw
4nnQR8RHxXnifPEx5OtNH0e83exvAeZ9lvWdwPkZ7PdJ+MnAvpR/zQ+4PGB+
3/wHunWs5A==
     "]], LineBox[CompressedData["
1:eJxd2nd4jlcYBvBPrJqtmajRRI1YLWLVaGJEEIQQo6gUoVFKlAohYkYjZqjR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     "]], LineBox[CompressedData["
1:eJxd2nd4TucbB/BXgkQSsWKThlZJaxetUUkpqV2q+qNoUFTN1l5JrBZVYtRo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     "]], LineBox[CompressedData["
1:eJxd2XlUVlUUBfDvQ0UREFSch6gkKM2htCJSUCs0yzSNVFJRwtRMDSlDUwnD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     "]], 
    LineBox[{{7738.144420702451, 0.99}, {7739., 0.9987683892250061}, {
     7739.864615469324, 1.01}}], 
    LineBox[{{7780.067370067961, 1.01}, {7781., 1.0077260732650757`}, {7782., 
     1.003340244293213}, {7783., 0.9965677857398987}, {7784., 
     0.9915966987609863}, {7784.602075832154, 0.99}}], 
    LineBox[{{7799.298498942366, 0.99}, {7800., 0.993202269077301}, {7801., 
     0.993202269077301}, {7802., 0.993202269077301}, {7803., 
     0.993202269077301}, {7804., 0.9922780394554138}, {7804.511402574464, 
     0.99}}], LineBox[{{7836.327255790552, 0.99}, {7837., 
     1.000839114189148}, {7837.596657349607, 1.01}}], 
    LineBox[{{7900.358435103388, 1.01}, {7901., 1.003697395324707}, {
     7901.877818709653, 0.99}}], 
    LineBox[{{7913.47648754402, 0.99}, {7914., 0.991913914680481}, {7915., 
     0.9976035952568054}, {7916., 1.0034695863723755`}, {7917., 
     1.006201148033142}, {7918., 1.008083701133728}, {7919., 
     1.0096217393875122`}, {7919.1030020125945`, 1.01}}], 
    LineBox[CompressedData["
1:eJxd12dY1WUYx/EjDmRooGm2FKREykxtkCtO5qhILcsyM0NyNFDKVMyRK8XC
kWnDPVJa2nChpqAgWjZMclWmmJi9KMcLui5JJTi/+37zPdfFOdfn+v/v57nv
57n/g/j0zD5DwgKBwN9Vf9W/yceK9166kh9MGjC3sLzl+ZRA9acyP1j1HVzi
DhRUe2dSorkGHBby5EC8uSZcS+c3bmauHXKwcxNznZADq2PN4To+vZ65bsil
UyLMEXJ6XXMkHAVHw/VCjkuLNteHr4JjQk5b7o6FG8ANEX+11mNelLmR8rng
9TQOecWCOuZrNN5AdxMdb+S+Vut5uLb5Ovh6+Ab4Rrgp3AyOg+Plk+7myi/V
80tQ/cPdN8E3q/7w+uYW2v98dyLcEk5Sf7Tx/rhF4yeHm2+FW8G3wa3h2zV+
0N0Gbgu3037N9/ruUL4TfH3uhO+C74aT4Xvg9nAH7Ue6uyPcCe4M36v9K6lh
ToGD8H1wF/h+eavvV1f1f4W7G9wd7iEnXjknP6Dxyi+aH4QfglMVX37Z/DDc
E+6lfhz6n7k3/Aj8KNwHfgx+XP1RXGHuCz8BP6l6stz94Kfg/oqP9/mehgfA
zyi/1u6B8LNwmrzyknmQ1i8rYPuVDj8HD4aHqH/HV9p4Q+Fh8PPwC6p/lvfH
i6pvv+f7EpwBD1f8Hq9nhFzk+WXCL2v+TO/vV+CR8KvwKHg0PEb3n5nuLHgs
/Bo8Tl7jHq96E8LME+CJ8Ou6n8V6/CR4MjwFnqp6cny8afAb8HR4hvLf6Pub
Dc+E34TfkiPcOfAszZfh1/ts9WMP9xx4Lvw24ufpeljkfkfrcc49X071/lyg
82O8n96F34Pfhz/QeLlez0J4keqt6feDxfASeKn6O8+9DF4Or4BXwquUT5H3
w4davzR/Hq7W8VPuNXCuxrvoz9OP9Hyq9Pelj+FP4E8Vv8H9mVwWaV6r+pfW
Mq9T/w/2/D+Hv4C/1HgT/Xn5lZzg75Pr4Q2aL9vf7zbCm+DNcB68Bd4Kb1O/
xPn8X8PbVc8h75cdcD5cAO9UfRX/mHfBhdqPy2fMRfBuuFgudu+B96o/Whwx
fwN/C+9TvqcPmr/T+uQdMH+v63dkgfkH9WfZFvOP8H6tX+lm808av+l68wG4
BP4ZPggfgg+rnuxN5iPwUdWTvM38C/yrzq/Ybv5N9UQWmo/Bvys+o8h8XPkc
LTGfgEu1P9EnzCflZb7/f2h9R501n1I+C/81l2m+YX5/OK3+aef9+6fi18WY
z+j4robmvxSfG3c+ZcSO43n9quz/r/4P5GW3XA==
     "]]}, 
   {RGBColor[0, 1, 0], LineBox[CompressedData["
1:eJxTTMoPSmViYGBQAGIQfXVxga0Xp62DZkz/oa8aH+wZwMDOAUg06CrD+PYg
PsNncRjfAcQ/UCYM5TeA+Q+kuGDyjiD+AhF2mDyYf+AoI0zeCWyeDozfAOY/
EIDLO4P4Dr8ZYPJgfkMjjM/gAuInVMLlwfwHEXB5VxBfwezfe6g8Gp/BDU0e
jc/gDubLweXR+AweYP8wwuXB/IS2XzB5T7D//L/C5MH8BbPewuS9wOadfgqT
B/MPHLwDk/cG860uw+TBfIbjp2DyPmC+1yGYPJi/IHw3TN4XHB5MW2HyEL76
uvf2hfrMO+Y0+jqsc39YJQLkAwBNaHKH
     "]], LineBox[CompressedData["
1:eJxd2m2MXUUZwPGhLbKIkEtCwhKJjkDMokavEM2CLx1fiJsAyUVeutIWB5B2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     "]], LineBox[CompressedData["
1:eJxd239M3OUdB/BvldlTqR4OJzHorhOVrbheLbPMEb2tZKUG3a02G07ivlFU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     "]], LineBox[CompressedData["
1:eJxd2X9o1GUcB/Cvc+qyWUM2XDH1qy6YsGDFzEUjDxwxdMHKoaOGHTZzxNAr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     "]], LineBox[CompressedData["
1:eJxd3X9cXmd9//FbmsWIiCki0jTibb4xw8hiliEyRlNGY8wYw4gpplm++d5m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     "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQnbhw3qHfbBscNGP6D33V+GDPAALsGxyApEIojM8B
5i8QZ4PyOcF8h0JGKJ8Lwg+A8bnB/AeqMD4PmN9w6vt7CJ8Xjc8H5ie0wPj8
aHwBiHlNML4gGl8IYv/2r1C+MJjP0PkFyheByLd8hvJF0fhiaHxxNL4EGl8S
jS+FxpdG48tA/JMHc48smH/gCcy9cpDwfvgTypeH+C//F5SvAOEzwcJfEWJ+
GjuUrwTRf5r/g732BoPEF0qI+AQAtMd8Mg==
     "]], LineBox[CompressedData["
1:eJxd1MkvQ1EUBvBnjJjD1kI3Nc9DjW1NNc8zLVVqpqh5qGIpYW/DH2Ahkhp2
YsOOnY2FvQUWNsTUd86J5HvJey+/3Dd8956Tq7E5Wuy+iqJY/k7v3Xke49yL
PzEmmPev3+NfDYr3SDgx/l2vnrXsRNXG+0h2kuqj8wh2Mj2fIk4Bp4LTVCtv
Yex0cAY4E5wFzqZ8W6HsHHAuWAfOA+erdt/5swtUxy75sAtp/h6FXaT66enn
hVwM1oMNYCO4hHwmLgWXgcvBFWATuJJsEleptp5+s6upXhdf7BpwLbgOXA9u
ADeCmyjPgbgZ3AJuBbeB26l+IeIOGr/9YHeCu8Dd4B5wL9hMDv9kW6hfXOI+
8qe4n/rHLOttpf7bFQ9Q/lKpj43efxcP0v/SpR+HqH7aALYdPAweAY+Cx8Dj
lNdP+n2C8hxKnknwFHga7KD8bvEMeBY8B3aC58EL4EXwEngZvAJeBa9RfW7E
6+Q4WZ8Nmq8+kO2i9XwUb9L3HoLYbqr/ZTB7i8YdUext2u900ewdGvfuz/fH
Gk/gzv/+/QsCD5U0
     "]], LineBox[CompressedData["
1:eJxd3HfcjuX/x/HbjmSEysooGdkyMnKH7L3SwE1WQkJGyUiysmXHLXvL3pvM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     "]], LineBox[CompressedData["
1:eJxd13t0z3Ucx/Gf0W0oXdRc2yKRZCmXIYaUdCGxJDFbRiVzKbUhq4hKUZRS
MqUbUS7DujD7zx9O/luF/MyQEXKfmdm+r+9r53junJ3feZzP5/d73z6f729L
SMscNDomEokcqfqtfl0TV95hSFFecpvh8wpPtz7eM1L982decvXL3gah/woc
XV8n9N9yaST0zsC5ByuOybv0/p32bq2n2/8EziktD70ncHKJHdXnz7H3an/K
+dDF8q6y0PsCx++wSxQ//2zo/Voffyb0gcCpSfZB+F/4EFwKH4aPIN5/gQva
Ob+jqm+hfQw+rvc3dL3/wyfgk/Ap+DR8Bj4Ln4PL4PNwOXxB80n0/CpUf6ML
oS9qf7bPQ6XmX2hHNlzuWoELonZM4PiMytC14TrwFfCV8FWBU7Psq7W+2r4G
joXrwvUCR9v7ftSHr4WvgxsEzsmyr4dvgG+Eb4IbwjfDt8jbnH+c+j3ObqT+
RC+Gbqz1Vp5vE7gp3AxuDt8Kx4f98LwTFP+AfZv2D3R+LQJHYl1PS61n2LfD
reA74NZwG/hOxGur9QrncxfcDr4bbg8nwvdoPvscr4POW2Wt0Pcqn7SY0PfB
HeFOcGe4C5yk/re0u+p+xtrdlE+S8+kO3w/3gHvCyXAvuLfOR77j94EfgPvC
D8IPwf1U/yz74cC5fzh+f+1fbj+ieWXbj2p/P/sx9W+J5/e4+tffHgAPhJ+A
B8FPwoOVzwx7CJwCPwUPhZ+Gh8HPwMOVzxQ/L56FR8Aj4VR4FJymfo7y/UhX
v7c7/nPaP93zG638dtQOnQGPgcfCz8MvwC/KKz3vcTofK5zPS8p3sT1e56vY
34eZut8p9gTlX+nn4UR4EjwZfhl+BZ6i/DId71WtJ/r5+hqcBWfDU+Fp8HT1
Z7Djva71Vc5nhtZL/PdDjvozwX4DfhN+C54Jz4Lfhmcrn5rvnzlaH2m/o34l
OP934feUf00/58Lvwx/A8+D58IfwR/ACeCH8MfwJvAj+VPUX2Z+pPxHfv8V6
Hh/1/fsc/gJeAn8JL4VzdZ+LHG+Z1ofZX+k+xfl8fQ0vh7+Bv4W/g7+Hf1A+
6b6/K9Svpb7vK+Ef4VXwavgn+GfVu8jx1qj/+13/WuUz3/mtU7459no9TxLs
PO1vbG/QfAs9343wJjgf/gX+Ff5N9ZxzvN+Vf2/nv1n51sxzi1xmF6j+jq5/
q+rJr+rP7oLislNV9v+rlwAoud+s
     "]], LineBox[CompressedData["
1:eJxd1llQjlEYB/CvQrY2S9m1UlpkK0l9ny2KQoiIFlLWsnRJ3THjghk33HVr
htu4MKYxIzMqZE1CshRFkfblU+///G/+38w37/zmnPc9z3me57zzBuQVpee7
2my2O6P/sWtGa2Jh2pMKR1jW1YfdoZ1229ivusIxdukJNq6xXB7ha1xruSzY
2/ipZf8Yd+Nn4ufiOsuV0W7GLzAeSL+E0wc64Ffi1+I34rfievE7y02lw8YN
2F89/V7cKP4g/ij+JG6ynOPk+p+RXx+62bKjpN/4C+L16jP+iny19Rp/E38X
t4hbxT/EP2X9Nrh90Lgd828PGf8S/xZ3iDvFf8R/4SC6S/wP9UplPN3ov3C6
B37M+HvFfeJ+8YB4UDwkHkY9q1i/EdSrmnZifgPjs9214neyH1zErpYrE0aM
3SzbXJ3G4yznXKPHW3Z00RMsl/vYzPlxF08UTxJPtuwfRU+xXBZPT8X8C7QH
fIv2RLyZLsZeeN5F2lvsI54mni6eIZ4p6/kiH+2Mxw/zm+lZ2M8lejbyn0vP
wX7uMZ9zxfNQnxh6vniBeKHYXxwgDhQHod6NdDDszXhDMD/J1XiReLE4VBwm
XiIOR34K2J8R4khxFPJdxfO6VBwtXiZeLl4hXon4IrneKtT7Ch0jjhWvFseh
H+7zvK1Bfh/R8eK1mN9CJ4gTxXaxA/mqYT3X4fmerOd6zLfTGzDeRm9EP4aw
3zeJk8SbxVvEychvMp2C/F6nt4q3iVNx/wM6DeOx7J/t4h3ineJ08S7xbvEe
5KuU62eI94r3iTPF+8UHxFnmfcD1D+L9k8vvlUMYb/Q0zhbniHPFeeLD4iPY
/w3Gk4/xJPoo+quO/VUgLkS9UuhjOA92+jjG4+gTuN+DPik+JT4tLhIXi89g
vVT291nEk02fQ/4vc3/nsd9w5rsErh39nqxqLfa7OWp+v/4H2szV1A==
     "]], LineBox[CompressedData["
1:eJxd2nmcTuUbx/Extp+tsoQSDZGtTdYsmYSRLBlLhEyifqSkFFnHOrbJMlR+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     "]], LineBox[CompressedData["
1:eJxd2ne8j2UYx/Gfc4zDsfdKh1JURkKROA2JaGiSyoiWUMkqOUYlVFpGg0NZ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     "]], LineBox[CompressedData["
1:eJxd2XVUVUsYBfCLrYgY2PGwu1sMrAfY3YEi9jMxUJ/y7MbATmzF7kDFxkax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     "]], 
    LineBox[{{7738.144420702451, 0.99}, {7739., 0.9987683892250061}, {
     7739.864615469324, 1.01}}], 
    LineBox[{{7780.067370067961, 1.01}, {7781., 1.0077260732650757`}, {7782., 
     1.003340244293213}, {7783., 0.9965677857398987}, {7784., 
     0.9915966987609863}, {7784.602075832154, 0.99}}], 
    LineBox[{{7836.327255790552, 0.99}, {7837., 1.000839114189148}, {
     7837.596657349607, 1.01}}], 
    LineBox[{{7900.358435103388, 1.01}, {7901., 1.003697395324707}, {
     7901.877818709653, 0.99}}], 
    LineBox[{{7913.47648754402, 0.99}, {7914., 0.991913914680481}, {7915., 
     0.9976035952568054}, {7916., 1.0034695863723755`}, {7917., 
     1.006201148033142}, {7918., 1.008083701133728}, {7919., 
     1.0096217393875122`}, {7919.189076391372, 1.01}}], 
    LineBox[CompressedData["
1:eJxd13t4zmUcx/HHChtTRkZHm2FWqCZNNe0pUplzpQNpJqaaJtEJGVIqx5xP
C0knx9KMtLEhynERlcM0h/4gqy51UcP2fL7ff97PdT3Pc72u+3ff3/v3vb/3
/bt+selZPfqHBQKB0xXfyv929Vt1PX8xP5jQe3LhuWZlKYHKz6X8YMVvcL47
UFDpjQnx5iohB2fEmcNCXljWyHxFyNmBWPOV6h/d0FxV/ds2MFcLObAkylxd
7eNqmcPVnhtpjoBrhByT5q4JR8K14KvgqzX/qTXNteEouA5cF75G42e464Vc
8meEOVr5m17NXB9uEHJaH/e1aq/nvk75PVbVfD18A3wjfBPcEI6BYxU/1eM3
guN0v4PcjeWk6uYmcFOtd9AdDzeDE+Cb4Vvg5ojXAm4J36p8T/P53wbfDifC
reA7NH62u7Xymey+U/U8wvObBLeB71L/dPfd8D1wMtwWvlf5ygszp8BB+D74
frid6qG4irk9/ID2R/zFs3IH+EH4Ifhh+Vy5uaPiJ7tT4U7abwP+M3eGu8Bd
4W5wd7gH/Aj8qOoh1v0Y3BN+HH4CfhJ+Cu6l+C3dveGn4T7yov/Nz8jlnr80
uK/y39rXI13rO8HdD34W7g8PUH0Pv2TOgAfCz8HPwy/AmfKwgNXfINX/LPeL
mk+ROwseDL+k+//LPUTjZ3l9vwwPhYfBr+h8GO9+FX4Nfh1+Ax4Oj4BHwm/C
o+Bs5au7ezQ8Rvstyj0Wfkv5Cvd8jYPfVrw1vl7vwOPhd+W+7vfkCPf7Gn+b
19cEeKLmd9breRI8GZ4CT4U/gKfJqR5vOjwDngnPgmfDc+C58Dw5x/fzfHgB
nAN/CC+EF8lFvr6Lld8SP/8/ktP8+bZE15e6P9Z+Ou/P26XwJ/Cn8Gfw5/AX
8DJ4ObwCXinHhZtXwavhL+Gv4DXw13AuvBbOg9fB63U+x7i/gTfo+bDf98e3
cD5cILf/17wR3qT4F86YC3UelJ8yF8Gb5S3uLeq/+qR5q8b/+5D5O81/sHub
6qfpAfN2XX9in/l77f+1e80/6HwdUmDeAe+Ed6lej+eZdyt+Sa55D7wXLoZ/
hPfB++Gf4APwQfhn3W/SevMvys+FDeZfdT81Cs2HdH1mkfmw2pftMB9RPg8W
m48qP6We3xKtX+RR8zE5x9f/N10/9A9zqeYz5x/zccXP8PPihNY/0d9/Tqr/
8trmU2rfVNf8u/ovjSlLSWyzJzqzwv6+ehmdwb7b
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{4000., 0.99},
  ImageSize->{1060., Automatic},
  PlotRange->{{4000, 4500}, {0.99, 1.01}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.538218243837807*^9, {3.5382182788286686`*^9, 3.5382183076247187`*^9}}]
}, Open  ]],

Cell[BoxData["\[IndentingNewLine]"], "Input",
 CellChangeTimes->{3.5381272031263576`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Re", "@", 
    RowBox[{"WaveletPhi", "[", 
     RowBox[{
      RowBox[{"CDFWavelet", "[", "]"}], ",", "x"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5381272137962103`*^9, 3.5381272464125404`*^9}, {
   3.538128028044215*^9, 3.538128048314803*^9}, {3.538128106544433*^9, 
   3.5381281106389275`*^9}, {3.538128143395903*^9, 3.538128155363966*^9}, 
   3.538128784430475*^9, 3.538129107034097*^9, {3.538214888656041*^9, 
   3.538214957243558*^9}, {3.5382150339070916`*^9, 3.538215102251606*^9}, {
   3.5382236828866825`*^9, 3.5382236888734922`*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQBWIQXfvc99P//8IHGKDgWbXY19t/EHw/gfvft/9E8BUs
C/7mf0bwD3VN4njwDMHn0Lsud+Asgj+lJMG7YTaCv5qxeAmDOYLPmupuJBkr
BOcL3zias2iiIJwfdHhWsuYpAThf5cqTe8ePIfjfnuhFpR1G8GeyHQ5YvAfB
f+D52lZ2PYKfe8FaQnAKgt9x986ZH7EIftQ7NY/pUQi+zv+Cw6bhCP55BdZd
RQEIvliK7vI3Tgj+4le1jQ/UEfyS38f/1Kkg+G48QhWyigj+K91leVFSCL5B
4bnoKzwIPlOTxPUiTgT/yqSkIEE2BD9SXuq1MzOCDwDPE27+
      "]], LineBox[CompressedData["
1:eJxEVnc41m/UNx+bzMhPWSlCElF4jhURkUSpyBYlqSR771lIioSESshoyH1b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      "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGDQB2IQ/WpR6NMfLAIODFAgd+H5DxUOBD/obyVPIDeCvzt8
nvFKQQS/h+d5Y6Qcgn/AsnJqqyKC/yWNe+VGFQQ/5qD+BU5tBF+3rEJulzmC
f+4+526pQASfiXfOObcQBN/MSu9RUTiCP29KEOfpWAQ/33N2eHUWgi+wWefL
7WYk/7T5687dhuAvi/zguXMngv9TZ2La1T0I/oLLl+bzHkbw3yqECdWdR/A7
dsd8j3uB4O/7kHlQQUoQzteKbgldUovgX3vGuWhyqBDCv0lPHYXkheH8hyzL
f0xVQvC/LMtYL6mG4Eu+fi2jqIvgpxR/+q5vjeD/av6/1jccwVdbKinV2Y/g
W7rfvsAzGcH3eTmnfcI0BL9QV+Hr9LkI/p6taheWrUbwg44Ztx05juCnZny1
8TiN4Fdwbf98+hyCP9fPKvHyVQT/xTUHm0ePkdxbwfQ59TmCzyt9ZOXLVwi+
Uby7+MePCL4rI+e5kq8IfsTiUy0/fiD4Wa491jV/EPza576f/v9H8AF2oqBk

      "]]}, {}}, {{}, {}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.5381272181795855`*^9, 3.5381272468181195`*^9}, {
   3.538128038288212*^9, 3.5381280511293697`*^9}, 3.5381281112161684`*^9, 
   3.53812815598801*^9, 3.538128786411828*^9, 3.5381291074241285`*^9, 
   3.5382147836640615`*^9, {3.538214903879067*^9, 3.53821495820496*^9}, 
   3.538215250880855*^9, 3.5382236896066937`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"dwd1", " ", "=", " ", 
   RowBox[{"DiscreteWaveletPacketTransform", "[", 
    RowBox[{"data", ",", 
     RowBox[{"CDFWavelet", "[", "]"}], ",", "3"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.5381159675033255`*^9, 3.5381159773481874`*^9}, {
   3.5381163816405907`*^9, 3.53811638204631*^9}, {3.5381180984469366`*^9, 
   3.5381181243429365`*^9}, {3.5381182554609365`*^9, 3.538118262636937*^9}, {
   3.538126488719428*^9, 3.538126504570552*^9}, {3.5381265696702642`*^9, 
   3.5381265781272774`*^9}, {3.5381270995848465`*^9, 3.5381271215652943`*^9}, 
   3.5381272514678826`*^9, {3.5381288041944084`*^9, 3.5381288053020935`*^9}, {
   3.5381295542595463`*^9, 3.5381295870799007`*^9}, {3.5382151822123384`*^9, 
   3.538215193242357*^9}, {3.5382152591332693`*^9, 3.5382152942977304`*^9}, {
   3.538215394195305*^9, 3.5382153965969086`*^9}, {3.538215941475049*^9, 
   3.538215942489051*^9}, {3.538216111689146*^9, 3.53821611406035*^9}, {
   3.5382161537596183`*^9, 3.53821615488282*^9}, {3.5382163961630316`*^9, 
   3.538216403944645*^9}, {3.53821648328578*^9, 3.538216488246188*^9}, {
   3.5382234225458355`*^9, 3.5382234229826365`*^9}, {3.5382237011159134`*^9, 
   3.5382237036331167`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WaveletScalogram", "[", 
  RowBox[{"dwd1", ",", 
   RowBox[{"Ticks", "\[Rule]", "Full"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.538128550867302*^9, 3.5381285652032104`*^9}, {
  3.53812863364672*^9, 3.5381286396843843`*^9}}],

Cell[BoxData[
 GraphicsBox[{
   TagBox[
    TooltipBox[RasterBox[CompressedData["
1:eJyFmvc7Fm4XwB+rx96jrIzsFAkR5xghEimyUkb6FkmR7Iw0UNkhs22GJCKJ
7Egie2/K3uvx+g/eH+7r/Hyfc59zPp/rugVtnc/akxMIBLLdQ6QkEOLjV58F
H8lGu6qzyotDkfiuT8/B0+MTRtoK1VI75+Lrjlv9sr9cMK5LRa4xWBIbl/iu
3H/wF0w/HQFOh2E4J/Xm00gNGVofJll1vR2ECpe68Jcf9+DjCpODQqXj0FcQ
IOTkuwlKiT+XFbLIUU46w5/AswJoekIyXJID562ctZ6akaDOTvtfQS8dyn53
ci/U4UWFV3IlT0KO4KvbbNKFSixoRnPHMaRMBINa+05yKrBg3FxtE/svIq5G
qxcqVmdC3O9HqoXbI6BP07Dj0C6Nup/fC0wkiON58m6Vu2pb4H7pu433JgPW
yobdLiOfBHILRT+ysg1QFmYtm28VwEA/jht63Zw4QS7SmUZJhgtdbJZrglSY
qKnHk0xDhy7yCerh8sJ4YlS/v7p+E168+hvbQkaGPevbljw5DChkXnq37z01
tupfanfUJmAfJKn9q6fFxow0E+JJCbzH+HBdjJkcy+OE7Io6B+ELhbmGXTY3
ph2PPcWTxISNwyI87JJcuPDH82V7OD9qirZKr5rtxS8lT2kKNRdAZVYpIHRr
C8Ie7ly82iCKXlNcHkyfF2DJRiemjIUOBwPD83my6JHnUZm9nSoXyorGOw/c
4cSELaqr7/t5sazJL01DjBZlyVOPuf6mxOeW9ILV9ychdI9JZ/qzXhC73j2o
lEqORrX/ZZ/qnIKsKXuNtncceHBUe1mKgxuF/C47mr4lx0mP212s4j8hVzZ2
GnUnwJizPqrVlgmdjJVVVmcr4bjjfQ9Tnb14TupJc+AIF+pKGzZcH1iDd08U
/7C/IcfAFhmymtdE9Ejp0mUmbUPTgxHPSNtWIPaZ6Oe+HITEkJ+M/qc5sTZM
qNo/eQWICtwf6g4dxmIW8ZzFTF78LDYzFCbPg5c7XpYOajCjS3GOaKbHPqx2
UnYezqNC/4OsJ26sTUAgn5mFkeI8uB3Qc71x/SDqtS/I1axFgKv4T9K8ahuc
+Z5Cpue1AdcODc5fenIEzT7LRenduYyPc3+5pKQFosN5Z90EZm80eR356XTN
FfyoGkMz13wL73by8uT72uC0fmmw4nnADpqFo9FX6JFumI7lsa0LvqqtbI/k
0cSxiFuRqVRGaMkzW0b9kAU74pnpihgF8YyrAPuXG8yYN/c2R0qIAhMKqasl
LnAgg9R1vV73LTjoYl7bI9oKV46uTHRJz4P8syqxqbPfIW55P5M9CxPeS2Hh
SHhCgaOzLRbquhToUO6pyjy6CLELvLeWW5jxSzRGRCrQIet/M0cGOVhRL/OQ
pOqBLXjdIv9sapMbl7tb/PfldcCHPmXhrx6M+Cs/kOlRCwm4d4jlfTtUOP7Q
v3rQuhnMvm+wPT28Bp60WFj4mAr9NKbuXIzrgmcfT8RUJA+ApU2flavAKAy+
25r+4rQKd341pf+12YGEgLN0RjrkeP1fg2rVxDQ4q7Q+aIiiwB9MtJma3/Zj
ukBwqrQXIzapJwWqSVJiuIVtvSLtFry9Q+ZKPjUHd4YPvPRW6wVZh5Hkq+R7
MND8zRKfrgiyiT48za3IjudmD6bfuNcHrMzKp4KE50Bx6+tLyglmbN0h8A2a
sGNMk+aNW1bk6HbtnWClODum3ezkvRvPgfQtfwlpM8yoUCf1K7dvHzI9rZcu
cmPDR0Ujd4Y6tuDlj7ZT5i1b0Pes2f3w2UlIoxbyJX2mQ1u70bw6NzI0rhF+
9iqeEtc7nv6ISRLA0406361KmHA5sD3qYvI3aHnvRSSfX4C11TPSGjvzoP5V
8FJhzjJkdh6be862BAccVD7h2A4wtZF3R/IugkFS+wYD/xTcUF46URdLjU6l
RA9rvzmgkrDnVs7Zhi2GXBXWP/NgssfRj4diE67uDWOoLtuEJdPbMzWdFNhn
HvjnbMwg1Cqcn2ueqoenBL+5V4F/oXc97R6d7yr0BGvIeJNJY7NIg+vJEFos
2z/6wK2cCsH3pP+S2ySkH7Uvtm8+ie9cxGV4Fa7gjHxH3pSPM0YpmD7ndlfF
suDgF2W8tCgUdlw/XoaA3XU6QZ1Bv4DhZKsSq8QIpJSYzEo2rEKSi77cL602
eH1U6/Udp3zQdtcb4CSQIUfwq3PKxHyY7r0xZM5FRJMb6VRstIqofVC2Ktjg
CkY7H6e9X/gSBzffXh71jsSwld6ToGiClqSrCve42ZD1VUNcV/skTDz9N+Fh
XQId6ptu+m6dwM2oVmNEqoES037FcXYS/DRXEnW9TYLn/aemotabIIHWJpFv
7zCYK9wdsjo4DNRZov1gQIkCbCaKx99+A5VvddRrG2sg5CW4Ws3VAQeJjWQn
4kbgaKGNsnfsIshqnX1C0bubrzNXQno/foO1s93De0tJkG8j4phiS43b45tP
ZqoIaEZ2RWfWtxWqC5P+I1C0QIlNzjmzIQLmTV6e0JWoBDNK35ILB6fBNcy5
WjV1HU6RTbC83J23CYUtb1ykeiA8/cDozVvbINGiAn8M5FCSRlHP9DwVSo+O
qTG8noF/qekPNZbbwVrhU5JLxW+odw8T5jD8CcZl1wclPs2B4wez9/ps6xAo
3H+egY8bFfzOU0YZ7wDPiJ5BJHEObheeHaP8MweU6srZhx7PQyaLDFls9TaE
xr+b/K+BBMZPVEovt0/Aj4655Zq7bBgsnBccmMqAnYSfivmUO1CyzMhlNSSN
Y1y5T1uyj6BMooYO3U8JrLNiv/WSRhH71yfoKLfkcOrmF/IiwU242M/x7/gJ
Clzk4n42MTQHvS+cZR5rLcIJ1RXaDzN7UPJGnlXKhVYYnjTPfx/EjPzPj9lv
x3FiUE6fjpTeAmRoU/4pGBkE3UPZ7zI+lsPq40d33FlW4bfRpztbtnRoGFOe
ULhNibKXigb2h0/BpQKXsOaDy8CexXjDh3sDgj/T0vFX0KAFBXW4xdMcqJJx
MTzGS4mv9VZtz+1fg4OrIt8/C7SDne9UK+EFLWZQr2jLC9HhydVDP8+n0KL2
Z+aY0jAZPGOb/Kmclg/3kNGsaO+tA5YXB88WnWfGGsXU6y0LO3BF1nRWv6EK
5B3a1udfjkBc4tBgny4D+osgjy3dBswckku/Rz8Mr9vm+N7WToELcbs3uWYd
SG9PtDY/GoGRAO70N41E3FIx2GBSW4W6Pq3h5f4dOGjqGp7eOQQTCv8Ei4I2
YFM7PaTImxH3izD1FeUQ0e16yWaAFRc2Nyc5d1mexu31Ge7w32x4iMczc/QC
Ax7Nyp2mTCSg9vR9Ke7SXjA7c6TIcnEP+t7tmOm9MQ+ztPvW7pNT48zg80PT
RGr8KS7L7iG7BbROh98k2HUAq2evnUrpFnB7jHye/sKBKlcflhFDzqJRyIhr
d4sSqjJ4lh0rWYXG6MgRpvNrwPLb1+5r9g5Qe7Z5jFfWAgoMl65QNoMFJfOS
eLckJkurnCiFVRDUkJhnYGgBX93fHL+j6TCkd/Zd4ywF8sslJCfIzMHYVWr6
9dM0aNZFFtIpQYJZ8qQKzXP0qNjEKxgxQYZsa9uqRNyAlK4xTSHbdXhOsKT9
/R8V0sgIicdUbQL1fZ75MuEFaLkfd+iy3g40tSSX3HJcBdKhXzz2/F1Q/V6g
3MurHzg/qqyJa5GhYcICg6v0Agx+1HvD/4oec8JzmXzFCHg0gf2iLKMcijIq
/tHpZ8Z+AarM8YwNUOc4s3dahxVf7OxjU7pGjlp9Q6cjU5kw71qIJLXHCvjw
1L/uNZoFX50knZsmatjimR89dXEAPliI9zlcIoF4vOCa8ksKrHX/qPVxgQzn
kiz38U4Mw50CkYzQwQXYF6cI2gfHgP/NaTboIsf4s1oig7X0eP1MF5duvxg2
VqjcNJ1hxIqthhtURGGcG73wzqxCEf98sJPML2FHARcGixJuTlTZJ3L33jUy
9H1iHDVbSwI76kpxt7FI4E1sP9h/pQXy2x2+WehsgL/K9/nL2RMw6ZY/UFxN
gWE37e/p2tBjt5X11fxzg3DVStA2a2oC3FJThwOHJDDoh+s2V7MMGjeK+azz
c+F/a8ExRc70SJ56o9P4JAVSUo5fc+rKhjxz1T2sxgVw3WlBPS59BDLIXw2F
d02BouQJh1/zS2B6KrfHJ28I6nkXnhsZLwAhUKvXP2sSzA6pNj0QZcHr/nb6
MgIrcNP6R/SJegacqDjaHrFEghenmd6vXiNg/v35cDOXIVCZKVW+ubwJsqv3
bo9xUuGHrrv35q/8gtQd+5yB8xyYFm6xOdUmg4lDT3jlOm0xrFlPqGc7GDdb
3wQVNIXjSU7iP9/P1uhnffG7jfEczC350870bwItGeWr3+fIcEScWsDOZnKX
752pu0idwHex12HOdXq3f3gfZ0b8hbkfoR71xrnwrUTs3qHeATByK2NfpO+D
RCPPpmeh/+DzeFL5yc4JIDw7uykr/BRkowwsEg3+wgExdtKyXQ9oVo12lGdQ
onZy6mu319sQEjlwnYJlC6Ief0r5fZ0To3ucjjCcokTDl29PxN3mQx7XRSsX
9X34gHt1ekNfAbV+ld2R+D0HTBMj4jOpW9AYEiS659s0KFZbXBpTGYfQiNfH
SPOUGOBuZ3agnwovXfrLWVpGwGrru+lBvYuQRuqzJvtJht39j8vcuBah1D/3
TcBlQQyn9H/b33YWpz8eKxH+twTTcb/G9b92gdmKw+9l2VLQ3SHWSdw/ho2X
b5DPJe7Bs8KneS9lzUPT0kPNGfZ62Deyd7+fVjmErK6F7U1iQ13eM+eyC/ag
4dng4ZzkQYgJTkjuV1qDaf+vjUMr23D72LV669LdPmsq9Ag3aACllI7giUoC
epRer6r2pcWdnYtsYx/mIOC0pjNl4jLMs3dnuSYsQd1rJdPFNCJSWYxxFtIy
4Hz7ls/cfztAq79RMtk2Dlptq10jYdT42sPA5YX4JkgNnK//L7kdxCZtnFRe
EdDiqdl7gvQSxCqQVTUF7oDnp4eNEScG4Keln9t/0XvwVb3Tjg+VJOqHJDwt
7D2BV+/fH1e018DRmKckJel/MCNfkmNmzI89jozDk9PM+CJSq6YlnAp9HG1b
y1z+Aa3w8z4jWQZsZtU9QiXNgxsGC6Nu1OSYPExjtzK5DNOkrMQpb3msu28r
qqtNgbo6ht5NPfXgKzFBqmHfAIPyA+uHSuagONAg4+7NHtDiZjCpjvwEywP5
rc4GJOC0zBeUDdvlUXOL0untcVi7556+b20UvgxTdJha7XLakhvFsw5alFnO
vJl0rwPIRSqrFSp38/Je5GG7yhzkhBqaJfOzocxrA9U7RAH88pWYorEihOaT
GTPFrpcwVeqoiNW/Y8g5EHlXpzgY2SKKZU3uyaPzd+JWGY0hhkbfyShjvIcy
JtapHGcz8Ztky4E/T/NwM7/yV/7fALSJsXjy/DAtfjfPvCUbzYXnWT659epN
g0h9Xnnsxy2QF5a6NlTFhK9C2FI8ngui+TX13oc3jmLD50G/iGIuFKQUH7q1
6/F3X33//F4oEsUDGLudWu+jyeVMzfL8k5iwInBu7o0C+mRrdJ55aYV2UZev
HGM8icfsGzzMfymgIzlvawLfErx7RJaOHdNgmZs7WFu/69tHBxKGSYKoGFt+
oZOOAhk6VZ99uzwFvOF7K2PcmDCZUjqkT5ACyeHRze5X0+Crykme3T0KYtQx
tXealuDxdrifeQEZymgOpWQVLMNk8G1dD9p6mOBqH1zJnYc3d9bfG1z6BztN
uTM/xZixkKQfEZ5QCKVSQwS2LVP0K0nOOjD5CFc95y33fgrCWMuiJ6cvWyGr
gFXAd3ox5LFqe2YENZDhcj7ea3fviVUvFMQZ1YJzs0+Af/YYpOWF0vecmoIy
3n08mgE9UPgQSRfVaLDl2soFI28qNFjiaeL6/RLS4n5ojMnT4wB96gehq0Rc
ihuMk6LfAvrS4o51axbcf3CLxYaGBTVrKop0DMthJYdysHW6HGwpXgv4NNeD
XNgDVymaVVAA+vy37ly4S6g/1YJmYL5CWvRHyDrc0F+5ZOXZAfGfjDi5DQrB
J2iDrm6ZFfduyM8sfiAikeXF69ZdXqbKTvG6O0SCeyzOZ09e/gGMAR8Efmll
QkWUT6NuEhna8of8Z165AYmPnqyyb3aAamFU2/XZCmDo8TMJy18At2bisUnt
JqDtvSBntdgFRXOvg6m/dwPxY8G2Z+xHeHFuNq9abQUiXgQqeO/pho/qDNUy
fIwotbps2sJORHb74Gu0rey4pNptIRG0Cr4P7LgKY1jxQpf3tztBAjhcOdQq
7TIJvBVh7WzkK6DBPR0eaM+Ovu43V47GcGNVRONfDbcqWNA+cilHeT9e4bul
HymyAs9donVevhoGfa/H7DztPJhnXH3ZQdwbv1+40Ru4VIG+fziYJA77Iq09
M8NbKmoUtZf+EmsphUeqWSr8FDiw2FCigQA/QL1Vkj1TiR+LrqVx1uxnw1GJ
ioSIgnYgn4+5wHidDPVCPseGPRNAmxen9Jd+E1BjVeyinz8rLhP8NY16BXAq
hb6E1pwLlb9miH8UJIFD2Mqo7AkRJKyIG/UzCmJo1hUGOaktGPxhGuT2aAxG
POVvxH37AEePFQwYtu1yg0nOxVgCJ0atrTL/+E8NuSnM5BeeuGLiAdemN8XR
+E47m2tn7Tn2S0w5OmW4ISHC7fOGx67nbFbaFyvyoZKwrkl4MDOaokeMsQIb
Ptt/7rRQUQeEfGv+QvAUwHO6pwR4GnYgXSN9n8AKHRqIRCgqVi2AoH3gyfzd
Of4maFxIK2sNkruPx7sKZ0L4s1PkYVpsmCWfYBnxexAyz+hhwpld37bfaKTw
3oIX1p9Ld5oZUWLAqt25lhufqtjWcqkPwwADlSOBcxvSfEUV3B72wHce0fSQ
Y9vQwTxfpSW2AFOcg8XdnatQyvF59t4V8l0+2jnSnc6JFlo5+weFNmEfC/k3
3XAKNI0fteD8uQENibZHPzgyYXlzRcMoJSM+aZ34lRRAhXYjuYtHHqyAL2Ru
If1nqOZIsVCm2wIflYclj2wI2LRxtHd/wRLIa+2lPeUliVeMdjx5TLdA+Zmh
vchPSuQO3ao4UkfABx2re6bWV0CTRHOAa6kW3qi2KV87WQ98qWT/zjuz4FT5
2dI6RiIep2yXMozZAK1TiddOBo4B7+CwKcM4C+ae4DWbU5wAq/qvQv41y/D7
YD3PjAId6uh47Z8VzINw0gJHdJUE8jrQ0I50HMOhsnPT/j6cqF99Mcix+Ar6
CfHHadPr4AINWxXXXx4sCKQY/LElhPs+LfU55IqgvEsTtw7HGBQSKfkqxFiw
vPK0UmU2C6pym+kYIBXy0W9mhu/6XlEzNiQukWOrE81k4PlFCL5qzuYdT4EH
nb+56/vS4XTBmWZDIiXGNGnXVkZSoM0h3W9j9zeA63bwPBUDK+pXhLRa7bHD
GKPTImJBaljWb+sz/5YJk+I4fh7/zYjKnEWf16PbgcXuqiB94gI81wJ35okh
KHvwg8qhkRpdZd+IFBWz4JWEpjCLEgbU/aO08ZNnHH6oTts+SxBBLZ2de15/
zJHviK17CzEAW87yF3e1eiBdSmv0cXcvrBO5yqSSbISSCfSZXM7CyDKeVHWU
bRHcOVKzo/f8gRIebwkpJS5UW7j61vIrN25OHjb0jhmEJhIx6bFnJxAnDLwD
eoWwj9+q7flpOsy/+ADHl8Tx3A3P4zuBB9CEvtb4jWwX1L3hm/b8I4zbEw8s
dUZWwFp9P19fpzCOGg49dZrlRde65vLvu556t8twI7DqAvqkUjQMcjvihumD
qxyRsljPUPXP/301RMvcC8xyjIMDIrcM4h/EwOWyGOm2p+TYuEbyclVmxxan
TLFbDRLIeq+WX0dSGOO3dotkswGslaf+qvtsgdIl0aowAyqc1PkRZqEwBu+u
p+09n78MgoRLWh8eMeNz6Xg18QA6/BlYOfxscQcuJxusvvCgQmrWUMNfFFsQ
wjRTHRgyCkWRCVJUev2gGfHbZ+HHKfwUdkG+mEIVhdZnO8n+Y0AL1pHDj8Vn
YWmKv32mgAvTsrj97ymeRPqvDW3n9A6iU+uLgDTtUcgCSvO1UgKyOFi4cOit
ghwU63Dd74CCP05fB2InYbhnpqzg/l949DfySN7xReAWWmY6o7gG/C9lzYMO
tEBCaEA2wYEKy1I9RgzZfwNHgQWLtwozHnEpDHi96yc0oZf/tB6jxvdMx94u
/loGMrdTMttc6xB6NWEyPGYWyu5qev19ugfPU0nFpknQYl70joG80gQcZula
PkInidPGghU5X4VR+wdpWxbGYXxdKEN3en73XayS/HtoUV2RMLTXbAYYXtR1
2Ew0w4jHRfKbDj/huQbRybo+A1oCKf0T/yNH0oUKkShLbpTzlJbreKuE+l9C
+MwP6aLGtxaZgiYBfOBB8HTU2AZaNsWIEv0NkOD0eDuoXQ35VZwNVw9xoKdO
QpexjAYqtjn0c0da47dpE9f5Q7nY43O7I4rNDe0pj2vxWUlifohqhXK/8O7e
VwsJq+sA98rQwwyWZHhI65/TmbUm0HjQtE8wYANySDW/TY1k8VFV+Zc7OjRY
EVKfy622BV2hDZAx8Qc4xdX0okbYMe8d/Vz/KgUmPWrJyCeyoHGTOwdX/l+Y
jy0waHhPhfGixU4nVgdhpSNqoSh4CO4dJwYM1O3AOxIpLP9DGFxT6tCZJexB
+rm7HBzFRLz9SL3R6uwuL+8PECP3YcR89eFY1i4qlAitmzlUSsTQpbnBhgN8
uD/d2zNqt25/3mcvz+2MQURE5EoxAxleGLSX3XNjAAZObc3I7hdB2aCLEq/e
t4Ho+Qudy+/GgFEgyUMzfR34U7ZFyFiFscmc9mtqJgt6Ghgpewnx4n+a+8cT
9+/2k9TAcYYDSuj60KBNxs4WLxZfMSU+4kbBxJffZxJYMX5y2PLv3BqEesmk
Vx/fg/2m0+yhbxjxjVGg2gusgYOvbnqz/lmEYsV33GaNG9BDe3y7qLwHqAqe
dNmtcmGNQ8BsrMgStKskWtmt/4WQEuuR5pel4OhjNvHafQO6b+ubSbxmxUtj
I6/JPxlibeEihf5pSnwnMKmge4EMLzG1HuMR24f7FJnkqPPHQfMW+whdxwL8
VqtQvPV4C/onb02Gh+yAFfPkd4okalRhzy+cd8uHS2LtsaGUM8DxXUX98gUW
fK/91NqGZddTqivl7FdpUSU8cra4YhFyZ+OJAgn0SKo8cV0C2LHzktgL/g8n
sbfHN0qH9ybm7/OxGGe7sssdjE70ehr4vdtm8PoCBXJWS08Me7OinT6D39Pz
ExB2t0WwTVEYacr007fxF9yq21mcTl2Axw8SXCm6VPCMYfb8R6ICfq3KoOY7
vQqmMksyrPmjoEOaT6j9wYkmA9qy0S7UOFmDdwN/kYBnzeTCiYoVOCzpXm1w
gxUNXv0wFvYcgG/PvI9kZzIi22dag44IIVRIKBm02a1LyaB1At80NdZJfpt2
DFRGpa9aBJ5BZhxP8Ha3YFqHcYrK0cW/ajiwX2u7tc8ezaW65YVZndD0hVNg
Y7oSniyRuZuYcwjF3XN6QxWMUcM+2sRNTQOf1kRMVj44gFmatiw2oi0wLnkt
ucOrHyi6WfujnrDiQnZ4r6AlNUolS/j4GHHhyGhf3SMReky4clfj7yQFPj4z
zEtBdgBdlp2aaOOZ0Mv45Z6YUXJs/jiSPdK8G52agi1at8DmRJpGXvZhPGDj
ljmSbI0xouaPea3lcA7LtaVuy+AEde41pyBxLM3zSZ/bNwflU2Sp4jPiGGU2
9WmIhRlLFky9LyQL4csclj6tWgW86yFy/Zm2ODZ+4OvbKyKA/yxVNUxTqfCd
FF0OHpNCN0vbGVM+KSSkfO2oRCaMLxnJlO/nRD/OOxN2XDx4h9Xxj0ULP7aH
UEVx9TLgWBN1C+stTYxLYmyofUuF5yYbJ5KM+JGxJkRnWaYdrj865dXCx4rG
DkFn+DKZMf0i14iDIz9OGNbqkY1SIYXRcYWbBHVcYzeNYRLTwAL3Wx2R0dKo
patzkllu955Gt5eEJhSQMmY6yu+jPT4rzXSNTrmDlkf+li0LXkcDx9baMVc9
1B5vNostkMebacYp1ElqSCf1g15tXQnjeXhSP31ZhBwXYWP1wwLIJxqX3/CD
HsO/ZplvHRNDCht6MttAHeTsuU+hy3wYl9PIxykfyeCQJJtPtpXSbn4Jd+Mf
qGFYb/bbHjlJHBT/UkfpJo8lpeAhraCJovVGW6olfCgiY5g/7cyKe1KCL385
cxiTbuZctp45gB+XezI2AsTxlU5v4pPMo5jk7ZVeMq+IJ2d9tS/tU8WSZ3bs
k1yC6P3BZvvazDG85ccKI/XbUJTQkvSqkgSlWROnW98uQfpg4NuKNjFMKXqR
WxUkgXCsk5QRK4V8Fo4JlSL7cMZq6koGIwdmcc9S+GwKIqn+q4uXFwPqvfeB
d/UkOKHWf5F4bT++CMiny4lQxoUHTlJnQjQw+Ku4Or+/OAbP18vfeUWNtb8u
0sz+5scLQc79Uqb6uKO+aPjI3ww/XstZEKvRx1KuMPVWt//w/nyjnMv+PPx/
/wL+Bwh4+YA=
      "], {{0, 0}, {8190, 1}},
      ColorFunction->ColorDataFunction[
       "SunsetColors", "Gradients", {1, 0}, Blend[{{1., 
           RGBColor[0., 0., 0.]}, {0.8333333333333334, 
           RGBColor[0.372793, 0.1358, 0.506503]}, {0.6666666666666667, 
           RGBColor[0.788287, 0.259816, 0.270778]}, {0.5, 
           RGBColor[0.979377, 0.451467, 0.0511329]}, {0.33333333333333337`, 
           RGBColor[1., 0.682688, 0.129771]}, {0.1666666666666667, 
           RGBColor[1., 0.882236, 0.491094]}, {5.551115123125783*^-17, 
           RGBColor[1., 1., 1.]}}, #]& ],
      ColorFunctionScaling->True],
     RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "1"}], "}"}]],
    Annotation[#, {1, 1, 1}, "Tooltip"]& ], 
   TagBox[
    TooltipBox[RasterBox[CompressedData["
1:eJx1mmc4F977x/n4GB97701G9siK+5aIIrNEMkOkSJQ0pCEk5YvQUBpGVvZK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      "], {{0, 1}, {8190, 2}},
      ColorFunction->ColorDataFunction[
       "SunsetColors", "Gradients", {1, 0}, Blend[{{1., 
           RGBColor[0., 0., 0.]}, {0.8333333333333334, 
           RGBColor[0.372793, 0.1358, 0.506503]}, {0.6666666666666667, 
           RGBColor[0.788287, 0.259816, 0.270778]}, {0.5, 
           RGBColor[0.979377, 0.451467, 0.0511329]}, {0.33333333333333337`, 
           RGBColor[1., 0.682688, 0.129771]}, {0.1666666666666667, 
           RGBColor[1., 0.882236, 0.491094]}, {5.551115123125783*^-17, 
           RGBColor[1., 1., 1.]}}, #]& ],
      ColorFunctionScaling->True],
     RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "0"}], "}"}]],
    Annotation[#, {1, 1, 0}, "Tooltip"]& ], 
   TagBox[
    TooltipBox[RasterBox[CompressedData["
1:eJyFmuc71u8bgB8Pj733LCN7Fpm5rrIiQkLJSqlESn2lUCoUKpWICqnsvUKS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      "], {{0, 2}, {8190, 3}},
      ColorFunction->ColorDataFunction[
       "SunsetColors", "Gradients", {1, 0}, Blend[{{1., 
           RGBColor[0., 0., 0.]}, {0.8333333333333334, 
           RGBColor[0.372793, 0.1358, 0.506503]}, {0.6666666666666667, 
           RGBColor[0.788287, 0.259816, 0.270778]}, {0.5, 
           RGBColor[0.979377, 0.451467, 0.0511329]}, {0.33333333333333337`, 
           RGBColor[1., 0.682688, 0.129771]}, {0.1666666666666667, 
           RGBColor[1., 0.882236, 0.491094]}, {5.551115123125783*^-17, 
           RGBColor[1., 1., 1.]}}, #]& ],
      ColorFunctionScaling->True],
     RowBox[{"{", 
       RowBox[{"1", ",", "0", ",", "1"}], "}"}]],
    Annotation[#, {1, 0, 1}, "Tooltip"]& ], 
   TagBox[
    TooltipBox[RasterBox[CompressedData["
1:eJx1mmc4Fv73x7ndt7032WRmZYbOMRqKjMiKKFtoICplRKGkqAhF5jepUEgl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      "], {{0, 3}, {8190, 4}},
      ColorFunction->ColorDataFunction[
       "SunsetColors", "Gradients", {1, 0}, Blend[{{1., 
           RGBColor[0., 0., 0.]}, {0.8333333333333334, 
           RGBColor[0.372793, 0.1358, 0.506503]}, {0.6666666666666667, 
           RGBColor[0.788287, 0.259816, 0.270778]}, {0.5, 
           RGBColor[0.979377, 0.451467, 0.0511329]}, {0.33333333333333337`, 
           RGBColor[1., 0.682688, 0.129771]}, {0.1666666666666667, 
           RGBColor[1., 0.882236, 0.491094]}, {5.551115123125783*^-17, 
           RGBColor[1., 1., 1.]}}, #]& ],
      ColorFunctionScaling->True],
     RowBox[{"{", 
       RowBox[{"1", ",", "0", ",", "0"}], "}"}]],
    Annotation[#, {1, 0, 0}, "Tooltip"]& ], 
   TagBox[
    TooltipBox[RasterBox[CompressedData["
1:eJyFmvc7Fe7/xzkOBwfn2MfK3nvLuF8hiRQZWdVbViqyMpNRlEJJJBmVopBZ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      "], {{0, 4}, {8190, 5}},
      ColorFunction->ColorDataFunction[
       "SunsetColors", "Gradients", {1, 0}, Blend[{{1., 
           RGBColor[0., 0., 0.]}, {0.8333333333333334, 
           RGBColor[0.372793, 0.1358, 0.506503]}, {0.6666666666666667, 
           RGBColor[0.788287, 0.259816, 0.270778]}, {0.5, 
           RGBColor[0.979377, 0.451467, 0.0511329]}, {0.33333333333333337`, 
           RGBColor[1., 0.682688, 0.129771]}, {0.1666666666666667, 
           RGBColor[1., 0.882236, 0.491094]}, {5.551115123125783*^-17, 
           RGBColor[1., 1., 1.]}}, #]& ],
      ColorFunctionScaling->True],
     RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "1"}], "}"}]],
    Annotation[#, {0, 1, 1}, "Tooltip"]& ], 
   TagBox[
    TooltipBox[RasterBox[CompressedData["
1:eJx1muc/F/73xq23t723t70j2bvXsYkSlcouspOZnRnJqoyIVCIkZI/Msn1S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      "], {{0, 5}, {8190, 6}},
      ColorFunction->ColorDataFunction[
       "SunsetColors", "Gradients", {1, 0}, Blend[{{1., 
           RGBColor[0., 0., 0.]}, {0.8333333333333334, 
           RGBColor[0.372793, 0.1358, 0.506503]}, {0.6666666666666667, 
           RGBColor[0.788287, 0.259816, 0.270778]}, {0.5, 
           RGBColor[0.979377, 0.451467, 0.0511329]}, {0.33333333333333337`, 
           RGBColor[1., 0.682688, 0.129771]}, {0.1666666666666667, 
           RGBColor[1., 0.882236, 0.491094]}, {5.551115123125783*^-17, 
           RGBColor[1., 1., 1.]}}, #]& ],
      ColorFunctionScaling->True],
     RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "0"}], "}"}]],
    Annotation[#, {0, 1, 0}, "Tooltip"]& ], 
   TagBox[
    TooltipBox[RasterBox[CompressedData["
1:eJyFmvc7F14fxu09PvbeK3tGyLnNhCjKiGTENyERkUQqlVJmkhJNRIgipSgN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      "], {{0, 6}, {8190, 7}},
      ColorFunction->ColorDataFunction[
       "SunsetColors", "Gradients", {1, 0}, Blend[{{1., 
           RGBColor[0., 0., 0.]}, {0.8333333333333334, 
           RGBColor[0.372793, 0.1358, 0.506503]}, {0.6666666666666667, 
           RGBColor[0.788287, 0.259816, 0.270778]}, {0.5, 
           RGBColor[0.979377, 0.451467, 0.0511329]}, {0.33333333333333337`, 
           RGBColor[1., 0.682688, 0.129771]}, {0.1666666666666667, 
           RGBColor[1., 0.882236, 0.491094]}, {5.551115123125783*^-17, 
           RGBColor[1., 1., 1.]}}, #]& ],
      ColorFunctionScaling->True],
     RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "1"}], "}"}]],
    Annotation[#, {0, 0, 1}, "Tooltip"]& ], 
   TagBox[
    TooltipBox[RasterBox[CompressedData["
1:eJyFWoc/19/3t7IzEkVllOyEhEpeQiTZCclIysremRVZTSMUkY+RSoQQKikj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      "], {{0, 7}, {8190, 8}},
      ColorFunction->ColorDataFunction[
       "SunsetColors", "Gradients", {1, 0}, Blend[{{1., 
           RGBColor[0., 0., 0.]}, {0.8333333333333334, 
           RGBColor[0.372793, 0.1358, 0.506503]}, {0.6666666666666667, 
           RGBColor[0.788287, 0.259816, 0.270778]}, {0.5, 
           RGBColor[0.979377, 0.451467, 0.0511329]}, {0.33333333333333337`, 
           RGBColor[1., 0.682688, 0.129771]}, {0.1666666666666667, 
           RGBColor[1., 0.882236, 0.491094]}, {5.551115123125783*^-17, 
           RGBColor[1., 1., 1.]}}, #]& ],
      ColorFunctionScaling->True],
     RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}]],
    Annotation[#, {0, 0, 0}, "Tooltip"]& ]},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  ContentSelectable->False,
  FrameTicks->{{{{1, 
       FormBox["\"\"", TraditionalForm]}, {2, 
       FormBox["\"\"", TraditionalForm]}, {3, 
       FormBox["\"\"", TraditionalForm]}, {4, 
       FormBox["\"\"", TraditionalForm]}, {5, 
       FormBox["\"\"", TraditionalForm]}, {6, 
       FormBox["\"\"", TraditionalForm]}, {7, 
       FormBox["\"\"", TraditionalForm]}, {8, 
       FormBox["3", TraditionalForm]}}, {{1, 
       FormBox["\"\"", TraditionalForm]}, {2, 
       FormBox["\"\"", TraditionalForm]}, {3, 
       FormBox["\"\"", TraditionalForm]}, {4, 
       FormBox["\"\"", TraditionalForm]}, {5, 
       FormBox["\"\"", TraditionalForm]}, {6, 
       FormBox["\"\"", TraditionalForm]}, {7, 
       FormBox["\"\"", TraditionalForm]}, {8, 
       FormBox["\"\"", TraditionalForm]}}}, {Automatic, Automatic}},
  Method->{"GridLinesInFront" -> True},
  Ticks->{Automatic, {{1, 
      FormBox[
       RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "1"}], "}"}], TraditionalForm]}, {2, 
      FormBox[
       RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "0"}], "}"}], TraditionalForm]}, {3, 
      FormBox[
       RowBox[{"{", 
         RowBox[{"1", ",", "0", ",", "1"}], "}"}], TraditionalForm]}, {4, 
      FormBox[
       RowBox[{"{", 
         RowBox[{"1", ",", "0", ",", "0"}], "}"}], TraditionalForm]}, {5, 
      FormBox[
       RowBox[{"{", 
         RowBox[{"0", ",", "1", ",", "1"}], "}"}], TraditionalForm]}, {6, 
      FormBox[
       RowBox[{"{", 
         RowBox[{"0", ",", "1", ",", "0"}], "}"}], TraditionalForm]}, {7, 
      FormBox[
       RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "1"}], "}"}], TraditionalForm]}, {8, 
      FormBox[
       RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}], 
       TraditionalForm]}}}]], "Output",
 CellChangeTimes->{
  3.5381285657804546`*^9, 3.5381286401524205`*^9, {3.53812879265232*^9, 
   3.5381288082943306`*^9}, 3.538129112144498*^9, 3.5381295894844856`*^9, 
   3.5382147839740615`*^9, {3.5382152729100933`*^9, 3.538215296606535*^9}, 
   3.5382153989213123`*^9, 3.5382159473250594`*^9, 3.5382163211429033`*^9, 
   3.5382164945173993`*^9, 3.5382234281134453`*^9, 3.5382237077901244`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WaveletListPlot", "[", 
  RowBox[{"dwd1", ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<BlueGreenYellow\>\""}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}]}], "]"}]], "Input",
 CellChangeTimes->{3.538128721557757*^9}],

Cell[BoxData[
 GraphicsBox[{{
    TagBox[
     TooltipBox[GraphicsComplexBox[CompressedData["
1:eJx83Xdczt/7B/BSEdGgSSqlSTtNuq+UEqFQpFSyibJSdipEpaFSoq2997rf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       "], {
        {GrayLevel[0.5], EdgeForm[None], 
         GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtmnfgVuMbxt9xzrvfL0oqmmSlUFRIu+xESNGk0lBWtkRZLRFFu5C2JomU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            "]], PolygonBox[CompressedData["
1:eJwt2Qm4VdP/x/Fzz63bPfd2K6LR0CQqGmQmfn9jk6FSUoii+EnSrJAIhYiU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            "]]}]}, {{}, {}, 
         {RGBColor[0.122103, 0.00901808, 0.39826], LineBox[CompressedData["
1:eJwl2XfczuUewHF77733LspOhIyWGQoRhcwQIlIpo2zZe28quzIyk9EiFRmh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           "],
           VertexColors->Automatic]}}},
       VertexColors->CompressedData["
1:eJwcXHk4ll8TrmiRQknJkqJFKWlRojxSJEtISCJ7CPGTKNmypIiyFJUtpEip
lK3IXgiRvJaXbKEQlZRK3z3fX+913de55sxznzlzZubMeVdYnDxoPWPatGnb
eaZN48Cv+QG7+kyDEuZOnqmd8rtuhv/cP4PN67uYgQ/PYqO/vmU0NH/JjO7t
ZzgNvwWpnulkXDcOyNyalstcV7yebNPexiz8ejTri0wXc/aBmtBz7ZcM82Pv
WqaxizErqFs4pdnFGF8c+/VWvZVRmGuv+2zHIDNnpMH1+Nd2pt4r6HquMYvR
u1J2QuXTAHN06udC+bNsJmZMpM92D4speJ1YY/pxgMlOqfqvz5fNyO6SnPVF
hcX4tqqfqQAu89B601bgc41Tap6psZjbyz0eyPUPMP2rHg07+7CZJbMGSt5j
/N7v6VElGH/6hHGLPMbXGW+9NV2JxaT2HfvX0DfAPO5/5fHOD3JuPgpdp8pi
duyxnFWP8c3rx9olMN718LVo1j4W0zXz/iwByJf5XNaTCfmWI/b3OiHnt6Zb
4g/I8b+zMew65AwvcTfai/FbD+bs+gs5y98ohr3HePH4M/FTWiwmaMD02oKB
AWZ49hD/lBebyVC4LbsG+i//rp2yop/w77oxGL/TtHNJtzqLUfzxtfIqcLZX
/HWWN5vhjJtzNU+OxfRare5P6x1gav1ZzY3+bKZ+l1ren5UsxsvcZ7VX1wCj
ZTqHQ/Eim7mwLmrw7C4Wo9lupHACelpOX9YdeJ7NfDATS4g1ZDH6isdW3Roc
YO5MW+Fl7Mlm3pvrCGposhibmhvZ1Zi38sHNMDfMOxlxK7WMYTE8PDu2v4ac
brbs5j58r01Odk/1XhZz9OCFkuv43m2H03kDwFteklg+J/i8y1nx/TXw4INb
d0kDb+vvObtdisUErDTh8uoeYBrnfPYPvsBm1hxlPeQ9wmK4+zYpToc9jLzu
Tn4Ae5D5kjG9dTeLefEut3oZ5Dw/FfHhIObN1emKM9BgMT2pOmdToOfSZLnE
XOi5Ju41z07MyxMT3tSA8VPuRrximLffUFO4DOtSEBP4YgHGH2UN+D0Bz+wD
y5tM9VjMdDs12xGsS3rp7+CAc/iu3VdKcg+wmI0Fx05tBP7aWIejGutVftOh
RB76PIt0UJwJ+a/snK54Q5+Esr/bDsMeTFRe9X4AP8aSkc+eAz/sdXoJP3gT
eNqTdx/47CUt/QLg//vkoxUmW1lMxLEZZd97BpimsdvLZgWymeB82/SPkD/9
ybPG5ZAfnht0XBtygpfO3xIKO7GMjmNtgv5K4R5x56D/0LK7Mqrg4YTk1eYk
4MdYbStegAfdJ135UZg3tGYiqBjzCly2NvwKOZbCv+5bQj7/adE6bsg/9umj
gSvwh69dIpdjvHJ+Rc8DjA8sadm6EHq2xSwsS8a6ZHcUTVuKdeHLOsIZhHXx
PupsWAF9lr3rXq+AeQ1fS6U7QB/RG4I+Ldh3L3ZyziyFfGsTlaW072qkerxN
dGD/Cg9//Ac+t0Rvu24IPgWjhVcsUWQx9RbSmgGYV86Vb7Yx5j3S+PhOK/iv
k/ft3YrxTOnqnGKMz0tp7HixncVIGJsF+MD+r7ea9AoGsJmveiWJ9vLgx6PE
chh4g4jIXBPsi16H8fEhZRaTsKxtUB36DJml/Dcb3ytmcv1VOXjoGJtzWRh4
Vk2Dw2Hg1S9DRnwPsxhHszLlYuyL7lrNOSLYFzOk58j3w64iv1zRHMH41jE5
oVF8r/KSV4YLwJv9VZ7/aH2Hrt6zWAz9PypoC+Thuxxz09XigfNHCsVKA7do
Mr3VCz3XZpv9mAZ8bLFWpAL0bLsROE1eAf5HY+weD/AbEtqrVwL3e15vqq3L
YuKeza6IBQ8J/P/tFAAPB63zKvZgXtOyzIvZGK8rUBQ6B/LXVwsome5nMUo9
L0P1sC7Sypl/laHnrZuC7gHwq3m2ojssof8VhZBuNtbF5qiX40Osl+R/v/c+
B34qpTBZBXhg7fld3bBnjSvH5k5AfnDY0pZr4EfO9qrsf5CzO2WHhhnGB2im
9XZj/J5H9/y2Yr1k8zsVhKDn18OOGl+gJ//d1NCMHSxmleBofi3WxTbD0+0q
vuvw0pqhD5CfFnH4HflPnXcesuQ/t20an34O/mTuXJWxS5Dfvv35r1jIT1Dm
OxeNeQ/8k/1uDfy20L7tLcDFjGvvSYBn7y1ztIMg51Vd7TVD8CBw4EnBTchZ
t9hlzhWM77C4p3IV4xnrcWN9bRbzWnEgSg166mXbzU+EnguEynJvYV1+33Ny
HIeeAQLcmtrQUyHmwvA22M+SRzHZGyDH9EShxQ7oeTlS7dhH2L/8rOs6SuBZ
qzvjgyV47n82Mv4G6/LUpuZpFfTZNCqc0o3xT9UFlqTD3s5aegkvgZyTW3Jn
mgFfrl7vaQg9V6dPLQoEfnTbm6lk6PksJPoinV9HTTxC6PwyFhcYpH2UajRY
owE7iXPiClwA+TPS9feKQU+eE6X8btDz+3SPzO0Yr9zNaSAJ+Sr8/Qv51rGY
S7wSyVrwtysPSYe1wN8qThdyDcM5Yl3E+ycR3/tl80hGJ+TcqeL02Yj1enZP
tTEf+LroR15PCBf8vbgP58hF/ed7z2Fe36yDxbbg+U9QymMW+Dx1pjHNBHwW
3rk88xz4jGpMOhAGO/xsVqxsDH68JdNrZcFPenUWXyjWcb2rhosV9FzXU1PT
hu86rHe+8AX2Vw5XXEo/8MbBQM/fGH/fVqn05Hr4z8z6lQ+h/5oIR9Zm6H9g
U5X/Z/DmZhPddAvjOQOSLDzpfE+3Y58Db0Ky3JLZwL9IvDyvB3yDfmDOc/j/
/VKTl/mgz4/bPcFPIb8jsvlxnRWLadz9oz7/M/we1/qMAnfYj0u2v7xUMzO8
Yc8Pu7wBZmbindMlb9jMl9VBh3aptTNm80ZOuoYMMp8vLFiRZtPOPB1YXlhl
3AS9hO7MPznA/HlddrJPs4MZtOjJNORuZo6b7NusmT3AqBrY1Pm9R7whwKt8
dmMro1m8VFpPdpBZc+9gTv+vdsY1YMXi5YeamQK5nNZfRQPM/sb7mpdKECec
/XVl8RkWE8WWzvk9AvkHQ29L/cdmfP7Ecr2C/TvIfXmQiHWZKdrpvQ7rMh6o
u+Wl+nvmSd0eOetonIMeka6G3B3MHbvi7ylBLIY9bBgmOTbAeE2euObqxGaK
O/0VuPNZTHLRcvbxX7Bz4cq3RmZs5p+gfJoR1v1Hk3SfNeQvTeqbHg75xp6z
5mzfhrhlqUitEuwkIqdZJAB++E1DhOE4zqMPv6W/vgDP98WmCVzGeeQekKM6
HfZgyv8saS/wGpFtPkfBv44NZ9wT2PMuX80N4pDvsSjm9QzYW2bKuoBvWC/H
G6OHl2J8hrqR7x2MP/D30VknrG+DhXjLI6xv3Ti3myHWl0tzWv5z2E/Cgfqz
ZD8pan9LyH6mF4vuT4KdxBb5D5EfeN6fUxSO8QG3aiwjoGdUdNSCB5DPWWMm
fxd6srxFLASh59ndbAM14MW77SUNIGeB8ovuF/BXRhU8smPQ83XA3oZE7C+v
n+Jes6Gn/8HKM98gf62Cu1I/xjv2WncvRxxldKlwpAxywibmSvhBfsnPnQ5c
8A8FxvnrM8ivSvaECYLPY51csiLg+br4Fq6jwFemybMTgLd/P8/Nht8wzb6g
Jgb5e3k3clP8M2NwUl0N+5RZ+f5NIfgvyJHPug/eDDnuNO/A9/byOev5YnyN
kM/y+/he4brsGQawE8NJUcsw4vnIaMV+yE9cpykeCfmRy4Id+DFeP3JI1wby
B5foLkoAD1UXH38zgf6Hj5Rs3YTvUvOU2+AA+SoSf22CMX622SXdeIr3tLLi
vcDD8coNTrMw/nLZOlYFra+J2+7d4M1ZO1uWjXnTpv+ZUQr51otnFK6HnEeX
D+3whpy7P/xzH0KO3Kc30//BP4SEPuo+DXxPxNm9z4H37t326yXw6qrIEQfg
sbYL97+huO5Wb4Ut5u07OWsxB/nhxPHwGsz78aNOgz++a8rw8gQf2ckR7UB7
zPvAO2prA/x2Spbsol0YP3pp0tYO44OWzBBQg3yx+KpgI4x/USTvOgL5ferC
OUvBw6VlUZfJHrjVO6r0Sb7egJEC4hDFANFI+//7zwePd8L+HcKq2S6wq7Wy
t1vuYvz1pnOrH2HdTw4v5JeHHKeKykIt4E1n1T9pQo7cws7mTui5avOZAlrf
tZb3VHWh5wEdWaensGd3/mXaH4GfT7Ms/YvxClEibkLgzWOZsron2cP51OfZ
0NOQtTiR1qusR2yuKeS/3WjPQ+u1IGbuu8jNsJNZSZYZiDOl1Tsj/BFnrroR
0huNfMRw4/VX0+C3T/ytrRWCnqe22lYsgPwsy7i+M5B/QsZuWQ7ka9pWeK4B
P0XmJVqHgKcrxFlN0HlqJ8YTD7tVudnT4Yz1rdjOo3gOdiXqfX9FMuRrOVgN
zID8f3XzNyyB/Lf912+Mwh5ufjI7/Avj7c8ZDURQ/rW3Oi8c498UqlT/g/7f
Fn3yEcF4Az8bhVj4h/Q1d8ZEMb7nh+GsubDz1fX6puuxvx7d8qiowPgS3YA/
Xhh/e65RNCfizL2t5x5bYd6yjHO/T+I8CnEzbA/YiXPhn+PLPZATkqlg8Rp6
NjRJfPsL+7l88/xMYch5yb6ZnAzespa8OEJ4vx/PsBDwP9/s3xDecYU5pIR1
aeTiCGwED/NWmfWIggezV6skh7G/1uXeS74D+Q//Tmkvh/xfqz5KpMLebu4Q
bJGFnPPre8rdICdHknfOQayXYS3rmi7wz1pvDFWBc7++fzQGfjU7XchBB3Yl
utjIzg52NX98egIf5Jf8ZCn5Ux7HIV5/FPJ9ph2OScd6qW38ZB8BfcpLPm26
DH2suTfptSIeSBIzGdoHnPF1DJ8Hns8vjTj4HbionJKgJvD5dYmOM4Hra0QV
hwGPrdxbowB8xDBGfQXwvjMnveeBh2Oepvu+A1cQ+fGhj+LJ82smdfFdnB/n
+0lC/7RM62uhwLOHG5KbIMf5+GcpmvdrwinWfMix9/qqeg72wydeOWAOvPT7
tRUfoOeMt0mdG5Dnmj2XYp+CnHNFZnPmQk718fYbohivlf475yDGf+s2F5rE
eIFZ06YJYN7fZYdyl2G8zssanTiMvyP/t+0n5vUXu9lA37W4ecZGTszr/eig
xB/sL7ctuSorgU+7Huy/H/jNY+K5nfiu2TNfSi2GnLsKD0cyIGd4j/ibeNjn
5145uSHwrM6rY3QP4x9P3HrbhHOn3/ubI8VjpYcvCytAn3DD22sugH+LxjUF
ocB9b3d+ugb8tNXIaVPYiX9wxxEWcJ3xn/ECwA2CNRzsMW/7shQj8ld38o6I
kL/avO+/4C/Ii7k1Y6/eQJxz3PjbTAPEOUVqo4tjwc/qW3ILgshf8SXHD8HO
vz70G5SFntMtX1q2Qc+1J5LFKqCnjFu8kjLm7W/jeEf2WbpS6yjZZ/dnOw+N
GyzGx7AhT/s71mWFcQivHZtZyZOjkXS6hZnu8fJA+pJBJt5B/FzcejZzqO3f
z1OR75kdoevyeZPgZ5zr9Kwn2MzejJ6Ma+4spqJOclkh4hDBDv1vUYhDFAv9
uFRxrnksCv1I+cib4xPDs2Gf7w3GNh/DeoW3Syauo+/VahoPxvfOKIxZ8h94
c1SZNLoIPev1BR/fgp4Va/g0foFnhw8iYq+A66ZsNtsEvODW4O1DWN+LwZ88
NgP/e0hv5yZ8r67HFX4vjNcKL5CheC9TsM+V4j1lUbltM4HLZYqNJxL/v0b1
TwEfcOYtVIA97OiusaH8XVrERoPy97cCa7hLoY99rJThNdovcwfPBWH8oQ9d
ZkP4ruqjStfr8F1LznRptGJ81gODjcEOiB/uDn+bGBpgWNIHXOPc2Eyczg/O
9wuamfG9zLDB0wHGoLyvPO8dm2la99TAr/g1w1N5fk6JWx+zoWvr9/yED4zG
lGvFepEPTGW2yN+tGz4x03y1RpccbGM65h5Z0/m4mVnQ0fpoQ90AM26Woxl6
F/n7mOUZYfhJ7ZX8K4fBZ+r97VY7YQ9SolsC9pG9Je+6/w76b+aP+yQM/Y3X
FWVm47tExkW4ooC3vCtyvARcfsGBq1uBm9SUnfUBziU7FpEJPFrmxParVM+p
dz0cRvGzGiMZBXyF65ovYlhH4V/uZ5Zj3rNKfTo3sI4vxcJl1wF3irggJg7c
cUTN5zpwqSiul26Q86lPYZTW9+HpzY9uQk4kZ0PcJ6yLe6NiWTnF7YajNrJ0
fj2PzP4MvGb1r1HCVU3chQg3nd5Tvxt+kh1c/ucA1d8u3qpSh/xHf/d7kd+7
0RlhQ36v6Y3BDvJ7sUzFwq2wkx09hgzla23826XksV62VVdvXIR8jUbtLc+A
u5sKcepgvFvmG41X8DPH1EyEnYAfiapVrQY+/cw6h1eQo905NU8FuEXcU48F
kCNfYvRQBPbws/TrHqqTRHKLqvLDzv9+GlYnfXz2eZuSPstC1uwjffaphs7c
DH6sRk+aSVB84hV/JBr6m7q5OItjX5/T9ZrtCvziYlup+cBflOzS9cF4Ewv3
yo3AD3isX+0L/MpNryIDyNeeU/kjgL6X131zCuQv3eD3xQy4Ro9ibBBwo93/
bJIo30l8LaEMO9/KinKcBTxBUvTSOarXzeFbtxY8fLw0lHeH8sqEGWfsMf4X
xwxjN9jPr1OrZrdTnDzviCEv8JcH7+xNhb96WvK6ah70Ef/6YKIA+rwzcxTc
g/EbvFJ+kJ/5PWPpCvIzC0Lr+ldAH76zm8+dA36xPOLRY+CiK2cb8+C7tn+x
SROFHG3TkxIJkOM+MfwvXQL+M3j6D9Uu7N8HyvduXGQze7Q5489i3Z/9+bH0
MK173FlZBYzfpmMZdhHzrtn8eW8n5I/OSa/hgnxx9rTMYHzXytOb5tP6JoWo
qtD6Ht5ek2EBfSZbgz8QP7m5IsOJwEerczw9gfd8zW+jOsPud+HLbgDXu9jd
+hDypxcL2vcB/8D5Xf0f5lWU8Re5Bh7YKVuOzoU+bmcllr8Ebqd+01YM8YbV
1mPT7BBvRLwMT7BFvHHH4cXuQPBfWeO3eQGtl47/coo/Vyw/sigO8lclsW26
gSd/D3XhpDrzTjHrRbBDF9n7u3SBS03KJP0h/fclPp4G3OJq1KID5JfOB86Z
ATma6ft4siB//pqLfILAc0qLLUyB+yn9S98CnlPDeFPI3t7vm9YfBT09LDjy
d2DeVsVaN6qL1j7me0J1UVU7jx++iItUZ+kup7jIuuq3axXsWVbm67w9iGNt
bt40oLqisvjhKaorPqx7wLqMeVXOGUQuhBx/273lxzHvgipZPmmcX9vnhwd5
4vzavU5paQjOLwezdRdnW0PPyssVpcivDZSKjO4jvzbUK/HLkoZ8d+uH3IhL
JdIHEqKCcH5JJDlegF+dqmS9I7+qr/XfXfKrDiaSnH7iLMaua3DVEthJgGmQ
7RDs5MzQNdZP6FNe4FMoQX7jZJ69OvR5d1R2ohDnY5X4CXPK15w3OwRRvhZq
n5OeDR7CfhVtpLj69ATnL4qrO+tqFd5iv/8MHTqtCvx68cB8XoyvWmUpNo79
7iLqNFUPOeYSr/qagTuIlaZQ3Ubv4RVhqtvMt7v6jeo29kLur6bAm/mOP25F
4C2r+IfXJfAWXnpu160DLGZabteHdbCTGUJK7xtgJzM1N2q1QZ+lw7kWQ5Az
uD3v2Dfok19+bHEr7PnbJnVRqqPulir/sgPyk9Lrni0H7vTlrWkqxf8jp6sc
KJ+1r31mC/1Dh28/kgUedk01Xwp6xpxPfVwJP3PlaG7IZejT3WLc1Al92ngF
OMzAz/cgvlXd+C7t05MR+Rh/9kD5ytOwt+BPTUNU3wttNqzvonPTX/n5Otj/
k5aoFb+Ay1eJRLPJD/cfXyOAeW9/VdsvCXyTwf07ypDTWvuaywnzHtFslPTB
vCbrlzn9xLya5+6OTIG3Fe+lvyVgfNnRbzyn6Xx3mzp/BfpsuL17eJDygjfs
vZmQU3q4r9MT8yqIe62mvFKj9fnBSsz7I1jhx3nwkC5wTvwp6XPsyntdyLn9
69OvOMzrb/S1heIlhX2u+z5jXpO276V5wMcvOGqHAO8SbkzrAZ5+cv23tVjf
NX8brLIwb3hO4G1e2P+Nb1dqLcyRDyZai0rDbqWuf5G/74H1PSqVYS2HuKJq
yPkG4vPn0T/aPiEf8Zi7wvEyvmukuvT5ZehzzchpczT0STO1CmtHfjSwR/bj
WchvPZ8keALypwZ5d52C3T4UdnPnwfhqoSfVTvjeg/f+Vkvju8Yr9yelkT2E
Ow/bQs46n5rcSqyLXnsFB51Tc+6Kn6RzKmhlpL0M7K23Y4NRPL6r7dRM4VJ8
F89CmcrFWJfnFf9CaF0eid/aSuvyLHT51CDZz5aEdDpn7wYXRdA5WzH6VMgV
8n2nTZ2kdZ/1uCqV6rpyAaW+98B/sOoLj/mQ/5RLtTaf4tU93C5TdB/35tpX
itMEjJN+bKTzbrLBegZ43ipp2ONIfqM5fVwA4wdrnNmWkDP0RllzBvAZM4cG
3gBPPO649zR4OFZWVUU8NO2X20U87DbR0f4AffjHS8ZdgFdq6WeVQf74rpp8
LnxXziXOU6uB9zpMvVLB+IiCfFN95EdR1rVqVN84YzH0jeob0YXaN6uxvmW9
QvpUj71Q4bi/B+M3zVtaMYr9GHhEzkUO+zHc8VxqAfYjxwylV5/vsZjiwn0x
b38gLiqbLlZhxWaKA62GjsJPdrV+NdwFOdtSOQzfQX7r8Q3nt4J/40SV6Qn4
rmcFib+L6b7M6MseXXzX39Lu1jnQM+pli6UH5vUP5T6dBd4mnJxOUr39KqeU
MdXbC7bW/deI8+7KmqYjNpBzOqrvvTj4mRyqzCmFf5CeOxU7QPWQwr/Nv4g3
pb01efiuhofRZyrpe/NXrB+AfGWjstu5wHd4tOwn/NuMIi/C15pt+PoZ/Lt/
n1whCPmJF6ZH3aV80+nPkALsln2X4x7Vi7I5NoZlQJ/kLxO/Jik/sjcLofy3
McXhVAr5yYtqUbvAW0tKaJYweEu+pVQ7BN7CIvhXaZQ3M9luLdbiDQOMZhHc
XjLynQQVw0MuLEbcT4rzxTDy34WWQZqn2EzmNmc3A6yjxIvyUornt9saPpeB
nh/vVpX4Yd5t0/cJzsa8wqsPPy3HvFryH9M9wadhcdxdXoy/93a82IHOnQCu
0DDoX/Kt5hPtuyf9uT0Ur25hWlKdgL/Z4VNDdSoZyb/JccC5v3yNnjJG/iLK
vqPzaYDZx6vfufosmzHn4cwj++y5Ya9K9im97NNXsk+B6FX9Nliv1EdDSVmQ
s+HxiotGkONnOLR6HPa29DP/UBp4rinwXrYM9pA2vdt3A9aRY45tvgbkRFet
NtGBnBPrF3snYR0dFkqI9EBOhXiiAgfdsxS08uir/78euNoT41v73NX+wX4u
1KWap+J74x0WHlmM8Sbudjrm+N6eEe5NNZj3Xf5VoySqt1SsMF6LeSfn1L/g
wvhzt0fN/gJfdfHrjFCMn8ZY71gAni/dYaetgZxdPHfz9wD/fK/xWjy+94ep
cy431TlXFtW8gJ5r8pzNvKG/WK9lNsVd5n9cN8gD//Yfz+EPGP/fPDsVype5
f9SVUL6skPzDepTkh/G4a0D++z87/GZRPeeKxfbdiEP2ekXVr8L4RYW+G69i
/B7uogtUr9OL6eWm/HfEWi2J8l+lDRMh18FzVy2Xcy7kiC7sk9EEPzHFR08+
B/4gXdW4kPzkpOJCZeDfajl71tM9ZnQ0Jwfw+F3ZpucpL/t1YRsLPF961tbz
meJP/0S575D/M0Xx8jzs0/flf6/HkP7ZFWM14FmD99AuE+hZbnhfm/LTE+dc
fC5ifKTNIzmhlSxGySem9jDiDe/wLavPId7YWKVZnwR/7mStesaF6lFdgts8
qR4+NyRhJng4VG5QvQrz2t22HFSleFtqIHMWxhfGD0YdxnhRdbHyVIx/u8PD
pwXzvqovYRQpTrvVaHsc836PXbHxEfT8F+kz4wnwENenlQnQM4Tr2pED4G3f
5F3WFPlD1ZS6Row/93zsYwS+17uxvuwDcPMCrZ2zKd4u7DV9MA/+rT2s8Bob
5+axM5yD4fiux3HOM7Avzk8+OelO439a6hVg/L0PQ/EJ/68D/+coAPxV6mSv
BfRX8CspSse5zKs6JT4C/a993bHwDp0ji9PCZ2P8Lkfz2WRv5r0LbpG9mbWx
a8bp3sr7dnglxbfP/PQ3Q/5D4c4/beBnw4V0GTXgfOvuCFE9qrLqZsRj6vcw
4k6wB94sfnLnW4rnXQxrx8CP2QKl1crgwb4g84UZvvdanWTfY9h/XoCnehzm
ndWQpSEDPv/1Vts5GmHfRUdu7R8cYHgLNSXbsK+niktbLoHPLVl9bfchx9as
VSMdfI7f2LQ+cCvyLP6XMr8Rf5rbRYj/pvptdqXuDBH41VCNo/M+IP5Zwx+S
HcJmmuPUkn8qsJhldyKVNmDef2JzWr9g3jzLS8nmwA3tF80SIH6+J6kuRTzQ
OXeR723ov/lLmgPV/QTe7Pc5Df3v7nHXoPjc/mxBFMXnxjay0ykffFPnlNaG
dVnjt0j9BniYqg167gMeTtivUjIFbpTxfR3lL2NSVyRuA6+8vf4QH/i8tWCx
P+3r3HWXftG+NnpzdekV8ClsN2sJ3ZM6b/nvUSvdn1aZZazEvi69cFFbHfOq
W4W/Poh559+aWP8afF44+5BN90cFt0al6f4oYLeOegPW8d1GDnYx5CwpMObf
CTnzknlr6f5ursiDcLq/G/doiaH7u8Wj9hmS8Ktn6r/rScOvFptGhZmD/whj
m92NiKOC3c0llRBHPXbOMb+MOOps+cVHY/I4933KeDkw73LD83+2g7e4jh0+
07Fed0o+vr1G9l+/arIO67WMt82TC/rPONjyVQV40tdqxSPU/3Dh/dIq8CP1
kvcM9Z+My6tepv6TZbN/CRQBf/4mNjsaeJxKe8QF4EIX9ppQHCWyZMm4I+Xp
rYrBFEf9dDJ31Mc+Sl9/p/89cKvcu0sFgT+/GrshGTy/FV7Bz5AfPmeaJQye
b93T9eiGnE8nvA/8B/zzzwRBik/O/25d/xnj338/n0j9Bi+uzB2lfgOOz7/N
z2P8BH9kjwXlTeeqT3VgvNfXKpu9miwmwPteUhW+a2HcQyt3fK+T7e4B6iNS
v514iPqI6h8tPE59RD/qdS56Yr1MZoXYRoE3935/TwbrZdrxMioc+1Fb+3or
5WXFfi4alJedvV81+yjwfg/+6LnAuac3nnSjPqVKd3Yf9Eka/dZC+vv/3riu
FPqsNb3g1Yd52wRqBZdQvmBpYZSOec2KfGOOwA94NUSpdlG/gZUJL/W3/HfQ
sY/qeJe5p3tSncfya+IZquN9cT3+YAHihIBus9RFiBNkzsu0/ESckLkxXv3T
GuSJb+c5jMOv7qmTNncOZjO8wnOaDNRamG3hO1g7+QYZ34HrZ3R2sJkN93eo
TrWxmXrtDJmdNYNMRYpAes9EG2O04tLHKv8GZsuuIz0lHv1Mosiqs26qnQyf
b/V9IakWJt/z468Q7kGmfIA7WX834pk6f3lxfO+fz/1ueuSXDqU3/aRzJNZ6
Qw++18WpOo/ONfvoxt/0vSFHHhaspbxyK7f/DIq3f0vv9Mf3Xvs1fiKI8nRx
z4vUR5H/WMKI+ihmzozpkAEPOlrsbrrPSjl699oDitslNpscwPiwzU2XjgDf
d2Re/hD529Z6lWOwtxO3+M5RfVgmeLsN1Yd3Vx/s/gc5Owv2CVHd0pwlVOMG
fNWtq3d+Q87SnY2H6V6M48hmmRfAN7ayxxdhPOuSm+1Z4F2VTxSfAX9zy7ft
CMbnruEMPQr8SlCK5iDwt31c76gO8Ef19xmqAwiNDWVQHeDQqNDeT5BzqX//
bbpP524+lE/36Uk1L9KNMf6/Wd/7m4F/yvrPcjFw77Ab0mnwD/yN+77mU33e
sOnjPsIXXn+mj30qFLNI+iD4dMlT0FcBn0/be/KegE+dCc00qlfwav81MwGf
nG+qROj+63zaqTi6/8rp/n2G7r8eBafrKcKv5tVeM+alPpnGqB/i8A9NOTNX
UD1wMO3yB6oHPnNom6R6YIjsdsdwXRZjulZhfgr1dVTV3OOAve2Kak+YBT+T
dOqXIRv52s8tumc8IGe+VUBhwDIWo3WlxtkVfr7MqUmLE36+IOEB+zG+N9Sg
oo/qP7XyPu5TdM5mPRuZgJ0EnDDkoXhY2m6LeirdO/RHanhhfLi4mhab9t2p
orXzwcORF5fTJIAPJa/9XAvcZ5908SrgRZ1xwRbYRx9KU0Ip7w59192VR3HC
I825MfguWYmwhqPkBw6KSmyB/LiGXX+8cF44G7y8QvXAVS9z/akeWNfK3fsS
foYnOb55D/GWffciP+XLc6REc+l8sXPvpX7IjfOPXaV+yMVFN2TeY3zr2vPK
dC8TdK/pEd3LaOw+ZNiqh3imMGLHDJybmakz0yzOIW4/1rpXvrSZmcoKuvjm
7QCTNXdXEm8KmzmpllIpAR5u/dfJ8RNyDg3EeHVCvvalANZN2MOukMTlecAD
c37N0CD/6VMf+gh2dTg4NjgS+Jspj/0hlG9+ihF5IoT4tmdt5PvOAUYsI9qX
L5TN5AZ5tL8EDycz9Y9ZQn/JVpXRNZB/8uKpnX+hv3iLZZDWR+q/SvxNdbA/
bx7MvgT5V/mUN1H8nyP3bTndv3DMZeTEoM/aSydXUJ3kuq79FkfgWtkyQ67I
4/xP3Z+zG/wvGHg9uxb+MyzwnQX1hU5fJ/WD+kJfqQUFU1+ol7/vQerDufw6
6Tzd+5gGb/pJfThc4iX53uBhp2HJTapLPE3feYnuu0vHK7JFwH/rsc7vYoSb
x265CbzQKc06C3Fg7Ubtelfq2/kwIOtO82pwbVaBfO9qwx0ZFHdVWL2ygHy2
SI8g1YEdwx0Kad03bb4tS+teJSAhtQn5XfZjg8uPICdrPDxtPuQIRrrxCWK/
S9VbvaP6YepDn4TfxENOb+cV8Ka3dL/ETuBD794+XY7vyquUdL8PXCg3/ooS
5TV2YiuXUp+SyQG/SfBfEiSR4EDxP9eEmCDF7WLyTeI4l/s+ykndAj6xc/Jd
Bc6p6adZVnuh560LQnqrgXvmGepcwfjUN6FfpGD/LZ56DPXT6pdc96R+2nX1
ZlY3ob/i2YSYEujPvSnQf5TureQPCFEdbzJ0IoHqeHOmD8dTHS/nzE753Vjf
a4lV5/2A+7Y3L02HnLKayGfadK/3YvlNyq/FZrXXU36tPpS4g5fymsawHLqv
HONevYLuK/3LGtR8MT7rm7IN9QOkFOd4ncD48gvSz0rB/88b64OKyL/1yvIr
UR2pLX5WEXjg+TTGT3Y4e7eUiyTkBE4vL1FFnGPXMbVmC+KctT/UtIyob/mv
7mWBv82MQEMv/+K2AUawM9JCJorNOGZnOGwKwHr9jWGXjiJOu5X7Quwkm4nn
tR05hvVKPON01ITi+akDA/3U9+VRd/8L/Nhd7XLvJ9QnGaetPIj96CcSNo/u
u6XNjfLovvvHk28LvcH/llTpY0qw2zuPrBf8v79Ck3c39Vc83+aw6Sjkt3B0
lZD/3xjTPDJA9uD4RlwK6/hmcJ9vHOTw9LddLoOc0fxkqS07EH9ObbEvgJ+U
XnXH8zH85JL0nIdlWN/PHX0D8hj/PMpumSPVJ82O8zPg+XbKEus/kH9/cdw0
Fvmr/jXuQ2IsJtm5TTITfnWlwMv4pEuIHxjFIKrHag2ra1M99l62XSrVY1er
sAzp/vT8qt4Suj998DaVTfs3tNStjOqKvFLnLKh+ZXDumifVr4JEzNcvwXdd
F655SHZedGdBB9m5AVfMvOWQs17160a6d2jkG9vyBPijitix58BPpt46SnFg
t7zm2mC6D5XjFVuN7zISi3Onvmu3TWbx1HetonvnRjrwrd0X8rZR/dBtreop
8m9q7cGxmDeo7+oNG8jx290ixKL+h7jXZk/pXL66b+EJ4GrZdu71wBO1Ihps
Ice0101qPeQE3/qlGwQ5JZdXJ4vC/u9tWnCC7o9kFyhw0P2Rc2upbyjs8GCY
TTrdX5js8ZbThpz0NZIj1Jeu8njWYtpHruZbS2gf/fONKFmJeU2re9gUzwyd
75KgeEbO6rNeOvwb5w2X0v2Qb9QzIlQE+a+7BvyXbmcxe/J2r7LG+laM/ZhU
Qb6T5JxyPRJ5UOdFXr+/yIO07Lo2TAB3eRz6w1i0hfm4vNnckGuQKV77dlRI
hc0oRqZfmg6/LSy9QyAffvtWgPL23fDb/TNMRjljGhnl36Zsw7Z+Zv+vz3FV
fR3M8ZV87H475IOFZvyhQ7CrsfW9+qfZzJXFLjaLWpuZxE3D2z2aEI+5Vz+v
ikMezfpstdW0nbk/tOPhr7BB5ub50xcSzdqZ3jLXwaktn5jf+iHWPrJDTHzV
eUcfj2aGp2bUM06ikHGUW7+1SraLOT+rIU3AvIsJntVteFOsnbHfnWQ5EoB4
MuvqyxoXyI0UuxaoDju5v3T0PPVRhxj8HKN6aaKVShHihFTZmJ+TZP9H775V
gf1PDkRF6IDnOXKX+yh+cwsaW0bxW++vmfOoPibsudma4oFrzk+eUn1M0fSD
MQ/i82GDoZ7z1Ne6fsZJE/Bvuz6sbM4hxF2b4u5z4Zw91uD9SR/7+rvJxDVu
W/jblSVpDPjxtXwSygI/ta98Sx9AH9u6Cwd/Qh+vXz8Oq0MfjRGrZ9RX//Pd
+v/31dfKyytSXz3PT+H0P3M+MJwThqnz1nxiDvmF8yYcbWNWizBfrZa/Yy5d
SgnmmIe8MvzbZ75nHcwatZDTfbEs5tnefGPm+wCjwqd+QcqOzbw4FdjTdgL7
rjL+QDv0yVkQm1PjRn2bfxtHwLeHj3hlVznimfGNui65bOb9i4cvhb82M/Jf
7BX0WgaYgalHsluu43zffqd9pQOLUfIS5ByAnFnZuY9zIWd04t3V+eAtrzLM
lfxzlZhdNPlnFSenn9R/9fKwWib1X431v99K/VefnL53jgDPXzVX8xRwES3n
Ry+Bb512V/IY+FyqwlxcAj6ZlP3bFcGn0sGKJdXwM4uiwvW+gf+/zwo2x8Fv
7GvKWKIN3ialnHuaaP++CH2/FHIurVAfTYM/LNiWH/QI6/ixgUP3Nuzhv0ax
bdSv6OI/L4H6FQNtSv2pX9FAtr3Sk/LExQt5Kd6reioSRfFez0G7e3zAedVm
dFbT/k2ZM7EO+K5u5c47ynRfxk6n/PH1/LH7QtDHdFp83WP4B/0lKXMpTluv
Vz3zP8ifc2zAdQf4STuwzPs35a2GASEtFFcMVVrv+n8cMufXPaqzcXANWUE+
b/d/jVWYt/P0xItB4HOlq3snfKh+OHeXCXg7yn47/P/4v9Ihlfz/gTzd56OI
Q/I5hSW8wU+Kq3O4NexT5Yr78XmQvz04XOQ2xq9rbTj6H8YLulZ//zHIYs4a
bN0nOH2QGeLXOrpVD/v37OLZN7IbmRrLy4ohff3MiS2p3163dTCvnhkP7s5r
Z8R5rtZGxw0yq74KD6fua2dWzXL/soG3hTnWpjfMN3uQSTJXejWlhv1yRlSF
dxOLsd4zj9sR/qegUUpqJJDNLLy5siYSfnvDP/cS6kOY/eHPf5GUL4ffLaE6
Z8ODHHOqOwVtj59Odad/yxI8tlOd8GDsTOIn84JiqA3VAZjXCRngYSg7wc8O
+MFVjisbgR+Mn1msBd5cTN3ukz1ksEO3CtF9ys5NsWKYd+yvoyidI1vvx+rR
OdJqOLriIPxG6/XwB2epf+/rZ4Fp4Nnh/sTV87CTnuAUMyPge65/nbUD+P6y
2l/fKC5NWbEpnuz5sz3fGbK34I9+DfAPwfunmdyG/ouKIxLWUN/+3OgrQ5BT
sTrQwp7qk+J/vwpT//Nvgy/9VJdeI+dF+bjS8JPMe/S+aVgpxATxgN82h/Ra
ul9zH/N2ht1q8Sxkbwc+GZ8a/wr4mOSOprPAp+mFbr9L+R23Ahf1J8TuGmFR
f8JQwIjAHeqjXvTw0VXgCRm3nMKojpGSslAJfH5yH7JJB/7Tdo0M2dv8OLmb
drDnSsv97+me0VQozpPuGfO6OGf+Qb5fJCzJyCNusRh4HJ6L/CunKJN1ATyX
Zjyc6sB41Y2Fe+dCTtNfmR+3qc7Qwu1AfQXsG+mxz/FdmzK3y9M5yJuzKIHO
watVLA06B/enSXdzA0/LWD+b7NPZytKP7LMub/I+txbiH2bFzU+Qw1r8Ik8J
3xtZN+fuH/C5wMNvguJYwRtdwUsoDtyW5x4N+5m906qG+l05omc/sIb+hh5m
QVeBK/SdXEc4183hEuqDrWus41bGvEf+TOYQD/03r6ZaYl7OpPUHa8Dbkwml
d1R3GpE5OuZPfmBh+shSyLmpMm3yH9VnZDuvXoCcJ19sHtD7o3jB5U30/uhf
9WUjen80euHfs3DIlx87JJ0DOaGrhw0OUN/FgsmxldSv4h0/j/o0PiXqJJ0A
zr/sxu2P1H/4fO9WeodiXFe6h96hrFH7sNoD+gzu6TlI/QwdUUFzqN8m5HG+
ShzklIvJG1NeJjn/dbw68A49zrbbwBNWXFGi/D3x+YPF+4GvX3TmyEuyE+GM
AYqX8ore76C6mcYmKzs16F9VHNlL9agHMuPOTfQOrlHrNcl/98LAmeSvuJV1
luRLffjANoFf/W29LCUV3ysRy5P8jO5/3wWmtmJdTGT9zh8H/jfYjL0cclyG
2etGkO93F3pFSNF9ysujeV+xL7KOM+ZHYW++RX+fbYH8mGxfkY3g86po8fY+
xDnZtU7b9CgPahP59gDjvdv5YpYin20N2qbZAzuc1xl54TrOhXGxhoBA+AGJ
AisrqttURYTGUN3msYbUx0DIz852NZMnf5uZkCsB+fzJw633YFeh5pF/OCDn
bGXrIQHo/2BIQFBPh8XM6HXQcAF+U/SZyxHY+YP2qdFY8MYt0VwYDjlN83xL
6b3JLIvHdacQdwl3m1a74hw/a7vvy3rEV76tLudUwKdJznEH4nPixAlFqu+1
7tZY9hV83v5r9ZPeOSbuWHx4C+Rkn30Yzsa8y0TW+l/AvAWj29y2Yt6Sl3zq
oTJtTOXWBc8iTAcZEZ9jJeZP2hkF/cLjK5WLmHvPzGUXepxn3AMazy/xamEU
94yZ6tu2MZYxdzcEHR9kHsmFT/CntDMDz1RdeKgP84Bgw0mq22wuT1sIfVw7
5y1yPMpixjN8zS2Q77St9Ayfg3wnaDS2vhTrZWxWU7ES/Au2lRlOgf8JMYHg
3dA/j5N1m/bLtoHs17Rf5jBupj3ggb/sQXAgeBA423aDBzxYnJR5IQqe5TcL
+1E/m3KSZLkCeN5hXX9DCXyWiW+zo7xv7swoFcr7Yib55iXj3JyQWOZPdfVv
3t2Hqa7+1KZs7Vqsu+b759V94Ecxbq1yJNY9duNWVxXsx8F7l8epD+qlS3KS
J+W5i5UOj8B+fmfqZx6C/p13Vvx3H/qbX9oZbL4N+0u8N2Ef9Gx/OuuUB/S8
VKDbOgL/ltmqLU73xfdY1uufg/+77Ze1V0AfTy2Ox9QXp6cvNxpL+fKfY34b
DVmMYY3PshDEJyWDibEenmzmRvXOj9sgn2t71it6N/E4QWQ1vZs4frpHox16
Zga8Wkt1sCsZLxnq83cfeRCXSef4KedGOr8094TENFC9kaNyHid4vtVkXU51
Qq3Nl9Kov5FVUSgzjHX5mmJsT/vo3pPJv7SPjpit6nYAfmfzRONi4PvjRmQW
I56Mb1ste3Ie/Hk3961QNvI7HqvDk+HIQ7l+N+841or5Vvr/2TnI2Ky+Y1I7
1M6oXu5/UHX9A/O88Z3bh0OfmD3tSfV7edqYRayX3kFn6pg2hWsd0zw/MgPu
xV9TxD4w6+7s0TeKbWWGFkn/01YdZOISum3b29uZ4A1jb+yg/25ekaX0jiPQ
w/jFYeg/TbH/4EE5FhPlrm1wHfwc1r60bhR6pk6b3j0N55quxc4a6qv5kODz
6SLsJGGoZHki1vFhjMdyNXzXZb89/cX43ou/FdLoHcQ1iwwNutcu2la5gd5B
GHlHNOWA//KlnR76kL9Yl6/SDPz/k3Bep411FL8YMZ/6mT8ubDa+jHW0OaC9
4wPO63RzhyspkL+apdIuQX3d/tVzOuE3jP/UZtJ9lqRL1l5urNeVVF1nqqs0
vggMp7pKbO2/VVRXUa0zvrgTeJfV7xvSwK2fsljb6Vywe36SzhHR3f9YdI4c
X6w0SOeIz7LkvxuwL3o9MkRGqc/z9xvt7fje0/YpIvS+couw3DjVo2682Lf1
/++aD11TDETcG3HZedkA9Ey9Knk0C/JPzv7YSu9oWna12dA7mvMSYbb0jmYx
h1xxAPzzdD7frgzgHgM/JjIgP1n600nTHSxmf7KLcQn42ZDMHXcH/G+J63w7
hHmThV4uI7/UI7ylht5fz1Ap4y6leCw6WoTeUco4C2wwwryxfoPidzF+voTn
0gLgH+7WJVN92C4teucc8KzMx3tfBPMOLVz3NhH6eK35zUn3yDc6vI/TPbLx
zKab/79HnnI9forq86zEb5wY/2DC4thrjC8/vjBtBN/71ER+Dr0jiHto4RKJ
8SLlyQtXws45JKVWcVN9td9y3Troz22enEv1JYf9x/KovhRo4uVK9aVNgTXj
9N7nXEG4E73vaN328R+979DR+Pl+OvT5s3t4I93n/lkj9G0fxmcevlu8Avaw
sT57Gr03FFPPEzkMe7DnWzPsBPxN+lWLCOBhISJjysBbKrJS9ihR31HldarP
bLLXMi6BHLWk1ix3qt+2NgrKQT67/3T8GuBSXQkPc2EPQga5mdSvu7xJ59BF
qltesm6iOFDRj+cMxYFb+99mUxwo/0wvzw58cvue06E6w+SLjIVUZygas8y+
B/nHZLaLkR1OC+D4SHbYeThIV0SaxXgtNBr4Ru/p7ovtexHEZqwijk59gfz3
WbteUX/IoexC9zTI+SUmrGcCftbezreh96SV27IU9wDnclky0xfzOvw92Ev1
yS93mr77UD+nnCxzAvMqjt5fuo3O2RjrORQf8jN3B6k/SmeisJ7qtEdf7+Wj
/ijfq0EGF4GfEGhaRHj6x1Bdqv8sD/qVa4n93pa8/W4d1RtrZ75xgn3OeWwi
N8KwGG25/m7qx041vljVQus4vvDrbMzbPlGwjvqCNMf3q9L9u5ZrafxSyte+
/znwhs5l+x4/SeoP0S/Zfh3yRZa7fW6G/HmTF+6bQf5iKdE1mzD+1N0EgbdU
b0zYMl+c7qPXpZsqgJ/lrPYayssWZXRzUl42kjwoV4hz8+Mnn1mh9I5jc4NT
N+RYsdYeqMB3pbBWs6mf/HrY++uBdO8jIF+VA/51RMNb5yHfcag/kRgB/h1c
VANTTrKYpqhL+e7DA0yh//ifklM4d7ii/oTj3LlcFDooiXPn8Iz6ze9x7tjo
Z87kmtfMWL7puWObDf2r7kvqvmcz9T8N126NYjEWc2dc0P+GOFyGQ7fAHudO
ULVtF/zqr6kijQfY17EKTwZfYV+ckDSK3aGPc//en2h5nFOLVuuqz8C5qb79
2K1QnF/S4194bgBP0OvgOYbzK/aDVgk/+BnxUDCtofumxQGilOf+456bfB55
5fnmFA8HrItZXlKpP+x/7XLXSG/wHGurPNEIfj4JLjt5HPx8OVjWr4t9MZp6
q6sT4w1fPHQpxHotHn7bTvs00W9DEe3Tk4eu2NE+fbB539kJ2NtJOznePdSv
UnV04zGqq39Pl/wJfWx2LOIcw/jB1QJun4GLmvkn3Yf8yF/qztS38OE6X1gq
1Xs9uLdNYp9+Z3cX3CX7YW0uEIGeD9qUwzfDzj/9J3hJE/JvCPFOHqA+55ZF
/A8gx9z/egbJWTmeKUlytm6TnXgBe+guVSmm96SzV8psovekPE90OJeDh2PT
slLpHV+PUebbeMifd0iGg4NpZvK3Z0Rfez7ANFsPCeq/YjMRPWLf87yQdy+t
3pn/ZYCxPVXT2+eM+CrFh0MAesbM2jdO733EXFNv0rv4wi16pcrAPZq8NUOA
+zhm8WgDV56ptzgI/jbid/tt6oc02rXwN/U/O83QEu4FP9uHj9cMA38YaDhO
+cL32QsvdiKuONP4rYn6636zcz7S/bWi+YK1YdhfMUMiZ15SP0Nmxcrv9P8D
VSkn9uC7PDjH9CyAm2prCEdj3tOBXoXe0OfhiNYQ3Ud/X77rhiJw/Xt2j1Ih
f6/Z1GVbigM/T5S9o3psbPYHzc2Ii47snJ4I+x/XfcJ1Hfm+46UIqUc/sC6v
xxZKcAwyha83Bz7TxjnuxO0cM9LGbA8p3bDAa5BR1u6qUfRpZxIiNorti21i
zGcf3/vZY4BJ85ivPXtnB6OkkunkLdrGLOTZyhVgPMhIbzAbupnbzrjdVOK4
Xd3M3LJ1rl7diHyEEdEvTkKeu2Ry+Cbsf+XIfBN12HmXbKxOP+w87V/R51Hw
pj6jvPUL5R0tNi7D4G2v90x+PezrxJHOY9SHL9vivjWV7iMy5jp+lGcx6wq+
KE0HD3dtG/npXf/dl3errRC3H7l/UfwU9u/Q6ZBr+ti/V0SqGuk9kXmvphOd
48W+34XoPZHH+3mn6F3GQ1H+0/QuI6dk4ga9yyiK685cBj1fC8jt3QY9vYe6
7nNhn0548XtwYr0G6hTN0ynffPj601Lwr3Xwh86JjTjfF7TdXQuen9w3NjOH
n9mWd0TjogGLkY1f5eoMOW0GVzbfwfeOFbvxxUCfc1s1A6n/yogrdB71XxW+
tQtr3IJ86vZAVgfkeDj7tEthveo3N0U4wt/eXcicIT8vvuSf1TrYiaewcmUd
xqcdyxOg8ftNG/rWY7ySIWulgS54c9rTfgM8/Gh+YcYPHpb5TrOmvt/VGS4D
1PcbtEJQi/p+DxofDOjwbmZOOPvEN1UMMA1Rc+zrnyEvOLi06G9eC1MY80n5
jPgg0zM5/4W4EJt5z5/C3F2NdVz2sKi4C3HOohX5r4JxLvPYv9+E79qXILPs
LvTkkeldQv20vNpf9o+A5/ybF/bFARfVrk84C/yK44GgVuD3d2QJUx9O7zwW
ty/wWrXJyT7oado+LYX+D+HG3JMN0VT3WLJ5pwzizzc3ddZvA75916nYD+Df
YEvHAwFjxLEdPGpSyJv8e6dKbZA3bTLdkm+GdXzIuYutBP4veRuFTXhSPdA8
ZD74ZP4+46N+nix/gRd7qc+qUPgvxW82bocdKH4LiJE6RvHbvLEHYx5UL4re
2WRI79cO/Emn9xHZ+TEXBWC3fEr708g/dy6KS1wL/Ye9P5vQ+z6zFfue0/u+
dvMv1vS+L6VnkqcS+1qGJenqDv09p9lOOZM/cerYWItzTcde5VoYva9sSZzf
Ab9958YJOz344ZUdvwsoTh7PT9lE7/6mWgwiVZSoj31VP8U5mx1vNBZD/jkV
NS6KW5zlDhymuOVvef0QxS2LxNRVCuAfTtvrcdJ73iWbo1pqqb9IMeHkPPDf
WnpgLr0/VflpEp1LefryJTdCUnCOzC2o/D4+wLg+iEtjbJAvj5baTywEz79s
h2I6Bhi76+WxG8PYzIf5zQ+2Ib4V1r9+hPpy9S98sqC+3NbMPT3bMK97xfkK
Azq//CrXfYP8p5rn6xZrIy7deztEEfZZ37Bh2yOqX12vunN5rJl5FWjntLNl
gHn63/FNR66zmfy5Eu7yJnQfymfgj/X11ZLfXn8G+Wn9hjtzwP+/GV3RVZD/
7GPx2g2Qv7CafYPu8R0DlvtRvDRpcjKe7nNjDx8aswI/Sw9d8KC+0z7XnXHU
d6r+7+Is6svdmccVQPlL7fbjb6gvN3ei18sf+ucIrlhAdYxbEQOrqY/o8659
o/S/SSb2J2rpf5OC/fNP0v8mOX9frtFA9Wdnt9v0rmHjvzOlPPQOpWiL6H7g
qhwJCTLAbYyCrbcC/xXWNIfeEz2tUDhF/WYXV+27Q++JGo9dZ1Ff6Oo9GZXU
F7r7ndc86gstWKx+5DjGz495n3gB4y+L6qUkYLzyro7mftgVT+T7p/R/EZX5
X/8dh13tPj5wlvq7+Cxk/9/fxSGg/5v6u2reHnddCnu78FX1mgvwRwvu3eal
9zWhbRY7wU/S7Vs/KO7qP+H3gu4Zzyxp+SYD/WPaVhetBy5najlLgd6t8ybM
2gQeDArzmvSBvxFwq/gOfS44p7FeQP8/27x7LKgeqDijjO5zyzc9UKb/UZHo
9jpF7xZnu//Mov9RydS5JkdxoKq1oyDFgeLnbOdQHDjBGuv1RPx2sU9ZkQP+
7dPeDp5k+FX2v8bjH7Cvbx58Y6SPff3yStiFd9jX6ix+VjL0ST7NrUznoM6C
BtUmyFF4s0bnLcWZBidffaJ8x2qr6A/o82+TUzW9L5PceEqN7gfdZ9gp0v3g
e+/rgsqQo+k6EHGY7LY4Ycko9fVtSQ62pfdWP43eEv/Oeua6xP8s4WhRet8k
tiWxhuqBv4Yt5Oh906uZgk2TwAV9K9Tp/YVcW5e0O/DiuoLV1I/6py1wE/Wj
VvtJ+VE/qsPb93suIx/cGP6j4zXixr9HD5fF4lwL7ZzZO8uFxdxSqr6WhXh1
Fv/DcnPEq0KefgYhN1lMyNamef7fke9kSlfn2LKZtle3dzki7/YIfe+7H3LK
/Z/vckPe3ac9srcQ8R5v17HDQtBHOTf03BGso+Alo7c59H8dB1+U8UIf1+hv
H55BH96mBhcZ+POUNb966X2EiX3OGfLno0XOGpXI+/JbnuuvAm+aEeaWf8Gb
9aDUSs1ZLMZJdV/QlfYBxuBLmeG9q4iHH+72/yPZwkzrf/t7K/cgEyHfa/pp
N/K+MvEgUdVhZslCmfzneUPMrvwFiwVc3jNvRdkr06a9Zyz7PEP8LuL83TdP
N0Osg7F+Eb0qAn7+yI8oJQZ+wOzO9/i98PNuk0brqnEOzv+x6zAbdvLy76u1
0jgHuQbXWYRB/3hWygTVtxVCHbOp3qvVnrFBEjzUKkjvoX4zbr1j96jfzO0K
/xtdjN8/S4LJBH5+mrDeMeoTU0oSnQv7t5T94E/5Tuu5rkx6B5Fl3DD00ILF
5Fo9vmL5eYC5XbeepeMBe/B0v6uH/VXDv2OY7i8K9V6nU5+53hmzefT/WqpX
nN/Q/2s9SbrNprpThJJHxFnMG/uI/foJnRefyyQOUX1pMx9PP/W7pus7rQPP
1QKd97+D56gKjV0bsb9Gh59Np/i5rVGhRxvrlbtHyPEK/EDlBt6HThhfX7jt
tw/G+26P97GhPtI4GXvyV7JrBYU/Qv4ZgT9DO3COqPnGzWnH+JjZZTPL6T1X
f51AG/Xz3FdVpfdQYm2P7tF7qKDX5ePdwC8IFl0sAz5VkOq7Hfh2D8sUD3zX
vSTD9fReYNz25DVHyPka7DTRDvt3FZ/yofN95XMjM+qzzei9oCyJeT0OTmxu
wbyxsk4drzFeQveD2Wvsxwy3yF/0v2dTcp/76P3I8dA6xw58lwWf+BZP+i4x
kWh7fFd6wRXl/+DfEs69GaT/f+iqbJ5L//8gy6sWLwP5M29oXmqld8RHHCIr
IWdlj/izV5Avxi/dQfJVd5Qs6gUed22HkCPipbUiuiHxOI+inh9bNB/nkdNK
I2vyk68CZ0aRn7TWDrhDfvLe/emb0sCnx5yQavIzJ1SfG1O8PS/3TEkY9nU7
76vdmylOMEkf9KQ+0tO1o+XgLayhoIv6XpokMk4zdM9iMt6bg/g8coXghkew
20ThicwzsNv4SM4+H4y3UvNOoXfWeY9+ZR6kPi4F61Rh+LEp7623Kb/2E7z1
bQ3wryfm7LqD/evtmvKV7neWLwl5Qu9GdW/KszTgJ+UfuPrvgp805/ii9pfi
T62vaV7IE8VfebylPNHBOu8h5YlpCY3Rr5G3Tu1eeSYdfmPQru2/OvifkZwE
4yOw8y63/iZ92PlNoyBdW9h5tKRcXtJSnFPnjZ+md8LvzQ/2NQ5lM6rl31a8
3tfMDEyX/zP1Avv3VsXAUDmbCanoc9BCfO6pHmnhDJ4rvBr+GYPnfU/MZvVB
Hx1/7+O90MdbTOqQBvRRWzPLPgLf9UhDv4wL+JKpKoliyvuMCn9kwP7t+L9y
mlFdellPxgbg4sqemzxhD5nVRYfTKW8NPX39AZ13vkmVdL+ZnVZYTPebziU7
TtH9ZkBAX9lMyJdulthC/yfjtmxXHv2fTMYnx89Uj8q7K7uF6lHVGl7DVI/K
i/v85B69mxBtNKI62/3pb2T/X2frqImNQj5SINsq9p3+H2auWZAueJsyT3Pk
gfwS1XfX6P49UFTY6P/9UTE+LVZ0H5q10rwF+JbRyx381F/6LaEqC3pu+uxs
R/17jW2F3tS/J3KtWJwb+qw1rMgk/7MtS9GG/M/jyYtXBsBbkknvT+JtV3mk
sTr1F929cLO0uZkp710htLRpgOHitDrqGA9+DqTdon5O69+W36mf06d1lEX9
nCsWlqYlwG6tdaontgL/LbVknzvwaQ/+3HqKOI1jf+asw1gvm+YLqYH0/10l
9eFxsH+ed3+Z43R/lzVzWjP0LNdbFP6J3sXzuTTRfVnHyy0yXyAnXu31+7fw
D1tK5c+J0ncFrl+mT/4zzdDVBzjf0PS91CfG56yWS31iV2L8/0lj3xX2HuV2
gz5zB23yuCBHs6BuL/3PwORC9wmqwxuvG9WlOnxl88NrqtBnhcJ/GtTPoDRL
tJ36Gdbcc4gwBj+2KSeM6N5W1OEklwv9r+N+r44G7HfZe0GdD/BdJ3UN144h
v3O6lBmWhXkF/sg0XcR4nQ4/6Y8Yvz4ssLwU/A+c/aa1F/JtBQ8XLYSeVhk2
z58jH180nN1B/zun5xYZswF+6aRM73CMFuLecl2V6ZDvvC/s11LIkawYbOqM
xbmvG3FKEef1NA6/hRvs2MzMJycWmF58z6w5+Gy/S8IA0/No88DaSTYz5/pV
l6pTLcz53qZi0yWDTNqdvrRlG7DfDy8YbvSHv9XkZGePDjD2OYusdpxkMxYJ
23xj4ffWeviYfoY+n3iuvEn///8ntO1qBg+O1/Q2dVO98eFaEW3o8zSvtywK
vGnMbnhP7xeG+C7Y0f+8pXGZWDnAb/zuMH+uDL+xymWl8Xf4jdwrYwl69E5W
ad4lOh8fLZ3daEr7KCc7ieoeFrU/u6ju8VLLo57qHp4S32QYfuRxIbedU5Av
hBQvHRRGvmDlppdUbY+44ve2hKwh7N+922yXnIZ/1n2+1xr75dSRwUCKz1U6
jwRRfJ48b3JxHvRcOPIinfq+hPcX/ldH93ROnxY/PoDzK+uYhTT97011ZXMN
7HNbssfjJPh58aRbN0vBwyhv7qsR8JAefM6N/n/pi1zXGbp3zmWEFOje+a3r
BgUXyteKz/HS/7k5/RCzWgv85chKm7fgTXW2/u4u6FO72OuZDnib99/92dPp
f65KXsvSux6Xettn9K7n81xp/3PwP3kKX8LI/xSINciT/6nq1rjGpn6kFPcG
KfBZqrEvWBj2JjtglSWM9XKpj5Vuhp7PHqvqvqH7shVRhheg/yyvueZFwAee
JnD8AC47rYutuoTFXCldO7kf/jZg40j3tMvIK5lll1ZDz0tZXM3lmDd3ZXe0
D+Zd5XitaxPVaQ9r9lHcrjNDqpz+n+HEF9YaMR8W07by2OVvXwYYfs3kj/7O
bKZBsWLgi0sLk/hL6NLg/7o782iuvu//Ew1SESlEimYNVIaQq4EGhGTOGKIJ
SSi8zAqppEJJSogMlRRpUog0Ea45U70IUaQk/fZ5/79fa921eq/39/P797Fe
677OPWefffY59+znngn2Fjx5+iewt2+RRb4FuTVU5WrNPY4pbKpwflnmpj5Y
j7yEfvFDXPqkpmXPLYhLZ7go2thAXBq51dTHdylNTTlsJ2/dBv0mpBL+IAzi
dh6XW9xvYV7IX+PpG2VT06aftDM0B78neKTnNthzVL3DmWyw50zhKrcNYM9J
WQYTVSGuMxG7rFTSTvKbPHKNYH1cFMY7ag39/9hg+SGyb5pMvbxB9k1nS9vc
SP4al2HWP/lrlU9OTif5azKusXXN0D8iKXXO7dA/ynXvx+tC/2Te5X0/F+a7
9G794kPAT4REXiK6EF6Tt8V/Brs6xf/mkhK53z6WIvgQ7ErCd3hCDcz3rvqY
XnKf5IeybdpCmO8yl9rVloFf/Rq2L5TkIXY+mpRH8hArPPjFs6D9Sg1OWTS0
/2Ntt7QitN+5poNLFJ7TfG+mK9HhFOK7WWZOdJwmFO2oInq57VevDwLnFb/X
Hw/j1SF2dVw/+Od3nT6N6+H5ii3lqrbw/C2jjkeIblLae78Bci/OfsH7YqKb
5M5l3Xl1CfBz/nPUoP/lZ9wJGIb+zx6Ti7i5BOLwG+EqBhCHF8boziiAOFxq
wFFHxZGmDJQ2/hmE9T3zd4+8qWcT9WbRldUxi2mq9r1ZtiA8ZzF9+Pn64xCP
6eTPqFhJUz8Xxa9cC++V63XpvRbsy7YbTZ6WCH4gx5f7PtFb2H+j8iPJu7SL
EHA3Nif5sE2xUyBuN1HdoHIR4nbpU9x7XsF8kXKNP3GP5BmFfuOLhXHRyOw0
Z8N8yegqiVwO8+WW9pQYUZgvzl328TmSsH/Pf+Vo8IFN3aja568e0US9DBff
WmJGU2ap8zyH4Pc5m6pLiuD5Kazx47mUIA6PHp1qC+vysuKgnzqwD3o44nE8
HMbrQFhBqjn5nvL7Xq0iyXs9fq7TazlNyT6Izq6D922LWCLRDe/lL6ceqrSL
pnx/3i4zg/bnXzipMQue/8JOe40sjONIYVlwGIyX9S6FECMYx8N+kocKwH6e
G17OJ3q2iik9keVgP1/CIrzVYH93TcqeXQjtWVen0JdNvvdFuW9IgnYWai/o
PQp8dseth3OhnYMW9T6e8PyGerWis0SHanP9BQ14/pffvnaj3DS1c8vnfS0N
bOrM7yXz6WjwA+HKKapER/Sjsx6J5/etvB/5nJwzOKpNr4Pnuy0Iaw2C59+P
Mj44HZ4/YeibQxCJMxc7ryHn2Nnbuu+RvH6BmmOlWTBfzB9o3WmA/tmsU6lg
DuMSo0xr3Ic4nD+LR9iD3Nt/KDvNA9oz74BT3E9YT+/275t5F973iKvxiY8w
Xlr8UrpxRN/Pz3wC0bWryTxZvgr6+ZdaR4oD+J/4YfGmMfA/ZvZ5p1zB/4wc
0wi1AD9w7ZJZRBL4ATmJ2n3m4AfKSx/EGFvRVN6s4J4c6P94/o+agd5NlNCs
62U9DjSlPOBwig12+23uUY8DYLeLYqaXeoOdWLGfx28BO5Hd9jJcF+zkdaLz
yhsudVTCig6+SPBvUQWhvaErIP6063bIu1NPFV+P6g7f1kV9KElnX6lupKwu
mEckP62hrHumf/BKY1MXcofy8rubqGeVWd0NXbVUqliJDRfNplZskTx1JK6J
KjQJVjkhRVMp40+rJcD/8vDMoQvDwd8GGYzd46ep28UbFV2a2FRGjfvFZach
jh3Rbl8lSlO2VYJ1LuDPTx5ZL/ME4ufyXu2FPOSciiu89CvZT81ScGNDvw20
pW59u4Omsh5MPVFL9imn665lQD9f1LTZRPI0PSSz5Uie5p3oCk+Sp6liWGPS
bEq+Fz+n3sK8SEsWcBoH6/jEs+t+jH6rpVxGRA5dqYN+Hhm3Kvt8ExV15apG
gjVNDVLjTDqhn2f8aEtdDP1sfftgiJEtrO8aGb9koZ9LOn+1ZEP8r3pVIFod
4v82l8CKeGh/rBN37hFof/zxCOsiX5rq5ks+/wDGd4eE37l2GN/mUKMu0xU0
tSxiW9LvNrIvvpN6E+aXsLiP0Q/oN65Z1oLZ0G9H96taXoZ+O6RzVqB0HMQz
pnMH/oCdhxXqhF8BO1+Z9vltJtibR2hIbxr0w3SZU4a/oB9iCqq9htTAXwmK
VRpBP9Bl53zToR+Cepc2fwV/qJ/g8W0L/G9CyPYzreAPbzeXdLTC/otvvVb3
PfBjKcLWiw+Cf96rGW77E/wJNfXbjd/Qb27a+4pyYb7/EF3/a8c8mF/nnbI/
QjtXOuptoqCdlsqpL2YehPj2ST9bCdbBKZqNYnIeEC+NvLMfOkJTxgsOr0vu
g/Uut0L+6aEmau5wmVusIfiNqJKUYWi/ALu74DC038wnnmcM+lM2bkdwPvSn
pybXyg3Qn1MC6y9kQ9wyLvH4b6Jn+/GVehDRn1HTX15N9I5CY58EkPxWnhdp
80h+a557qKEE2E9XU+677/D7UjmBE63kfOCjhq+tHOzHQ4sWG8D7Cs7Ir5WE
/l/9QXMCDf65zth09zwY9wstGlme8L4j4tOeXQG/R384enMv8MY3RbYjYA9j
gfVhQrDfWTZx8voW8CfvuhYoeIAfuxJrf/krxL2iFa43BOC9jJfeseIGv+EV
n2K8TwHGcY2M1Fzif+ZKjj0A//MuLfx2JNgt/+jhJRdgvFrNdEtUYLwW/cib
GUPOEz4+PkviNBmNlmkkTnPeo/fBBvzYVKHAWFd4zgZN/T2rgkn+wpbv8Ydo
aodC7P4B6P9xyl2fv7rD+luS5TtzPNgh92CNVSObirtgv23sTBPlEFpW9gbW
LyuttlKyfunN0XirCf2weKevnRzEA8k8OzaRfYfgnPGmZN/BtbrSlfhnuT/n
Bol/3mP5M4f4511N8xp3tddSZUmWx4dq2JSo6bdy9Yvw+4Uq8aG9NNWntisq
nbuLenbz4UaVHRAfesYL96TS1Fp/ypf1HfYdTp2sHQ5N1Kldc3cOcddSE8KN
CspvsylLo5MNM+ogvlqel31X7DFV+KJ2uOBQK/Uiu+DLdrNW6t+uI4BxpnUE
mNYFYKr/j+n2Yzr8mN7+f6Wrj+neY7r0mP48pif/t3TgMf12TKf9/5q+OlMd
daZ65kx1y5nqkGN64P+27vff0uv+t3W5Mf1tTGcb09NmqpvNVAebqd41pmv9
b+tI/6/oP/+v6Dz/V7rNTPWZmeotY7rKmL4xpmP8b+sV/1e6xP+2/vD/up4w
phvMVAf4b+n9Yrq+mE4vUz1eTF+XqY4upn+L6dli+rT/tq4sphOL6cH+LX1X
TK/1b+my/tv6q0z1VDF91L+lX/q3dEqZ6pH+LR3R/xX9T0y3E9PV/Lf1MzE9
zL+le/lf6VtiepVM9ScxPUlMB5KpriNTPUZMXxHTRcT0DJnqDf4tXUFMPxDT
/cP0/f4rXT6m+nuYzh5T3TxM7w7TtWOqR/e3dOf+K305TBcO03/D9NwwvTVM
Pw3TScP00JjqmP1f0yvDdMmY6o8x1RnD9MSY6oNhOmCYfhemu/W39LL+bf0r
TOfqb+lZYbpVmE4Upgf1t3SfMH0nprpMf0t/ianOEqan9Ld0k5jqIzHVQcL0
jjBdI0y/6G/pFDHVEcL0fzCdH6Z6Pphuz3+lw8NUVwfTw/lbujeYzgxTPRlM
N4ap3gtTXRdMj4Wpvgqmo4LppWC6KEz1TP6v6ZNgOiSYrgimE8JU9wPT8WCq
1/G3dDmY6mxgOhhM9S7+bV2Lv6VfwVSPAtOFwPQfMJ0HTLeBqQ4DpreA6SFg
ugf/tr7B39IrwHQJMP2Bf1tngKmeAKYbgOkDYHn6/3Y+PpZ3j+XX/608eixf
HsuLZ5rn/rfy2bG8dSwPnWm+OZY/juWJ/6188P+VvG8sX5tp3jSWH43lO/+v
5zVj+chM846x/GIsjxjLF8bygv/X83//qzxfLG8Xy89lmj+L5ckyzYdlmvf6
t/JSsfzT/2v5oVge6N/K9/xb+ZtYnibTfEwsvxLLo2SaL/lv50UyzXP8W/mM
fys/Ec1D/Et5hf92/iCWJ4jlA/6tPD4sL49p/h2WZ4fl0/3/mgeH5aMxzTtj
mv+F5XlheVj/dr7V38qrYpon9bfynrA8JixfiWle0t/KP2KaN8Q0PwjLA8Ly
fZjm7zDN6/lb+T4WJwZ+vttWT6lO3muQt7aLmtRX6b7nayPKsfwgpnlDGFdY
t3jCF1IHuX6bNzk/lMt2kF/DgU+2SK7Ig/3O1bleWeR796cFt3rJ926MY/lK
TPOYMD754q1I8v1x7cbdE8j3x9plA43k+yPGsXwopnlSGO+d5WlG7oes2XFv
HbkfMveVetQ/90MQLn3Z+/IYzK9QttX56TC/eif2CI/54jxD9arCIujnuYN6
yaTuT+/EQQNS9wfjWD4XxnkTJp3Jh31Bh/3CT6kwr18H0bVVQTh/u25L/uh8
WL9sWQt9W9mUrtUkHvUTOMfyyDD+wUYqMc6EpozUrRdcAv+ZwjXP1+IYzrF8
NIyPRF+6/hz2ZdOmrVUi+7K2JoVVnQE4x/LamOa7Mc2DY5ofxzRvDuP39VsT
jGF/135d/2gy9JvYNeUr9/1wviihbJoavNe02FPV5D7wmKeZALkPjPFPJjqz
SV2JB7EhD0ldiV00O4DUlcB40/a51VawPnI7b3Hqg3mR/uzX8WAfnGP5gBgv
vri/SAX6Ie/sfvXx0M4XzgdP+wXgPPH5b0VT8AOWmi86PoCdWCw+m1fIgZv6
HpklDHYlcrc9/yY515pV90kkEOeDI7fmWa6hqWjrcc8HYd2sHrg6Z0IIzrE8
R5SLTV0dCX5j97kEWp7cfzjlleDDwjmWL4lxgzutBTHwXpEVw6FP4b1ETjqY
fA3A+e7ZP2/uJvcwj0i+4Yd2Wnd/NHbnwLE8TYw3xAo9vwbzIrf5MZcYzAvB
HHPe0KM499vlalIC/TDnfdsyVXgvkzLZ9P0snEvGi7LI976Harzjic6bg6Wm
GFnXMI7lkzLNM2Waf4rx/OSq5ocQ18lY2ASzwM9fqLfsEA3G+VfDoit7IW7c
7VW0uxd4pYTEZMsgnHfsHxrqgX1u4pyGLlJfuMcm+RCpL4xxLE8W4y+fRPT5
w37hgM3zDU9hXWh7rTNJ4hjOsXxbjG+Y9cJkOtjV3jPTDpF52nPmht3MQJx/
VNUTyYdxOXA/fQs5hxE+Kx63ggO3q7a61AH9tiTX5jsXufc4U/cs+U6EcSwv
mGm+MNM8Yqb5xUzzjpnmI2M85HXgujai33LaejLRPT4eJVZ3PgDnWF4z03xn
jAunXY/MWEtTC0T7C17DvHDKOOZxJgjnpmIVPR+gnanRpu9JnKn/3kuBxJkY
V5Qf4vaBOGTyZM0B8p2iUanwZ5w/zhM3CPqcg/fa/kdhkJzLXRXfrFTHgUtZ
vL4hA3brt3qSHqkf8eLN6/MmgTjH8r6Z5oNjfLr48/uXYF78unHwwBD0W7AI
v45eEM6xvHKm+eYY/5TXN/QK5sVdx4q7JK9Evn92clsAzu9uE5mVDn7s6G7f
2WRf77L6/ngbDhzLc2ea/47x62ZdFdrgNxIO8oVMJ/d40402SQXhfNq+Z8Ie
0G+D3F6Z5Bx1Qxuv8eIAnGsKfxISXEpT4QIy13Qhjp2/c0VUXRjO1bnF3aNg
3+HwWGD0yj95yn0ZLUE4TynnZa2EeZR3Q6uqAPjSc7d873DiiA4AxkdDk2/T
YIeHvatSLcEOH6WcHO/ji3NMT4CpzgBT/QGmugQY3y5fHvSZ3DN0PFdN6qrz
BifZkbrqGH+T7tzkA3YlrsC/mOisfpF5EmjIgS83CrlXSHSSZUdOkvsh36+2
Hyf3QzCO6Scw1VVgqreA8bvsuY/KLaqhP8RTprqwqdGy5y6dOs0ox3QbmOo5
MNV5YKr/gHHWaBzfC/Dz+5W/ZJG8nvGSLX4krwfjmI4ExlOcnw4mh9JUU69J
1OIBNuU7su+8+8EmlGN6FBj/I6qSagbz+nv1ik4HaKdYUif3qUCcY7oWGH9V
GW0yBPugD79WfH0IdntTikvkpB/OMX0MproZGM9MXhpM6i8ciO83JfUXMraZ
+ZP6Cxjf/vvW0YMwTyvtpOvI/ck3Q/weJv44x/Q6mOp4YDz4UsXuaOi3mHMx
07OgnbwVNippfjjH9ECY6oRg3PeHtO9E6LegHaXe5Pv1ElVPDfL9GuOY3gjG
i36o7eej/sl/XJZB4tLF7VGigTi3buFTkAC7vSC9mo/U65mfqtKUyIE3Dgby
N0FcYZUbtoXoeGwSWMlPznkwPq5rZNsWWDep+TWvHpHv7PdUcm4G4dyEJ6WW
1K3rEHQ1JHmpFeKsuaRuHcZnv8kdZwx+w2REcncUsVvz/pKtgTjHdFqY6rcw
1XVhqveCcX1Lj/Xrwa5c9XIV/ql3zz06jtS7x7jDzHGPlsH/3jq5c60f/G/a
96D72f44V+5+xf0H4oSIyFttR4BvjD66qZADx3RpmOrVMNWxYapvw1T3hqke
DlOdHIzvj3rZ5AZ+aYnC1Tpy/+dCtc9Ccv8H45jeDlMdHqb6PEx1e5jq+TDV
+WGq/4Pxw2ucSqZDO3N2J3SSe5j75Jzn3PPHuY5TybFFYCePbYt0dwJPV02w
H+bAMd0hpnpETHWKmOoXMdU1wvjCt0ZWJJ/x1iWvEpLPWGQQPOrrh3NMH4mp
bhLGK6tlvpH7IScvBo6fDf/7pOniNXI/BOM5sx6aE/4pYFovuU8y+m3vK04c
02tiquOE8Z8LPspcBz92ca1oHan/G7isvdiDhXNMDwrj/GU3d8VCXJqbLr5f
H/yS5EwzZ+dgnE8d4k4UhHYW/aA1SJ2+3TzSb3cF4pzFZRpLdHK2rOzeS3Ry
iou65YlODsYd+OUN6zfQVJKUZQ/Jg6b8D5yaEoDzQLHoHYPAJZU1RHWAT31z
5cB4DhzTxcJ4p7eL3xQYd+tjVptJ/qOqxPcPJP8R45i+FsZzeyuvVcP/uu75
LEve62viYZrkfWMc0+liqt/FVNeLqd4XxlNUfjf8gPcKkrpYScZlZu24lbwB
OMd0w5jqiTHVGWOqP8ZUlwzjR+z7jliR+5/Hm81p4PpDPy6LcOCYvhlT3TOm
emhMddIwLudxWWMDvNenBp73xE8+m6+7i/hJjLd9dvbSjqcplkllvt4gzIt5
FhECzjjH9NmY6rYx1XNjqvPGVP+NqS4cU704pjpyGDfwOi3sC8/RPfVAjpzj
ZYp2upNzPIxjenQYZ7sKPFIFP7C2rcKRfGdfIeGoTb6zY/ydyCL+Z9APe+Nk
TUidYmpyl0+oP84xHTym+ngYT9D/zlszvZYa2kT1Gt9lU8bFncX573GO6ewx
1d9jqsuH8d0Du71nQ9yoN194PskXvn5TyV7ND+eYvh/GLZY+zsyFcZEYkuAj
eaB17x8fCOfAVaZvP0Py4Cwrnh8leXB8CgPRmRw4piuI8Xnui75Iwbyb/dPT
ey6811GNTv14Fs4xfUKmuoUYP8tbmdAN88KzSv050TfjNel3VODATQrP5n4G
XrHwZz/hWpae4pw4ppeI8Vu/t/qSuC6+JdqRxHXVr4zXkrgO45juIlM9Rox7
ZL7SfgFxi/UWy9lER8485rXWSw6c23vp/hfwv3otY1M0gdsl3PWaHoBzlSKz
bFK/8sezrxvJvZGz/JJaROcE45huJMY3a0WOJ/UF7PtdbIi+lq7vZXOir4Vx
Kw83V2lYl30MfCe6Az8x00l2KgeO6VVi/PRF38fG0E69SaXfST3oagHPVcn+
OBdbHvCF5Alqt6vHkbwAs/V/HJM4cEwnE+OOkwSXLoFx/xjek59CvksmjvPe
64/znzzjLDzAz/w8vGBiIzk3nmJuIsCBP9mRsuk6xFF3i8rKSV0/6a9Zw6Su
H8YxPU+mOp9M9T+Z6oJifKMe7+WjMK/zRr+LkfxNuYSjCqTOMsYV9XdHnYD3
WrTq86YWaGf/pPQKPn+cY3qkGDdVqsiwg34YqT/+gdjJ/fsSvVc4cEzXFOOG
J9rqs6Gd3E9F93YC/8A7uO0PC+fqckES52Hcm5JX75oM/eBxVGbuEw4c01Nl
qrPKVH8V4+5qUg4zwO+5KdxcZwBcdkQuaZQDN9185TYXcLszMTO2k7goMGTS
uACcY7qvGA/Q+JNO9AOvRwkkEz9Ws5nrUwwL55h+LFNdWaZ6sxjPfpNFn1xP
dIqMzwrB/wY5bSreE4BzTLeWqZ4tU51bpvq3GN9vuZg3QJqmnFu7FswCvxFs
FerUcwLn3j3naaIjUfyA9YjoSGi55O8lOhIYx3R3merxYrzlzWvVd7CO/4js
OULqg194yp4qEIDz8gW7pYZgHXeTPDj2luhwyrzorOXAMR1gjO8V93wxBnZl
u3bUg+jJ5Dz97hvuh/NTz3zWXdpOU1z3Wz8sBb8xTlyjptIX5+N1Vuo2aBFd
gvt2PfC/XUr51t9YOC8otp5ZT+pLym+TJPdO18sWfyF1hzGO6Rsz1T1mqoeM
8QYBER4bsJPBUMEFRKdR78hIdEEAzjFdZaZ6y0x1mDFe/7qM7yC8l7lO1WIW
vJflsjkHf/jhHNNzZqrzjPFnpp0tx+C9VKV9F5Lvktr1hTtKWTj/flz1eyCM
e7qIjzSpZ6difbqG1LPD+NWf3T8T4L2CzL7WkXMk1c3umz/74RzTo2aqU81U
vxrje3fJZjgo05RyeY9rfAfEjee+N3QH4dxr8rwDJ2Fc+l4+KyS6Q+fNDq46
54/zVCv7qMZ1NMXeqPDxKLSzPjBJdF8gzjGdbab620x1uZnqdTPV8Waq781U
9xvjysHP/G+AnR/Xeug1Fdp5l0/rdQEL56s28ruNkTy4V+e/knMzEYuk7yv9
cb55pNJhHNjtmsUm7QdIXFGbPiTCwjmmT47xK3sObDoC4279vLycjHv1VuV1
ZNwxvt5SX+8D9IPwUNGQG/BSXaOc5/44H1pXUcAH43IvnPcw0Uno2D/2gugk
YDz6QYGVkTpNxTi83kLuaXjb9Xwj9zQwjumuY1x+ilhJP6yDIebKbsqwDp46
4HP9gS/OMf12prruTPXeGevAIzwokv9IDtjV8MGDLuQe+xleWQtyjx3jD9a8
OVQF+7jTi6rNHeF/j8R01kizcI7pz2P8isaminwYl8rsc95El967YN4yokuP
cUzHnqm+PVPde4xf+zL8k+i1TtxrE0G+81Yl7z9M9FoxjunnM9XVZ6q3z1SH
n6k+P8Z1VT6mHwM7NHmakCYAz7nxbujp/gCcTw/mi4yCfi76VtFN1rU7n+63
k3NUjGN1ATDO/+XruTELmiqRbErR72ZTmwWMWhYexbntNN584ifb4/dqET+5
Yk73V+InMY7VI2BapwDjqdxt/sth3vFMciogehfnyhdaEr0LjO9bNtMvCebd
fiEZiXb43xLpK6qkvjPGsfoIGA97c932Oozj5f1C5jPhOZaezvq2AThv7+OX
r4D3el9wxiyJ3GMpmWexJBDnI5PePiQ6uj5X+22Iju6CE1/HER1djGN1HDD+
+UbV+ctE39vK9T4/ubc5/3HFQxbOF+W72hC9MqmO3bnkXMt21H25CgeO1Y9g
WlcC45NP2ymt30JTm3xj3i6A58x45L/yDAvnG/kfh5F7dIaxHfzkO2+fw5ak
Cg5cY/lwxAWij/Saz5Xo+0kKdcoRfT+MY/UvmNbFwHjOzzBFGuw2PK+h/TM5
5wy6ojzIwvmPZPWTU2DdrCn+fSGW9HNuyUCFH86xehwYP+t4S1l8Pk1psGJf
m7ayKb9Tqxf6nMD5ynKdt0kQhx900PJ2I/egWkUVjwXi3GJyROJ4GPedxcYv
iW6V89XdXURHFONY3RCMv1vrxSL6ci/eFlFEX67mUpUT0ZfD+GDcvJW3oN/+
nGWNuwM8wv1uaaIfziP4zptvB7vaPJJGj5E4UCv5TRUL51h9E4xLPuqwypoC
cVpj1KPzTbCvtPbm7TqF87O3E1zHwboQOHLHhegs2f7YbUh0ljB+40PP5cR/
7v0eOiAC/MX1kQ67AJyrBhQ9Tod9sYDWmDTRKT3/da1QCgeO1W1hWs8F49mz
W0YbwE6Wh6XLbQEuuDRFnNyDwjhWF4ZpvRimdWQw/qfjpfMBM1jXzp1d86mL
TQk80lnccBTnWD0ajA/Fyy8LWUNTlsJP5H61Qz87R0v/Csb5/txSg3ESEJdG
au+a8oFNRS4SjsiNwHltwpZrP1Rpak7KWY3l8F5/pCbVfwnEOVY3B+Mtk2f4
X4V+XvUldT+51yfyaivrCAvnWP0djL96czC1AebFooAZ2+Jh3Mdehxay/HG+
b+8CDSvgZhmDS8l3lgHZ0zJXOfDSq8t2CoIdXpo+M4isy/eXhv8k6zLGsTpB
TOsHMa0rxLTeENM6RBif2b83YzHEpd5vBw1XQFz61ComyvYozrF6RkzrHGE8
oXktixvmUUrRx3fniZ9/u2DkjR/OsXpJGO8JqxErBzuRfSLgTXROhlS0ThKd
E4zPmfhT5DHwwldxuUS3P0GzMTqMA8fqNDGt34TxwjNxy6+B3b6bPU+Y1KGw
9LHKmR2A80s3DLza4H+79/ltJ3WdPv9IFCXnJBgP/FW/7DM8p2Yw8ArRMXh4
enI/0THAOFZnCuO+X8sdN+nQVLDfjaRyGBehhGx7Tz+cY/WqMP79rf6JYzCP
LCdEOMWAXXl+CjpGBeLcqvlJzClYB/X0LtST72JPA9y0yXcxjB+9WT5xF/BP
XsLnJgPn565y8eDAsbpaTOttYdzmsX+sOaz7vpUxWq1Ex8DeUoDotGAcq9vF
tJ4X0zpfGBeYPanaeEsdpXhqLa0m2EX5sy9466/FOVYvjGkdMab1xZjWHWNa
jwzjEebZD5aQ75Jr+IOILvGkXyvUiC4xxs//HNoXSr6bSx87QXQnCm7LmBHd
CYyPHx/bLAfjrq/b1EbysJJ3pZ3P4sCxumkYv1H/VtMa/Ni+S4I+5J6w3HEl
RxEOHKu/hvEFl86k/CJ1oNSqTEleGI/5KrmHHPjK+qahGfAcOtzD6ehHom98
Rz2PA8fqvmH8XSffe/Ldf1Trlzf57i8+0JMhxYHv7Bff1E3qwnzaepXkofPX
7iw4xoEnVTxMt4DnHJow+KkWeHfOod0zOXC/qPgVqRAnCFdt/krq0Xwzqf64
mRNH6tlh/G5je/4dsEP9YZ1Uco9CQO+3jWUAznlflUuQPK/A1MMJJM/rXtsv
bwMOHKujh/Hqe+PnkXuAXaknP5B7gHn7G0bIPUCMY/X4ML4upjFxAsQtSYd/
mjR1sKkfqw28vYJwjtX1w/iDxKym2zCOkcYlneSez2sVlucYC+c+OXl9w+A3
gveZTCPnwCucV2+7zoGnfDqr7QvPOSW9RbeJrGuHHy+Z6o9zrP4g07qEGHe8
pTM5FsZFQSaqchdZ93dIyqxm4Ryrb8i07iHTeohM6yQyrZ/ItK4ixl22JJfK
wLhfOtTC8wP+dyc71reFhXOsPiPGC1lvI2+BXzI9Hnf8LPBXY15bIzhwrM4j
0/qPGHc5cVjtN/SzdN3uUN2PROfqyi9y7wvjWB1JpvUlMa6bK9fjrkZTQYdv
TloPdj6dXTbxdSDOsTqVGPcN8t9BdG9OliUFkrweq+PyP4juDcb5pIsK/GDc
1UyKLpJ7EXfT1cJJHjfGsfqYTOtmYjxKm2+VJrTT76XJ2gxyrlVi/8LOH+dY
/U2Ml4vIyMpTNJV72/jkLfjfnKFTqVMDcS561kNQFNZx2bf278k9w+vZrMRf
/jjnudfRchrsylBsq4wa8J737+7ODcA5VicU43cttweMgJ0Xhcokknp2tnzD
UqIsnG+UUqmWhn1x50dl2UvAh9VG3pf44Zz7CG2/CfrtUpi44ULgx/JN9E+z
cI7VM8X40rc29hehn9WPJsYWQT/zy4cE9QfgXE5luzi5dzcSOZxI7t1N4u69
vI0Dv+etprIe5un5K+WBpO6bf2OtGKn7hnGs7irTeqxM67RivDhsRd4zsPMf
8ctCSf2L7g4FYQ1/nF9tuDzhMYz7tO4BYeL3Jq6XdSP1ZTCO1YdlWjeWaT1Z
pnVmMZ7n9ebmF4i70vSK/e4Q3cgEvQ1dPjjH6tVifPX1FdYa4FdTbjlM/0en
QkdgPdGpwDhW95ZpPVymdXIxPiv9XvZzmKefmzvZKvCcwhjnOQdYOMfq7WI8
4dMizx4pmrrm2rA4E+LS+SJPLieF49yGUg8l92B1e7fpkXuwN3Kdr5N7sBhf
qEmbkDzTwAUdRSTPNOvd9SayzmI88pnHc3IvUUDWx47cszL2OX+M3LPCeKiE
7bJZMC4XZldkE7/9OGV6M/HbGDfmi50yF/53mdbXlSSvoUpwYPUdDhyrU4zx
NmUBqYUwLmZSCZ5E19pD3uYy0bXGOFbvGON6WxqPx8F7hXaeiXeE/w1YXydO
++Mcq5vMtJ4y0zrLGHetf+YfCX5vR5RjOsmzsNzop6znj3OsXjPG//hHF82H
97J62d5EzmF6AltlfnDgyvafDdMhTuONd3u2Fdpp1t4n/jgQ52Wt7CAxJZra
mL9+gQPM05KB7yOawTjH6kozrTeNcfWz6eHcEFfPXrFWpADi6kvBG5TWR+Ic
q1vNtJ410zrXGLegP9uvsWqkbvaszf4Z1UVdDDwSdsWmEeVYvWymdbQxfnxC
m8lFqUZq7/qk3X3BXZR/zpknFW6NKMfqcWN82hV7zccqNHVdIfbHCPHzu9Le
aQbhHKvrzbTeN9M64Bh3Whb1fBKpHySfcJMP9q3WlX7dRj44x+qJM60zjnHt
Pvs8okv/4/2yf3TpX6uoqBNdeoxj9cqZ1jHH+KItEUc642gqb1OBBTXIpjQF
t4XJOjehHKuHjvH0l7+r+sCuvVjSpa3FbIo1tNLA7T7OsbrqGC9RSmmcv5+m
NHxFednwvxNy79++74FzrD47xjUPHvxBdK6emG7JJDpXA59q1hCdK4xjdd6Z
1n9nWhce45urM2bpgV2NyLq2k/rpAQ8ja8T8cR4+b1t/KsSBDxQLQm/BvPtY
yWNw1Q/nh6qkFImOolvQlESioxji+CyI6Chi3FihsfQY+W44U0iAnOOV35WI
Ied4GMfq3WN8XduGlpQNJI+sKZ18ZyybOnBTPADnVlyX39yGOMFoVvJkcm62
zPDl+EMsnE+yZruvBTtJ3T7Hj9TfTDAJjqjjwJ/1lDqs++fcY9JPUu++hoev
h9SLx7hA26GqcnivliPDD7uAT17xsmOYhfOwN5PXWZI64E3vev855y/df53E
+Rjfnm9Q2L8O7JB3towf2Emyu+sph0Cca5723DMF2ql0/JTEVXjO0vrKXYf8
cS7q/nLwexdNHTVes1mUu4vqEdbdtcYQ56ePzpwYn1tFVew+qR7R+Ynat/r6
t7KGZpS/yLPoWp/fSElPO/P6XEIXteDr7N7rmxtRvmCC55flAnWUdYNhr+DE
LirJVuPF2JYmlKt7S2oKyNOUw8Yp/AcgznlQJSvbF4JzoYvzK0gdxuV/PIuI
7sHED6OHSB1GjPueSisi9zYrs+7ZkntNoUqXucm9Joz/mZPopUTuDe6IG0/s
JDNMPdLRH+dzqLLEDBj3ntzEAFIXfseCA/OrOPAdl8c/1SX1HK08bhI/kNEU
uUacAw9Vk4+Tgvca+H1Akuw71tyMM7zDgdeb9M/bAXFF/YVTWaTeaPXXzyJc
LJzvvzl8JhD8RvvxZBsz4BsvfJ2wlgPf+vz1z2/kXDR5nvxl4oc/7xX09sd5
+PGPAZUQJxzfymVJ6ujNeBqduCgQ58smnzvdA/9bsjDEbi+5Jyn9++tsFs5v
/jL+QuoXty9S9iXfwTV672Te4MBn9WpEWOrQVIDi/vTXJE/Nc8DP1Q/nutOE
mpSAj1y+fvkF8IHFa6uPcuBchpFKaeQ7Hb8qH9FJiFvXRxOdBIz3BPeJpBDd
6RnZt84AT8y4dDCKAw9MThbSADvs9uxxTAf+w2mRnD0HPjVB+aIz+OHS3Vtr
SN6ilXjCMZK3iPH8Vt7xo9tp6vHsxZQKm03ZsW+fuu+L83uPM+kwsNtnGdlj
zfAcrZWPNk32x3n1b7nvV8m9hTr+/USXoCk+Pa6QhXP5TCUVsu8TuDcjkez7
zpTT2mTfh/GtqSva+IGnZiybSPykq/3ugEMc+Jv8kZv8ujSVQs272A3/S898
mK/hh/OzbyaljYIdTvcKGCbnrqLxrcdnsXAepJjveQ78zEQ1+wqi48pzbmKW
QwDOTbxsQs8AV+10WUo438XeIkcO/E3VG/4N8F7moyP3yLh/unjm+m5/nPMm
LdtRAXZ1Z1jjPbnX1Ce3ayCIA28XSu8Tg/+9qMk18ofck1FoORMWgPM7Xxyz
SJ2jy6Jzq0mdoz8vT5qROkcY7w/7k3cK2qkysHPFPfjfyIW9xqT+MsafTB8Z
mE90VPwuTyG6Gd1X9JP2ceDCc+KvfiQ6h4Wb1pC6JxZvnm0kdU8wvmjLh4Ve
0A9dG9t3EB2G5pjQSUTHBuMRtws0E+B/i6VULMh3scVTyy5v48CbDXkbrgJP
nHdag3xnv1KYNXMrB75shrf5E+I3ZmewyTlS/uOatWEcuLa8vfMW6Ofyp2c7
yD2oLLkh12oWzndX6ZaRdr5/aOxK2jnvUs5R0k6My3740GQJcekvhznJ12Ec
ZeKmXcvzw7nO+5Dr9TAvLBUCAvcA/33cpmkuC+duvU1L+1Rpqu2Rb7QsyUN5
siv/ayDOc/ZQtrvAj/k//p23GtoZm+svsTIA52cknyp1qtFU7uuDiobku0+D
xLesQJz7NQrGihnCuhmqqNMOfm9Ky9mwCz44H5KqDA6BdV/mgb09uVdTHh0Z
S+7VYPy2tuzHEGhnbq67jQqJYzMT78sE4Fz4Wm/9DfBLkbZnR3ngf4+W1u8U
8cN5Vo+IqKE+TY3r2K/tBvyiZJ6buS8H3jjWHwd2xS9T++gU/G/1FP9npI4J
xifY3X5zWImmZrdZvXSHffdRp81flgXj3L/ezUcT7NDy3p79xA6H9+1TJ/f0
MF6/XnvOV7DDq7/tf5C6jVfWzjRd7Y/z3KPZp5rgveZILAkKg/d60K/oscYX
50VPBLdFyjVQpWum50VbdVESLOsi2zuNKFc1erRn/obH1I08WwUhr0DKM7gq
cJZvHcrVNw5YGTk1ULtj05aH7umibimfGhZObkQ5O0/LbRrRvdwuWulC7tWs
Kk4Vgn7AuHvLlBkHdtHUUIa/rV03m2qYf+zUpKM4D+2Pe/sM5pGFTUXJfLBz
0YbnJmOBOB+WEjm+Hvo5n5e+StYRRXZuGVlHMD6J8rBqh3EXfp51PATGXeRo
Q/y0YJzbucg9lAS7VVk1O4DosG1IWlys6ofztQ5v4zXADp9LKzqT73qTx8do
ku96GI8dEZxyDfaVwzJzgsi99G9+babkXjrG7zo+X7IE5rVOTeHLTrAT9YQl
G8764Dxu5Rp3TVgHu26cHCK6T0/criUdC8D53Zkapn3gZ35lGmXuhH5uSZl3
6GYgzm3D1Y7bKsI6Jd2RuBn6rfHuhMNewTgPf2BQ3wdxWma9njTJI75BOywr
9MV5WuNJvXnQD8d0eW4TXThDI+X+OBbON45aB6w0oSmTCtaciC42VdR1Jc7r
GM7jX6p9VIR28inlvCB1JW4nSiwkdSUwvudIu3Yj9Ftm8Isl5N7X6YwnFNHt
x7hnX1ZCJtl3H3atIvssnY0RsZX+OB/PUzqFF+z2UrVDMbk3qLsqPPUwB06X
PJLrhXnxNdliL1l3btwZ+U3WHYyb2yxo2w88ZdVw1UzgWxP65GYG4fxyw0IF
lykQh7fxX4psYlOF0+xNR07hPI/vV+1a63p4n/lBo2pdlOPCFMvXPY0o1zr5
Kav8wgeqsOq9x4ed3dTGxqS3m6Y1oHwG/cQv1PsN1aB6vpnr2EeK7fn0a7LU
B5QvTdloZBZXT/XMWPFHT6uLSkhsc2psbET58eUDr5yhn9cLSIiRuhshXhYP
TaGfMc6l/mnHDmWaivHUM74AdmKqF760Pwjn17m427hgX2Zgp1ZBdGk+JLK6
T/jhPLGnaO4VmHfZsV5zt8C4nAzY+OlpIM5P/FJNJXUfzttlaJO87MeKpctJ
3QeMm/lFV98DOy8Wa/EygnbONBAstQnG+R8Z16V6MO+kT0RPJTrMH4VqLU6y
cO64XW/tB9hHp9vuP50M7VxIazbKBOL8Z9DLSS0QV1iMvs4keViL3XI28Qfg
/PR1A1dyL6XqYcgpci8l7vWfBWIcuNYbixNqwFvtf8WvAO5wl6aVOPA7zoUu
ZN8huf4PTfYde2ZqdJF9B8ZZc679Xg7rQodXhkQ/9MP1X6/0lPxwfmRvsgSp
U7l6tvIQuQcV/3DzGnIPCuNvdp5XD9GgqeiTrnPY0G/XzyzelROAc5eJH+tJ
3Zm6dQ2OpO5MoEyUE6k7g/GZPMpPgyFO5hb0b80A7sX+Ppzhh/NrK7pdrNbS
1NZrbhZFYCfLr/EnpAThfHVCy7seeK9r4k/mkLioffbqClLnGuPjNJ/zPyPn
YOfOSZC6k3KuIsvNAnAeF9AlnQbPmSpzTOwB8A9pb66Re8IYd049pzYJ7HaD
oMBNCXivHqGl766wcO676BcvyTuOb/bbQ/KOLcZXXyR5xxifPOa+5zC5J09f
+cYLz8katrMuY+G8eI9Qah+M411LlUmk7kBCtp3b2QCcSxRfE5oPfptnsewC
fnJP9dPupUuDcM5ve+0+uae0f6t1PrmnFGLp607uKWFcPqRiiNTx8Xlw6iCp
01Gv+PEPqdOBcX3tHzXc0A+j63tXkjzc0UXi3zYH4DzTNO3pPPADK9/mcpE6
hlLb8iVMA3G+V3BR70Hgr9LP2EUDj4qQGNjAgdeV5CRv1CC6RqUXyD0Z+b26
FkUBON+SVJ/jSe7Z1leJKkM7mz4dubyIA5dtTcy+D35A3Ph+JtHRnVutv/OE
P851wx2qybmfesA0b3Lut+bTu1xy7odxlTzDfGewQ35/H31yb2HkYYZQKAf+
eGB37g1op7WckhTxe1zBPB+J38N4i2mogcQKmvIVMmN/I3XobkptfhiKc/vo
XWNfoJ01OeteEJ2QnbmPPFNZOP8pNdvQEuxkydUCR1KHtFQxR30jB87nNmu8
P7zX/t87Osg9yS8p1YMsDtxTWYHaB++l3n9TTJHsW2MdJpFzQowLU2ldRCdK
f/jRW3JvdlfZJkGiE4Vx/zOhxieA7xOpnkF4+sdIg/Mc+NzQn/d3wzrecE0p
7Q25x/h6/KuDfjifdNtSuY+iKT3lT21EB/u6xYnyugCcyw8JfZ0I79U4/GAp
0QXSGdqqpcWB67o/uyxGvqMNjm5/RfbFe9sDFvvjfLVRkdIFaKfEXI/PtdDO
KSNhN238cD5TVnKRPDzncFqiyDt4jn/i6qnS/jiXXppupQp2MpdurCDfxWZk
tPGS72IY77vWpfwI9pUfu1kTIuF/P6+qPNjmh3N7esn2EhiXZHphE9EhvxBV
cyHEH+c3RFTK74Gd60ueqp/Szqb2v913JToU5/vdtEKSXWiqOia8wLOXTT0K
GhotOozzcL6Y0VOwrzn5OLJrMexrTMe9XVXji3NHo8zxfFNqqd2v2lOccqGf
y28uNqjB+dsfJkvWxNCU3eRxYUbf2JSdHI/Bg704jw996dQKcenPscfaWbAu
x6ne6XoRhPN9i83i1hrBvv7G6DkV2DfNWGiwbZwPzrcpWV+KhH3WiqEv0+KB
Jxo2T7M+hvO4D7pFwmAnfV6qVhUwLq0zgyXJd1uM/+GffC1wHU0F1iZ77Yd5
YZOf9CwoEOdL5rqf9QO7jXPaMFwFdtItOsdljx/Ov+x4/skA1oX+65daW+A5
Jg+z3R4F4Hxm77tGsm5eCVj+mKybLjtPO2/jwLNWbT46DH7MxVlZYCP879Py
XSutWTh/NJi++Af0g+PaGbwD8JyuhSIenzlwSZugpJvQzrM/t7kSXYUPFwSj
rgfgvNiLX3EE1s3BprYHacTP0KseSATiPKthw6lV4Le7D4mG60A748UFRraz
cP6+boZwFvyvbdCFDPK/84cyF5P/xfgaRYXhh+AH2p5pPiV1SCfOl5MndUgx
Pu2OPu9cGHdrrpzrpO5eu1nmu8uBOJ+yU46Hh6qlCpQyzp0vZFO1Dj2iRi9w
Ht0uNZjvS1NKYi/VCr6wKafDFR2drjgPTWbxiEC/xU7YPETq+Ei5X79I6sJj
/NFqw2cbgHtV++lEAGcdyJmmx4FvGG84MxTi2OhfjVeJDqTZOqFfROcZ4wfH
6c7uADtR6t1T0Qs8O8RkiHxHwPjgRKETLRtpyrvqWzXRqfvVdO8jybPGuLrt
9CVRsE7F9kh4PyE6DJkl8wcDcH68PHnfRhgXL94BQzvgVnras88F4vxIiO8j
P+iH7D7dHpIHPTh3Xbw6B250w/nWdWjnJpuxk07k3O/z8PP3/ji/FZf7QWcV
TZmYq3FfAT8/ZHCH70IIzg+ER8ve+g7zomxASIani3pUtiokTw/nJw7yu8b2
NVBKEc+WT/ftojbotVaosxpRnhi9UmpzXDVlO3HPps9ebCrVa6reRLVmlGto
Zh70k2yghKat4Qu26KJWLLfpuXi/EeUeFzV4rr6spS45ub5cWMWmZCgJo6dJ
TSgPnDXSexH8/Py+qZbbwG+3KsTpfzqG89Q/jz/3g11tG1dc/4V816hzdOtl
4XyT33hhQ1iXr/S1WBPde4U6zzXX/XH+PGPygY8qNLX0wRcNbhj3NKcqYdUg
nKc9SXtpr09T5jdPSB+GdbbnSMR5I1+cn5YoryJ1iGw7dA6SffdT/0FxUocI
4141Uw6TuhjZksJHSF2Me0XD8Zkc+OOEtsw50G9lIsqbFKHf/Hpab/L54HzY
V9iLF+YR+426bTr5jpld1i0WiHPdHd/1962Effr0hrQlYLd3blrY2IbiXDHf
XPuEMU0pXF7g7gr/22B8elXKMZwPPPUQjIV+8FmjE0J0rsz4IqcQnSuMP3rn
HFW1mqbqr7JzmuF/vVxZjbIhOH+7qjr6AMSxaUKUN4nbpWf9sV8agPNjszeU
voHnpFrni5DnbLWq7FwWgnMNE3q+sQHY1cGNjfEw7t9rH9oI++J8jj+XA9H1
XZjhxia6vqHzRHWJri/Gd1jsCG72q6X2ubIuV5ewqcqYSXvf5uF87Q6xx7/z
66hHsd0bvKW7qPaRqQ+lxXFeI5xMpS2EeTcn+/HTVjYVOGNewYvjON87bW+N
PIzL5kS5OWnQb9PkOmYRHVqMC+h92doHdltwMWxzAnBJvbeJRznw0we2h9YD
v7k2ZzbRvemYQvP7c+Cvt4yMdEK/WTVyJQ9Dv8VPdqk8F4Dz/Fmr1OTUYF9/
UX+ZInCldYfjPgTi3Hh1c5aIBU3FNE/bItvNpoI6xp45HsW5vNXqAhuYd9m8
65o0wM7D/cyiho/h3IrLNmIq2CH1O0+Q6PDkBIk83BSA87xHs3+TczZHD9P9
5JwtOFbWmpyzYXzKQNaAF7lHdE6t2gR42vbRdFUOPLcg9oQI+FVBja2pJE5u
mZFwZYk/znv9PluSOn028zYXkjp9jbZfHEidPownt49MK4V1WY5e7O4J/XyM
y2nMNRDnGw42r3wN+zL9vZrno6CdRXVXpjb74Twlfp+zIcS985t/PSDnxkMF
yfKkrh/Gx+qMz2pqEN31BZ/Iuc2qA/FVTwNw7qO5hY+cq7gqbzcl5yq/i9/2
kHMVjM+Q2qb5AOKEI3sNeUkd3lmrYupe++N8inqiyxSw8/pn2yeTOqeaPyzP
3efAb8+dFR+RDPuOyQ9KB4fYlHtWQirliPP6/md7h4XAbn869cQ2synnC8Vx
K6Nw/mFqbZaiNk3NNrpgTnRxjcK67YguLsbrMze2K8J7eZYElhiTfVZA6dJv
/ji/qxP4ZqYeTW3YdDVCHfzk28rlird8cX7vQnnKyYFa6kWI80G1OjZ199Ae
efMLOC+YLOOpYknyQAWNg2Ce+uuqKL31xnns2+Upk8DO/4xrPVcO7cz7+HTJ
cn+cC71siid59weC5waQc6QRS5fLJA8X43GmOwfswU7EdoZ5EV3TTne1hFcc
+LY/JyYQXVy1fL5g8p3ltdKeV0QXF+P3hzt8g6Cf74nOm07uXVyKZi9s5sA/
r9vc7wTccu++11bAjwcVuHRy4K6Dc7UryT1nV4+rpC7Dyj/ez6YF4Hze49WS
W4Fr8SQmygF3NDvusIYD/xlVPYnUIbpbonqY6JidWLA5hdQhwniV9QWa6IIu
3JhRSnRB17/3nUJ0QTH+YOY28z3wnKmxNVfC4DknJQ2TE/1xvmFdc+0n8EvT
ztbc9QE/UFrw9c+eQJyv38M+SnS6BO0U/tHp4hEx+kV0ujBe8W6Puxj4sbCv
WufdgN+afuOqAAvnzpENdmpgJ0lXL30n51qf9gU8pDlw71l13+Sgn2MbFj5e
BlzZavcE1QCcdwkkTpCHcTd+lF9tBPyViEfJoD/Ow1xT6YfQz6OKfu125B6g
+rjnJA8X48XyWRs2Qpwp0+Z7mNRVnOj5I2dSIM4z9c8rk3M/LYcDouTcT9rH
aRI598P4MD3QcWwFTZ3o3KDOA3Fa96bmaddCcd70p2rPB1iXL+54ZWYE6/KT
01Fh74/hfBstTF+Dfrh2hH8D2ffpT6/UqvbHueqrRfrvyLmlscuLbvIdx36N
5HcWzv/IH3xJ6pQtXnl4C8kT9BznrE7yBDFe43dBdAP8r447O9qU+NWnibP6
/XGeuPracSdSx+qH2Tti566GtgaJHPiE2eckSZ0mqdVXKsg9wJ+9dsrxHPiL
8aLVI8BF/Uu2kToXyg2tKzw58KdvHiwkOqijDSHyRAf1ZYBsANFBxfj+dzUb
T66lqZWnvjeXdcA6u8v0eVwQziNbxndMcKOpSxovz+f0sqkJwtnFtodxLn4s
wDjiIk1FrKmeEjTIpuQzV7y854TzhhdX1x1QpCmvyBr/rfC/xUGF6zyCcd6p
17fp0XqaEmi1NhWHfthwP9LHPADnouFm7+7BvN664+FzAegH93PfPuSxcC5Q
XekmB3F48qKfHaROhOXee97/xOEI73/sql2qCnF4XaHRArArnWjb3b8Dce7Q
JTtfZwJNHdTaHHq6kU0Zf3lucuMMzuOz1weNLq6juD69+7WGv4uKVumw6l6P
c/3n0qGSWr3ULCG5gsL8HmpdwfSZIm41KH8n2TQ/lauG2t15LCLgBOxzN08x
yJBqRrnDw3MLoiFuN/8eo0HBum+TMnh5E8TtGPcYMVv6EvZ9U7+vM20Cv/Hk
94slK0Jwzte11C4K+vkynTxM7mmrRh7IJfd4Ma7bmLF8MYz7a9UVG4mOGb+h
9Q2iY4Zxj9PCrwzgOVsnyFCZwAO5Zhta++N8vUaS5GTw87sVPgSR7zj1Pq2Z
pO4DxnMsKnuy7Wjqvv3t07s/s6mrb5bR+l44n3DMM80Q1qkK4bW9JM/ikWFZ
OtEtx7iht82UengvrdOur+bA/95JutpE7jVhPFrDK/oovFfcraayO2Qf8fm5
zE5/nNOrBKd9Ijqu6UYHl4LdvhRpuTkYiPOYEu11K2Gd6u/N4ybnzA1Vqu16
LJzf3yh+4DSs+6XLBbIPwnPePlL8xQrEub/SZZYj0R1NkNtL4iiFJaKzP/rj
3FtktGct7Du2+CdMaoTnxE58Pr44AOfvP70RaSA6PDe1tEgdKKmGWzdIHSiM
h5YVD7UBDxN9fOI58LEH1/2VOHAlr93JXjAuN5JMlpE6AkNOLucPBOD86/GD
w43g592lx1hknz6/0MyG6NZiPKMjbMNieC+vHcOr6uC94hQONpcF4FzG4INN
GayDGR5nf5YBH1P+3NnOge+JfHOgGcbFTlB69TEyLlIS5/YG4jz9wekNhyBO
S/R51ZX2iejg1U6+5YdzBYEtl+WgnePjdcLr4TmzzPefLQ3A+fx26bwX0E4p
4RXNpJ1aa4tmdHDgCefXih8wgHGUMIi4DPugmELrGVN9cX5wvpkDiRtfhIyP
IXGjg15wCokbMX7jJrd8Ktih16SIlyRu2adVaEHOsTE+5b53URSsy40CL9av
IucGluldx1g4/37kdX8x2FVU5YNWoutSLZNxhPLH+VbLoY57q2jq7DzR5bfA
r16ZPZzpHYLzy2d5O1nwHPstfsmkbnX+rZ+ZO/xxXqLqcH02xF1jfmuuku/U
AaKXvi3iwL/um7QuBdZZP/fkryRPZ+6siDukrijGDS6q0NoQN6pkuQetg7jR
lufLlt/HcD6g+zXVV4empF94vSPfDfc75GeT74YYT02sOlemDO1cP987HeKK
LueGQ2+CcN53L9HCHPx2q8enaiPw2xfNQg2cvHB+brFyfpIY7JsCLe6mt0Bc
N/W4v0UkzrWKv80r21xLsblVRscewjp7qYTdU4zziJLO/br6NHVs21k7V7Db
Et/KPxa+ON98x2ZCJ/SDfpDfng7oBz8p2Z3afjjfsmjC3mgYl1vaRs/5gM8a
K5d5ysL5NLNH3zPAzzsLf+W1Ifei57RnLOfApTcckz8GfiDz5WPTdPJdNfLI
hSw/nFf4J5WSPM3c1EdPSZ6ma9HawyRPE+PBwZ3Px0M7V9TKrP4G3GPOuvxP
LJxndB/4TO5B5acprCb3oF5q+/aSe1AYz0/4fOcGqSshWWVG7q3d5H6lQO6t
Ydy5uSIuRoWmHijUSw2CXT2YbBNqEITzMdvUA9OgnUVa78+TPPcQydlmJM8d
40GxrDp7kgeaM9+2Dvjq/pPNwv44X/ktsTwH+k3+s6sz0dmranjkF8GBS5x/
Ks0P/bDEpCSTxDmKOeqOJM7B+O2RE6fZYFdJlh0/iF2tKz5rsc0P5/1pYRef
1dZSxR3zxMWq2RQfr/2uA5dxLr099RLR4XT4tXuQ6HCy6vtposOJ8XlCz1IT
wa866L8cXgP8l+yszZ4cOFfW6KW7ejTFszVzginMI8fasOshvjifXvT2VAL4
+Wnvf1N7oB/4csZz1frjvNhwxqluUhde0K2a5JE1P1kt94WF88tbymreQZyw
+pmKjyQZl5Blc4wCcJ6TauLOAi7Yw72J6IYJum65v48DPx0b9GcFrGuPOnbx
e0A/TO5yzOdj4VznwZtN48HOR4Q8h8m9d4ul/Qbk3jvGS2uzz2tBP8xTPaRN
dBg0Jkg29nHgi27sj7YAO3FK3mdG8mol97vwufnhnHerb3MlrOMKN0JbsmBc
XAxMlgz44PxgeGZUDryXyKhc9Ql4jn5zwIqPfjhfFhVS/AzsnH30m+4maKeT
qOljoQCc22c4Fhaq09SM3tzmyxCHGHqcjV0eiHMXuY7eWF2a8iw20OSGdrpu
jvop5ofzxSVd1S1xsK83iD6sDvtoLp4AoeXOOB9/Z990qxM11KIdeVvdEtlU
+61V7CUjOJ904Yxb+eE6KrCj+qnVrC4qNaUzdc5ynH81nd5bFQRxrA5vU24/
m9p7b4b9Whec2yUq+sdBXLfEi2X1Gfqhe9rpV+kBOM/JalhXC+N+4LyhfBu5
x5i9RELPD+d38zuex4BdaU+srCF1FnoEw5zr/HGeymdpvx/iil/NtoUbIK5Y
4DbfYvAYzu+fHkg0JHVjNaaEk33iLbGJVVb+OA++l5tE7nXYvf7RSu51PNH1
ekvudWD8mMw3OUqYpqwirromN7OpiKdiXbOjcG7vYZj0ci9NJf9STMzpgXV2
k6LTrCM4n29QuMkB1pHD5l0h5Jxcs8U8lJyTY/zalJGZ+dBvQn0P04mu1+yt
jw698cd57sHumbe3wz4rx9puBZvk7ZbWVvjiXPGa1+0kiNulky5dfAbj3i9w
/0VfAM7Tj/t4nAU/9kW51ZvkNd+nxFUdOfB37stV3ch3tKc+AkrAD36Xsl/C
gT/pm+/4DuxKa6LR+lboh9czffP0/XA+5dDNidywbsYVlSmQujxub53ySF0e
jH+evCLIB+KcfNUvUSTOeSBVqULiHIyXt2mfbyI6SMmelbJgh8+0Nx+f7YNz
BbZ9zmyYR25v41bUQr/l3dYyeBWA87vzYkzCoJ8n+E62fQycfTeR5zsHrsDV
2qQ1i6ZOP1syshXi2OCVfW1cJ3GeTM0JXwj9Fp7DV1sM73V/fts5lh/OFxw4
3ypP7s2a6nSSc3X9cbLFKgE43/eFXiTFoqmG+dYnv31hU8I61z4GueK8Ur2E
/cWtjrryUzy8ayb4seDJ0z8tx/m3yCLfgtwaqnK15h7HFDZVOL8sc1Mfzku8
hH7xu9HUk5qWPbd62dQMF0Ubm8M4j9xq6uO7lKamHLaTt24DuxJSCX8QhvMm
Hpdb3G9hXZC/xtM3yqamTT9pZ2iO85WCR3pugx+Oqnc4kw1+OFO4ym2DC86T
sgwmqq6mKROxy0ol7aROk0euUQjOF4XxjlqDnT82WH6IfFeaTL28Qb4rYfxs
aZsbqbPGZZj1T521yicnp2/gwGVcY+uawU5EUuqc28FOlOvej9f1w3nmXd73
c2Edl96tX3wI+ImQyEtTWTj3mrwt/jP4pVP8by4pEZ32sRTBh744l/AdnlAD
63hXfUwv0SH5oWybtjAQ5zKX2tWWQVz6NWxfKKl72PloUh6pe4jxCg9+8Szo
Z6UGpywa+vljbbe0YgjOnWs6uEThf5vvzXQNhv8V4rtZZh6Ic8kJRTuqwA9c
b796fRA4r/i9/vgAnHeIXR3XD3Hyu06fxvXQTsWWclVbFs63jDoe+Q3rSNp7
vwGiC2e/4H3xNQ7cncu68+oS4Of856iBncvPuBMwHIbz7DG5iJtL6iiuG+Eq
BvxdVGGM7oyC9TiXGnDUUXGkKQOljX8GYZ+e+btH3tQT528WXVkds5imat+b
ZQvC/y6mDz9ffxzne3TyZ1SspKmfi+JXroVxyfW69F4rFOfbjSZPS4R1P8eX
+34b2Pn+G5UfSV1LjNtFCLgbm5M6sE2xU7rZlInqBpWLR3EufYp7zytYR6Rc
40/cg35OCv3GF+uHc43MTnM2rCMZXSWRy2EduaU9JUbUB+fOXfbxOZI0JZb/
ytHgA5u6UbXPXz0C5y/DxbeWmNGUWeo8zyF4Ts6m6pKiozhPYY0fz6VEUxXR
o1NtYV+8rDjop04wzh+OeBwPh3l0IKwg1Zzkofy+V6vIwrnu8XOdXstpSvZB
dHYdjGNbxBKJ7lCc+8uphyrtoinfn7fLzKCf8y+c1Jh1FOcv7LTXyMK8Gyks
Cw6DeWS9SyHEKBDnh/0kDxWAn3lueDl/JfgZxZSeyHJfnH8Ji/BWW0tT16Ts
2YXQD+vqFPqyg3C+Osp9QxL0W6H2gt6jwGd33Ho4Nxjngxb1Pp7QzoZ6taKz
0M7dm+svaATi/MtvX7tRbpraueXzvpYGNnXm95L5dDTOk8OVU1TBz2h/dNYj
5/D7Vt6PfB6A85+OatProJ1uC8Jag6Cd96OMD04PxvmEoW8OQeTccrHzGnLv
Ontb9z0Df5wL1BwrzYJ1xPyB1p0GsJPNOpUK5n44j1GmNe6voyn+LB5hD2jn
i4ey0zwCcT7vgFPcT9iH3u3fN/MujOMRV+MTH31wrsUvpRsHdnvUz3yCJfxv
TebJ8lUsnP9S60hxgDgnfli8aQziHDP7vFOurjgfOaYRagHr/rVLZhFJsO7L
SdTuM3fBeXnpgxhjK5rKmxXckwN2Hs//UTPQG+dCs66X9TjQlPKAwyk2+NVv
c496HPDE+aKY6aXe4Des2M/jt4DfkN32Mlw3AuevE51X3nCpoxJWdPBFQpwW
VRDaG7oC55vtuh3y7tRTxdejusO3dVEfStLZV6obUW51wTwi+WkNZd0z/YNX
Gpu6kDuUl9/dhPJnlVndDV21VKpYiQ0XzaZWbJE8dSQO54UmwSonpGgqZfxp
tQR4Lx6eOXRhOM73BRmM3eOnqdvFGxVdmthURo37xWWncT5tRLt9lShN2VYJ
1rlAHH7yyHqZJ5E4L+/VXshD7k1xhZd+Jd+hZim4sVk4H2hL3fp2B01lPZh6
opZ8Nzlddy3DB+cXNW02kbqZHpLZcqRu5p3oCk9SNxPjKoY1Js2mJI/4OfUW
1oW0ZAGnccdwPvHsuh+j32oplxGRQ1fqwG5Hxq3KPo/zqCtXNRKsaWqQGmfS
CXY740db6mJvnFvfPhhiZAv7dI2MX7JgtyWdv1qyvXCuelUgWl2MptpcAivi
oZ9jnbhzj0TiPP54hHWRL0118yWffwDzdIeE37l2V5w3hxp1ma6gqWUR25J+
t5HvwndSb4biXFjcx+gH2BXXLGvBbLCro/tVLS+H4/yQzlmB0nE0tcR07sAf
8NthhTrhV6JxvjLt89tM8GMeoSG9aTDu02VOGf7ywXlMQbXXkBrEUYJilUYw
7nTZOd/0QJwH9S5t/gpxoH6Cx7ct8F4JIdvPtIbh/HZzSUfrKpriW6/VfQ/i
rhRh68UHQ3C+VzPc9ifEIdTUbzd+g125ae8ryj2K8x+i63/tmAfr1Hmn7I/Q
bysd9TZR4Ti3VE59MfMgTa1+0s9Wgn3fFM1GMTkPnN8feWc/dISmjBccXpfc
B/u43Ar5p4dwPne4zC3WEOKKqJKUYehnAXZ3wWEfnJv5xPOMgR3Kxu0Izgc7
9NTkWrkhEudTAusvZK+nqXGJx3/PAj/w8ZV6kFUAztX0l1evgn1BaOyTAFKn
ledF2jxSpxXjee6hhhLgZ7qact99h+eUygmcaOXA73/U8LWVoyn30KLFBjCO
gjPyayVDcb76g+YEGuLkOmPT3fNgXl9o0cjyPIrzEfFpz65AXEd/OHpzL/DG
N0W2I944HwusDxNSgXk3cfL6FohD3nUtUPAIwvmVWPvLX3VpSrTC9YYAjIvx
0jtW3H4494pPMd6nAPNujYzUXBLnzJUcexCM83dp4bcjwa/yjx5ecgHmUauZ
bolKIM4X/cibGUPuIXx8fJacm8lotEwj52YYd96j98EG4q6pQoGxrvC/GzT1
96wKxnnksy3f4w/R1A6F2P0DYOfjlLs+f3XHeUVJlu/M8eD3uAdrrBrZVNwF
+21jZ3DuEFpW9gb2WVZabaVkn6U3R+OtZijOF+/0tZPbRlPJPDs2ke8agnPG
m5LvGhjnWl3pSuJkuT/nBkmcvMfyZw6JkzG+q2le4672WqosyfL4UA2bEjX9
Vq5+EedcC1XiQ3tpqk9tV1Q6dxf17ObDjSo7cP7ZM164J5Wm1vpTvqzvbMrF
qZO1wwHnp3bN3TnEXUtNCDcqKL/NpiyNTjbMqMN5yfK87Ltij6nCF7XDBYda
qRfZBV+2m7Wi3Ha789tM4yIqJd/KecP7NkrY54/xqmU4Z3/Iizv39R2lrfNT
rn/TJ4rX5FuolncLyt1XsuUucd2nLqhfuObY2EAJfd2V80WuFeVHs7aIF+o9
oajvm5ZQVa2UzYM3QmM6rdT/A4EnSAo=
        "]],
      RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "1"}], "}"}]],
     Annotation[#, {1, 1, 1}, "Tooltip"]& ], 
    TagBox[
     TooltipBox[GraphicsComplexBox[CompressedData["
1:eJx93WVcVF33N3AaTOzGRrETxV42JiqYgGIHio2KoCiKIiEqggjS0t2NeFko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       "], {
        {GrayLevel[0.5], EdgeForm[None], 
         GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1m3f8V/P7xt97n7cZ2kKkrDS0C1GUSrSJ7BLay6pIQyl7paKMkiiVaJCi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            "]], PolygonBox[CompressedData["
1:eJwt2Am4TtUex/H3PYczH1SaKaSRRoqKMqVUKDRdDTe3iYpG81BI0SAqUygz
TRTVFZUK3TSgiVQoJJWxDLmX7uffOs9zvs/ve9Zae+211157eqt36NKmc04m
kxmZzWTKyeKiTOZj/glKeNPCTOZWfhua8cbKfuIb0YTvkTfLW/AnH1aQyVSQ
FTGc3618P/8L9/AW+IX/iov5M9pU4gdgBG9rH134XWjHC7VZkk1jKuKnKruO
X4/TeEf05L3QiY/Wx4H8IIzhm3AOPxe/8JEFaV/RZhSfhEP5YZjMq8nX5Ruo
zp8qSMcSY3yaTylIbQ/HVN5U/lf+D834tIJUdwSm8/ONeUM2zVkjfrIxXptN
x3AKr4X22VRWm5d3Mvpp9wDy4sTgft4VWX65Np2zaY7a8Ln2UYMfg7f4BByS
Tcc0kT+Hg7Op7Hne2jZ3ZlMfl/EvZVV9H4Wvoh+5Qq5ETX6sNlfza3AcP1Ou
0c9anMXvVNZb9ok++ZHyRXUvoQp/SB8Fxl2IQby2sk/VfYaT+Va0Vd4O2+K8
yaVyGSrzG2U9/dZHB94Am227BQ357YXp3McY7uDHyw/ULcQJvBv+pfwmdOfr
lNeT9bGefxpr1X4q4bM4L/IPuTPWGG+NzXxLzFdR6uNmfd2CHvwMfKOfVajD
W8VaVncgWvPTsULdyoLU9ip9bJc7cDWvrt2VUY4a/ILCdK11RHN+Q1Eayy78
kw9Afk6a04ExP0Wpbjc6xBqxTXN+IXL4o8qKtS3BY3E+i9K5/SbOJ++IvbGG
4/rhnWQL212M2/nZyn6MecM5/JjCNNZYEzV5dWVfZ9OaqcFbKrsjm9ZYK960
KN0rfo77B3/XPBwb+8YCPlg+rN0jGMK/wJHaVSlKazOuqX3a7ccF/AHcr21X
PJhN2wyObeNYY93bbrn8PK5pfnxROtZVOIH/L8YmO2MfP7gorbXY5hD+oH4G
xZjQnw8oTP4IBsb9L859Nt0Tm/AK5nWY7YajIr9JeUPl5+Fm/rIcK8fhFS4y
3fKso7y/L+3MImXTFc7A4rh/leor130HY/izpcmfxlj+OB7jj+MJ/rbcKrfh
Hb4Y2Qr6xod8Ifap249FuYm/eKZCarubvyffx57YF4byJ2OffB4m8cmYz2+w
3U6+C//k12AH/x3/4GPkDO1eiLHz5zCbz8Hz/GU5Vo7DK3y0nCanl6ZtZ5am
uvGYxTfL1vq9DFv4n6VprB9gL1+Kl6MvLOMnF7uXmtjrcApviTv4nWjFG+MW
fiua8IPQml+GyrwW2uekPmrzHujPB6Anv0IeLavhSr68NO17Jj7nTYtT37eh
Ge8kW8iLcTv/KOZG2xexhH9cmvwlfMIvKE7bdkRz/mlpqotj/Iw/WuJ65iV4
jJ9anI71epzG5yj/XrvVeJ33Kk5jH4jevK153Kp8G9rxbsh68OegO9+uz/PU
nY8d/C9cwJsjo8+t/m+Ym9ps49nSVHchcnghLuaXoIjnlqa6i1COXypLZQW0
5Odgk35+wbl8s2yQm/axhTeJcy73oik/MuaOv4QqsXbk4fIITOe/l6SxN8If
fAIO4YdiIt+HZrnpmPbzxnENyD1l+zoJH/ElqMXvNyfxYhRz1JWfrWyjup9L
0tjXyXqyPtbz6tp8zVegBl8qD5KVsYw3lj9FH2jCj8ZXuWmbajzXfnrJ3ihX
LtGH90V5/nOMnTfHJv6NfZ4h62BVHLvyDblpH434mqiTdbGW1431od1qnJmb
WMPX4ix+TIU09pWoyb+Xp8rTsJrXkt/K71Cbn4hVuanspLI2p8szyvY9TL8V
ZEUM5w/E+4x12BUPxpqMa5N3Rh/ePs6h/COuQf4v7OZ74t7Kr8A2vh1X8hux
Kye16cBf1c94/hxe47OLkz+POXwuJvJJeIu/iyl8Khbw8sbZL8aJPD5A5ssC
DORfa1dd1sAKfon8Vf6GS3k57frIviWpr3vjGoobPb+P90AOz0VP/lBJ6rsQ
g2J9attF3oX9/Ku43/BqZft+Ie4hxrkEL/KRcpgcjlE8X7uP+JJ4R+AfytwY
F/7DX8ZS7ZbhFb4Q+/h+LMpJZcv555iZk/iCf4lZfIV8NeYWK2MbTOczsJhv
xnz+NrbwnVjA38Mu/gyezEljHsGfCJfDMZS/E+eW74hzw6fJ0XIMpvNJGBnH
isl8AkbkpLKJcS6LU11sM5X3k/fK+4rT2vsSVc3FUSVpbpfh4LhHYDk/AYs8
yxfjRD5bHi2rxfrhteTH8pN4l41zjlJ9V4hnTfQdc6ZuVrxT8xflkbIKXuLj
UDn2ifF8Bo7ISW1eiPdB+ab8N2rEPMqa8tiYm6J0jXSxr7vQNydxN7+n7Fhj
m7navRXvanwwHlb3CIbwm2V32QO3lI25oqyEVjw+Bi/nbdCFH2BePos1gwP5
NP0enpPGPJ1/Ed9k8eyJuQ3X5nu+Osrino51fD0a8JPxXU5qc0o8S0pS3Qac
x3+SjeNejI38cPl5rMHYZzyL4t7LN6E5byR3xjswGvMfUE95ffzI60ff8c2K
s3l5x3WRbIE8fqZco24tzuKbZQPZMNYv/xZ1eF18V9bmh3gnRr2cxDq+vijt
66uiNBen42v+VEm691WK9yn+TEnyAzCCP4uDeGWM5S3zva+4XdyJVnyK98TD
+OGYyjvLy5W3QRdeGeOUj8fB/BBM4BNxKD8as/kcVMukNs/x5/NS25myqjwK
s/JSn2313Q538dtwAW+Ojvx++YB8EF35veiXSWX38U6yhbwYt/PecSy8M/rw
e3AN/0dsm0l9XsgvKts22nSJfaMv748evCcG8IPwrHGOzUvHPkCqyvg8yAzk
36MuPxOreSO5U+5CY75O1pP1sZ6fL3+Xf5S1PQPf8FWow0/HCr4yL9U1wGa+
BQ1jHqS/v8fQn2zIS32fjZ/44yhJr06ZJ3ivvL8fBX//1tKbe+XPPCwfgeWS
qYG5/C0cE7/LyAPkgRjFh+X9/eqeqYjhfGhe6jvKnizrY7AcAss7cxI+4ktQ
K5PmvL3BXov7Yv5jbmUvdOLbDegd3yLvxjcqnyd/lb9hPn8Kz8Y3DZ7OprLN
fAvejm8YZA0iBx/Gt5vyhXIR9vP35Z9yLz7gs/AV/xqv8hGYwCcWpt+kgkl8
MkbFt72clk3fTAv5e5iaTWXvl7WZEmXxLRXHIadkU5sF0SeG8eEYxYfGMcWx
4MnYF+bFscY+47cDc9LN3HTHTflpjCvUrcRr/Hs5R76O1fH9rt1fZQuieVyr
OJQfFtcsvwjleR5axHqWreVlcS3zG2U9WR8dYn1Z2Hn6zo/vUd4yzr26SmiV
SWP4xn5XYXZ8Oytvq7wdqvD2spasHeecrylMY30Da+PbVp+FvCi+cfn1sea1
PQM38IeUFWRTm0H8GOVXKb8aNXnV/LSvK+IeEtdoQRprbDOQH6/8A/OxECfw
Y/EuX4DjMon3+Pt5qe2L+Fg/n+Al/gqW888xk7+BH/iPeDOTyr7gX2JWXKtx
jmJesJKXug8PtRafLErf6q/HHChfm5/6qhPftPEtG+/GpanPderW4998UZzP
shvMYvEUHxrXGp7m8+N+ILfg7Uxqk9U2Bx/yjcrnyrfwM9+JBXHM2MV35yd/
H3v4pvzUdh5+4c/kp30Nwwh+sjFea6zX4RReC+1zU1lt3lleLtugC++BW/lt
6Jmbytrydrgr3vcxzw1qPmrykSXp2XQgRvHRJcnjGTWGz0RVfhRm8VtlU301
i33kpj6v4Ffi7vj+lAPi3Rm9eSfZIr4RcTs/Vl4tr8FxvE9pavsQ+pa1uSS+
G3FHlOFufg/6xTszHuT98XA4uvHuURbfHOZttHkbg6f4OPm0fAbj+aMBfyzg
G2XT+C0XP/O747enWAO4hy+Na1ZWxjJ+s9wj/8QtvJx130f2RXmei168d1nd
rQWp7V7cFutEWQ/ZsyC1rRi/Sar7DJXit0r8wH+MZxbvY4wD47pEX746rtf4
bRFrMmlMB8dvwFjOT4zfJuW38Szg62VDeR42xFrHubxBWV30UYfXjd94Y43i
Rt4Bu3lL+VusebTil+DXTCq7lL9tTJP5FLzDJ8g341rCxLj281PdVCwoK5sb
ax6T+OP56Vw8jif4YAzJpHM0hD+Xn87dCDwf/ecnH4mJfHa0iTrM4aNiLHIq
RvO2xrhVbot7JN8ur5JXYwf/KG7dcc/DEt4vP831IDwQ9xaMz6R9vBb3pML0
2974eJbxGbHW1D2LF/hY+bJ8BePifu5Bnefhn4/+/P8vJktp
            "]]}]}, {{}, {}, 
         {RGBColor[
          0.08943771428571429, 0.24098401142857143`, 0.49412457142857147`], 
          LineBox[CompressedData["
1:eJwl2XfczeUbwHFbNonsvTeJjJAdSlZW9kyyN6U0rELSNMqWKDMzISkkldKw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           "],
           VertexColors->Automatic]}}},
       VertexColors->CompressedData["
1:eJwcXHc81t8Xl5ldUihllqhEiFI+KqMUSsoulGSEEEkhCalooK+sSGRVUsnK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        "]],
      RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "0"}], "}"}]],
     Annotation[#, {1, 1, 0}, "Tooltip"]& ], 
    TagBox[
     TooltipBox[GraphicsComplexBox[CompressedData["
1:eJx93WVcVU33N3DSwEIFxURRzEtFsTGWYHcHKoqtGNhgYIOIhQICIlLS0p0G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       "], {
        {GrayLevel[0.5], EdgeForm[None], 
         GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtmgf8juX3x59x389zPysapDKyFUVGIYTKKHtHKaM0pEEDpSgtowiVlb2S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            "]], PolygonBox[CompressedData["
1:eJwtmnWAFVUfhmfvZe/dvbsXgaWRRikBQcnlk24klRCUku4UZEE6lg5h6RTp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            "]]}]}, {{}, {}, 
         {RGBColor[
          0.09378314285714286, 0.43570714285714285`, 0.5372898571428572], 
          LineBox[CompressedData["
1:eJwl2HfUl/Mfx/F2hIjMQpFVyEpWIasQDZRKEUppp6GkXTQVhRJSQkVKQ9Ky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           "],
           VertexColors->Automatic]}}},
       VertexColors->CompressedData["
1:eJwcXHc41l8UN1P2imyyslcySl9ZZUQSWVmRkFAis1BRCakQqSgrGRmZ2a/K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        "]],
      RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "1"}], "}"}]],
     Annotation[#, {1, 0, 1}, "Tooltip"]& ], 
    TagBox[
     TooltipBox[GraphicsComplexBox[CompressedData["
1:eJx93XVUVV23B2BAxVZUbLFbsAsVnYrdooIdGBigiAWiKGIHUiJId3e33Y2K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       "], {
        {GrayLevel[0.5], EdgeForm[None], 
         GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtmnfgVuMbxt/3+57zvudd4acUUUpFkpZ2EUq0UGYlWmZGhQrJChllpU1l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            "]], PolygonBox[CompressedData["
1:eJwt2QmYjlUfx/FnnmHGPDOTLKWIUIqUpYRKFG16K0vW9rRTtIiSIhURZW/R
Skop1KvSSkJoDyFbtKF9J728n39nrsv3+n2d+5xzb+ec577vqdOrX+e+2Uwm
81leJlNOviynFmUy0/AK7yjHyHvRib8qZ8hn8Brvjq8qZDJfowdvg7n8JZwQ
rt58uQAv8ePlHNteQGs+T54o2+LVsrIX5X8rpL6ek8fJVniev1yU+nobr/Df
lV3IL8IfFdIxP6l8OubxFvF/5dPRkg9Q/rh8AgP5UfJh2x5BM94FG/kmdM1L
fTyl3tNl5948ro9t0yqkvofL+rIBRvCz5KdyBTrwI/EQn1Ih7es67Kev/XF9
XBe5WC6Jc+LLA/5ewLO4nF+BfP6JXCPX4lO+sCi1fRfv8ANlf/u6EbV5E2W3
ytvQlGdy7hX/Bnm8HL7lW1GeH67OLXwwjuCNipJHH435oqK0r6VYHMeXS31F
H/m8IJf62oZCvl3mZDG+4yu1+Uh+jFX8fflhlOGDqCt7yz4o5m85j5P4yZjP
6+rnT/4XDuK9lVXnNaINvxTV4hrjMn6kOrv5HhzFt8i/9bsLX/JrsDevhL78
auzFKxalbXFMH8d1x4d8t/wqL13DPXxojAnZArfzK1HAC3FVXuqzMq+Cfvxa
x1RT1oqxEPfIMf2Rl86pDt8L3/MfUJHvnUv+IyrxIbKZvo4u2/dSfbSXp2MZ
X14h+X9i/PB5RWmuLIz5FeMm7rXchs/jfOWUmANxLfhIeZpsj1ExvmNu8nYY
EdcK3fTbHZX4scqHyTtwHJ+svEmMNdzPD46xJ4egHu+tzkN5aZ99+BFyrG3j
0Cgv9dmD90TlvFQ2nk9A49i3NmPlOHTno5U35IdjTIW0jm2Je4vV/Hu5Tq6P
a8qruoY/8Z+xD79BHqC8JvrnJWrFPMKN/DA5KC/NiYa8ci7di+ijSi7N4erK
axSlvqJNbV4HA/ISdflBGMiL4vrGPUOOn6d8gpyI82M9wyb+Bf7gnWK+q7sW
nWOcFKVtm2MOxBpclO7tO3id/xJj33Htj19j3BSlc98Qx8zrK98ZcwANuMi0
LMhkjkH8DjylYJh6d8SaxysUG8c29EYR/1Sbs3gHrOArc8k7YhX/LJe8E1bz
M+SH8iOcyS/Fbr4Hl/Ge2Mq34Ry+JpfadsZafrHcEceMXvwC/Mp/w4X8jBLr
RH4mU4Iz+ZzSTOZN/hZe4E/iFT4P0/mzeI2/jpn8bH2s19cGdOHzlc9V/hIW
8Gcxit+Dmfx5jOXjMIvPwWR+P17gj8q58iU8xodjBn8GI0rTPjba1yZ05d2w
hX+J7rw/arnOB+LGbKI2r4MBvK96B8ia6MevRo1sKrsm1kNUz6ayPjG+Y5u2
NYtT35cqqyb3w2X8yhgr2dTmKn6wegP5TajHb5b1ZQMM4nvLa+I4UIk3x1B+
O1rwXHEaK31QzAtwZTaNocLidM5f2M/mXDr3lsWp7TAcw9tiOB+BdrwJbuW3
oSmvXJz23Q9V+LVyX1kN1/FJrvNFrvPFmMwfwOX8CjzI70MX3hVj+Va5Vn6O
bXy1/Ep+jTV8A37mv2BjbMNuvifq8L/lFvkldvHtpamvdfiOvyfflx/gfb5D
bs5PbXby70tT3fX4gX+BVfwzbOZnxNjjo2N88yPlQ8b5FBzFl8jTZHu8yxfh
1PxUtpgv1WYZX45lvLGcqHwSmvBjY4zzmTguxq9sJo+O8ctbyCfldLTkzTGV
Tyvb9mlcuzgHrMhPrOcbsJJ/gjVxjUtT3ep7mb/yN9Tgv8ta8kD8wavKn+Ka
Yx9eGT/mp7IqfLFcoK+3sYQPkI/LJzCQL4q5L+eXpro9Yq7K8ejJh2I6fwq3
88tzaS7EHLginl2UF9hPIbbFPYy1hZfi+7jfOIw3xC6eld/Ib5HPV+rzI/4x
VpWmNnspr4gf+CFyR9x7HMrLeehuLdugPD9S7rZtD47iecpaymOQjQd0NOct
yrb1d8wHxhoRawUfinr8kJiTfFgu+aG4g1d2337kP8X84SX4jn+PUv6nrCsP
wl/ZxMG8Hnbw32I94TXxO69akvr6Gfvw683DR/ljuIHfhCf4VNzM66uzk/+N
BrwtCpxrIdrxcrK1bIPyMdfUOzLGOvZkE8340cjYnpPbs+kcivnDsTbZTz88
wv+HJsqblqS+/kEj3rgkbduFw/kRJWlbvj5b8ePLjiUbcyTmRknaNk2dwbEm
4Un+NO7kd2FGNpXdxodgOl8ol8h38Q5fgMXZVPY2f00+K2fidT5LviHfxGz+
FhZlU5v5fJYcLydgNn9KzpOvxrHwufJR+Rhe4i/gAf4gXozf7Pi94xuwks8p
Tvt6K+ryXpjM78clsXZHW/5QrOFxLMXpXJbGMfEp8ur4TShO134CzuPnYyLv
Iu+TY9GVX1qc+n4gfn/4GNlRdsK9/CI5KZuO4WJ+eXGqG8dwRZyD+9DafWiD
/5akc9iofBNW8ffle5H4gHeLZ+j4rUJ3fmcuzYX6uIsPzyVvEL85fA6O563j
evBZaJVNZbPjGQEVs6nPrnwhTuGnxv3lJ8p58lW05Z3jmT6b2pwdz0Yozaay
TrxHLh1bZfTkg1CXH4Rb+G3xm5xNc3oIH5xL26LsVr4ol/Z9WtwPviSXvH2M
uXj+incvXoIz45jiHY0Xol08c+XSvqvg3Hi2y6W6cYwd+Btox0+KMcnHoxFv
HPeaT0YT3jTGDP/bNd/Cv4y5xbPu0Tf825hbMWfxdTaV5cUcK0nbtqI8/1xu
1+47rOMf4lO+Ah/xNdGWf4u1fLlcnk33/D3+gfxYflKc2m6Rn8nVcUx8BzZn
0zHuLOtjq9xWnPbdMuaU83gax/CJuXSucY6T+Gg0jDUDY+I5Tv6u7R/4greI
NUD59Fzq61HZTB6Nx/jjueTN8UTcK+1G8lFxz/iRMdeUT8FRMW9ibTLWG2Ec
vxeH56ey+/hoNMxPZWNiPfUc71+mEO3KnumPlccV/Ltc/ksrfnxB+t4TtOZt
UJ5XQg/eE5X5abLss0GmPa8ou8iu2DuT6pzDz0UVfor0qvJvm1P5SQXpWKLs
ZN4fB/LauJHvL6+UV6E6v0BWlfvgQr4AJ0e/eLtsn91k94J0rNGmN++DGryv
PEDWRD++r+wlL0E1PqAg7bsOBvKbCpLXxc38rIJ/h2jGT3emA+9YkNzPbaYT
vw0H83oYwkfGNXKC7TGKT1bWRDbF/fxhHMWb4RE+FkfwRhjHf9VuI9+E3/h2
fM7X4Tu+Xv4of8IGvlWuzaQ62/gObOZbsJPfIA+QNdGfH4o77ecu1Oej5GGy
Ie6JcSGfk8+jFZ8qm8sWmMZnxLthjCE8ww+Rw+QdBanv12TbGGt4nc/DiZlU
9ip/GSdkUtkr/G40yKRjGMnnxtjLpDov8dXyK8f+NdbE/Yp7ww/CQL6vvFZe
h2q8W5y7dl/GmMgkvuJfo0cm8Q3/NsY0/1meH+MMv8S4kP/I/+FSvl2eI8+N
688vljvkTvTKpDq7+R5clknPbCcYHCeigD8f3zMM/nGYxUfLmfK5+D7Bp8pB
8Y0tvrHyu+NbqnwWI/mT8b1EDolvmHlpn3/b166yY402g+ObXlndUUWpbezj
Hj4cM/JSnyPKjmF8fGPA7LzERD4Jc/hG/XbRb9cYg3w9zs6ksg38P/J9+QHO
iPnumveNuYUqvByuiDkc14IfgptiLsXY44dhEL8lxhy/OuaSrIhrYl2QV8Uc
jjWDFxSmvqKskFctTPuKe74PzxWmun1QzPcrTGPheuzPW+GOGPM4nt8VY0ue
iOF8jfPoJDtjLV9YkNaWU/EOX4r2/HQsK0ht2mrbDiNi3hWktnGN1sWcKkzn
GufYgGdxeSZdk3x+eGE698E4gg+JtUAejaGZdI+HxrfDovTt5UNln9q2Ah/x
FVgfcx8rY6xbnLpZxLvHO2e8q1mchvCh8c7GG2EwvxWN+bEYxu/AcbxVafI7
cXy8b+qja37qc3M8W5WmbXfFMxY/BXfzkTg13oHV6ZKf2mzineP9T67D2fGO
Gu8+/BOcxS/LT4tpXrxr8V7xDmXbLlzCf5UXyAvjnZAPl23VbYcR+alNlufH
O3w878vesg+K+Tlye7zD4Nx4b5YdZSesjudDdMhPZav4oHh/064hbuH7ymvl
dajGq6Jffirbh3fUpjTe4aLPOKeS9K0pyjrwHqjEK8f7Ja8ue8s+qME7l6S2
FXE2319eKa8qq7tfnCO/omzbKHlYfvpNvyeuDarGscQ14hfLHfEOVZKu5dKS
9O5/OpbxYTgk3i3jnvMDnMMNvD9q8qvjXGRFXBPHLfvmp3OuEh5tom6URV/K
buI3R598gLLavE68b/O6cpC8Jd4Z+d2yQX46h5H82pLUV624xvwL43iVIfEZ
NvOLlP8Z75pl5/aosrnxW4DHYn57cPiF/xrzm/8Wv2/xDR2/8+XqLJfvBXwp
lmVS2TK+JMoyqezdwtSmlrYH4g/+MPrGGoNHYp/oz2/E45lUp7a6dfAnP1j+
Fb8JqBffcLE9fitiPeLlzOHW8bcrlI/v1/If2/6HxvFtvELy3Wgaf5eSQ+3r
djzF87RpqfwYZON7u/xB+Y+oxAuwlW+L9ZFXqJA8jqEovplXSHV/ivWZT421
KdYgTIt1Vj4kp8Qayhfh3Uy6Rov5bDlRTsIc/lbUiW2YzxfGNc2kNu/wBYVp
W5S9zZ+XY+U4zOLP4V5+X9m2KBvPJ5TtayZG8zGFqe4D8gX5Ih6M35d4F/Pw
2Qbl+Vxl821bEGMk9oE3+JuYzc/APdEnzox+ZUfZCffG71ocSxwjuvLX5LNy
Jl7n49CD98R4PgHn8fMxMZPKzuHnFqZtMzA8fhvwTCbVuYBfGNcwk54J2no2
aBfflPj/AcQhvcw=
            "]]}]}, {{}, {}, 
         {RGBColor[
          0.14216071428571428`, 0.5862125714285714, 0.5369255714285714], 
          LineBox[CompressedData["
1:eJwl2Xf4lmMfwOH23nvvor1JUxoaVFbak6wGUkpLU3sPlBaloj1o7yUkmqJE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           "],
           VertexColors->Automatic]}}},
       VertexColors->CompressedData["
1:eJwkXHk0ld/Xz5AMmYoIiYQoiZKUPEQlQ5nTJJWKhq+ppBIlQyGh0VCEkFSm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